/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.event.stax;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.joran.event.stax.BodyEvent;
import com.eg.ch.qos.logback.core.joran.event.stax.EndEvent;
import com.eg.ch.qos.logback.core.joran.event.stax.StartEvent;
import com.eg.ch.qos.logback.core.joran.event.stax.StaxEvent;
import com.eg.ch.qos.logback.core.joran.spi.ElementPath;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxEventRecorder
extends ContextAwareBase {
    List<StaxEvent> eventList = new ArrayList<StaxEvent>();
    ElementPath globalElementPath = new ElementPath();

    public StaxEventRecorder(Context context) {
        this.setContext(context);
    }

    public void recordEvents(InputStream inputStream) throws JoranException {
        try {
            XMLEventReader xMLEventReader = XMLInputFactory.newInstance().createXMLEventReader(inputStream);
            this.read(xMLEventReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", xMLStreamException);
        }
    }

    public List<StaxEvent> getEventList() {
        return this.eventList;
    }

    private void read(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            switch (xMLEvent.getEventType()) {
                case 1: {
                    this.addStartElement(xMLEvent);
                    break;
                }
                case 4: {
                    this.addCharacters(xMLEvent);
                    break;
                }
                case 2: {
                    this.addEndEvent(xMLEvent);
                    break;
                }
            }
        }
    }

    private void addStartElement(XMLEvent xMLEvent) {
        StartElement startElement = xMLEvent.asStartElement();
        String string = startElement.getName().getLocalPart();
        this.globalElementPath.push(string);
        ElementPath elementPath = this.globalElementPath.duplicate();
        StartEvent startEvent = new StartEvent(elementPath, string, startElement.getAttributes(), startElement.getLocation());
        this.eventList.add(startEvent);
    }

    private void addCharacters(XMLEvent xMLEvent) {
        Characters characters = xMLEvent.asCharacters();
        StaxEvent staxEvent = this.getLastEvent();
        if (staxEvent instanceof BodyEvent) {
            BodyEvent bodyEvent = (BodyEvent)staxEvent;
            bodyEvent.append(characters.getData());
        } else if (!characters.isWhiteSpace()) {
            BodyEvent bodyEvent = new BodyEvent(characters.getData(), xMLEvent.getLocation());
            this.eventList.add(bodyEvent);
        }
    }

    private void addEndEvent(XMLEvent xMLEvent) {
        EndElement endElement = xMLEvent.asEndElement();
        String string = endElement.getName().getLocalPart();
        EndEvent endEvent = new EndEvent(string, endElement.getLocation());
        this.eventList.add(endEvent);
        this.globalElementPath.pop();
    }

    StaxEvent getLastEvent() {
        if (this.eventList.isEmpty()) {
            return null;
        }
        int n = this.eventList.size();
        if (n == 0) {
            return null;
        }
        return this.eventList.get(n - 1);
    }
}

