/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern;

import com.eg.ch.qos.logback.core.pattern.Converter;
import com.eg.ch.qos.logback.core.pattern.FormatInfo;
import com.eg.ch.qos.logback.core.pattern.SpacePadder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    public final void setFormattingInfo(FormatInfo formatInfo) {
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = formatInfo;
    }

    @Override
    public final void write(StringBuilder stringBuilder, E e) {
        String string = this.convert(e);
        if (this.formattingInfo == null) {
            stringBuilder.append(string);
            return;
        }
        int n = this.formattingInfo.getMin();
        int n2 = this.formattingInfo.getMax();
        if (string == null) {
            if (0 < n) {
                SpacePadder.spacePad(stringBuilder, n);
            }
            return;
        }
        int n3 = string.length();
        if (n3 > n2) {
            if (this.formattingInfo.isLeftTruncate()) {
                stringBuilder.append(string.substring(n3 - n2));
            } else {
                stringBuilder.append(string.substring(0, n2));
            }
        } else if (n3 < n) {
            if (this.formattingInfo.isLeftPad()) {
                SpacePadder.leftPad(stringBuilder, string, n);
            } else {
                SpacePadder.rightPad(stringBuilder, string, n);
            }
        } else {
            stringBuilder.append(string);
        }
    }
}

