/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.rolling;

import com.eg.ch.qos.logback.core.joran.spi.NoAutoStart;
import com.eg.ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import com.eg.ch.qos.logback.core.rolling.helper.ArchiveRemover;
import com.eg.ch.qos.logback.core.rolling.helper.CompressionMode;
import com.eg.ch.qos.logback.core.rolling.helper.FileFilterUtil;
import com.eg.ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import com.eg.ch.qos.logback.core.util.DefaultInvocationGate;
import com.eg.ch.qos.logback.core.util.FileSize;
import com.eg.ch.qos.logback.core.util.InvocationGate;
import java.io.File;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoAutoStart
public class SizeAndTimeBasedFNATP<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    long nextSizeCheck = 0L;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private final Usage usage;
    InvocationGate invocationGate = new DefaultInvocationGate();

    public SizeAndTimeBasedFNATP() {
        this(Usage.DIRECT);
    }

    public SizeAndTimeBasedFNATP(Usage usage) {
        this.usage = usage;
    }

    @Override
    public void start() {
        super.start();
        if (this.usage == Usage.DIRECT) {
            this.addWarn("SizeAndTimeBasedFNATP is deprecated. Use SizeAndTimeBasedRollingPolicy instead");
            this.addWarn("For more information see http://logback.qos.ch/manual/appenders.html#SizeAndTimeBasedRollingPolicy");
        }
        if (!super.isErrorFree()) {
            return;
        }
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            this.withErrors();
        }
        if (!this.validateDateAndIntegerTokens()) {
            this.withErrors();
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        String string2 = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string2);
        if (this.isErrorFree()) {
            this.started = true;
        }
    }

    private boolean validateDateAndIntegerTokens() {
        boolean bl = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also http://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return !bl;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    void computeCurrentPeriodsHighestCounterValue(String string) {
        File file = new File(this.getCurrentPeriodsFileNameWithoutCompressionSuffix());
        File file2 = file.getParentFile();
        File[] fileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file2, string);
        if (fileArray == null || fileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter(fileArray, string);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    @Override
    public boolean isTriggeringEvent(File file, E e) {
        long l = this.getCurrentTime();
        if (l >= this.nextCheck) {
            Date date = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(date, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(l);
            this.computeNextCheck();
            return true;
        }
        if (this.invocationGate.isTooSoon(l)) {
            return false;
        }
        if (file == null) {
            this.addWarn("activeFile == null");
            return false;
        }
        if (this.maxFileSize == null) {
            this.addWarn("maxFileSize = null");
            return false;
        }
        if (file.length() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    public void setMaxFileSize(FileSize fileSize) {
        this.maxFileSize = fileSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Usage {
        EMBEDDED,
        DIRECT;

    }
}

