/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.utils.CustomConfigurationManager;
import com.eg.jtm.ACTION;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMSocket;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.Mode;
import com.eg.jtm.OffLoadAgentCheck;
import com.eg.jtm.OffLoadAgentInfiniteCheck;
import com.eg.jtm.PropFilesTracker;
import com.eg.jtm.PropsManager;
import com.eg.jtm.STATUS;
import com.eg.jtm.StartServer;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jtm.TimeZoneManager;
import com.eg.jtm.TrackerTask;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;

public final class BTMOffLoadConfig {
    private static final String OFFLOAD_WORKERS = "TRANSMIT_WORKERS";
    private static final String OFFLOAD_QUEUE_CAPACITY = "EVENT_QUEUE_CAPACITY";
    private static final String PONG_MESSAGE = "OFFLOAD - PONG";
    private static final String ACK_MESSAGE = "OK";
    private static final String UNMONITORED_HOST_MESSAGE = "UNMONITORED HOST";
    private static final String DISCOVERY_DETAILS_RECEIVED = "DISCOVERY_DETAILS_RECEIVED";
    private static final String DISCOVERY_DETAILS_FINALIZED = "DISCOVERY_DETAILS_FINALIZED";
    private static final String HEARTBEATCHECK_OK = "HeartBeatCheck_OK";
    private static final String LOGPATH_OK = "LogPath_OK";
    private static final String NEW_JVMGUID_OK = "New_JvmGuid_OK";
    static final String APP_RENAME_OK = "APP_RENAME_OK";
    static final String TIER_RENAME_OK = "TIER_RENAME_OK";
    private static final String COMPONENT_DISCOVERD = "COMPONENT_DISCOVERD_";
    private static final String LOG_FILE_CLEAN_UP = "LOG_FILE_CLEAN_UP";
    private static final String GRANT_LOG_HOME_FILE_ACCESS = "GRANT_LOG_HOME_FILE_ACCESS_FOR_AGENT";
    private static final int DEFAULT_OFFLOAD_WORKER = 5;
    private static final int DEFAULT_OFFLOAD_QUEUE_CAPACITY = 100000;
    private static int offLoadWorker = 5;
    private static int offLoadQueueCapacity = 100000;
    private static String collectorAgentIP = "127.0.0.1";
    private static boolean logFileCleanUp = true;
    private static boolean grantLogFileAccess = true;
    private static String applicationName = "MyApp";
    private static String tierName = "MyTier";
    private static boolean isAutoNameEnabled = true;
    private static boolean isAgentIpDiscoveryEnabled = true;
    private static boolean isContainerDiscoveryEnabled = false;
    private static long discoveryMaxWaitTime = 900000L;
    private static long mbeansMaxWaitTime = 180000L;
    private static int collectorAgentPortNo = 13700;
    private static int socketConnectionTimeOut = 1000;
    private static boolean collectorDetailsFound = false;
    private static boolean oKToSendOffloadData = true;
    private static boolean isNodeIDValidatedWithAgent = false;
    private static boolean isThisOffloadAgent = false;
    private static boolean isThisComponentManaged = false;
    private static boolean isValidComponentIDAssigned = false;
    private static boolean isSystemPropsIpUsed = false;
    private static boolean isAckReceivedForDiscovery = false;
    private static boolean isDiscoveryDetailsFinalized = false;
    private static boolean btmlogFolderFound = false;
    private static String btmLogFolderFoundedAs = "";
    private static long maxWaitTime = 300000L;
    private static long heartBeatIntervalTime = 180000L;
    private static long lastActiveConnectionTime = -1L;
    private static boolean print = false;
    private static final String[] DEFAULT_AGENT_SERVER_SOCKET_PORT_ORDER = new String[]{"11700", "12700", "13700", "14700", "15700", "16700", "17700", "18700", "19700", "20700"};
    private static String btmNodeID = "NONE";
    private static final Object configObject = new Object();
    private static boolean memoryCopyOnly = false;
    private static Mode currentMode = Mode.OFFLOAD_DATA_COLLECTION;

    private BTMOffLoadConfig() {
    }

    public static boolean isDiscoveryMode() {
        return currentMode == Mode.OFFLOAD_DISCOVERY;
    }

    public static boolean isDataCollectionMode() {
        return currentMode == Mode.OFFLOAD_DATA_COLLECTION;
    }

    public static void setCurrentMode(Mode mode) {
        currentMode = mode;
    }

    static int getOffLoadWorker() {
        return offLoadWorker;
    }

    private static void setOffLoadWorker(int n) {
        offLoadWorker = n;
        BTMLog.logger.info("Assigning {} worker threads for sending data to eG Agent", (Object)n);
    }

    static int getOffLoadQueueCapacity() {
        return offLoadQueueCapacity;
    }

    private static void setOffLoadQueueCapacity(int n) {
        offLoadQueueCapacity = n;
        BTMLog.logger.info("Assigning offLoad worker threads queue capacity as  : {}", (Object)n);
    }

    static void updateMeasurePeriod(long l) {
        BTMOffLoadConfig.assignMaxWaitTime(l);
    }

    static List getOffloadPortOrder() {
        Object[] objectArray = DEFAULT_AGENT_SERVER_SOCKET_PORT_ORDER;
        List<Object> list = Arrays.asList(objectArray);
        String string = "";
        try {
            string = PropsManager.getProperty("AGENT_PORT_ORDER");
            if (string != null && string.length() > 0) {
                objectArray = string.split(",");
            } else {
                BTMLog.logger.warn(" AGENT_PORT_ORDER empty , so using default port order :{} ", objectArray);
            }
            list = Arrays.asList(objectArray);
            BTMLog.logger.info(" Given AGENT_PORT_ORDER : {}", (Object)list);
        }
        catch (Exception exception) {
            BTMLog.logger.debug(" Given AGENT_PORT_ORDER : {}", (Object)string);
            BTMLog.logger.warn(" Unable to parse AGENT_PORT_ORDER , so using default port order :{} ", (Object)objectArray, (Object)exception);
        }
        return list;
    }

    private static void assignMaxWaitTime(long l) {
        maxWaitTime = l * 2L;
        BTMLog.logger.debug(" Assigned maxWaitTime is  : {} for the test frequency of {} ", (Object)maxWaitTime, (Object)l);
    }

    private static void setLastActiveConnectionTime(long l) {
        lastActiveConnectionTime = l;
        BTMLog.logger.trace(" Last Agent active connection Time : {} ", (Object)lastActiveConnectionTime);
    }

    static void checkStatus(boolean bl) {
        if (lastActiveConnectionTime <= 0L) {
            lastActiveConnectionTime = BTMUtils.getTimeStamp();
            print = false;
            return;
        }
        if (bl) {
            lastActiveConnectionTime = BTMUtils.getTimeStamp();
            PropsManager.setTalkingToAgent(true);
            print = false;
            BTMLog.logger.info("eG Java BTM is able to talk with eG Agent & lastActiveConnectionTime is {} ", (Object)new Date(lastActiveConnectionTime));
        } else {
            long l = BTMUtils.getTimeStamp();
            long l2 = l - lastActiveConnectionTime;
            if (l2 >= maxWaitTime) {
                PropsManager.setTalkingToAgent(false);
                if (!print) {
                    BTMLog.logger.warn("eG Agent is not reachable from {} ", (Object)new Date(lastActiveConnectionTime));
                    int n = ThreadPoolManager.getThreadPoolManager().getQueueSize();
                    if (n > 0) {
                        ThreadPoolManager.getThreadPoolManager().clearData();
                        n = ThreadPoolManager.getThreadPoolManager().getQueueSize();
                        BTMLog.logger.warn(" Clearing collected information to avoid performance overhead. Current Queue size is : {} ", (Object)n);
                    }
                }
                print = true;
                ThreadPoolManager.getThreadPoolManager().clearData();
            }
        }
    }

    private static void assignOffLoadWorker(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    BTMOffLoadConfig.setOffLoadWorker(n);
                } else {
                    BTMLog.logger.info("Given value for {} is not valid, so considering default value", (Object)OFFLOAD_WORKERS);
                    BTMOffLoadConfig.setOffLoadWorker(5);
                }
            }
            catch (Exception exception) {
                BTMOffLoadConfig.setOffLoadWorker(5);
            }
        }
    }

    private static void assignLogFileCleanUpStatus(String string) {
        if (string != null && string.length() > 0) {
            try {
                BTMOffLoadConfig.setLogFileCleanUpStatus(Boolean.parseBoolean(string));
            }
            catch (Exception exception) {
                BTMOffLoadConfig.setLogFileCleanUpStatus(true);
            }
        }
    }

    private static void setLogFileCleanUpStatus(boolean bl) {
        logFileCleanUp = bl;
        BTMLog.logger.info("Assigning status {} for log file clean-up on eG BTM", (Object)logFileCleanUp);
    }

    public static boolean isLogFileCleanUpEnabled() {
        return logFileCleanUp;
    }

    private static void assignGrantFileAccessStatus(String string) {
        if (string != null && string.length() > 0) {
            try {
                BTMOffLoadConfig.setGrantFileAccessStatus(Boolean.parseBoolean(string));
            }
            catch (Exception exception) {
                BTMOffLoadConfig.setGrantFileAccessStatus(true);
            }
        }
    }

    private static void setGrantFileAccessStatus(boolean bl) {
        grantLogFileAccess = bl;
        BTMLog.logger.info("Assigning status {} for log file permission change", (Object)grantLogFileAccess);
    }

    public static boolean isLogFileGrantAccessEnabled() {
        return grantLogFileAccess;
    }

    private static void assignOffLoadQueueCapacity(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    BTMOffLoadConfig.setOffLoadQueueCapacity(n);
                } else {
                    BTMLog.logger.info("Given value for {}  is not valid, so considering default value", (Object)OFFLOAD_QUEUE_CAPACITY);
                    BTMOffLoadConfig.setOffLoadQueueCapacity(100000);
                }
            }
            catch (Exception exception) {
                BTMOffLoadConfig.setOffLoadQueueCapacity(100000);
            }
        }
    }

    private static void setCollectorDetailsFound() {
        if (collectorAgentIP != null && collectorAgentPortNo > 1024) {
            collectorDetailsFound = true;
            BTMLog.logger.debug("Collector Agent IP & Port is - {} {} ", (Object)collectorAgentIP, (Object)collectorAgentPortNo);
        } else {
            collectorDetailsFound = false;
        }
    }

    static void assignCollectorAgentIP(String string) {
        if (string != null && string.length() > 0 && !isSystemPropsIpUsed) {
            collectorAgentIP = string;
            BTMLog.logger.debug("Collector AgentIP is assigned as : {} ", (Object)collectorAgentIP);
            BTMOffLoadConfig.setCollectorDetailsFound();
        } else {
            BTMLog.logger.debug("Collector AgentIP is not valid {} ", (Object)string);
        }
    }

    private static void assignCollectorAgentPortNo(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 1024) {
                    collectorAgentPortNo = n;
                    OffLoadAgentCheck offLoadAgentCheck = OffLoadAgentCheck.getInstance();
                    offLoadAgentCheck.setPort(collectorAgentPortNo);
                    BTMLog.logger.debug("collectorAgentPort : {} ", (Object)collectorAgentPortNo);
                    BTMOffLoadConfig.setCollectorDetailsFound();
                } else {
                    BTMLog.logger.debug("collectorAgentPort is not Valid :{} ", (Object)n);
                }
            }
            catch (Exception exception) {
                collectorAgentPortNo = 13700;
                BTMLog.logger.debug("collectorAgentPort is not Valid : {} , Assigning default value of {} ", (Object)string, (Object)collectorAgentPortNo);
            }
        }
    }

    private static void assignSocketConnectionTimeOut(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                socketConnectionTimeOut = n > 1000 ? n : 1000;
                BTMLog.logger.debug("Assigned SocketConnection TimeOut as {} ", (Object)socketConnectionTimeOut);
            }
            catch (Exception exception) {
                socketConnectionTimeOut = 1000;
                BTMLog.logger.debug("SocketConnection TimeOut is not Valid : {} , Assigning default value of  {} ", (Object)string, (Object)socketConnectionTimeOut);
            }
        }
    }

    static void assignApplicationName(String string) {
        try {
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                applicationName = string;
                BTMLog.logger.debug("Application Name | Service Name assigned as : {} ", (Object)applicationName);
            } else if (string != null && string.equalsIgnoreCase("none") && !applicationName.equals("MyApp")) {
                applicationName = "MyApp";
                BTMLog.logger.debug("Default Application Name | Service Name assigned : {} ", (Object)applicationName);
            } else {
                BTMLog.logger.debug("Application Name is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            applicationName = "MyApp";
            BTMLog.logger.warn("Application Name is not valid {} ", exception);
        }
    }

    static void assignTierName(String string) {
        try {
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                tierName = string;
                BTMLog.logger.debug("Tier Name | Group Name assigned as : {} ", (Object)tierName);
            } else if (string != null && string.equalsIgnoreCase("none") && !tierName.equalsIgnoreCase("MyTier")) {
                tierName = "MyTier";
                BTMLog.logger.debug("Default Tier Name | Group Name assigned : {} ", (Object)tierName);
            } else {
                BTMLog.logger.debug("Tier Name is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            tierName = "MyTier";
            BTMLog.logger.warn("Tier Name - {} - is not Valid {}", (Object)string, (Object)exception);
        }
    }

    static void assignAutoNamingStaus(String string) {
        try {
            if (string != null && string.length() > 0) {
                if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                    isAutoNameEnabled = true;
                } else if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                    isAutoNameEnabled = false;
                }
                BTMLog.logger.debug("AutoNaming value is set as : {}", (Object)isAutoNameEnabled);
            } else {
                BTMLog.logger.debug("AutoNaming value is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("AutoNaming value {}  is not Valid {} ", (Object)string, (Object)exception);
        }
    }

    private static void assignHeartBeatIntervalTime(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                heartBeatIntervalTime = n > 0 ? (long)(n * 60) * 1000L : 180000L;
                BTMLog.logger.debug("Assigned Heart Beat Interval Time as {} ", (Object)heartBeatIntervalTime);
            }
            catch (Exception exception) {
                heartBeatIntervalTime = 180000L;
                BTMLog.logger.debug("Heart Beat Interval Time is not Valid : {} , Assigning default value of  {} ", (Object)string, (Object)heartBeatIntervalTime);
            }
        }
    }

    static long getHearBeatIntervalTime() {
        return heartBeatIntervalTime;
    }

    static boolean isAutoNamingEnabled() {
        return isAutoNameEnabled;
    }

    static boolean isCollectorDetailsFound() {
        return collectorDetailsFound;
    }

    static String getCollectorAgentIP() {
        return collectorAgentIP;
    }

    static String getApplicationName() {
        return applicationName;
    }

    static String getTierName() {
        return tierName;
    }

    static int getCollectorAgentPortNo() {
        return collectorAgentPortNo;
    }

    static int getSocketConnectionTimeOut() {
        return socketConnectionTimeOut;
    }

    static void setFlagToSendOffloadData(boolean bl) {
        oKToSendOffloadData = bl;
    }

    public static boolean isOKToSendOffloadData() {
        return oKToSendOffloadData;
    }

    public static boolean isThisComponentManaged() {
        return isThisComponentManaged;
    }

    static void resetThisComponentManaged() {
        isThisComponentManaged = false;
    }

    public static boolean isValidComponentIDAssigned() {
        return isValidComponentIDAssigned;
    }

    static void resetValidComponentIDAssigned() {
        isValidComponentIDAssigned = false;
    }

    public static boolean isThisOffloadAgent() {
        return isThisOffloadAgent;
    }

    static void resetThisOffloadAgent() {
        isThisOffloadAgent = false;
    }

    public static boolean isNodeIDValidatedWithAgent() {
        return isNodeIDValidatedWithAgent;
    }

    static void resetNodeIDValidatedWithAgent() {
        isNodeIDValidatedWithAgent = false;
    }

    static boolean validateDiscoverMessage(String string, BTMSocket bTMSocket, String string2) {
        if (string.equals("null") || string.equals("")) {
            return false;
        }
        if (string.startsWith(COMPONENT_DISCOVERD)) {
            String string3 = string.replace(COMPONENT_DISCOVERD, "");
            if (string3.equals("")) {
                BTMLog.logger.warn("Found Invalid message from eG Agent during Discovery - {}.", (Object)string);
                return false;
            }
            PropsManager.setTalkingToAgent(true);
            BTMOffLoadConfig.setFlagToSendOffloadData(true);
            isValidComponentIDAssigned = true;
            isThisComponentManaged = true;
            isAckReceivedForDiscovery = true;
            BTMOffLoadConfig.setCurrentMode(Mode.OFFLOAD_DATA_COLLECTION);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("COMPONENT_GUID", string3);
            BTMLog.logger.warn("********************************************************************************");
            BTMLog.logger.info("Found JVM GUID for this JVM during Discovery - {}.", (Object)string3);
            BTMLog.logger.warn("INFO:- Found JVM GUID for this JVM during Discovery - {}.", (Object)string3);
            BTMLog.logger.warn("********************************************************************************");
            BTMOffLoadConfig.writeOffloadConfigProps(hashMap);
            ThreadPoolManager threadPoolManager = ThreadPoolManager.getThreadPoolManager(true);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ACK4BTM_").append("!;-;!");
            stringBuilder.append(PropsManager.getJvmGUID()).append("!;-;!");
            stringBuilder.append(NEW_JVMGUID_OK);
            threadPoolManager.submitTask(stringBuilder.toString());
            BTMLog.logger.info("[COMPONENT_DISCOVERD] message [{}] added into the queue & current queue size {} ", (Object)stringBuilder, (Object)threadPoolManager.getQueueSize());
            return true;
        }
        boolean bl = BTMOffLoadConfig.validateMessage(string, bTMSocket, BTMOffLoadConfig.getCollectorAgentPortNo(), string2);
        if (!bl) {
            BTMLog.logger.warn("Found Invalid message from eG Agent during Discovery - {}.", (Object)string);
        }
        return bl;
    }

    static boolean validateMessage(String string, BTMSocket bTMSocket, int n, String string2) {
        String[] stringArray;
        if (string == null || string.equals("null") || string.equals("")) {
            return false;
        }
        if (string.equalsIgnoreCase(ACK_MESSAGE)) {
            isNodeIDValidatedWithAgent = true;
            BTMLog.logger.debug("[ACK] Received [OK] from eG Agent by the thread - {} ", (Object)string2);
            return true;
        }
        if (string.equalsIgnoreCase(HEARTBEATCHECK_OK)) {
            BTMOffLoadConfig.setLastActiveConnectionTime(BTMUtils.getTimeStamp());
            return true;
        }
        if (string.startsWith(PONG_MESSAGE) && (stringArray = string.split("!;-;!"))[0].equalsIgnoreCase(PONG_MESSAGE)) {
            BTMLog.logger.debug("[ACK] Received {} from eG Agent, marking this JVM running as OFFLoad mode.", (Object)PONG_MESSAGE);
            String string3 = String.valueOf(n);
            BTMOffLoadConfig.actionsForPongMessage(bTMSocket, string3);
            return true;
        }
        if (string.equalsIgnoreCase(UNMONITORED_HOST_MESSAGE)) {
            BTMOffLoadConfig.doActionsForUnMonitorMsg();
            return true;
        }
        if (string.equalsIgnoreCase(DISCOVERY_DETAILS_RECEIVED)) {
            BTMLog.logger.debug("[ACK] Received [DISCOVERY_DETAILS_RECEIVED] from eG Agent by the thread - {} ", (Object)string2);
            BTMOffLoadConfig.setAckReceivedForDiscovery(true);
            return true;
        }
        if (string.equalsIgnoreCase(DISCOVERY_DETAILS_FINALIZED)) {
            BTMLog.logger.debug("[ACK] Received [DISCOVERY_DETAILS_FINALIZED] from eG Agent by the thread - {} ", (Object)string2);
            BTMOffLoadConfig.setDiscoveryDetailsFinalized(true);
            return true;
        }
        return false;
    }

    private static void doActionsForUnMonitorMsg() {
        OffLoadAgentInfiniteCheck offLoadAgentInfiniteCheck;
        if (BTMLog.logger.isWarnEnabled()) {
            BTMLog.logger.warn(" eG BTM Profiler able to communicate with eG Agent, eG Agent replied this message : {} ", (Object)UNMONITORED_HOST_MESSAGE);
            BTMLog.logger.warn("----------------------------------------------------------------------------------");
            BTMLog.logger.warn("             Suggestion(s) : Why Java BTM metrics are not reporting?              ");
            BTMLog.logger.warn("----------------------------------------------------------------------------------");
            BTMLog.logger.warn("  1. Verify this JVM (or) Server is monitored by eG Manager.");
            BTMLog.logger.warn("  2. Verify Java BTM test(s) are enabled for this JVM.");
            BTMLog.logger.warn("  3. Verify this JVM is assigned with valid GUID {} & NODE ID {} by referring config.props file.", (Object)PropsManager.getJvmGUID(), (Object)BTMOffLoadConfig.getNodeID());
            BTMLog.logger.warn("  4. Not reporting Java BTM metrics due to recent restart of eG Agent. Pls, wait until BTM Test(s) are initialized.");
            BTMLog.logger.warn("  5. Restarting eG Agent may solve the issue.");
            BTMLog.logger.warn("----------------------------------------------------------------------------------");
        }
        if ((offLoadAgentInfiniteCheck = OffLoadAgentInfiniteCheck.getInstance()).getCheckStatus().isStatusNone()) {
            offLoadAgentInfiniteCheck.setCheckStatus(STATUS.OFFLOAD);
            BTMOffLoadConfig.setFlagToSendOffloadData(false);
            isThisOffloadAgent = false;
            String string = "eGInfinite OFFLoad Check";
            isNodeIDValidatedWithAgent = false;
            Thread thread = new Thread((Runnable)offLoadAgentInfiniteCheck, string);
            thread.setDaemon(true);
            thread.start();
            BTMLog.logger.warn(" {} Started, when this JVM is not monitored by eG Agent either OFFLoad or Non-OFFLoad mode", (Object)string);
        }
    }

    private static void actionsForPongMessage(BTMSocket bTMSocket, String string) {
        PropsManager.oldModel = false;
        PropsManager.setTalkingToAgent(true);
        isNodeIDValidatedWithAgent = true;
        isThisOffloadAgent = true;
        BTMOffLoadConfig.setFlagToSendOffloadData(true);
        BTMOffLoadConfig.assignCollectorAgentPortNo(string);
        BTMLog.logger.info("eG Agent OFFLoad Port (new) {} is assigned for this JVM.", (Object)string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PUSH_TO_AGENT_MODE", "true");
        hashMap.put("BACKWARD_COMPATIBILITY_CHECK", "false");
        hashMap.put("AGENT_PORT", string);
        BTMOffLoadConfig.writeOffloadConfigProps(hashMap);
        bTMSocket.setConnectionSuccess(true);
        if (StartServer.btmSrv != null && StartServer.started) {
            StartServer.stopBTMServer();
        }
        BTMLog.logger.debug("This JVM is running in OFFLoad mode, shutting down Non-Offload mode.");
        PropFilesTracker.PFTimer = new Timer("eG BTM PropFilesTracker", true);
        PropFilesTracker.TT = new TrackerTask();
        PropFilesTracker.scheduleTracking();
        BTMLog.logger.debug("Initializing Java BTM ThreadPool Manager & Worker Threads for OFFLoad mode.");
        ThreadPoolManager.getThreadPoolManager();
    }

    static void updateOffLoadConfiguration() {
        try {
            String string;
            String string2 = PropsManager.getProperty(OFFLOAD_WORKERS);
            BTMOffLoadConfig.assignOffLoadWorker(string2);
            String string3 = PropsManager.getProperty(OFFLOAD_QUEUE_CAPACITY);
            BTMOffLoadConfig.assignOffLoadQueueCapacity(string3);
            String string4 = System.getProperty("eG_Node_ID");
            if (string4 == null || string4.length() <= 0) {
                string4 = PropsManager.getProperty("NODE_ID");
            }
            BTMOffLoadConfig.setOffloadNodeID(string4);
            if (ContainerDiscovery.isThisDockerContainer()) {
                string = PropsManager.getProperty("AGENT_CONTAINER_IP");
                BTMOffLoadConfig.assignCollectorAgentIP(string);
            } else {
                string = PropsManager.getProperty("AGENT_IP");
                BTMOffLoadConfig.assignCollectorAgentIP(string);
            }
            string = PropsManager.getProperty("AGENT_PORT");
            BTMOffLoadConfig.assignCollectorAgentPortNo(string);
            String string5 = PropsManager.getProperty("AGENT_SOCKET_TIMEOUT");
            BTMOffLoadConfig.assignSocketConnectionTimeOut(string5);
            String string6 = System.getProperty("eG_Application_Name");
            if (string6 == null || string6.length() <= 0) {
                string6 = System.getProperty("eG_Service_Name");
            }
            if (string6 == null || string6.length() <= 0) {
                string6 = PropsManager.getProperty("APPLICATION_NAME");
            }
            BTMOffLoadConfig.assignApplicationName(string6);
            String string7 = System.getProperty("eG_Tier_Name");
            if (string7 == null || string7.length() <= 0) {
                string7 = System.getProperty("eG_Group_Name");
            }
            if (string7 == null || string7.length() <= 0) {
                string7 = PropsManager.getProperty("TIER_NAME");
            }
            BTMOffLoadConfig.assignTierName(string7);
            String string8 = PropsManager.getProperty("AUTO_NAMING");
            BTMOffLoadConfig.assignAutoNamingStaus(string8);
            String string9 = PropsManager.getProperty("DISCOVER_AGNET_IP");
            BTMOffLoadConfig.assignAgentIpdiscoveryStaus(string9);
            String string10 = PropsManager.getProperty("WRITE_CONFIG_IN_DISK");
            BTMOffLoadConfig.assignDiskWriteStaus(string10);
            String string11 = PropsManager.getProperty("DISCOVER_CONTAINER_ON_STARTUP");
            BTMOffLoadConfig.assignContainerDiscoveryStaus(string11);
            String string12 = PropsManager.getProperty("DISCOVERY_MAX_WAIT_TIME");
            BTMOffLoadConfig.assignDiscoveryMaxWaitTimeStaus(string12);
            String string13 = PropsManager.getProperty("MBEAN_OBJECT_MAX_WAIT_TIME");
            BTMOffLoadConfig.updateMbeanMaxWaitTime(string13);
            String string14 = PropsManager.getProperty("HEARTBEAT_INTERVAL_TIME");
            BTMOffLoadConfig.assignHeartBeatIntervalTime(string14);
            String string15 = PropsManager.getProperty(LOG_FILE_CLEAN_UP);
            BTMOffLoadConfig.assignLogFileCleanUpStatus(string15);
            String string16 = PropsManager.getProperty(GRANT_LOG_HOME_FILE_ACCESS);
            BTMOffLoadConfig.assignGrantFileAccessStatus(string16);
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Unable to update offload configs from props file {}", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOffloadConfigProps(HashMap hashMap) {
        if (hashMap.size() == 0) {
            return;
        }
        if (memoryCopyOnly) {
            BTMLog.logger.info("Memory copy updated for the properties from {}, Updated Details are {} ", (Object)"config.props", (Object)hashMap);
            Object object = configObject;
            synchronized (object) {
                PropsManager.updatePropertiesOnMemory(hashMap, true);
            }
        }
        if (!PropsManager.isPropsFileExists(PropsManager.configPropsFile)) {
            return;
        }
        Object object = configObject;
        synchronized (object) {
            PropsManager.updateProperties(PropsManager.configPropsFile, hashMap, "Please, Don't edit below config for the component", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOffloadCpcProps(HashMap hashMap) {
        if (hashMap.size() == 0) {
            return;
        }
        if (memoryCopyOnly) {
            BTMLog.logger.info("Memory copy updated for the properties from {}, Updated Details are {} ", (Object)"custom.props", (Object)hashMap);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)hashMap);
            CustomConfigurationManager.getCustomConfiguredPatternMap(properties);
        } else {
            if (!PropsManager.isPropsFileExists(PropsManager.cpcPropsFile)) {
                return;
            }
            Object object = configObject;
            synchronized (object) {
                PropsManager.updateProperties(PropsManager.cpcPropsFile, hashMap, null, true);
            }
        }
    }

    static void setOffloadNodeID(String string) {
        if (string != null && string.length() != 0) {
            btmNodeID = string;
            BTMLog.logger.info("This JVM is assigned with Node ID: {}", (Object)btmNodeID);
        } else {
            BTMLog.logger.warn("Invalid Node ID for this JVM - {}", (Object)string);
        }
    }

    public static String getNodeID() {
        return btmNodeID;
    }

    static boolean isMemoryCopyOnly() {
        return memoryCopyOnly;
    }

    static void assignAgentIpdiscoveryStaus(String string) {
        try {
            if (string != null && string.length() > 0) {
                if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                    isAgentIpDiscoveryEnabled = true;
                } else if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                    isAgentIpDiscoveryEnabled = false;
                }
                BTMLog.logger.debug("Agent Ip Discovery value is set as : {}", (Object)isAgentIpDiscoveryEnabled);
            } else {
                BTMLog.logger.debug("Agent Ip Discovery value is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Agent Ip Discovery value {}  is not Valid {} ", (Object)string, (Object)exception);
        }
    }

    static boolean isAgentIpDiscoveryEnabled() {
        return isAgentIpDiscoveryEnabled;
    }

    static void assignDiskWriteStaus(String string) {
        try {
            if (string != null && string.length() > 0) {
                if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                    memoryCopyOnly = false;
                } else if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                    memoryCopyOnly = true;
                }
                BTMLog.logger.debug("DiskWrite value is set as : {}", (Object)memoryCopyOnly);
            } else {
                BTMLog.logger.debug("DiskWrite value is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("DiskWrite value {}  is not Valid {} ", (Object)string, (Object)exception);
        }
    }

    static void assignContainerDiscoveryStaus(String string) {
        try {
            if (string != null && string.length() > 0) {
                if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                    isContainerDiscoveryEnabled = true;
                } else if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                    isContainerDiscoveryEnabled = false;
                }
                BTMLog.logger.debug("Container Startup Discovery value is set as : {}", (Object)isContainerDiscoveryEnabled);
            } else {
                BTMLog.logger.debug("Container Startup Discovery value is not valid {} ", (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Container Discovery value {}  is not Valid {} ", (Object)string, (Object)exception);
        }
    }

    public static boolean isContainerStartUpDiscoveryEnabled() {
        return isContainerDiscoveryEnabled;
    }

    private static void updateMbeanMaxWaitTime(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    mbeansMaxWaitTime = n * 60 * 1000;
                    BTMLog.logger.debug("discoveryMaxWaitTime : {} ", (Object)discoveryMaxWaitTime);
                }
            }
            catch (Exception exception) {
                mbeansMaxWaitTime = 180000L;
                BTMLog.logger.debug("discoveryMaxWaitTime is not valid : {} , Assigning default value of {} ", (Object)string, (Object)discoveryMaxWaitTime);
            }
        }
    }

    public static long getMbeanMaxWaitTime() {
        return mbeansMaxWaitTime;
    }

    private static void assignDiscoveryMaxWaitTimeStaus(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    discoveryMaxWaitTime = n * 60 * 1000;
                    BTMLog.logger.debug("discoveryMaxWaitTime : {} ", (Object)discoveryMaxWaitTime);
                } else {
                    BTMLog.logger.debug("discoveryMaxWaitTime is not valid :{} ", (Object)n);
                }
            }
            catch (Exception exception) {
                discoveryMaxWaitTime = 900000L;
                BTMLog.logger.debug("discoveryMaxWaitTime is not valid : {} , Assigning default value of {} ", (Object)string, (Object)discoveryMaxWaitTime);
            }
        }
    }

    public static long getDiscoveryMaxWaitTime() {
        return discoveryMaxWaitTime;
    }

    public static String getBtmLogFolderName() {
        if (btmlogFolderFound && btmLogFolderFoundedAs.length() > 0) {
            return btmLogFolderFoundedAs;
        }
        String string = BTMConstants.btmLogFolderName;
        try {
            if (BTMOffLoadConfig.isDefaultLogHomeEnabled()) {
                btmlogFolderFound = true;
                btmLogFolderFoundedAs = string;
                return string;
            }
            boolean bl = ContainerDiscovery.isThisDockerContainer();
            String string2 = "_" + System.currentTimeMillis() + "_" + TimeZoneManager.getShortTimeZone();
            String string3 = "eGBTM_";
            if (bl) {
                String string4 = ContainerDiscovery.getContainerName();
                if (string4 == null || string4.equalsIgnoreCase("none") || string4.length() <= 0) {
                    string4 = (String)ContainerDiscovery.getDiscoveredDetailsByStartup().get("CONTAINER_ID");
                }
                if (string4 != null && !string4.equalsIgnoreCase("none") && string4.length() > 0) {
                    string = string + string4 + File.separatorChar;
                } else {
                    ContainerDiscovery.discoverContainerInformation(ACTION.DISCOVER_FULL_CONTAINER_DETAILS, 10);
                    string4 = ContainerDiscovery.getContainerName();
                    if (string4 != null && !string4.equalsIgnoreCase("none") && string4.length() > 0) {
                        string = string + string4 + File.separatorChar;
                    } else {
                        String string5 = ContainerDiscovery.getProcessID();
                        if (string5 != null && string5.length() > 0) {
                            string = string + string3 + string5 + string2 + File.separatorChar;
                        }
                    }
                }
            } else {
                String string6 = System.getProperty("eG_Node_ID");
                if (btmNodeID != null && btmNodeID.length() > 0 && btmNodeID.startsWith("[") && BTMOffLoadConfig.isDataCollectionMode()) {
                    String string7 = btmNodeID.substring(1, btmNodeID.length() - 1);
                    string7 = string7.replace(":", "_");
                    string = string + string7 + File.separatorChar;
                } else if (string6 != null && string6.length() > 0 && string6.startsWith("[") && BTMOffLoadConfig.isDataCollectionMode()) {
                    String string8 = string6.substring(1, string6.length() - 1);
                    string8 = string8.replace(":", "_");
                    string = string + string8 + File.separatorChar;
                } else {
                    String string9 = ContainerDiscovery.getProcessID();
                    if (string9 != null && string9.length() > 0) {
                        string = string + string3 + string9 + string2 + File.separatorChar;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ContainerDiscovery.printOutLog("INFO", "eG BTM Log Subfolder Name :" + string);
        btmLogFolderFoundedAs = string;
        btmlogFolderFound = true;
        return string;
    }

    static String getBtmLogFolderName(boolean bl) {
        if (bl) {
            ContainerDiscovery.discoverContainerInformation(ACTION.DISCOVER_FULL_CONTAINER_DETAILS, 10);
        }
        return BTMOffLoadConfig.getBtmLogFolderName();
    }

    public static String getBtmLogHomeFolder() {
        return System.getProperty("EG_LOG_HOME");
    }

    public static String getFullLogFolderPath() {
        return BTMOffLoadConfig.getBtmLogHomeFolder() + BTMOffLoadConfig.getBtmLogFolderName();
    }

    public static String getAbsoluteBTMLogFilePath() {
        return BTMOffLoadConfig.getBtmLogHomeFolder() + BTMOffLoadConfig.getBtmLogFolderName() + "BTMLog.log";
    }

    public static String getLogPathWithSubFolderName() {
        return BTMOffLoadConfig.getBtmLogHomeFolder() + BTMConstants.btmLogFolderName;
    }

    private static boolean isDefaultLogHomeEnabled() {
        String string = System.getProperty("eg.default.log.home");
        return string != null && string.length() > 0;
    }

    static void setSystemPropsIpUsed(boolean bl) {
        isSystemPropsIpUsed = bl;
    }

    static boolean isAckReceivedForDiscovery() {
        return isAckReceivedForDiscovery;
    }

    static void setAckReceivedForDiscovery(boolean bl) {
        isAckReceivedForDiscovery = bl;
    }

    static boolean isDiscoveryDetailsFinalized() {
        return isDiscoveryDetailsFinalized;
    }

    static void setDiscoveryDetailsFinalized(boolean bl) {
        isDiscoveryDetailsFinalized = bl;
    }

    static boolean resendDiscoveryData() {
        return !BTMOffLoadConfig.isDiscoveryDetailsFinalized();
    }

    static void resetDiscoveryDataAckFlags() {
        BTMOffLoadConfig.setDiscoveryDetailsFinalized(false);
        BTMOffLoadConfig.setAckReceivedForDiscovery(false);
        BTMLog.logger.debug("Discovery Data Fail-Safe [Data resend]:- Resetting ACK flags, isDiscoveryDetailsFinalized: {}, isAckReceivedForDiscovery: {}", (Object)isDiscoveryDetailsFinalized, (Object)isAckReceivedForDiscovery);
    }

    static void setCollectorAgentIP(String string) {
        collectorAgentIP = string;
    }

    static void writeDetailsInConfig(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        BTMOffLoadConfig.writeOffloadConfigProps(hashMap);
    }
}

