/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.org.objectweb.asm.Type;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class BTMUtils {
    public static final String sepStarLine = "*******************************************************************************************";
    public static final String sepDashLine = "---------------------------------------------";
    public static final String ExcpnRowSep = "?^?";
    public static final int NumRowsInStackTrace = 10;
    private static final char space = ' ';
    static final HashMap<String, String> EXTERNAL_MAPPING = new HashMap();
    static final HashMap<String, String> FRONT_END_MAPPING = new HashMap();
    public static final HashMap<String, String> RUM_MAPPING = new HashMap();
    public static final HashMap<String, String> OVERLOADED_MAPPING = new HashMap();
    public static final Hashtable<Object, Object> IC_INPUT_METHODDESC_MAPPING = new Hashtable();

    private BTMUtils() {
    }

    public static boolean patternMatch(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer;
        int n2;
        if (string2.equals("*")) {
            return true;
        }
        int n3 = string2.indexOf("*");
        if (n3 < 0) {
            return string.equalsIgnoreCase(string2);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!string2.startsWith("*")) {
            bl2 = true;
        }
        if (!string2.endsWith("*")) {
            bl3 = true;
        }
        if ((n2 = (stringTokenizer = new StringTokenizer(string2, "*")).countTokens()) <= 0) {
            return false;
        }
        String string3 = new String(string);
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl2 && !string3.startsWith(stringArray[0])) {
            return false;
        }
        if (bl3 && !string3.endsWith(stringArray[n2 - 1])) {
            return false;
        }
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            string4 = stringArray[i];
            n = string3.indexOf(string4);
            if (n == -1) {
                return false;
            }
            bl = true;
            string3 = new String(string3.substring(n += string4.length()));
        }
        return bl;
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String STEs2Str(Throwable throwable) {
        return BTMUtils.partialSTEs2Str(throwable, -1);
    }

    public static String partialSTEs2Str(Throwable throwable) {
        return BTMUtils.partialSTEs2Str(throwable, 10);
    }

    public static String partialSTEs2Str(Throwable throwable, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = throwable.toString().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() <= 0) continue;
            stringBuffer.append(string2.trim());
            stringBuffer.append(' ');
        }
        stringBuilder.append(stringBuffer).append(ExcpnRowSep);
        int n2 = stackTraceElementArray.length;
        if (n < 1 || n > n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            String string3 = stackTraceElementArray[i].toString().trim();
            if (string3 == null || string3.length() <= 0 || string3.equals("\n")) continue;
            stringBuilder.append(string3).append(ExcpnRowSep);
        }
        return stringBuilder.toString();
    }

    public static String partialSTEs2Str(StackTraceElement[] stackTraceElementArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = stackTraceElementArray.length;
        if (n < 1 || n > n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            String string = stackTraceElementArray[i].toString().trim();
            if (string == null || string.length() <= 0 || string.equals("\n")) continue;
            stringBuilder.append(string).append(ExcpnRowSep);
        }
        return stringBuilder.toString();
    }

    public static String STEs2Str(StackTraceElement[] stackTraceElementArray) {
        return BTMUtils.partialSTEs2Str(stackTraceElementArray, -1);
    }

    public static String checkPortAvailability(String string) {
        ServerSocket serverSocket;
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return "port number " + string + " is not valid";
        }
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (Exception exception) {
            if (exception instanceof BindException) {
                BTMLog.logger.warn("BindException from checkPortAvailability for {} {}", (Object)n, (Object)exception);
                return "Port " + n + " may already be in use.";
            }
            BTMLog.logger.warn("Exception while checking PortAvailability for {} {} ", (Object)n, (Object)exception);
            return "Exception while checking availability of port " + n;
        }
        try {
            BTMLog.logger.info("Closing temporary server socket");
            serverSocket.close();
        }
        catch (IOException iOException) {
            BTMLog.logger.error("Exception while closing temporary server socket {} ", iOException);
            return "Could not close server socket created for testing connection properties! : " + iOException.toString();
        }
        return null;
    }

    public static double String2Double(String string) {
        double d = -1.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            BTMLog.logger.warn("Obtained invalid double value {} {}", (Object)string, (Object)numberFormatException);
        }
        return d;
    }

    public static long String2Long(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            BTMLog.logger.warn("Obtained invalid long value {} {} ", (Object)string, (Object)numberFormatException);
        }
        return l;
    }

    public static int String2Integer(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            BTMLog.logger.warn("Obtained invalid int value {} {}", (Object)string, (Object)numberFormatException);
        }
        return n;
    }

    public static Boolean String2Boolean(String string) {
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getPlainDescription(String string, String string2) {
        char[] cArray = string2.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("_");
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '(': {
                    continue block7;
                }
                case ')': {
                    continue block7;
                }
                case ';': {
                    continue block7;
                }
                case '/': {
                    continue block7;
                }
                case '[': {
                    stringBuilder.append("_sqr_");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static {
        FRONT_END_MAPPING.put("FILTER", "FILTER");
        FRONT_END_MAPPING.put("HTTPSERVLET", "HTTPSERVLET");
        FRONT_END_MAPPING.put("JSP", "JSP");
        FRONT_END_MAPPING.put("STRUTS", "STRUTS");
        FRONT_END_MAPPING.put("THREAD", "THREAD");
        FRONT_END_MAPPING.put("SpringDispatcher", "SpringDispatcher");
        FRONT_END_MAPPING.put("GENERICSERVLET", "GENERICSERVLET");
        FRONT_END_MAPPING.put("JSF", "JSF");
        FRONT_END_MAPPING.put("MULE", "MULE");
        FRONT_END_MAPPING.put("JMS_ENTRY", "JMS_ENTRY");
        OVERLOADED_MAPPING.put("FILTER", "FILTER");
        OVERLOADED_MAPPING.put("HTTPSERVLET", "HTTPSERVLET");
        OVERLOADED_MAPPING.put("JSP", "JSP");
        OVERLOADED_MAPPING.put("STRUTS", "STRUTS");
        OVERLOADED_MAPPING.put("THREAD", "THREAD");
        OVERLOADED_MAPPING.put("SpringDispatcher", "SpringDispatcher");
        OVERLOADED_MAPPING.put("GENERICSERVLET", "GENERICSERVLET");
        OVERLOADED_MAPPING.put("JSF", "JSF");
        OVERLOADED_MAPPING.put("POJO", "POJO");
        OVERLOADED_MAPPING.put("HTTP", "HTTP");
        OVERLOADED_MAPPING.put("HttpConn", "HttpConn");
        OVERLOADED_MAPPING.put("HTTPStream", "HTTPStream");
        EXTERNAL_MAPPING.put("SQL", "jdbcUrl,sqlStmt,sqlError,stackTrace");
        EXTERNAL_MAPPING.put("HTTP", "EXTURL,METHOD,NODE_ORDER,SC,RM");
        EXTERNAL_MAPPING.put("WEBSERVICE", "TargetUrl,OperationName");
        EXTERNAL_MAPPING.put("JMS", "JMS-PROVIDER,JMS-QUEUE,TYPE,NODE_ORDER");
        EXTERNAL_MAPPING.put("JMS_ENTRY", "JMS-PROVIDER,JMS-QUEUE,TYPE");
        EXTERNAL_MAPPING.put("SAP JCO", "ASHost,SystemNo,systemID,User,CLIENT,JCOFunction,Group,URL,TPName,GWHost,GWServ,MSHost");
        EXTERNAL_MAPPING.put("RMI", "host,protocol");
        EXTERNAL_MAPPING.put("LDAP", "method,endPoint");
        EXTERNAL_MAPPING.put("EMAIL", "method,endPoint");
        EXTERNAL_MAPPING.put("EJB_HIDE", "ejbhost,method,NODE_ORDER");
        EXTERNAL_MAPPING.put("RUNTIME", "COMMAND");
        EXTERNAL_MAPPING.put("REDIS", "redisIP,redisPort,redisDetails");
        EXTERNAL_MAPPING.put("MONGODB", "mongoServerDetails,mongoDBName,mongoTableName,mongoMethodName,mongoQuery");
        RUM_MAPPING.put("doPost", "doPost");
        RUM_MAPPING.put("doGet", "doGet");
        RUM_MAPPING.put("service", "service");
        RUM_MAPPING.put("_jspService", "_jspService");
        IC_INPUT_METHODDESC_MAPPING.put("void", Type.VOID_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("boolean", Type.BOOLEAN_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("char", Type.CHAR_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("byte", Type.BYTE_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("short", Type.SHORT_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("int", Type.INT_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("float", Type.FLOAT_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("long", Type.LONG_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("double", Type.DOUBLE_TYPE);
        IC_INPUT_METHODDESC_MAPPING.put("boolean[]", Type.getDescriptor(boolean[].class));
        IC_INPUT_METHODDESC_MAPPING.put("char[]", Type.getDescriptor(char[].class));
        IC_INPUT_METHODDESC_MAPPING.put("byte[]", Type.getDescriptor(byte[].class));
        IC_INPUT_METHODDESC_MAPPING.put("short[]", Type.getDescriptor(short[].class));
        IC_INPUT_METHODDESC_MAPPING.put("int[]", Type.getDescriptor(int[].class));
        IC_INPUT_METHODDESC_MAPPING.put("float[]", Type.getDescriptor(float[].class));
        IC_INPUT_METHODDESC_MAPPING.put("long[]", Type.getDescriptor(long[].class));
        IC_INPUT_METHODDESC_MAPPING.put("double[]", Type.getDescriptor(double[].class));
    }
}

