/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMPojoBoolean;
import com.eg.jtm.BTMSqlBoolean;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.RequestIdentifier;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class LongRunningTrackerThread
implements Runnable {
    private RequestIdentifier requestIdentifier = null;
    private Thread parentThread = null;
    private BTMPojoBoolean booleanPojoObject = null;
    private BTMSqlBoolean booleanSqlObject = null;

    public LongRunningTrackerThread(RequestIdentifier requestIdentifier, BTMPojoBoolean bTMPojoBoolean, BTMSqlBoolean bTMSqlBoolean, Thread thread) {
        this.requestIdentifier = requestIdentifier;
        this.parentThread = thread;
        this.booleanPojoObject = bTMPojoBoolean;
        this.booleanSqlObject = bTMSqlBoolean;
    }

    public void run() {
        if (this.requestIdentifier != null && this.parentThread != null) {
            MethodEventProcessor.removeObjectFromThreadLocal();
            this.parentThreadLocalDetails();
            this.parentInheritableThreadLocalDetails();
            MethodInfo methodInfo = this.requestIdentifier.getRootMinfo();
            long l = BTMUtils.getTimeStamp();
            while (!methodInfo.isCompleted()) {
                this.requestIdentifier.onMethodEnd(false, l);
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            boolean bl = this.requestIdentifier.isFirstNodeRequest();
            this.requestIdentifier.recordEndTime();
            this.requestIdentifier.onEnd();
            long l2 = MethodEventProcessor.getDiagnosisData(this.requestIdentifier, methodInfo);
            long l3 = this.requestIdentifier.getThreadBlockedTime();
            long l4 = this.requestIdentifier.getThreadWaitedTime();
            String string = methodInfo.getUrlPatternsMatched();
            methodInfo.calculateMinfo(this.requestIdentifier, false, string);
            MethodEventProcessor.addStalledURLDetails(methodInfo, bl, this.requestIdentifier, l2, l3, l4);
            this.requestIdentifier.freeMemory();
            this.requestIdentifier = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parentThreadLocalDetails() {
        boolean bl = false;
        if (this.parentThread == null) {
            return bl;
        }
        Field field = null;
        try {
            field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            return bl;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return bl;
        }
        Class<?> clazz = null;
        Field field2 = null;
        Object object = null;
        Object object2 = null;
        try {
            clazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        try {
            field2 = clazz.getDeclaredField("table");
            field2.setAccessible(true);
            object = field.get(this.parentThread);
            if (object == null) {
                boolean bl2 = bl;
                return bl2;
            }
            object2 = field2.get(object);
            if (object2 != null) {
                int n = Array.getLength(object2);
                for (int i = 0; i < n; ++i) {
                    Object object3 = Array.get(object2, i);
                    if (object3 == null) continue;
                    try {
                        String string;
                        Field field3 = object3.getClass().getDeclaredField("value");
                        field3.setAccessible(true);
                        Object object4 = field3.get(object3);
                        if (object4 == null || !(string = object4.getClass().getName()).startsWith("com.eg.jtm.")) continue;
                        if (object4 instanceof RequestIdentifier) {
                            if (this.requestIdentifier != object4) continue;
                            field3.set(object3, null);
                            bl = true;
                            continue;
                        }
                        if (object4 instanceof BTMPojoBoolean) {
                            if (this.booleanPojoObject != object4) continue;
                            field3.set(object3, null);
                            bl = true;
                            continue;
                        }
                        if (!(object4 instanceof BTMSqlBoolean) || this.booleanSqlObject != object4) continue;
                        field3.set(object3, null);
                        bl = true;
                        continue;
                    }
                    catch (Exception exception) {
                        boolean bl3 = bl;
                        return bl;
                    }
                }
            }
        }
        catch (SecurityException securityException) {}
        catch (NoSuchFieldException noSuchFieldException) {}
        catch (IllegalArgumentException illegalArgumentException) {}
        catch (IllegalAccessException illegalAccessException) {}
        finally {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parentInheritableThreadLocalDetails() {
        boolean bl = false;
        if (this.parentThread == null) {
            return bl;
        }
        Field field = null;
        try {
            field = Thread.class.getDeclaredField("inheritableThreadLocals");
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            return bl;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return bl;
        }
        Class<?> clazz = null;
        Field field2 = null;
        Object object = null;
        Object object2 = null;
        try {
            clazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        try {
            field2 = clazz.getDeclaredField("table");
            field2.setAccessible(true);
            object = field.get(this.parentThread);
            if (object == null) {
                boolean bl2 = bl;
                return bl2;
            }
            object2 = field2.get(object);
            if (object2 != null) {
                int n = Array.getLength(object2);
                for (int i = 0; i < n; ++i) {
                    Object object3 = Array.get(object2, i);
                    if (object3 == null) continue;
                    try {
                        Field field3 = object3.getClass().getDeclaredField("value");
                        field3.setAccessible(true);
                        Object object4 = field3.get(object3);
                        if (object4 == null || !(object4 instanceof RequestIdentifier) || this.requestIdentifier != object4) continue;
                        field3.set(object3, null);
                        bl = true;
                        continue;
                    }
                    catch (Exception exception) {
                        boolean bl3 = bl;
                        return bl;
                    }
                }
            }
        }
        catch (SecurityException securityException) {}
        catch (NoSuchFieldException noSuchFieldException) {}
        catch (IllegalArgumentException illegalArgumentException) {}
        catch (IllegalAccessException illegalAccessException) {}
        finally {
            return bl;
        }
    }
}

