/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.RootTracer;
import com.eg.agent.trace.utils.Base64Coder;
import com.eg.agent.trace.utils.StatusCodeUtils;
import com.eg.agent.trace.utils.TraceUtils;
import com.eg.agent.ux.Measure;
import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMPojoBoolean;
import com.eg.jtm.BTMSqlBoolean;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.OtherAPMTestConfiguration;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.RumPropsManager;
import com.eg.jtm.StatusCodeErrorRange;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import com.eg.jtm.learning.EgThreadPoolExecutor;
import com.eg.jtm.learning.EgWorkerThread;
import com.eg.jtm.learning.LearningProperties;
import com.eg.rum.RumBtmIntegrationHelper;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MethodEventProcessor {
    private static ThreadLocal<RequestIdentifier> reqIdTL = new ThreadLocal();
    private static InheritableThreadLocal<RequestIdentifier> inheritReqIdTL = new InheritableThreadLocal();
    private static final String PATTERN_STRING = "PS";

    private MethodEventProcessor() {
    }

    public static String getInComingGUID() {
        String string = null;
        RequestIdentifier requestIdentifier = reqIdTL.get();
        if (requestIdentifier != null) {
            string = requestIdentifier.getReqGUID();
        }
        return string;
    }

    public static RequestIdentifier getRequestIdentifier() {
        RequestIdentifier requestIdentifier = reqIdTL.get();
        return requestIdentifier;
    }

    static void removeObjectFromThreadLocal() {
        reqIdTL.remove();
        inheritReqIdTL.remove();
        RootTracer.pojoBlockLocal.set(null);
        RootTracer.sqlBlockLocal.set(null);
    }

    static void removeFromThreadLocal() {
        RequestIdentifier requestIdentifier = reqIdTL.get();
        if (requestIdentifier != null) {
            requestIdentifier.freeMemory();
        }
        MethodEventProcessor.removeObjectFromThreadLocal();
    }

    public static boolean eventStarted(RequestIdentifier requestIdentifier, Map map, String string, String string2, String string3, String string4, long l, String string5) {
        return MethodEventProcessor.eventStarted(requestIdentifier, map, string, string2, string3, string4, l, string5, null, null, null);
    }

    public static boolean eventStarted(RequestIdentifier requestIdentifier, Map map, String string, String string2, String string3, String string4, long l, String string5, Object object, Object object2, Object object3) {
        boolean bl;
        block21: {
            bl = false;
            try {
                if (requestIdentifier == null) {
                    requestIdentifier = (RequestIdentifier)inheritReqIdTL.get();
                    if (requestIdentifier == null) {
                        if (string5 != null && MethodInfo.isFrontEndComponent(string)) {
                            String string6 = null;
                            boolean bl2 = false;
                            if (map != null) {
                                if (map.containsKey("eG-GUID")) {
                                    string6 = (String)map.get("eG-GUID");
                                }
                                if (map.containsKey("KEY_TRANSACTION")) {
                                    bl2 = true;
                                }
                            }
                            RequestIdentifier requestIdentifier2 = new RequestIdentifier(new MethodInfo(), "Web", string6, l, bl2);
                            MethodEventProcessor.initialTLValues(requestIdentifier2, object);
                            bl = requestIdentifier2.rootMethodStart(string2, string3, string4, l, map, string, string5);
                            BTMLog.logger.debug("{}    EventStarted    {}    {}    {}    {} ", string, requestIdentifier2.getReqGUID(), (String)map.get("requestID"), string2, string3);
                            if (object2 != null && object3 != null && MeasureUtil.isICExists()) {
                                MethodEventProcessor.getICMeasures(object, object2, object3, requestIdentifier2, true);
                            }
                            if (object != null && requestIdentifier2.isRumBtmIntegrationEnabled()) {
                                MethodEventProcessor.doRumBtmIntegration(requestIdentifier2, object, object2, "-", map);
                            }
                        }
                    } else if (string.equals("THREAD")) {
                        long l2 = Thread.currentThread().getId();
                        String string7 = Thread.currentThread().getName();
                        BTMLog.logger.debug("NEW THREAD CALL found {} & ID {} . Is RequestIdentifier Object ( from inheritReqIdTL ) Presents?  {} ", string7, l2, requestIdentifier != null);
                        String[] stringArray = requestIdentifier.getAsyncGUID(l2);
                        if (stringArray == null) {
                            BTMLog.logger.debug("Parent Details Not Found for THREAD CALL : {}  & ID {} ", (Object)string7, (Object)l2);
                        } else {
                            MethodInfo methodInfo = requestIdentifier.getRootMinfo();
                            boolean bl3 = requestIdentifier.isKeyTransactionRequest();
                            String string8 = null;
                            if (methodInfo != null) {
                                string8 = methodInfo.getUrlPatternsMatched();
                            }
                            if (string8 != null) {
                                Map map2 = methodInfo.getProperties();
                                string7 = string7 + "[" + l2 + "]";
                                String string9 = stringArray[0];
                                String string10 = stringArray[1];
                                HashMap hashMap = MethodEventProcessor.getCurrentThreadProps(map2, string7, string9);
                                String string11 = string8;
                                BTMLog.logger.debug("NEW ASYNC CALL FOUND FOR PATTERN : {} & THREAD DETAILS : {} isKeyTransaction? {} ", string11, string7, bl3);
                                RequestIdentifier requestIdentifier3 = new RequestIdentifier(new MethodInfo(), "Thread", string10, l, bl3);
                                MethodEventProcessor.initialTLValues(requestIdentifier3, null);
                                bl = requestIdentifier3.rootMethodStart(string2, string3, string4, l, hashMap, string, string11);
                                BTMLog.logger.debug("{}    EventStarted    {}    {}    {}    {} ", string, requestIdentifier3.getReqGUID(), (String)hashMap.get("requestID"), string2, string3);
                            }
                        }
                    } else if (string.equals("JMS_ENTRY")) {
                        String string12;
                        boolean bl4 = requestIdentifier.isKeyTransactionRequest();
                        if (!(map == null || (string12 = (String)map.get("eG-GUID")) != null && string12.equals("-"))) {
                            RequestIdentifier requestIdentifier4 = new RequestIdentifier(new MethodInfo(), "Web", string12, l, bl4);
                            MethodEventProcessor.initialTLValues(requestIdentifier4, null);
                            bl = requestIdentifier4.rootMethodStart(string2, string3, string4, l, map, string, string5);
                            BTMLog.logger.debug("{}    EventStarted    {}    {}    {}    {} ", string, requestIdentifier4.getReqGUID(), (String)map.get("requestID"), string2, string3);
                        }
                    }
                    break block21;
                }
                boolean bl5 = false;
                try {
                    bl5 = requestIdentifier.onMethodStart(string2, string3, string4, l, map, string);
                    BTMLog.logger.debug("{}    EventStarted    {}    {}    {}    {} ", string, requestIdentifier.getReqGUID(), string2, string3, map);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl5;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[MethodEventProcessor - eventStarted ] Exception while recording an event start", exception);
                bl = false;
                MethodEventProcessor.removeObjectFromThreadLocal();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sqlEventEnded(RequestIdentifier requestIdentifier, boolean bl, long l, Object object) {
        try {
            if (requestIdentifier == null) return;
            BTMLog.logger.debug("{}    EventEnded    {}    {}    {}", requestIdentifier.getCurrentMinfo().getType(), requestIdentifier.getReqGUID(), requestIdentifier.getCurrentMinfo().getClassName(), requestIdentifier.getCurrentMinfo().getMethodName());
            if (!requestIdentifier.sqlMethodEnd(bl, l, object)) return;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor - sqlEventEnded ] Exception {} ", exception);
        }
    }

    private static void getICMeasures(Object object, Object object2, Object object3, RequestIdentifier requestIdentifier, boolean bl) {
        if (requestIdentifier.capturedIcValues()) {
            return;
        }
        String string = null;
        try {
            string = requestIdentifier.getRootMinfo().getRawURL();
            String string2 = MeasureUtil.getRequestUriOnly(string);
            MethodEventProcessor.getStaticMeasures(object, object2, object3, bl, string2, requestIdentifier);
            if (requestIdentifier.capturedIcValues()) {
                return;
            }
            MethodEventProcessor.getSessionMeasures(object, object2, object3, bl, string2, requestIdentifier, string);
            if (requestIdentifier.capturedIcValues()) {
                return;
            }
            MethodEventProcessor.getRequestParamMeasures(object2, requestIdentifier, string2);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_for_APM] Exception occured while processing IC Measures !!!.. {} ", exception);
        }
    }

    private static void getRequestParamMeasures(Object object, RequestIdentifier requestIdentifier, String string) {
        Hashtable<String, Measure> hashtable = MeasureUtil.getRequestParamMeasureTable();
        Enumeration<Measure> enumeration = hashtable.elements();
        block0: while (enumeration.hasMoreElements()) {
            Measure measure = enumeration.nextElement();
            if (measure == null) continue;
            int n = measure.getFieldType();
            boolean bl = requestIdentifier.capturedIcUsernameValue();
            boolean bl2 = requestIdentifier.capturedIcBusinessContextValue();
            if (bl && bl2) break;
            if (n == 1 && bl || n == 2 && bl2) continue;
            String string2 = measure.getSessionKey();
            String string3 = measure.getId();
            ArrayList arrayList = measure.getUrlPatterns();
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl3;
                String string4 = (String)arrayList.get(i);
                if (string == null || string4 == null || !(bl3 = BTMUtils.patternMatch(string, string4))) continue;
                BTMLog.logger.info("[IC_for_APM] Started to process HTTP Request parameter measure for the URL Pattern : {} & Parameter Name : {} [Measure id = {}] ", string4, string2, string3);
                Object object2 = MethodEventProcessor.getRequestParameter(object, string2);
                BTMLog.logger.info("[IC_for_APM] Result of HTTP Request parameter measure for the URL Pattern : {} & Parameter Name : {} result = {} ", string4, string2, object2);
                if (object2 == null) continue block0;
                String string5 = object2.toString();
                if (measure.isUserNameField()) {
                    requestIdentifier.setIcUsername(string5);
                    BTMLog.logger.debug("[IC_for_APM] Processed Request Parameter measure for the [Measure id = {}] Result : {} ", (Object)string3, (Object)string5);
                    continue block0;
                }
                requestIdentifier.setIcBusinessContext(string5);
                BTMLog.logger.debug("[IC_for_APM] Processed Request Parameter measure for the [Measure id = {}] Result : {} ", (Object)string3, (Object)string5);
                continue block0;
            }
        }
    }

    private static Object getRequestParameter(Object object, String string) {
        Class<?> clazz = null;
        Object object2 = null;
        try {
            clazz = object.getClass();
            Method method = clazz.getMethod("getParameter", String.class);
            method.setAccessible(true);
            object2 = method.invoke(object, new String(string));
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_for_APM] Exception occured while processing getRequestParameter !!!.. {} ", exception);
            object2 = null;
        }
        return object2;
    }

    private static void getStaticMeasures(Object object, Object object2, Object object3, boolean bl, String string, RequestIdentifier requestIdentifier) {
        block6: {
            try {
                Hashtable<String, Measure> hashtable = MeasureUtil.getStaticMethodMeasures();
                if (hashtable == null) break block6;
                Enumeration<Measure> enumeration = hashtable.elements();
                block2: while (enumeration.hasMoreElements()) {
                    Measure measure = enumeration.nextElement();
                    if (measure == null) continue;
                    int n = measure.getFieldType();
                    boolean bl2 = requestIdentifier.capturedIcUsernameValue();
                    boolean bl3 = requestIdentifier.capturedIcBusinessContextValue();
                    if (!bl2 || !bl3) {
                        if (n == 1 && bl2 || n == 2 && bl3) continue;
                        ArrayList arrayList = measure.getUrlPatterns();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            boolean bl4;
                            String string2 = (String)arrayList.get(i);
                            if (string == null || string2 == null || !(bl4 = BTMUtils.patternMatch(string, string2))) continue;
                            boolean bl5 = measure.isFetchOnReqStart();
                            String string3 = measure.getId();
                            if (bl && bl5) {
                                BTMLog.logger.info("[IC_for_APM] Started to process IC static measure in the Start of the transaction [Measure id = {}]", (Object)string3);
                                MethodEventProcessor.getStaticMethodValue(object2, object3, measure, requestIdentifier);
                                BTMLog.logger.info("[IC_for_APM] Processed the IC static Measure in the Start of the transaction [Measure id = {}]", (Object)string3);
                                continue block2;
                            }
                            if (bl || bl5) continue block2;
                            BTMLog.logger.info("[IC_for_APM] Started to process IC static measure in the End of the transaction [Measure id = {}]", (Object)string3);
                            MethodEventProcessor.getStaticMethodValue(object2, object3, measure, requestIdentifier);
                            BTMLog.logger.info("[IC_for_APM] Processed the IC static Measure in the End of the transaction [Measure id = {}]", (Object)string3);
                            continue block2;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while processing Static method measure..{}", exception);
            }
        }
    }

    private static void getSessionMeasures(Object object, Object object2, Object object3, boolean bl, String string, RequestIdentifier requestIdentifier, String string2) {
        block9: {
            try {
                Object object4;
                Object object5;
                Hashtable<String, Measure> hashtable = MeasureUtil.getSessionMeasures();
                if (hashtable == null || hashtable.size() <= 0) break block9;
                boolean bl2 = false;
                if (object != null && (object5 = ((Class)(object4 = object.getClass())).getMethod("isCommitted", new Class[0])) != null) {
                    ((Method)object5).setAccessible(true);
                    Object object6 = ((Method)object5).invoke(object, TraceUtils.ARGS);
                    if (object6 != null) {
                        bl2 = (Boolean)object6;
                    }
                }
                if (bl2) {
                    return;
                }
                object4 = hashtable.elements();
                block2: while (object4.hasMoreElements()) {
                    object5 = (Measure)object4.nextElement();
                    if (object5 == null) continue;
                    int n = ((Measure)object5).getFieldType();
                    boolean bl3 = requestIdentifier.capturedIcUsernameValue();
                    boolean bl4 = requestIdentifier.capturedIcBusinessContextValue();
                    if (!bl3 || !bl4) {
                        if (n == 1 && bl3 || n == 2 && bl4) continue;
                        ArrayList arrayList = ((Measure)object5).getUrlPatterns();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            boolean bl5;
                            String string3 = (String)arrayList.get(i);
                            if (string == null || string3 == null || !(bl5 = BTMUtils.patternMatch(string, string3))) continue;
                            boolean bl6 = ((Measure)object5).isFetchOnReqStart();
                            String string4 = ((Measure)object5).getId();
                            if (bl && bl6) {
                                BTMLog.logger.info("[IC_for_APM] Started to process IC Session Measure in the Start of the transaction [Measure id = {}]", (Object)string4);
                                MethodEventProcessor.getSesssionAttributeValue(object, object2, (Measure)object5, requestIdentifier);
                                BTMLog.logger.info("[IC_for_APM] Processed the IC Session Measure in the Start of the transaction [Measure id = {}]", (Object)string4);
                                continue block2;
                            }
                            if (bl || bl6) continue block2;
                            BTMLog.logger.info("[IC_for_APM] Started to process IC Session Measure in the End of the transaction [Measure id = {}]", (Object)string4);
                            MethodEventProcessor.getSesssionAttributeValue(object, object2, (Measure)object5, requestIdentifier);
                            BTMLog.logger.info("[IC_for_APM] Processed the IC Session Measure in the End of the transaction [Measure id = {}]", (Object)string4);
                            continue block2;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while processing Session Attribute measure.. {}", exception);
            }
        }
    }

    private static void getSesssionAttributeValue(Object object, Object object2, Measure measure, RequestIdentifier requestIdentifier) {
        try {
            BTMLog.logger.info("[IC_for_APM] Started to get the Session value [Measure id = {}]", (Object)measure.getId());
            String string = measure.getSessionKey();
            String string2 = null;
            if (object2 != null) {
                Class<?> clazz = object2.getClass();
                Method method = MeasureUtil.getMethodFromClass(clazz, "getSession", null, true);
                if (method != null) {
                    Class[] classArray;
                    Method method2;
                    Class<?> clazz2;
                    method.setAccessible(true);
                    Object object3 = method.invoke(object2, TraceUtils.ARGS);
                    if (object3 != null && (clazz2 = object3.getClass()) != null && (method2 = MeasureUtil.getMethodFromClass(clazz2, "getAttribute", classArray = new Class[]{String.class}, true)) != null) {
                        method2.setAccessible(true);
                        Object object4 = method2.invoke(object3, string);
                        if (object4 != null) {
                            string2 = object4.toString();
                            boolean bl = measure.isUserNameField();
                            if (string2 != null) {
                                if (bl) {
                                    requestIdentifier.setIcUsername(string2);
                                } else {
                                    requestIdentifier.setIcBusinessContext(string2);
                                }
                            }
                        }
                    }
                }
                BTMLog.logger.debug("[IC_for_APM] Set the Session value for the Measure [Measure id= {}] ; Value = {}", (Object)measure.getId(), (Object)string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_for_APM] Exception while getting Session values.. {} ", exception);
        }
    }

    private static void getStaticMethodValue(Object object, Object object2, Measure measure, RequestIdentifier requestIdentifier) {
        try {
            String string;
            BTMLog.logger.info("[IC_for_APM] Started to get the Static method return value [Measure id = {}]", (Object)measure.getId());
            String string2 = measure.getId();
            Object[] objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
            boolean bl = measure.isInputRequestObj();
            if (bl) {
                classArray = new Class[]{Object.class};
                objectArray = new Object[]{object};
            }
            ClassLoader classLoader = null;
            if (object2 != null) {
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception exception) {
                    classLoader = null;
                    BTMLog.logger.warn("[IC_for_APM] Exception occured while getting the Classloader, so it is set to null!!...{}", exception);
                }
            }
            Class<?> clazz = null;
            try {
                if (classLoader != null) {
                    clazz = classLoader.loadClass(measure.getClassName());
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[IC_for_APM] Couldn't able to load the configured class.. [Measure id = {}] & exception is {} ", (Object)string2, (Object)exception);
            }
            Method method = MeasureUtil.getMethodFromClass(clazz, measure.getMethodName(), classArray, false);
            Object object3 = null;
            if (method != null) {
                try {
                    method.setAccessible(true);
                    string = method.getReturnType().toString();
                    if ("void".equalsIgnoreCase(string)) {
                        BTMLog.logger.warn("[IC_For_APM] Invalid Measure; Method return type is VOID type [Measure id = {}]", (Object)string2);
                        MeasureUtil.removeRuntimeInvalidMeasure(string2, string2, 2);
                    }
                    object3 = method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_for_APM] Couldn't possible to invoke the declared Method for the [Measure id = {}] & exception is {}", (Object)string2, (Object)exception);
                }
            }
            string = null;
            if (object3 != null) {
                try {
                    string = object3.toString();
                }
                catch (Exception exception) {
                    string = null;
                    BTMLog.logger.warn("[IC_for_APM] Exception occured while performing type conversion for the [Measure id = {}] & exception is {}", (Object)string2, (Object)exception);
                }
                boolean bl2 = measure.isUserNameField();
                if (string != null) {
                    if (bl2) {
                        requestIdentifier.setIcUsername(string);
                    } else {
                        requestIdentifier.setIcBusinessContext(string);
                    }
                }
            }
            BTMLog.logger.debug("[IC_for_APM] Static Value for the configured method [Measure id = {}]  , Value =  {}", (Object)string2, (Object)string);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_for_APM] Exception while getting getStaticMeasure values : {} ", exception);
        }
    }

    private static void injectRumScript(Object object, RequestIdentifier requestIdentifier, String string, String string2) {
        try {
            if (requestIdentifier.getWriterObj() != null) {
                MethodEventProcessor.writeRumScript(object, string, "getWriter", "println", new Class[]{String.class}, false);
            } else if (requestIdentifier.getOutputStreamObject() != null) {
                MethodEventProcessor.writeRumScript(object, string, "getOutputStream", "write", new Class[]{byte[].class}, true);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor] [injectRumScript] Exception occured {} ", exception);
        }
    }

    private static void writeRumScript(Object object, String string, String string2, String string3, Class[] classArray, boolean bl) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod(string2, new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, TraceUtils.ARGS);
            Object[] objectArray = null;
            Method method2 = null;
            if (bl) {
                method2 = OutputStream.class.getMethod(string3, byte[].class);
                objectArray = new Object[]{string.getBytes()};
            } else {
                method2 = PrintWriter.class.getMethod(string3, classArray);
                objectArray = new Object[]{string};
            }
            method2.setAccessible(true);
            method2.invoke(object2, objectArray);
            BTMLog.logger.info("[MethodEventProcessor][writeRumScript] eGRum Script Injection Success using {} ", (Object)string2);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor][writeRumScript] Exception occured  when using {} {} ", (Object)string2, (Object)exception);
        }
    }

    static long getDiagnosisData(RequestIdentifier requestIdentifier, MethodInfo methodInfo) {
        long l = requestIdentifier.getThreadCPUTime();
        long l2 = requestIdentifier.getThreadBlockedTime();
        long l3 = requestIdentifier.getThreadWaitedTime();
        long l4 = 0L;
        l4 = l >= 0L ? l4 + l : l4;
        long l5 = l4 = l2 >= 0L ? l4 + l2 + l3 : l4;
        if (l4 > methodInfo.getExecutionTime()) {
            BTMLog.logger.info("Thread diagnosis time is higher than response time !!!! for the GUID {} ", (Object)requestIdentifier.getReqGUID());
            long l6 = l4 - methodInfo.getExecutionTime();
            if (l >= l6) {
                l -= l6;
            }
        }
        Map map = methodInfo.getProperties();
        map.put("cpuTime", l);
        map.put("blockedTime", l2);
        map.put("waitedTime", l3);
        return l;
    }

    public static void rootEventEnded(RequestIdentifier requestIdentifier, boolean bl, long l, Object object, Object object2, Object object3) {
        try {
            if (requestIdentifier != null) {
                MethodInfo methodInfo;
                BTMLog.logger.debug("{}    EventEnded    {}    {}    {}", requestIdentifier.getCurrentMinfo().getType(), requestIdentifier.getReqGUID(), requestIdentifier.getCurrentMinfo().getClassName(), requestIdentifier.getCurrentMinfo().getMethodName());
                if (requestIdentifier.onMethodEnd(bl, l) && (methodInfo = requestIdentifier.getRootMinfo()).isCompleted()) {
                    Object object4;
                    Object object5;
                    HashMap<String, String> hashMap;
                    MethodEventProcessor.removeObjectFromThreadLocal();
                    requestIdentifier.recordEndTime();
                    long l2 = MethodEventProcessor.getDiagnosisData(requestIdentifier, methodInfo);
                    long l3 = requestIdentifier.getThreadBlockedTime();
                    long l4 = requestIdentifier.getThreadWaitedTime();
                    Map map = methodInfo.getProperties();
                    String string = methodInfo.getUrlPatternsMatched();
                    if (object2 != null) {
                        TraceUtils.updateSessionID(object2, methodInfo, requestIdentifier.getReqGUID(), requestIdentifier.getRequestURL());
                        if (object3 != null && MeasureUtil.isICExists()) {
                            MethodEventProcessor.getICMeasures(object, object2, object3, requestIdentifier, false);
                        }
                        string = TraceUtils.updateCPCPattern(object2, map, string, requestIdentifier.getReqGUID());
                    }
                    String string2 = requestIdentifier.getRequestType();
                    boolean bl2 = requestIdentifier.isFirstNodeRequest();
                    long l5 = methodInfo.getExecutionTime();
                    requestIdentifier.onEnd();
                    if (object != null) {
                        MethodEventProcessor.doResponseEnd(object2, object, requestIdentifier, bl, string2, bl2, l5, map);
                    }
                    if ((hashMap = requestIdentifier.getIcMeasureData()) != null) {
                        MethodEventProcessor.addICDetails(hashMap, map);
                    }
                    methodInfo.calculateMinfo(requestIdentifier, true, string);
                    if (requestIdentifier.is404Code()) {
                        String string3 = (String)map.get("requestID");
                        BTMLog.logger.warn("Status code 404 Found for the URL : {}  & GUID : {} ", (Object)string3, (Object)requestIdentifier.getReqGUID());
                        StatusCodeUtils.update404Counter(1.0, 0.0);
                        requestIdentifier.freeMemory();
                        return;
                    }
                    if (!TraceUtils.isDiscoveryDetailsSent()) {
                        TraceUtils.getContainerDetails(object2, map);
                    }
                    boolean bl3 = requestIdentifier.isKeyTransactionRequest();
                    if (PropsManager.isOldModel()) {
                        if (!bl3 && (object5 = PropsManager.autoPatternTable.get(object4 = methodInfo.getUrlPatternsMatched())) == null) {
                            PropsManager.autoPatternTable.put((String)object4, (String)object4);
                            UPDManager.updateTables4Auto();
                        }
                        if (methodInfo.isErrorURL() || methodInfo.isSlowURL()) {
                            MethodEventProcessor.addToUPD(methodInfo, bl2, bl3, string2, l2, l3, l4);
                        } else if (methodInfo.isStalled()) {
                            MethodEventProcessor.addStalledURLDetails(methodInfo, bl2, bl3, string2, l2, l3, l4);
                        } else {
                            MethodEventProcessor.updateAllUrlDetails(methodInfo, bl2, bl3, string2, l2, l3, l4);
                        }
                    } else {
                        map.put("firstNode", bl2);
                        map.put("keyTransaction", bl3);
                        map.put("requestType", string2);
                        map.put("isStalled", methodInfo.isStalled());
                        map.put("isSlowURL", methodInfo.isSlowURL());
                        map.put("isErrorURL", methodInfo.isErrorURL());
                        map.put("isSQLPresent", methodInfo.isSQLPresent());
                        map.put(PATTERN_STRING, string);
                        object4 = ThreadPoolManager.getThreadPoolManager();
                        ((ThreadPoolManager)object4).submitTask(methodInfo);
                        BTMLog.logger.info("REQUEST END !!! Details = GUID :{}, TYPE :{}, URL :{} , PATTERN :{} , EXE.TIME :{} ms ", requestIdentifier.getReqGUID(), string2, map.get("requestID"), string, l5);
                        BTMLog.logger.debug("eG Java BTM metrics are added into the queue & current queue size is {} ", (Object)((ThreadPoolManager)object4).getQueueSize());
                    }
                    if (LearningProperties.isLearningMode()) {
                        object4 = requestIdentifier.getMethodCountMap();
                        object5 = requestIdentifier.getFastMethodMap();
                        MethodEventProcessor.createWorkerThread((HashMap)object4, (HashMap)object5);
                    }
                    requestIdentifier.freeMemory();
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor - rootEventEnded ] Exception {} ", exception);
            requestIdentifier.freeMemory();
        }
    }

    public static void doRUMInjection(RequestIdentifier requestIdentifier, boolean bl) {
        Object object = requestIdentifier.getResponseObject();
        if (object == null || requestIdentifier.isAlreadyRumScriptInjected()) {
            return;
        }
        String string = (String)requestIdentifier.getRootMinfo().getProperties().get("RequestURI");
        if (RumPropsManager.isRumEnabled() && requestIdentifier.isInjectRumScript()) {
            String string2 = RumPropsManager.getRumScript();
            if (string2.length() > 0) {
                if (bl || requestIdentifier.isAjaxRequest()) {
                    BTMLog.logger.info("RUM script will not be injected for the URL : {} either EXCEPTION or AJAX call ", (Object)string);
                } else if (string != null) {
                    if (requestIdentifier.getContentType() == RequestIdentifier.ContentType.TEXT_HTML) {
                        if (requestIdentifier.getTags().isInject()) {
                            BTMLog.logger.info("Tag Found : {} presents for the URL : {}  is eligible for RUM Injection & contentType :  {} ", new Object[]{requestIdentifier.getTags(), string, requestIdentifier.getContentTypeString()});
                            if (requestIdentifier.isRumBtmIntegrationEnabled()) {
                                MethodInfo methodInfo = requestIdentifier.getRootMinfo();
                                long l = methodInfo.getExecutionTime();
                                String string3 = requestIdentifier.getReqGUID();
                                String string4 = PropsManager.getJvmGUID();
                                String string5 = (String)methodInfo.getProperties().get("SESSIONID");
                                String string6 = "-";
                                HashMap<String, String> hashMap = requestIdentifier.getIcMeasureData();
                                if (hashMap != null && hashMap.containsKey("Username")) {
                                    string6 = hashMap.get("Username");
                                }
                                if (string6 == null) {
                                    string6 = "-";
                                }
                                String string7 = requestIdentifier.getDummyUID();
                                if (string5 != null && string5.length() > 7 && !string5.equals("-")) {
                                    string5 = string5.substring(0, 7) + string7 + string5.substring(7);
                                } else {
                                    BTMLog.logger.info("[MethodEventProcessor] SessionID length should be greater than 7. SesssionID: {} ", (Object)string5);
                                }
                                string5 = Base64Coder.encodeString(string5 + "#|#" + string6);
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("<script> ");
                                stringBuilder.append("window['eg_btm_guid']='").append(string3).append("';");
                                stringBuilder.append("window['eg_btm_exe_time']='").append(l).append("';");
                                stringBuilder.append("window['eg_btm_node_guid']='").append(string4).append("';");
                                stringBuilder.append("window['eg_btm_session_id']='").append(string5).append("';");
                                stringBuilder.append("</script> ");
                                string2 = stringBuilder.toString() + string2;
                            }
                            MethodEventProcessor.injectRumScript(object, requestIdentifier, string2, string);
                        } else {
                            BTMLog.logger.info("Due to the absense of tags - <!doctype..> or <html> or <body> - RUM Injection not happens for the URL : {} & contentType  : {} TAG Status : {} ", new Object[]{string, requestIdentifier.getContentTypeString(), requestIdentifier.getTags()});
                        }
                    } else {
                        BTMLog.logger.info("URL :{} is Not eligible for RUM Injection. Response content type is {} {} ", new Object[]{string, requestIdentifier.getContentTypeString(), requestIdentifier.getContentType()});
                    }
                }
            } else {
                BTMLog.logger.info("Specified RUM script is {}, So it will not be injected for the URL : {}", (Object)string2, (Object)string);
            }
        }
        requestIdentifier.setAlreadyRumScriptInjected();
    }

    private static final void doResponseEnd(Object object, Object object2, RequestIdentifier requestIdentifier, boolean bl, String string, boolean bl2, long l, Map map) {
        if (!requestIdentifier.isAlreadyRumScriptInjected()) {
            MethodEventProcessor.doRUMInjection(requestIdentifier, bl);
        }
        if (PropsManager.captureHttpStatusCode() || OtherAPMTestConfiguration.isStatusCodeTestRunning()) {
            MethodEventProcessor.captureStatusCode(requestIdentifier, map, object2);
        }
        if (requestIdentifier.isRumBtmIntegrationEnabled()) {
            MethodEventProcessor.doRumBtmIntegration(requestIdentifier, object2, object, String.valueOf(l), map);
        }
    }

    private static void captureStatusCode(RequestIdentifier requestIdentifier, Map map, Object object) {
        String string = (String)map.get("CONTEXT");
        boolean bl = TraceUtils.getStatusTable(string);
        if (bl) {
            Object object2 = TraceUtils.getResponseDetails(object);
            boolean bl2 = (Boolean)map.get("REDIRECTED_ERROR_PAGE");
            if (object2 != null) {
                int n = (Integer)object2;
                if (!requestIdentifier.getRootMinfo().isErrorURL()) {
                    if (bl2) {
                        n = 200;
                    } else if (StatusCodeErrorRange.checkRange(n)) {
                        requestIdentifier.getRootMinfo().setErrorURL(true);
                    }
                } else if (requestIdentifier.isFrontExceptionAvailable() && n == 200) {
                    n = 500;
                }
                map.put("STATUS", n);
            }
        }
    }

    public static void eventEnded(RequestIdentifier requestIdentifier, boolean bl, long l) {
        try {
            if (requestIdentifier != null) {
                BTMLog.logger.debug("{}    EventEnded    {}    {}    {} ", requestIdentifier.getCurrentMinfo().getType(), requestIdentifier.getReqGUID(), requestIdentifier.getCurrentMinfo().getClassName(), requestIdentifier.getCurrentMinfo().getMethodName());
                requestIdentifier.onMethodEnd(bl, l);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor - eventEnded ] Exception ", exception);
        }
    }

    public static void eventEnded(RequestIdentifier requestIdentifier, boolean bl, long l, Object object, String string) {
        try {
            if (requestIdentifier != null) {
                BTMLog.logger.debug("{}    EventEnded    {}    {}    {}", requestIdentifier.getCurrentMinfo().getType(), requestIdentifier.getReqGUID(), requestIdentifier.getCurrentMinfo().getClassName(), requestIdentifier.getCurrentMinfo().getMethodName());
                requestIdentifier.onMethodEnd(bl, l);
                requestIdentifier.addPrepareOrCallableStmtQuery(object, string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor - eventEnded ] Exception {} ", exception);
        }
    }

    private static void addICDetails(HashMap hashMap, Map map) {
        if (hashMap == null) {
            return;
        }
        try {
            String string;
            String string2 = (String)hashMap.get("Username");
            if (string2 != null) {
                string = (String)map.get("SESSIONID");
                if (!string.equals("-")) {
                    if (PropsManager.isOldModel()) {
                        BTMDiscovery.addUserSessionDetails(string2, string);
                    } else {
                        String[] stringArray = new String[]{string2, string};
                        map.put("sessionUserMapping", stringArray);
                    }
                }
                map.put("Username", string2);
            }
            if ((string = (String)hashMap.get("BusinessContext")) != null) {
                map.put("BusinessContext", string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_For_APM] Error while setting IC values... {} ", exception);
        }
    }

    public static void createWorkerThread(HashMap hashMap, HashMap hashMap2) {
        if (hashMap == null && hashMap2 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (hashMap != null) {
            n = hashMap.size();
        }
        if (hashMap2 != null) {
            n2 = hashMap2.size();
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        EgWorkerThread egWorkerThread = new EgWorkerThread(hashMap, hashMap2);
        EgThreadPoolExecutor egThreadPoolExecutor = EgThreadPoolExecutor.getExecutor();
        egThreadPoolExecutor.execute(egWorkerThread);
    }

    public static void pojoEventEnded(RequestIdentifier requestIdentifier, boolean bl, long l) {
        try {
            if (requestIdentifier != null) {
                requestIdentifier.onMethodEnd(bl, l);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[MethodEventProcessor - pojoEventEnded ] Exception {} ", exception);
        }
    }

    private static void updateAllUrlDetails(MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                BTMLog.logger.info(" URL {} : {} ms & matched patterns : {} ", methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched());
                String string2 = methodInfo.getUrlPatternsMatched();
                URLPatternData uRLPatternData = (URLPatternData)UPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.updateAllUrlCount(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    private static void addToUPD(MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                BTMLog.logger.info(" URL {} : {} ms & matched patterns : {} ", methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched());
                String string2 = methodInfo.getUrlPatternsMatched();
                URLPatternData uRLPatternData = (URLPatternData)UPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.addURLInfo(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    private static void addStalledURLDetails(MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                BTMLog.logger.info(" Stalled URL {} : {} ms & matched patterns : {} ", methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched());
                String string2 = methodInfo.getUrlPatternsMatched();
                URLPatternData uRLPatternData = (URLPatternData)UPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.addStalledURLInfo(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    public static void addStalledURLDetails(MethodInfo methodInfo, boolean bl, RequestIdentifier requestIdentifier, long l, long l2, long l3) {
        if (PropsManager.isOldModel()) {
            Object object;
            block5: {
                try {
                    BTMLog.logger.info(" Stalled URL {} : {} ms & matched patterns : {} ", methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched());
                    boolean bl2 = requestIdentifier.isKeyTransactionRequest();
                    object = requestIdentifier.getRequestType();
                    String string = methodInfo.getUrlPatternsMatched();
                    URLPatternData uRLPatternData = (URLPatternData)UPDManager.getUPDTblWC(bl2).get(string);
                    if (uRLPatternData != null) {
                        uRLPatternData.addStalledURLInfo(methodInfo, bl, (String)object, l, l2, l3);
                    }
                }
                catch (Exception exception) {
                    if (methodInfo == null) break block5;
                    methodInfo.clearURLTree();
                }
            }
            HashMap<String, Integer> hashMap = requestIdentifier.getMethodCountMap();
            object = requestIdentifier.getFastMethodMap();
            MethodEventProcessor.createWorkerThread(hashMap, object);
        } else {
            Map map = methodInfo.getProperties();
            boolean bl3 = requestIdentifier.isKeyTransactionRequest();
            String string = requestIdentifier.getRequestType();
            map.put("firstNode", bl);
            map.put("keyTransaction", bl3);
            map.put("requestType", string);
            map.put("isStalled", methodInfo.isStalled());
            map.put("isSlowURL", methodInfo.isSlowURL());
            map.put("isErrorURL", methodInfo.isErrorURL());
            map.put("isSQLPresent", methodInfo.isSQLPresent());
            map.put(PATTERN_STRING, methodInfo.getUrlPatternsMatched());
            BTMLog.logger.info(" Stalled URL {} : {} ms & matched patterns : {} ", methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched());
            ThreadPoolManager threadPoolManager = ThreadPoolManager.getThreadPoolManager();
            threadPoolManager.submitTask(methodInfo);
            BTMLog.logger.debug(" Added Stalled Minfo into the queue. Queue size is : {} ", (Object)threadPoolManager.getQueueSize());
        }
    }

    private static HashMap getCurrentThreadProps(Map map, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = (String)map.get("requestID");
        String string4 = (String)map.get("RequestURI");
        String string5 = (String)map.get("CONTEXT");
        String string6 = (String)map.get("remoteHost");
        String string7 = (String)map.get("QUERYSTRING");
        String string8 = (String)map.get("SESSIONID");
        String string9 = (String)map.get("REFERER");
        String string10 = (String)map.get("DEVICE");
        String string11 = (String)map.get("OS");
        String string12 = (String)map.get("BROWSER");
        String string13 = (String)map.get("UTC");
        if (string3 == null) {
            string3 = "-";
        }
        if (string4 == null) {
            string4 = "-";
        }
        if (string5 == null) {
            string5 = "-";
        }
        if (string6 == null) {
            string6 = "-";
        }
        if (string7 == null) {
            string7 = "-";
        }
        if (string8 == null) {
            string8 = "-";
        }
        if (string9 == null) {
            string9 = "-";
        }
        if (string10 == null) {
            string10 = "-";
        }
        if (string11 == null) {
            string11 = "-";
        }
        if (string12 == null) {
            string12 = "-";
        }
        if (string13 == null) {
            string13 = "-";
        }
        hashMap.put("requestID", string3);
        hashMap.put("RequestURI", string4);
        hashMap.put("CONTEXT", string5);
        hashMap.put("remoteHost", string6);
        hashMap.put("QUERYSTRING", string7);
        hashMap.put("SESSIONID", string8);
        hashMap.put("REFERER", string9);
        hashMap.put("DEVICE", string10);
        hashMap.put("OS", string11);
        hashMap.put("BROWSER", string12);
        hashMap.put("UTC", string13);
        hashMap.put("THREAD", string);
        hashMap.put("Thread_GUID", string2);
        return hashMap;
    }

    private static void initialTLValues(RequestIdentifier requestIdentifier, Object object) {
        Object object2;
        reqIdTL.set(requestIdentifier);
        inheritReqIdTL.set(requestIdentifier);
        requestIdentifier.setResponseObject(object);
        if (PropsManager.getMonitoringMode() == 2) {
            RootTracer.pojoBlockLocal.set(null);
        } else {
            object2 = new BTMPojoBoolean();
            ((BTMPojoBoolean)object2).setPojoFlag(false);
            RootTracer.pojoBlockLocal.set((BTMPojoBoolean)object2);
        }
        object2 = new BTMSqlBoolean();
        ((BTMSqlBoolean)object2).setSqlFlag(false);
        RootTracer.sqlBlockLocal.set((BTMSqlBoolean)object2);
    }

    private static void doRumBtmIntegration(RequestIdentifier requestIdentifier, Object object, Object object2, String string, Map map) {
        String string2 = requestIdentifier.getReqGUID();
        String string3 = requestIdentifier.getRootMinfo().getRawURL();
        String string4 = MeasureUtil.getRequestUriOnly(string3);
        boolean bl = requestIdentifier.isAjaxRequest();
        String string5 = (String)map.get("SESSIONID");
        String string6 = "-";
        HashMap<String, String> hashMap = requestIdentifier.getIcMeasureData();
        if (hashMap != null && hashMap.containsKey("Username") && (string6 = hashMap.get("Username")) == null) {
            string6 = "-";
        }
        String string7 = requestIdentifier.getDummyUID();
        RumBtmIntegrationHelper.setIntegrationCookie(object, object2, string2, string, string4, bl, string5, string6, string7);
    }
}

