/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.RootTracer;
import com.eg.agent.trace.utils.HtmlTagChecker;
import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMPojoBoolean;
import com.eg.jtm.BTMSqlBoolean;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.EgCustomPointCutManager;
import com.eg.jtm.EgScheduledThreadPoolExecutor;
import com.eg.jtm.ExceptionTestConfigManager;
import com.eg.jtm.ExternalCallDiagnosis;
import com.eg.jtm.LongRunningTrackerThread;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.OtherAPMTestConfiguration;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RedisCommandInfo;
import com.eg.jtm.RumPropsManager;
import com.eg.jtm.ThreadDiagnosis;
import com.eg.jtm.Threshold;
import com.eg.jtm.Type;
import com.eg.jtm.UPDManager;
import com.eg.jtm.learning.LearningProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestIdentifier {
    private MethodInfo rootMinfo = null;
    private MethodInfo currentMinfo = null;
    private MethodInfo prevMinfo = null;
    private String reqGUID;
    private String dummyUUID = null;
    private String reqType = null;
    private String httpCallCounter = null;
    private String threadCallCounter = null;
    private long pojoInvokeCount = 0L;
    private int sqlInvokeCountPerBT = 0;
    private int sqlInvokeCount = 0;
    private int sqlErrorInvokeCount = 0;
    private long reqStartTime = -1L;
    private LongRunningTrackerThread trackerThread = null;
    private ScheduledFuture<?> scheduledFuture = null;
    private boolean isTracking = false;
    private HashMap<String, Integer> methodCountMap = null;
    private HashMap<String, String> fastMethodMap = null;
    private boolean firstNodeRequest;
    private HashMap<Object, Integer> entryAndSQLtrackerMap = new HashMap();
    private HashMap<Object, MethodInfo> POJOExceptionTracker = new HashMap();
    private static final Integer dummyIntVal = new Integer(1);
    private boolean isPointcutLimitReached = false;
    private int otherPointcutCount = 0;
    private int recursiveCount = 0;
    private boolean keyTransactionRequest = false;
    private boolean isAjaxRequest = false;
    private HashMap<String, String> httpCallTrackerMap = null;
    private HashMap<String, double[]> allSqlDetailsMap = null;
    private HashMap<String, double[]> fastSqlDetailsMap = null;
    private HashMap<String, double[]> slowSqlLimitExceedDetailsMap = null;
    private HashMap<String, double[]> errorSqlLimitExceedDetailsMap = null;
    private long methodInfoCount = 0L;
    private HashMap<Long, MethodInfo> childMap = null;
    private static final Long rootKey = new Long(0L);
    private HashMap<String, String> icMeasureData = null;
    private boolean isExpWithStackTraceCountLimitReached = false;
    private boolean isExpFQENCountLimitReached = false;
    private int totalExceptionCounter = 0;
    private int exceptionWithStackCounter = 0;
    private int exceptionFQENCounter = 0;
    private String autoRumFirstServlet = null;
    private Object responseObject = null;
    private Object writerObject = null;
    private Object outputStreamObject = null;
    private boolean injectRumScript = false;
    private boolean alreadyRumScriptInjected = false;
    private HtmlTagChecker.TAGS enumTags = HtmlTagChecker.TAGS.UNKNOWN;
    private ContentType contentType = ContentType.UNKNOWN;
    private String contentTypeString = null;
    private StringBuilder templateBuilder = null;
    private String requestURL = null;
    private ThreadDiagnosis threadDiagnosis = null;
    private Hashtable<Long, String[]> threadIdTable = null;
    private HashMap<Object, String> prepareOrCallableStmtQuery = null;
    private HashMap<Object, Object> jmsSessionTable = null;
    private boolean collectFlowMetrics = false;
    private ExternalCallDiagnosis callDiagnosis = null;
    private String responseUniqueJvmGuid = null;
    private boolean rumBtmIntegration = false;
    private int statusCode = 0;
    private Queue<RedisCommandInfo> redisCommandQueue = null;
    private HashMap<Object, String[]> noSQLDetails = null;
    private HashMap ehCacheDetailsMap = null;
    private HashMap<Long, String> httpResponseHeader = null;
    private HashMap<Long, String> httpResponseCodes = null;
    private Long recentHTTPConnectID = null;
    private boolean isErrorOutBoundHTTP = false;
    private ArrayList<String[]> exceptionList = null;
    private String exceptionBottomFQCN = null;
    private String exceptionRootFQCN = null;
    private boolean isReadCause = false;
    private boolean isFrontExceptionAvailable = false;
    private static final HashMap<String, Enum<Type>> MAPPINGS = new HashMap();
    private Map rootProps = null;

    public RequestIdentifier(MethodInfo methodInfo, String string, String string2, long l, boolean bl) {
        this.rootMinfo = methodInfo;
        this.prevMinfo = methodInfo;
        this.currentMinfo = methodInfo;
        this.reqStartTime = l;
        if (string2 == null) {
            UUID uUID = UUID.randomUUID();
            string2 = uUID.toString() + "-" + l;
            this.reqGUID = string2 + "#~#" + 1;
            this.firstNodeRequest = true;
        } else {
            this.reqGUID = string2;
            this.firstNodeRequest = false;
        }
        this.reqType = string;
        this.keyTransactionRequest = bl;
        this.isAjaxRequest = false;
        this.childMap = new HashMap();
        this.isReadCause = ExceptionTestConfigManager.isReadRootCauseDetails();
        this.threadDiagnosis = new ThreadDiagnosis();
        this.threadDiagnosis.recordTimings(true);
        if (OtherAPMTestConfiguration.isFlowTestRunning()) {
            this.collectFlowMetrics = true;
            this.callDiagnosis = new ExternalCallDiagnosis(string, this.reqGUID, this.firstNodeRequest);
        }
        if (RumPropsManager.isRumBtmIntegrationEnabled() && this.firstNodeRequest && string.equalsIgnoreCase("Web")) {
            this.rumBtmIntegration = true;
            this.dummyUUID = UUID.randomUUID().toString();
        }
    }

    public boolean isRumBtmIntegrationEnabled() {
        return this.rumBtmIntegration;
    }

    public boolean isCollectFlowMetrics() {
        return this.collectFlowMetrics;
    }

    public HashMap<String, String> getIcMeasureData() {
        if (this.icMeasureData != null) {
            BTMLog.logger.debug("[IC_For_APM] icMeasureData : " + this.icMeasureData.toString());
        }
        return this.icMeasureData;
    }

    private void setIcMeasuredData(String string, String string2) {
        if (this.icMeasureData == null) {
            this.icMeasureData = new HashMap();
        }
        if (string != null && string2 != null && !this.icMeasureData.containsKey(string)) {
            this.icMeasureData.put(string, string2);
        }
    }

    public void setIcUsername(String string) {
        BTMLog.logger.debug("[IC_For_APM] Going to set the Username...");
        this.setIcMeasuredData("Username", string);
    }

    public void setIcBusinessContext(String string) {
        BTMLog.logger.debug("[IC_For_APM] Going to set the BusinessContext...");
        this.setIcMeasuredData("BusinessContext", string);
    }

    public boolean capturedIcUsernameValue() {
        if (this.icMeasureData == null) {
            return false;
        }
        return this.icMeasureData.containsKey("Username");
    }

    public boolean capturedIcBusinessContextValue() {
        if (this.icMeasureData == null) {
            return false;
        }
        return this.icMeasureData.containsKey("BusinessContext");
    }

    public boolean capturedIcValues() {
        boolean bl;
        boolean bl2 = this.capturedIcUsernameValue();
        return bl2 && (bl = this.capturedIcBusinessContextValue());
    }

    public boolean isFirstNodeRequest() {
        return this.firstNodeRequest;
    }

    public String getRequestType() {
        return this.reqType;
    }

    public String getReqGUID() {
        return this.reqGUID;
    }

    public String getDummyUID() {
        return this.dummyUUID;
    }

    public String getHttpCallCounter() {
        return this.httpCallCounter;
    }

    public String getThreadCallCounter() {
        return this.threadCallCounter;
    }

    public void addException(String[] stringArray) {
        try {
            this.exceptionList.add(stringArray);
        }
        catch (NullPointerException nullPointerException) {
            this.exceptionList = new ArrayList();
            this.exceptionList.add(stringArray);
        }
    }

    public void setThreadCallCounter(String string, long l, String string2, String string3) {
        this.threadCallCounter = string;
        if (this.threadIdTable == null) {
            this.threadIdTable = new Hashtable();
        }
        String[] stringArray = new String[]{string2, string3 + "#~#" + string};
        this.threadIdTable.put(l, stringArray);
    }

    String[] getAsyncGUID(long l) {
        Long l2;
        String[] stringArray = null;
        if (this.threadIdTable != null && this.threadIdTable.containsKey(l2 = new Long(l))) {
            stringArray = this.threadIdTable.get(l2);
        }
        return stringArray;
    }

    public String getExternalURL(String string) {
        String string2 = null;
        try {
            string2 = this.httpCallTrackerMap.get(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public void setHttpCallCounter(String string, String string2) {
        this.httpCallCounter = string;
        if (this.httpCallTrackerMap == null) {
            this.httpCallTrackerMap = new HashMap();
        }
        this.httpCallTrackerMap.put(string, string2);
    }

    public MethodInfo getRootMinfo() {
        return this.childMap.get(rootKey);
    }

    public HashMap<Long, MethodInfo> getChildMap() {
        return this.childMap;
    }

    public HashMap<String, Integer> getMethodCountMap() {
        return this.methodCountMap;
    }

    public HashMap<String, String> getFastMethodMap() {
        return this.fastMethodMap;
    }

    public MethodInfo getCurrentMinfo() {
        return this.currentMinfo;
    }

    private void setCurrentMinfo(MethodInfo methodInfo) {
        this.prevMinfo = this.currentMinfo;
        this.currentMinfo = methodInfo;
    }

    public boolean rootMethodStart(String string, String string2, String string3, long l, Map map, String string4, String string5) {
        boolean bl = false;
        MethodInfo methodInfo = new MethodInfo(string, string2, string3, this.currentMinfo, string5, this.methodInfoCount, this.childMap);
        map.put("GUID", this.reqGUID);
        methodInfo.setStartTime(l);
        methodInfo.setProperties(map);
        methodInfo.setType(string4);
        this.rootProps = map;
        this.requestURL = (String)map.get("RequestURI");
        if (this.firstNodeRequest && map.containsKey("AJAX")) {
            this.isAjaxRequest = true;
        }
        try {
            this.currentMinfo.addChildMinfo(methodInfo, this.childMap);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception occured rootMethodStart {} ", exception);
            BTMLog.logger.error("[rootMethodStart]- {} {} {} Type : {} URL_Pattern : {}", string, string2, string3, string4, string5);
        }
        this.setCurrentMinfo(methodInfo);
        ++this.methodInfoCount;
        bl = true;
        return bl;
    }

    public boolean onMethodStart(String string, String string2, String string3, long l, Map map, String string4) {
        boolean bl = false;
        long l2 = l - this.reqStartTime;
        if (l2 >= PropsManager.getMaxTracePeriod()) {
            RootTracer.pojoBlockLocal.remove();
            RootTracer.pojoBlockLocal.set(null);
            if (!this.isTracking) {
                this.isTracking = true;
                this.doTraceLongRunningRequest();
            }
        }
        if (string4.equals("POJO")) {
            ++this.pojoInvokeCount;
            if (this.pojoInvokeCount >= PropsManager.getMaxTraceLines()) {
                RootTracer.pojoBlockLocal.remove();
                RootTracer.pojoBlockLocal.set(null);
            }
        } else if (string4.equals("SQL")) {
            if ((long)this.sqlInvokeCountPerBT >= PropsManager.getMaxSQLCountLimit()) {
                RootTracer.sqlBlockLocal.remove();
                RootTracer.sqlBlockLocal.set(null);
                return false;
            }
        } else if (!MethodInfo.isFrontEndComponent(string4)) {
            ++this.otherPointcutCount;
            if (this.otherPointcutCount >= PropsManager.getOtherPointcutMethodLimit()) {
                this.isPointcutLimitReached = true;
                BTMLog.logger.warn("Pointcut Limit is Reached for the URL : {} ", (Object)this.getRootMinfo().getRawURL());
            }
        }
        ++this.recursiveCount;
        if (this.recursiveCount >= PropsManager.getRecursionTraceLimit()) {
            BTMLog.logger.warn("Unable to trace this request {} due to recursion So, removing the request from threadlocal", (Object)this.getRootMinfo().getRawURL());
            MethodEventProcessor.removeFromThreadLocal();
        }
        MethodInfo methodInfo = new MethodInfo(string, string2, string3, this.currentMinfo, this.methodInfoCount, this.childMap);
        methodInfo.setStartTime(l);
        methodInfo.setProperties(map);
        methodInfo.setType(string4);
        try {
            this.currentMinfo.addChildMinfo(methodInfo, this.childMap);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception onMethodStart...{}", exception);
            BTMLog.logger.error("[onMethodStart]- {} {} {} Type : {} ", string, string2, string3, string4);
        }
        this.setCurrentMinfo(methodInfo);
        if (string4.equals("EXCEPTION")) {
            MethodInfo methodInfo2 = this.getRootMinfo();
            methodInfo2.setErrorURL(true);
        }
        bl = true;
        ++this.methodInfoCount;
        return bl;
    }

    private void removeCurrentMinfo(boolean bl) {
        if (this.currentMinfo.getParent() != null) {
            MethodInfo methodInfo = this.currentMinfo;
            this.setCurrentMinfo(this.currentMinfo.getParent());
            this.currentMinfo.removeChildMinfo(methodInfo, this.childMap);
            if (bl && !methodInfo.getChildMinfos().isEmpty()) {
                List<Long> list = methodInfo.getChildMinfos();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    long l = list.get(i);
                    MethodInfo methodInfo2 = this.childMap.get(l);
                    this.currentMinfo.addChildMinfo(methodInfo2, this.childMap);
                }
            }
            methodInfo = null;
        }
    }

    public boolean sqlMethodEnd(boolean bl, long l, Object object) {
        Object object2;
        List<Long> list;
        String string = this.currentMinfo.getType();
        if (string != null && !string.equalsIgnoreCase("SQL")) {
            this.removeCurrentMinfo(false);
            return true;
        }
        this.currentMinfo.setEndTime(l, bl);
        double d = this.currentMinfo.getExecutionTime();
        boolean bl2 = false;
        if (this.currentMinfo.getParent() != null) {
            list = this.currentMinfo.getParent();
            object2 = ((MethodInfo)((Object)list)).getType();
            if (string != null && string.equals(object2)) {
                if (this.currentMinfo.getClassName().equals(((MethodInfo)((Object)list)).getClassName())) {
                    if (this.currentMinfo.getMethodName().equals(((MethodInfo)((Object)list)).getMethodName())) {
                        bl2 = true;
                    }
                } else {
                    bl2 = this.sqlWrapperClassCheck(this.currentMinfo);
                }
            }
        }
        if (bl2) {
            String string2;
            long l2;
            MethodInfo methodInfo;
            list = this.currentMinfo.getChildMinfos();
            if (list != null && list.size() == 1 && (methodInfo = this.childMap.remove(l2 = ((Long)list.remove(0)).longValue())) != null && (string2 = methodInfo.getType()).equals("EXCEPTION")) {
                MethodInfo methodInfo2 = this.currentMinfo.getParent();
                methodInfo2.addChildMinfo(methodInfo, this.childMap);
                this.updateErrorSQLCall(methodInfo2.getProperties(), d, true);
            }
            this.removeCurrentMinfo(false);
        } else if (object != null) {
            ++this.sqlErrorInvokeCount;
            list = this.getCurrentMinfo().getProperties();
            if ((long)this.sqlErrorInvokeCount > PropsManager.getMaxSQLErrorTraceCount()) {
                object2 = (String)list.get("jdbcUrl");
                String string3 = (String)list.get("sqlStmt");
                this.errorSqlLimitExceedDetailsMap = this.updateFastAndLimitExceedSQLDetails((String)object2, d, string3, this.errorSqlLimitExceedDetailsMap, "[Error SQL Limit Exceed Details]");
                this.removeCurrentMinfo(false);
            } else {
                object2 = (Throwable)object;
                String string4 = ((Throwable)object2).getMessage();
                this.updateErrorSQLCall((Map)((Object)list), d, true);
                list.put("sqlError", string4);
                String string5 = TraceUtils.partialSTEs2Str((Throwable)object2, PropsManager.getMaxExceptionLineCount());
                this.setExceptionTraceAvailable(true);
                list.put("stackTrace", string5);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                this.updateAllSQLDetails(d);
            }
        }
        return true;
    }

    private void updateErrorSQLCall(Map map, double d, boolean bl) {
        if (this.collectFlowMetrics) {
            try {
                String string = (String)map.get("jdbcUrl");
                String string2 = "SQL#" + string + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string2, d, bl);
            }
            catch (Exception exception) {
                BTMLog.logger.error("Exception occured while updating Error SQL call Details for TFT {} ", exception);
            }
        }
    }

    private boolean pojoMethodExecutionCutOffProcess(double d) {
        boolean bl = false;
        if (LearningProperties.isLearningMode()) {
            String string = this.currentMinfo.getLearningKey();
            if (d < UPDManager.getMethExecCutOff()) {
                int n = 0;
                try {
                    n = this.fastMethodMap.size();
                }
                catch (NullPointerException nullPointerException) {
                    this.fastMethodMap = new HashMap();
                    n = 0;
                }
                if (n < LearningProperties.getFastMethodLimit() && !this.fastMethodMap.containsKey(string)) {
                    this.fastMethodMap.put(string, " @ ");
                }
                this.removeCurrentMinfo(true);
                bl = true;
            } else {
                this.fillMethodCountMap(string);
            }
        } else if (d < UPDManager.getMethExecCutOff()) {
            this.removeCurrentMinfo(true);
            bl = true;
        }
        return bl;
    }

    private void fillMethodCountMap(String string) {
        int n = 0;
        try {
            n = this.methodCountMap.size();
        }
        catch (NullPointerException nullPointerException) {
            this.methodCountMap = new HashMap();
            n = 0;
        }
        Integer n2 = this.methodCountMap.get(string);
        if (n < LearningProperties.getSlowMethodLimit()) {
            if (n2 != null) {
                Integer n3 = n2;
                Integer n4 = n2 = Integer.valueOf(n2 + 1);
                this.methodCountMap.put(string, new Integer(n2));
            } else {
                this.methodCountMap.put(string, new Integer(1));
            }
        } else if (n2 != null) {
            Integer n5 = n2;
            Integer n6 = n2 = Integer.valueOf(n2 + 1);
            this.methodCountMap.put(string, new Integer(n2));
        }
    }

    private boolean jdbcMethodExecutionCutOffProcess(double d) {
        boolean bl = false;
        if (LearningProperties.isLearningMode()) {
            String string = this.currentMinfo.getLearningKey();
            if (d < UPDManager.getMethExecCutOff()) {
                this.removeCurrentMinfo(true);
                bl = true;
            } else {
                this.fillMethodCountMap(string);
            }
        } else if (d < UPDManager.getMethExecCutOff()) {
            this.removeCurrentMinfo(true);
            bl = true;
        }
        return bl;
    }

    private boolean isOverLoadedMethod(String string) {
        MethodInfo methodInfo;
        String string2;
        boolean bl = false;
        if (BTMUtils.OVERLOADED_MAPPING.containsKey(string)) {
            return bl;
        }
        if (this.currentMinfo.getParent() != null && string.equals(string2 = (methodInfo = this.currentMinfo.getParent()).getType()) && this.currentMinfo.getClassName().equals(methodInfo.getClassName()) && this.currentMinfo.getMethodName().equals(methodInfo.getMethodName())) {
            bl = true;
            this.removeCurrentMinfo(false);
        }
        return bl;
    }

    private boolean isCutOffMethods(Type type, double d, String string) {
        switch (type) {
            case POJO: {
                if (!this.pojoMethodExecutionCutOffProcess(d)) break;
                return true;
            }
            case JDBC: {
                if (!this.jdbcMethodExecutionCutOffProcess(d)) break;
                return true;
            }
        }
        return this.isOverLoadedMethod(string);
    }

    public boolean onMethodEnd(boolean bl, long l) {
        String string = this.currentMinfo.getType();
        if (string != null && string.equalsIgnoreCase("unknown")) {
            this.removeCurrentMinfo(false);
            return true;
        }
        Type type = null;
        type = string.indexOf("Custom_") > -1 ? Type.CUSTOM : (Type)MAPPINGS.get(string);
        this.currentMinfo.setEndTime(l, bl);
        --this.recursiveCount;
        double d = this.currentMinfo.getExecutionTime();
        if (this.isCutOffMethods(type, d, string)) {
            return true;
        }
        if (this.collectFlowMetrics) {
            return this.onMethodEndWithFlowMetrics(bl, l, type, d, string);
        }
        return this.onMethodEndNoFlowMetrics(bl, l, type, d, string);
    }

    private void updateSQLCallHelper(double d) {
        String string = (String)this.currentMinfo.getProperties().get("jdbcUrl");
        String string2 = (String)this.currentMinfo.getProperties().get("sqlStmt");
        if (d < PropsManager.getSQLExecCutOff()) {
            this.fastSqlDetailsMap = this.updateFastAndLimitExceedSQLDetails(string, d, string2, this.fastSqlDetailsMap, "[Fast SQL Details]");
            this.removeCurrentMinfo(false);
        } else {
            ++this.sqlInvokeCount;
            if ((long)this.sqlInvokeCount > PropsManager.getMaxSQLTraceCount()) {
                this.slowSqlLimitExceedDetailsMap = this.updateFastAndLimitExceedSQLDetails(string, d, string2, this.slowSqlLimitExceedDetailsMap, "[Slow SQL Limit Exceed Details]");
                this.removeCurrentMinfo(false);
            } else {
                this.setCurrentMinfo(this.currentMinfo.getParent());
                this.updateAllSQLDetails(d);
            }
        }
    }

    private boolean onMethodEndNoFlowMetrics(boolean bl, long l, Type type, double d, String string) {
        switch (type) {
            case SQL: {
                boolean bl2 = this.sqlWrapperClassCheck(this.currentMinfo);
                if (bl2) {
                    this.removeCurrentMinfo(false);
                    break;
                }
                this.updateSQLCallHelper(d);
                break;
            }
            case HTTP: {
                String string2 = this.currentMinfo.getParent().getType();
                if (string2 != null && string2.equals("HTTPStream")) {
                    Map map = this.currentMinfo.getProperties();
                    this.currentMinfo.getParent().setProperties(map);
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case HTTPERRORSTREAM: {
                this.currentMinfo.setType("POJO");
                this.getCurrentMinfo().setProperties(null);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case THREADJOIN: {
                if (d > 0.0) {
                    this.setCurrentMinfo(this.currentMinfo.getParent());
                    break;
                }
                this.removeCurrentMinfo(false);
                break;
            }
            case EHCACHE: {
                this.updateEhCacheDetails(this.currentMinfo.getMethodName(), d);
                this.removeCurrentMinfo(false);
                break;
            }
            default: {
                this.setCurrentMinfo(this.currentMinfo.getParent());
            }
        }
        return true;
    }

    private boolean onMethodEndWithFlowMetrics(boolean bl, long l, Type type, double d, String string) {
        Map map = this.currentMinfo.getProperties();
        switch (type) {
            case SQL: {
                boolean bl2 = this.sqlWrapperClassCheck(this.currentMinfo);
                if (bl2) {
                    this.removeCurrentMinfo(false);
                    break;
                }
                String string2 = (String)map.get("jdbcUrl");
                String string3 = "SQL#" + string2 + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string3, d, false);
                this.updateSQLCallHelper(d);
                break;
            }
            case JMS: {
                String string4 = (String)map.get("TFT_KEY");
                String string5 = "JMS#" + string4 + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string5, d, bl);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case WEBSERVICE: {
                String string6 = (String)map.get("TFT_KEY");
                String string7 = this.getResponseUniqueJvmGuid() == null ? string6 : this.getResponseUniqueJvmGuid();
                String string8 = "WEBSERVICE#" + string7 + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string8, d, bl);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case HTTPSTREAM: {
                String string9;
                String string10 = this.currentMinfo.getParent().getType();
                if (string10 != null && string10.equals("HTTPStream")) {
                    Map map2 = this.currentMinfo.getProperties();
                    this.currentMinfo.getParent().setProperties(map2);
                    this.setCurrentMinfo(this.currentMinfo.getParent());
                    break;
                }
                if (bl) {
                    String string11 = (String)map.get("NODE_ORDER");
                    boolean bl3 = this.callDiagnosis.isStreamErrorCaptured(string11);
                    if (bl3) {
                        bl = false;
                    } else {
                        this.callDiagnosis.registerStreamNodeOrderErrorMap(string11);
                    }
                }
                boolean bl4 = this.checkParent(this.currentMinfo);
                String string12 = (String)map.get("EXTURL");
                String string13 = null;
                if (this.getResponseUniqueJvmGuid() != null) {
                    string13 = "UNIQUE_JVM_GUID#" + string12 + "_" + this.getResponseUniqueJvmGuid();
                    this.callDiagnosis.updateExternalCallDetails(string13, 0.0, bl);
                }
                if (!bl4 && this.httpResponseHeader.containsKey(this.recentHTTPConnectID) && (string9 = this.httpResponseHeader.get(this.recentHTTPConnectID)) != null && string9.equals("FOUND") && d > 0.0) {
                    String string14 = this.getResponseUniqueJvmGuid() == null ? string12 : this.getResponseUniqueJvmGuid();
                    String string15 = "HTTP#" + string14 + "_" + this.reqType;
                    this.callDiagnosis.updateExternalCallDetails(string15, d, bl, false);
                    this.httpResponseHeader.put(this.recentHTTPConnectID, "STORED");
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case HTTP: {
                String string16 = this.currentMinfo.getParent().getType();
                if (string16 != null && string16.equals("HTTPStream")) {
                    Map map3 = this.currentMinfo.getProperties();
                    this.currentMinfo.getParent().setProperties(map3);
                    d = 0.0;
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case HTTPERRORSTREAM: {
                this.currentMinfo.setType("POJO");
                this.getCurrentMinfo().setProperties(null);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case SAP: {
                String string17 = (String)map.get("ASHost");
                String string18 = (String)map.get("SystemNo");
                String string19 = "SAP JCO#ABAP:" + string17 + "::" + string18 + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string19, d, bl);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case THREADJOIN: {
                if (d > 0.0) {
                    this.setCurrentMinfo(this.currentMinfo.getParent());
                    break;
                }
                this.removeCurrentMinfo(false);
                break;
            }
            case EJB_HIDE: {
                if (map != null) {
                    String string20 = (String)map.get("ejbhost");
                    String string21 = "EJB_HIDE#" + string20 + "_" + this.reqType;
                    this.callDiagnosis.updateExternalCallDetails(string21, d, bl);
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case EMAIL: {
                if (map != null) {
                    String string22 = (String)map.get("endPoint");
                    if (!string22.equals("-")) {
                        double d2 = 0.0;
                        d2 = this.currentMinfo.getParent().getType().equals("EMAIL") ? (double)this.currentMinfo.getParent().getExecutionTime() : d;
                        String string23 = "EMAIL#" + string22 + "_" + this.reqType;
                        this.callDiagnosis.updateExternalCallDetails(string23, d2, bl);
                    } else if (string22.equals("-") && bl) {
                        String string24 = "EMAIL#_" + this.reqType;
                        this.callDiagnosis.updateExternalCallDetails(string24, d, bl);
                    }
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case LDAP: {
                if (map != null) {
                    String string25 = (String)map.get("endPoint");
                    double d3 = 0.0;
                    d3 = this.currentMinfo.getParent().getType().equals("LDAP") ? d : d;
                    String string26 = "LDAP#" + string25 + "_" + this.reqType;
                    this.callDiagnosis.updateExternalCallDetails(string26, d3, bl);
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case RMI: {
                String string27 = (String)map.get("host");
                String string28 = "RMI#" + string27 + "_" + this.reqType;
                this.callDiagnosis.updateExternalCallDetails(string28, d, bl);
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case CUSTOM: {
                String string29 = EgCustomPointCutManager.getInstance().getCustomPointCutDisplayName(string);
                if (string29 != null && string29.length() > 0) {
                    String string30 = "Custom_#" + string29 + "_" + this.reqType;
                    this.callDiagnosis.updateExternalCallDetails(string30, d, bl);
                }
                this.setCurrentMinfo(this.currentMinfo.getParent());
                break;
            }
            case EHCACHE: {
                this.updateEhCacheDetails(this.currentMinfo.getMethodName(), d);
                this.removeCurrentMinfo(false);
                break;
            }
            default: {
                this.setCurrentMinfo(this.currentMinfo.getParent());
            }
        }
        return true;
    }

    private boolean checkParent(MethodInfo methodInfo) {
        Stack<MethodInfo> stack = new Stack<MethodInfo>();
        stack.push(methodInfo);
        for (int i = 0; !stack.isEmpty() && i < 150; ++i) {
            MethodInfo methodInfo2 = (MethodInfo)stack.pop();
            if (methodInfo2 == null) continue;
            String string = methodInfo2.getType();
            if (string.equals("WEBSERVICE")) {
                return true;
            }
            MethodInfo methodInfo3 = methodInfo2.getParent();
            stack.push(methodInfo3);
        }
        return false;
    }

    private HashMap updateFastAndLimitExceedSQLDetails(String string, double d, String string2, HashMap<String, double[]> hashMap, String string3) {
        BTMLog.logger.debug("{} : {} Time: {} Query: {} GUID: {} ", string3, string, d, string2, this.getReqGUID());
        try {
            double[] dArray = hashMap.get(string);
            if (dArray == null) {
                hashMap.put(string, new double[]{1.0, d});
            } else {
                dArray[0] = dArray[0] + 1.0;
                dArray[1] = dArray[1] + d;
            }
        }
        catch (NullPointerException nullPointerException) {
            hashMap = new HashMap();
            hashMap.put(string, new double[]{1.0, d});
        }
        this.updateAllSQLDetails(d);
        return hashMap;
    }

    private void updateAllSQLDetails(double d) {
        try {
            ++this.sqlInvokeCountPerBT;
            double[] dArray = this.allSqlDetailsMap.get("ALL_SQL");
            dArray[0] = dArray[0] + 1.0;
            dArray[1] = dArray[1] + d;
        }
        catch (NullPointerException nullPointerException) {
            this.allSqlDetailsMap = new HashMap(1);
            this.allSqlDetailsMap.put("ALL_SQL", new double[]{1.0, d});
        }
    }

    public void updateEhCacheDetails(String string, double d) {
        try {
            if (this.ehCacheDetailsMap == null) {
                this.ehCacheDetailsMap = new HashMap();
            }
            if (this.ehCacheDetailsMap.containsKey(string)) {
                double[] dArray = (double[])this.ehCacheDetailsMap.get(string);
                dArray[0] = dArray[0] + 1.0;
                dArray[1] = dArray[1] + d;
            } else {
                double[] dArray = new double[]{1.0, d};
                this.ehCacheDetailsMap.put(string, dArray);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error(" [updateEhCacheDetails] Exception while calculating Ehcache details.. {} ", exception);
        }
    }

    public void computeJmsEntryDetails(long l, boolean bl) {
        Map map = this.getRootMinfo().getProperties();
        String string = (String)map.get("TFT_KEY");
        String string2 = "JMS_ENTRY#" + string + "_" + this.reqType;
        this.callDiagnosis.updateExternalCallDetails(string2, l, bl);
    }

    private boolean sqlWrapperClassCheck(MethodInfo methodInfo) {
        String string;
        String string2;
        MethodInfo methodInfo2;
        Map map;
        boolean bl = false;
        Map map2 = methodInfo.getProperties();
        if (map2 != null && map2.containsKey("sqlStmt") && (map = (methodInfo2 = methodInfo.getParent()).getProperties()) != null && map.containsKey("sqlStmt") && (string2 = (String)map2.get("sqlStmt")).equalsIgnoreCase(string = (String)map.get("sqlStmt"))) {
            bl = true;
        }
        return bl;
    }

    private void doTraceLongRunningRequest() {
        BTMPojoBoolean bTMPojoBoolean = RootTracer.pojoBlockLocal.get();
        BTMSqlBoolean bTMSqlBoolean = RootTracer.sqlBlockLocal.get();
        this.trackerThread = new LongRunningTrackerThread(this, bTMPojoBoolean, bTMSqlBoolean, Thread.currentThread());
        MethodInfo methodInfo = this.getRootMinfo();
        String string = methodInfo.getUrlPatternsMatched();
        Threshold threshold = PropsManager.getThreshold(this.keyTransactionRequest, string);
        double d = threshold.getStalledThreshold();
        long l = (long)d;
        this.scheduledFuture = EgScheduledThreadPoolExecutor.getExecutor().schedule(this.trackerThread, l, TimeUnit.MILLISECONDS);
        BTMLog.logger.trace("Tracing begin for long running request of {} & request started @ {} ", (Object)this.reqGUID, (Object)this.reqStartTime);
    }

    public void removeFromScheduledThreadPoolExecutor() {
        if (this.scheduledFuture != null && this.trackerThread != null) {
            boolean bl = this.scheduledFuture.isDone();
            if (bl) {
                return;
            }
            boolean bl2 = this.scheduledFuture.cancel(true);
            long l = this.scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
            if (bl2) {
                BTMLog.logger.trace("Tracing removed for long running request of {} & request started @ {} & remaining time {}", this.reqGUID, this.reqStartTime, l);
                MethodEventProcessor.removeObjectFromThreadLocal();
            } else {
                BTMLog.logger.warn("Could Not be Removed the RequestIdentifier Object from EgScheduledThreadPoolExecutor: {} removeFromPool :{}  {}", this, bl2, l);
            }
        }
        this.scheduledFuture = null;
        this.trackerThread = null;
    }

    public Object getObjectFromEntryAndSQLTracker(Object object) {
        return this.entryAndSQLtrackerMap.get(object);
    }

    public void addObjectToEntryAndSQLTracker(Object object) {
        try {
            this.entryAndSQLtrackerMap.put(object, dummyIntVal);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public MethodInfo getObjectFromPOJOExceptionTracker(Object object) {
        return this.POJOExceptionTracker.get(object);
    }

    public void removeObjectFromPOJOExceptionTracker(Object object) {
        this.POJOExceptionTracker.remove(object);
    }

    public void addObjectToPOJOExceptionTracker(Object object, MethodInfo methodInfo) {
        try {
            this.POJOExceptionTracker.put(object, methodInfo);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean isPointcutLimitReached() {
        return this.isPointcutLimitReached;
    }

    public void beginHTTPStatus() {
        this.isPointcutLimitReached = true;
    }

    public void endHTTPStatus() {
        this.isPointcutLimitReached = false;
    }

    public boolean isCodeFound() {
        return this.recentHTTPConnectID != null && this.httpResponseCodes.containsKey(this.recentHTTPConnectID);
    }

    public boolean isResponseJVMGuidCollected() {
        return this.recentHTTPConnectID != null && this.httpResponseHeader.containsKey(this.recentHTTPConnectID);
    }

    public void freeMemory() {
        if (this.entryAndSQLtrackerMap != null) {
            this.entryAndSQLtrackerMap.clear();
        }
        this.prepareOrCallableStmtQuery = null;
        this.jmsSessionTable = null;
        this.entryAndSQLtrackerMap = null;
        this.POJOExceptionTracker = null;
        this.methodCountMap = null;
        this.fastMethodMap = null;
        this.reqType = null;
        this.httpCallCounter = null;
        this.threadCallCounter = null;
        this.icMeasureData = null;
        this.threadDiagnosis = null;
        this.redisCommandQueue = null;
        this.noSQLDetails = null;
        this.httpResponseCodes = null;
        this.httpResponseHeader = null;
        this.responseObject = null;
        this.writerObject = null;
        this.outputStreamObject = null;
        this.templateBuilder = null;
    }

    public boolean isKeyTransactionRequest() {
        return this.keyTransactionRequest;
    }

    public boolean isAjaxRequest() {
        return this.isAjaxRequest;
    }

    public void setAjaxRequest(boolean bl) {
        this.isAjaxRequest = bl;
    }

    public long getRequestStartTime() {
        return this.reqStartTime;
    }

    public String getAutoRumFirstServlet() {
        return this.autoRumFirstServlet;
    }

    public void setAutoRumFirstServlet(String string, Object object) {
        this.autoRumFirstServlet = string;
        this.responseObject = object;
    }

    public void setExceptionBottomFQCN(String string) {
        this.exceptionBottomFQCN = string;
    }

    public void setExceptionRootFQCN(String string) {
        this.exceptionRootFQCN = string;
    }

    public void setResponseObject(Object object) {
        this.responseObject = object;
    }

    public Object getResponseObject() {
        return this.responseObject;
    }

    public Object getWriterObj() {
        return this.writerObject;
    }

    public void setWriterObj(Object object) {
        this.writerObject = object;
    }

    public Object getOutputStreamObject() {
        return this.outputStreamObject;
    }

    public void setOutputStreamObject(Object object) {
        this.outputStreamObject = object;
    }

    public boolean isInjectRumScript() {
        return this.injectRumScript;
    }

    public void setInjectRumScript(boolean bl) {
        this.injectRumScript = bl;
    }

    public boolean isAlreadyRumScriptInjected() {
        return this.alreadyRumScriptInjected;
    }

    public void setAlreadyRumScriptInjected() {
        this.alreadyRumScriptInjected = true;
    }

    public void setRequestForwarded(boolean bl) {
        this.autoRumFirstServlet = null;
    }

    public HtmlTagChecker.TAGS getTags() {
        return this.enumTags;
    }

    public void setTags(HtmlTagChecker.TAGS tAGS) {
        this.enumTags = tAGS;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public StringBuilder getTemplateBuilder() {
        return this.templateBuilder;
    }

    public void createNewTemplateBuilder(String string) {
        this.templateBuilder = new StringBuilder(string);
    }

    public void setContentType(ContentType contentType, String string) {
        this.contentType = contentType;
        this.contentTypeString = string;
    }

    public String getContentTypeString() {
        return this.contentTypeString;
    }

    public void recordEndTime() {
        this.threadDiagnosis.recordTimings(false);
    }

    public long getThreadCPUTime() {
        return this.threadDiagnosis.getCPUTime();
    }

    public long getThreadBlockedTime() {
        return this.threadDiagnosis.getBlockedTime();
    }

    public long getThreadWaitedTime() {
        return this.threadDiagnosis.getWaitedTime();
    }

    public void addPrepareOrCallableStmtQuery(Object object, String string) {
        if (object != null) {
            try {
                this.prepareOrCallableStmtQuery.put(object, string);
            }
            catch (NullPointerException nullPointerException) {
                this.prepareOrCallableStmtQuery = new HashMap();
                this.prepareOrCallableStmtQuery.put(object, string);
            }
        }
    }

    public String getPrepareOrCallableStmtQuery(Object object) {
        if (object != null) {
            try {
                String string = this.prepareOrCallableStmtQuery.get(object);
                if (string == null) {
                    return "-";
                }
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    public void removePrepareOrCallableStmtQuery(Object object) {
        if (object != null) {
            try {
                this.prepareOrCallableStmtQuery.remove(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addProviderName(Object object, String string) {
        if (object != null) {
            try {
                this.jmsSessionTable.put(object, string);
            }
            catch (NullPointerException nullPointerException) {
                this.jmsSessionTable = new HashMap();
                this.jmsSessionTable.put(object, string);
            }
        }
    }

    public String getProviderName(Object object) {
        if (object != null) {
            try {
                String string = (String)this.jmsSessionTable.get(object);
                if (string == null) {
                    return "-";
                }
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    public void removeObjectFromTable(Object object) {
        try {
            this.jmsSessionTable.remove(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addJMSDetails(Object object, String[] stringArray) {
        if (object != null) {
            try {
                this.jmsSessionTable.put(object, stringArray);
            }
            catch (NullPointerException nullPointerException) {
                this.jmsSessionTable = new HashMap();
                this.jmsSessionTable.put(object, stringArray);
            }
        }
    }

    public String[] getJMSDetails(Object object) {
        String[] stringArray = null;
        if (object != null && this.jmsSessionTable != null) {
            stringArray = (String[])this.jmsSessionTable.get(object);
        }
        return stringArray;
    }

    public boolean is404Code() {
        return this.statusCode == 404;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public void setStatusMessage(String string) {
        this.rootProps.put("STATUS_MESSAGE", string);
    }

    public String[] getNoSQLConnectionDetails(Object object) {
        String[] stringArray = null;
        if (this.noSQLDetails != null) {
            stringArray = this.noSQLDetails.get(object);
        }
        return stringArray;
    }

    public void addNoSQLConnectionDetails(Object object, String[] stringArray) {
        if (this.noSQLDetails == null) {
            this.noSQLDetails = new HashMap();
        }
        this.noSQLDetails.put(object, stringArray);
    }

    public String getLdapDetails(Object object) {
        String[] stringArray = this.getNoSQLConnectionDetails(object);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public void addLdapDetails(Object object, String string) {
        String[] stringArray = new String[]{string};
        this.addNoSQLConnectionDetails(object, stringArray);
    }

    public void addRedisCommandDetails(RedisCommandInfo redisCommandInfo) {
        if (this.redisCommandQueue == null) {
            this.redisCommandQueue = new LinkedList<RedisCommandInfo>();
        }
        this.redisCommandQueue.add(redisCommandInfo);
    }

    public Map getRedisCommandDetails() {
        if (this.redisCommandQueue != null) {
            RedisCommandInfo redisCommandInfo = this.redisCommandQueue.poll();
            String string = redisCommandInfo.getRedisHost();
            String string2 = redisCommandInfo.getRedisPort();
            String string3 = redisCommandInfo.getRedisDB();
            String string4 = redisCommandInfo.getRedisCmd();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3).append("#").append(string4);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("redisIP", string);
            hashMap.put("redisPort", string2);
            hashMap.put("redisDetails", stringBuilder.toString());
            return hashMap;
        }
        return null;
    }

    public Map getRedisCommandDetails(boolean bl) {
        if (this.redisCommandQueue != null) {
            Object object;
            RedisCommandInfo redisCommandInfo = this.redisCommandQueue.poll();
            String string = redisCommandInfo.getRedisHost();
            String string2 = redisCommandInfo.getRedisPort();
            String string3 = redisCommandInfo.getRedisDB();
            String string4 = redisCommandInfo.getRedisCmd();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3).append("#").append(string4).append(",");
            while (!this.redisCommandQueue.isEmpty()) {
                object = this.redisCommandQueue.poll();
                String string5 = ((RedisCommandInfo)object).getRedisDB();
                String string6 = ((RedisCommandInfo)object).getRedisCmd();
                stringBuilder.append(string5).append("#").append(string6).append(",");
            }
            object = new HashMap();
            object.put("redisIP", string);
            object.put("redisPort", string2);
            object.put("redisDetails", stringBuilder.toString());
            return object;
        }
        return null;
    }

    public void updateHTTPConnectionID() {
        String string;
        if (this.currentMinfo != null && (string = this.currentMinfo.getType()) != null && string.equals("HTTP")) {
            this.recentHTTPConnectID = this.currentMinfo.getId();
            if (this.httpResponseCodes == null || this.httpResponseHeader == null) {
                this.httpResponseCodes = new HashMap();
                this.httpResponseHeader = new HashMap();
            }
        }
    }

    public void updateHTTPResponseJVMGuidDetails(String string) {
        Map map;
        MethodInfo methodInfo;
        if (this.recentHTTPConnectID > 0L && (methodInfo = this.childMap.get(this.recentHTTPConnectID)) != null && (map = methodInfo.getProperties()) != null) {
            map.put("TFT_KEY", String.valueOf(string));
            this.httpResponseHeader.put(this.recentHTTPConnectID, "FOUND");
            BTMLog.logger.info("HTTP Response UNIQUE JVM GUID code for the {} is collected & props are {} ", (Object)this.getReqGUID(), (Object)map);
        }
    }

    public void updateHTTPStatusCode(int n, String string) {
        Map map;
        MethodInfo methodInfo;
        if (this.recentHTTPConnectID > 0L && (methodInfo = this.childMap.get(this.recentHTTPConnectID)) != null && (map = methodInfo.getProperties()) != null) {
            map.put("SC", String.valueOf(n));
            this.isErrorOutBoundHTTP = true;
            if (string != null) {
                map.put("RM", string);
            }
            this.httpResponseCodes.put(this.recentHTTPConnectID, "FOUND");
            BTMLog.logger.info("HTTP Response code for the {} is updated the code : {} & props are {} ", this.getReqGUID(), n, map);
        }
    }

    public void updateHTTPStatusCode(int n) {
        Map map;
        MethodInfo methodInfo;
        if (this.recentHTTPConnectID > 0L && (methodInfo = this.childMap.get(this.recentHTTPConnectID)) != null && (map = methodInfo.getProperties()) != null) {
            map.put("SC", String.valueOf(n));
            this.httpResponseCodes.put(this.recentHTTPConnectID, "FOUND");
            BTMLog.logger.info("HTTP Response code for the {} is updated the code : {} & props are {} ", this.getReqGUID(), n, map);
        }
    }

    public void updateApacheHTTPStatusCode(int n) {
        Map map;
        MethodInfo methodInfo = this.currentMinfo;
        if (methodInfo != null && (map = methodInfo.getProperties()) != null) {
            map.put("SC", String.valueOf(n));
            BTMLog.logger.info("HTTP Response code for the {} is updated the code : {} & props are {} ", this.getReqGUID(), n, map);
        }
    }

    public String getResponseUniqueJvmGuid() {
        return this.responseUniqueJvmGuid;
    }

    public void setResponseUniqueJvmGuid(String string) {
        this.responseUniqueJvmGuid = string;
    }

    public void updateApacheHTTPStatusCode(int n, String string) {
        Map map;
        MethodInfo methodInfo = this.currentMinfo;
        if (methodInfo != null && (map = methodInfo.getProperties()) != null) {
            map.put("SC", String.valueOf(n));
            this.isErrorOutBoundHTTP = true;
            if (string != null) {
                map.put("RM", string);
            }
            BTMLog.logger.info("HTTP Response code for the {} is updated the code : {} & props are {} ", this.getReqGUID(), n, map);
        }
    }

    public boolean isErrorOutBoundHTTP() {
        return this.isErrorOutBoundHTTP;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public boolean isReadCause() {
        return this.isReadCause;
    }

    public boolean isExpWithStackTraceCountLimitReached() {
        return this.isExpWithStackTraceCountLimitReached;
    }

    public void setExpWithStackTraceCountLimitReached(boolean bl) {
        this.isExpWithStackTraceCountLimitReached = bl;
    }

    public boolean isExpFQENCountLimitReached() {
        return this.isExpFQENCountLimitReached;
    }

    public void setExpFQENCountLimitReached(boolean bl) {
        this.isExpFQENCountLimitReached = bl;
    }

    public int getTotalExceptionCount() {
        return this.totalExceptionCounter;
    }

    public void incrementTotalExceptionCounter() {
        ++this.totalExceptionCounter;
    }

    public int getTotalExceptionWithStackCount() {
        return this.exceptionWithStackCounter;
    }

    public void incrementExceptionWithStackCounter() {
        ++this.exceptionWithStackCounter;
    }

    public int getTotalFQExceptionCount() {
        return this.exceptionFQENCounter;
    }

    public void incrementFQExceptionCounter() {
        ++this.exceptionFQENCounter;
    }

    public void setExceptionTraceAvailable(boolean bl) {
        this.rootProps.put("ExceptionTrace", bl);
    }

    public boolean isFrontExceptionAvailable() {
        return this.isFrontExceptionAvailable;
    }

    public void setFrontExceptionAvailable(boolean bl) {
        this.isFrontExceptionAvailable = bl;
    }

    void onEnd() {
        this.rootProps.put("CHILD_MAP", this.childMap);
        this.rootProps.put("STATUS", "-");
        if (this.fastSqlDetailsMap != null) {
            this.rootProps.put("Fast_Method_Map", this.fastSqlDetailsMap);
        }
        if (this.slowSqlLimitExceedDetailsMap != null) {
            this.rootProps.put("Slow_Exceed_Sql_Limit_Map", this.slowSqlLimitExceedDetailsMap);
        }
        if (this.errorSqlLimitExceedDetailsMap != null) {
            this.rootProps.put("Error_Exceed_Sql_Limit_Map", this.errorSqlLimitExceedDetailsMap);
        }
        if (this.ehCacheDetailsMap != null) {
            this.rootProps.put("EHCACHE_DETAILS", this.ehCacheDetailsMap);
        }
        if (this.exceptionList != null) {
            this.rootProps.put("JAVA_EXCEPTION_DETAILS", this.exceptionList);
        }
        if (this.exceptionRootFQCN != null) {
            this.rootProps.put("JAVA_EXCEPTION_FQCN_ROOT", this.exceptionRootFQCN);
        }
        if (this.exceptionBottomFQCN != null) {
            this.rootProps.put("JAVA_EXCEPTION_FQCN_BOTTOM", this.exceptionBottomFQCN);
        }
        if (this.allSqlDetailsMap != null) {
            this.getRootMinfo().setSQLPresent(true);
            this.rootProps.put("SlowSQLTime", this.allSqlDetailsMap.get("ALL_SQL"));
        }
        if (this.totalExceptionCounter != 0) {
            long l = this.getTotalExceptionCount() - (this.getTotalExceptionWithStackCount() + this.getTotalFQExceptionCount());
            this.rootProps.put("ExceededExceptionCountDetails", l);
        }
        if (this.isCollectFlowMetrics()) {
            Map<String, double[]> map;
            String string = this.rootMinfo.getType();
            if (string.equals("JMS_ENTRY")) {
                this.computeJmsEntryDetails(this.getRootMinfo().getExecutionTime(), this.getRootMinfo().isErrorURL());
            }
            if ((map = this.callDiagnosis.computeSelfNodeTime(this.getRootMinfo().getExecutionTime(), this.getRootMinfo().isErrorURL(), string)) != null) {
                this.rootProps.put("TRANSACTION_FLOW_DETAILS", map);
            }
        }
        this.rootProps.put("TimeZone", BTMDiscovery.getDataBaseHT().get("TimeZone"));
    }

    static {
        MAPPINGS.put("Unknown", Type.UNKNOWN);
        MAPPINGS.put("SQL", Type.SQL);
        MAPPINGS.put("JDBC", Type.JDBC);
        MAPPINGS.put("POJO", Type.POJO);
        MAPPINGS.put("JMS", Type.JMS);
        MAPPINGS.put("HTTP", Type.HTTP);
        MAPPINGS.put("HTTPStream", Type.HTTPSTREAM);
        MAPPINGS.put("WEBSERVICE", Type.WEBSERVICE);
        MAPPINGS.put("RMI", Type.RMI);
        MAPPINGS.put("EMAIL", Type.EMAIL);
        MAPPINGS.put("LDAP", Type.LDAP);
        MAPPINGS.put("EJB", Type.EJB);
        MAPPINGS.put("EJB_HIDE", Type.EJB_HIDE);
        MAPPINGS.put("Custom_", Type.CUSTOM);
        MAPPINGS.put("HttpConn", Type.HTTPCONN);
        MAPPINGS.put("HTTPErrorStream", Type.HTTPERRORSTREAM);
        MAPPINGS.put("SAP JCO", Type.SAP);
        MAPPINGS.put("JSP", Type.JSP);
        MAPPINGS.put("SpringDispatcher", Type.SPRINGDISPATCHER);
        MAPPINGS.put("SpringRender", Type.SPRINGRENDER);
        MAPPINGS.put("STRUTS", Type.STRUTS);
        MAPPINGS.put("STRUTS2", Type.STRUTS);
        MAPPINGS.put("FILTER", Type.FILTER);
        MAPPINGS.put("THREAD", Type.THREAD);
        MAPPINGS.put("THREAD_JOIN", Type.THREADJOIN);
        MAPPINGS.put("THREAD_SLEEP", Type.THREAD_SLEEP);
        MAPPINGS.put("THREAD_INIT", Type.THREAD_INIT);
        MAPPINGS.put("HTTPSERVLET", Type.HTTPSERVLET);
        MAPPINGS.put("JSF", Type.JSF);
        MAPPINGS.put("MULE", Type.MULE);
        MAPPINGS.put("JMS_ENTRY", Type.JMS_ENTRY);
        MAPPINGS.put("JSFRender", Type.JSFRENDER);
        MAPPINGS.put("RUNTIME", Type.RUNTIME);
        MAPPINGS.put("WAITFOR", Type.WAITFOR);
        MAPPINGS.put("WEBSERVICE_ENTRY", Type.WEBSERVICE_ENTRY);
        MAPPINGS.put("EXCEPTION", Type.ERROR);
        MAPPINGS.put("MONGODB", Type.MONGODB);
        MAPPINGS.put("REDIS", Type.REDIS);
        MAPPINGS.put("EHCACHE", Type.EHCACHE);
        MAPPINGS.put("JMS_LISTENER", Type.JMSLISTENER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        UNKNOWN{

            public boolean isContentTypeFound() {
                return false;
            }

            public boolean isTextHtml() {
                return false;
            }
        }
        ,
        TEXT_HTML{

            public boolean isContentTypeFound() {
                return true;
            }

            public boolean isTextHtml() {
                return true;
            }
        }
        ,
        NOT_TEXT_HTML{

            public boolean isContentTypeFound() {
                return true;
            }

            public boolean isTextHtml() {
                return false;
            }
        };


        public abstract boolean isContentTypeFound();

        public abstract boolean isTextHtml();
    }
}

