/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMServer;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.OffLoadAgentCheck;
import com.eg.jtm.PlatformThreadMXBean;
import com.eg.jtm.PropFilesTracker;
import com.eg.jtm.PropsManager;
import com.eg.jtm.STATUS;
import com.eg.jtm.learning.LearningProperties;
import com.eg.jvmmonitor.JVMMetricsManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StartServer {
    static boolean started = false;
    static BTMServer btmSrv = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean startThread() {
        try {
            if (started) return started;
            Class<StartServer> clazz = StartServer.class;
            synchronized (StartServer.class) {
                if (!started) {
                    Object object;
                    Runnable runnable;
                    BTMLog.initBTMLogger();
                    BTMLog.initBTMDebugLogger();
                    PropsManager.resetBTMEnabled();
                    if (PropsManager.EG_BTM_HOME == null) {
                        BTMLog.logger.error("BTM_Error: EG_BTM_HOME property was not set!! Aborting BTM startup...");
                        PropsManager.resetBTMEnabled();
                        started = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return false;
                    }
                    if (!StartServer.okToStart()) {
                        BTMLog.logger.error("BTM_Error: Aborting BTM Startup");
                        PropsManager.resetBTMEnabled();
                        started = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return false;
                    }
                    BTMLog.logger.info("*******************************************************************************************");
                    BTMLog.logger.info("************** eG Java Business Transaction Monitoring (BTM) Begins *************");
                    BTMLog.logger.info("*******************************************************************************************");
                    BTMLog.logger.info("Working in directory {} ", (Object)PropsManager.EG_BTM_HOME);
                    PropsManager.assignJvmGUID();
                    ContainerDiscovery.initDiscoveryProcess();
                    PropsManager.applyBTMProps();
                    PropFilesTracker.scheduleTracking();
                    if (!StartServer.isOffloadCheckDone() && ((OffLoadAgentCheck)(runnable = OffLoadAgentCheck.getInstance())).getCheckStatus().isStatusNone()) {
                        ((OffLoadAgentCheck)runnable).setCheckStatus(STATUS.OFFLOAD);
                        object = new Thread(runnable, "Offload_Checker_Frm_StartServer");
                        ((Thread)object).setDaemon(true);
                        ((Thread)object).start();
                    }
                    runnable = new JVMMetricsManager(PropsManager.getJvmGUID());
                    PropsManager.setBTMEnabled();
                    btmSrv = new BTMServer();
                    btmSrv.setDaemon(true);
                    btmSrv.setName("BTM_Server");
                    btmSrv.start();
                    started = true;
                    object = LearningProperties.getInstance();
                    PlatformThreadMXBean.getInstance();
                }
                ContainerDiscovery.logConfigDetails();
                // ** MonitorExit[var0] (shouldn't be in output)
                return started;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception While Starting Thread...");
            exception.printStackTrace();
        }
        return started;
    }

    public static void stopBTMServer() {
        System.out.println(" stopBTMServer : btmSrv :" + btmSrv + " started :" + started);
        if (btmSrv != null && started) {
            btmSrv.shutDownServerSocket();
        }
    }

    public static boolean isOffloadCheckDone() {
        String string = PropsManager.getProperty("BACKWARD_COMPATIBILITY_CHECK");
        return string != null && string.equalsIgnoreCase("false");
    }

    private static boolean okToStart() {
        String string;
        File file = new File(PropsManager.EG_BTM_HOME);
        if (!file.isDirectory()) {
            BTMLog.logger.error("BTM_Error: Cannot find EG_BTM_HOME directory : {} ", (Object)PropsManager.EG_BTM_HOME);
            return false;
        }
        PropsManager.setPropFileNames();
        if (!PropsManager.isPropsFileValid(PropsManager.otherPropsFile)) {
            BTMLog.logger.error("BTM_Error: Could not find BTM connection properties file in {} or the file is empty ", (Object)PropsManager.EG_BTM_HOME);
            return false;
        }
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(PropsManager.otherPropsFile)));
        }
        catch (IOException iOException) {
            BTMLog.logger.error("BTM_Error: Exception while getting props from {} {} ", (Object)PropsManager.otherPropsFileName, (Object)iOException);
            return false;
        }
        String string2 = properties.getProperty("BTM_Port");
        if (string2 == null) {
            BTMLog.logger.error("BTM_Error: Could not find BTM_Port entry in the connection properties file.");
            return false;
        }
        PropsManager.initProps();
        if (PropsManager.isPropsFileValid(PropsManager.otherPropsFile)) {
            PropsManager.loadPropsFromFile(true);
        } else {
            BTMLog.logger.warn("Props file was not valid. Could not load props from file. Using default values instead");
        }
        if ((!StartServer.isOffloadCheckDone() || PropsManager.isOldModel()) && (string = BTMUtils.checkPortAvailability(string2)) != null) {
            BTMLog.logger.error("BTM_Error: " + string);
            return false;
        }
        System.out.println("OK to start BTM");
        return true;
    }
}

