/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import java.util.HashMap;
import java.util.StringTokenizer;

public class StatusCodeErrorRange {
    private static final HashMap<Integer, Integer> errorStatusCodeMap = new HashMap();
    private static final int DEFAULT_MINIMUM = 400;
    private static final int DEFAULT_MAXIMUM = 505;

    private StatusCodeErrorRange() {
    }

    private static void assignRange(int n, int n2) {
        if (n > n2) {
            return;
        }
        if (n >= 100 && n2 < 600) {
            Integer n3 = errorStatusCodeMap.get(n);
            if (n3 != null) {
                int n4 = n3;
                if (n4 > n2) {
                    for (int i = n; i <= n4; ++i) {
                        errorStatusCodeMap.put(i, n4);
                    }
                    BTMLog.logger.trace("Updated error HTTP status code range {} -{} ", (Object)n, (Object)n4);
                }
            } else {
                for (int i = n; i <= n2; ++i) {
                    errorStatusCodeMap.put(i, n2);
                }
                BTMLog.logger.trace("Updated error HTTP status code range {} -{} ", (Object)n, (Object)n2);
            }
        }
    }

    static boolean checkRange(int n) {
        return errorStatusCodeMap.containsKey(n);
    }

    private static void reset() {
        errorStatusCodeMap.clear();
        for (int i = 400; i <= 505; ++i) {
            errorStatusCodeMap.put(i, 505);
        }
    }

    public static void initializeErrorRange(String string) {
        StatusCodeErrorRange.reset();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                while (stringTokenizer2.hasMoreElements()) {
                    try {
                        Integer n = Integer.parseInt((String)stringTokenizer2.nextElement());
                        Integer n2 = Integer.parseInt((String)stringTokenizer2.nextElement());
                        StatusCodeErrorRange.assignRange(n, n2);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while updating error HTTP status code range {} ", exception);
        }
    }

    static {
        for (int i = 400; i <= 505; ++i) {
            errorStatusCodeMap.put(i, 505);
        }
    }
}

