/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeZoneManager {
    private static String idString = null;
    private static String shortTimeZone = null;
    private static TimeZone timeZone = null;
    private static boolean isDayLightTimeZone = false;
    private static String shortDayLightTimeZone = null;
    public static final String TIMEZONE = "TimeZone";
    private static final long check_interval = 600000L;
    private static long lastVerifiedTime = -1L;

    static void updateTimeZoneDetails() {
        if (isDayLightTimeZone) {
            long l = System.currentTimeMillis();
            if (lastVerifiedTime > 0L && l - lastVerifiedTime < 600000L) {
                return;
            }
            lastVerifiedTime = l;
            Date date = new Date(l);
            String string = (String)BTMDiscovery.getDataBaseHT().get(TIMEZONE);
            boolean bl = TimeZone.getTimeZone(idString).inDaylightTime(date);
            if (bl) {
                if (!string.equals(shortDayLightTimeZone)) {
                    BTMDiscovery.getDataBaseHT().put(TIMEZONE, shortDayLightTimeZone);
                    BTMLog.logger.info("JVM uses DayLight Savings Time(DST), so modified {} TimeZone for the {} ", (Object)shortDayLightTimeZone, (Object)idString);
                }
            } else if (!string.equals(shortTimeZone)) {
                BTMDiscovery.getDataBaseHT().put(TIMEZONE, shortTimeZone);
                BTMLog.logger.info("JVM not using DayLight Savings Time(DST), so modified {} TimeZone for the  {} ", (Object)shortTimeZone, (Object)idString);
            }
        }
    }

    public static String getShortTimeZone() {
        return shortTimeZone;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        timeZone = calendar.getTimeZone();
        idString = timeZone.getID();
        shortTimeZone = timeZone.getDisplayName(false, 0);
        isDayLightTimeZone = TimeZone.getTimeZone(idString).useDaylightTime();
        if (isDayLightTimeZone) {
            shortDayLightTimeZone = timeZone.getDisplayName(true, 0);
            BTMDiscovery.getDataBaseHT().put(TIMEZONE, shortDayLightTimeZone);
            if (BTMLog.logger != null) {
                BTMLog.logger.info("JVM running on the {}  TimeZone & DayLight Savings Time(DST) is {} & Timezone ID : {}", shortDayLightTimeZone, isDayLightTimeZone, idString);
            }
        } else {
            BTMDiscovery.getDataBaseHT().put(TIMEZONE, shortTimeZone);
            if (BTMLog.logger != null) {
                BTMLog.logger.info("JVM running on the {} TimeZone & DayLight Savings Time(DST) is {} & Timezone ID : {} ", shortTimeZone, isDayLightTimeZone, idString);
            }
        }
        lastVerifiedTime = System.currentTimeMillis();
    }
}

