/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMQueue;
import com.eg.jtm.BTMSocket;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.DataWriterProvider;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.OffLoadAgentCheck;
import com.eg.jtm.OffLoadAgentInfiniteCheck;
import com.eg.jtm.PropsManager;
import com.eg.jtm.STATUS;
import com.eg.jvmmonitor.JVMMetricData;
import com.eg.org.apache.commons.lang3.SerializationUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Worker
implements Runnable {
    private BTMQueue<Object> myQueue;
    private MethodInfo tempMinfo = null;
    private String tempHeartBeatInfo = null;
    private static final String JvmGUID = "JvmGUID";
    private static final String NodeID = "NodeID";
    private static boolean doOffloadCheck = false;
    private boolean runThis = true;
    private static final String OFFLOAD_CONFIG_OK = "OFFLOAD_CONFIG_OK";
    private static final String OFFLOAD_CPC_CONFIG_OK = "OFFLOAD_CPC_CONFIG_OK";
    private static final long ONE_SECOND = 1000L;
    private static final long SIXTY_SECONDS = 60000L;
    private static final long THIRTY_SECONDS = 30000L;
    private static final long TEN_MILLISECONDS = 10L;
    private static final long HUNDRED_MILLISECONDS = 100L;
    private static final long FIFTEEN_MINS = 900000L;
    private final long startUpTime = System.currentTimeMillis();
    private long lastDiscoveryDataTransferTime = System.currentTimeMillis();
    private static final HashMap<String, String> propsMap = new HashMap(2);
    private static final HashMap<String, String> threshMap = new HashMap(2);
    private static final ReentrantLock lock;

    public Worker(BTMQueue<Object> bTMQueue) {
        this.myQueue = bTMQueue;
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (BTMOffLoadConfig.isDiscoveryMode()) {
            this.processDiscoveryData();
            return;
        }
        String string = "[" + Thread.currentThread().getName() + "]";
        DataWriterProvider dataWriterProvider = new DataWriterProvider();
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        BTMSocket bTMSocket = null;
        do {
            try {
                BTMLog.logger.debug("{} eG Java BTM able to send offload data? {} & Offload Infinite Agent Check Status : {} &  Offload Agent Check Status : {} , Worker Offload Check Status : {}, Offload Agent Check result : {}", new Object[]{string, BTMOffLoadConfig.isOKToSendOffloadData(), OffLoadAgentInfiniteCheck.getInstance().getCheckStatus(), OffLoadAgentCheck.getInstance().getCheckStatus(), doOffloadCheck, BTMOffLoadConfig.isThisOffloadAgent()});
                if (!BTMOffLoadConfig.isOKToSendOffloadData()) {
                    if (OffLoadAgentInfiniteCheck.getInstance().getCheckStatus().isStatusNone()) {
                        BTMLog.logger.trace(" {} trying to trigger Offload Agent Port Discovery", (Object)string);
                        this.triggerOffloadAgentCheck(string);
                    }
                    this.sleep(60000L);
                    this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                    continue;
                }
                boolean bl = false;
                while (doOffloadCheck) {
                    this.triggerOffloadAgentCheck(string);
                }
                bTMSocket = dataWriterProvider.establishConnection(false, BTMOffLoadConfig.getCollectorAgentPortNo());
                if (!bTMSocket.isConnectionSuccess()) {
                    doOffloadCheck = true;
                    this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                    continue;
                }
                doOffloadCheck = false;
                objectOutputStream = dataWriterProvider.getObjOutputStream(bTMSocket, string);
                if (objectOutputStream != null) {
                    objectInputStream = dataWriterProvider.getObjInputStream(bTMSocket, true, string);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string).append("-").append(bTMSocket.getInetAddress()).append(":").append(bTMSocket.getLocalPort());
                String string2 = stringBuilder.toString();
                while (!bl && this.runThis && objectOutputStream != null && objectInputStream != null && BTMOffLoadConfig.isOKToSendOffloadData()) {
                    try {
                        Object object = this.myQueue.dequeue();
                        if (object != null) {
                            if (object instanceof MethodInfo) {
                                this.flushBtmData((MethodInfo)object, objectInputStream, objectOutputStream, string2, bTMSocket);
                            } else if (object instanceof JVMMetricData) {
                                this.flushJvmData((JVMMetricData)object, objectInputStream, objectOutputStream, string2, bTMSocket);
                            } else if (object instanceof String) {
                                this.flushStringData((String)object, objectInputStream, objectOutputStream, string2, bTMSocket);
                            }
                        } else {
                            this.sleep(10L);
                        }
                    }
                    catch (SocketException socketException) {
                        doOffloadCheck = true;
                        BTMLog.logger.warn("{} Failed to send data to eG Agent due to SocketException: {} ", (Object)string, (Object)socketException.getMessage());
                        if (this.tempMinfo != null) {
                            this.myQueue.enqueue(this.tempMinfo);
                            BTMLog.logger.warn(" Enqueued data which is failed to send. Current Queue size : {} ", (Object)this.myQueue.getSize());
                            BTMLog.logger.trace(" Failed to send the Minfo for the GUID : {} ", (Object)this.tempMinfo.getGuidString());
                        }
                        if (this.tempHeartBeatInfo != null) {
                            this.myQueue.enqueue(this.tempHeartBeatInfo);
                            BTMLog.logger.warn(" Enqueued HeartBeat data[{}] which is failed to send. Current Queue size : {} ", (Object)this.tempHeartBeatInfo, (Object)this.myQueue.getSize());
                        }
                        this.tempMinfo = null;
                        this.tempHeartBeatInfo = null;
                        bl = true;
                    }
                    catch (NullPointerException nullPointerException) {
                        bl = true;
                        BTMLog.logger.warn("{}  Failed to send data to eG Agent due to NullPointerException: {}", string, nullPointerException.getMessage(), nullPointerException);
                    }
                    catch (Exception exception) {
                        bl = true;
                        doOffloadCheck = true;
                        BTMLog.logger.warn("{} Failed to send data to eG Agent : {} ", (Object)string, (Object)exception.getMessage());
                    }
                    this.sleep(1L);
                }
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                this.sleep(1000L);
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Exception occured in the worker thread {}", (Object)string, (Object)exception);
            }
            finally {
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
            }
            this.sleep(100L);
        } while (this.runThis);
        BTMLog.logger.warn("{} Worker destroyed!!!", (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDiscoveryData() {
        String string = "[" + Thread.currentThread().getName() + "]";
        DataWriterProvider dataWriterProvider = new DataWriterProvider();
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        BTMSocket bTMSocket = null;
        HashMap hashMap = null;
        do {
            try {
                BTMLog.logger.debug("{} eG Java BTM able to send offload data? {} & Offload Infinite Agent Check Status : {} &  Offload Agent Check Status : {} , Worker Offload Check Status : {}, Offload Agent Check result : {}", new Object[]{string, BTMOffLoadConfig.isOKToSendOffloadData(), OffLoadAgentInfiniteCheck.getInstance().getCheckStatus(), OffLoadAgentCheck.getInstance().getCheckStatus(), doOffloadCheck, BTMOffLoadConfig.isThisOffloadAgent()});
                if (!BTMOffLoadConfig.isOKToSendOffloadData()) {
                    if (OffLoadAgentInfiniteCheck.getInstance().getCheckStatus().isStatusNone()) {
                        this.triggerOffloadAgentCheck(string);
                    }
                    this.sleep(60000L);
                    this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                    continue;
                }
                boolean bl = false;
                while (doOffloadCheck) {
                    this.triggerOffloadAgentCheck(string);
                }
                bTMSocket = dataWriterProvider.establishConnection(false, BTMOffLoadConfig.getCollectorAgentPortNo());
                if (!bTMSocket.isConnectionSuccess()) {
                    doOffloadCheck = true;
                    this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                    continue;
                }
                doOffloadCheck = false;
                objectOutputStream = dataWriterProvider.getObjOutputStream(bTMSocket, string);
                if (objectOutputStream != null) {
                    objectInputStream = dataWriterProvider.getObjInputStream(bTMSocket, true, string);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string).append("-").append(bTMSocket.getInetAddress()).append(":").append(bTMSocket.getLocalPort());
                String string2 = stringBuilder.toString();
                while (!bl && this.runThis && objectOutputStream != null && objectInputStream != null && BTMOffLoadConfig.isOKToSendOffloadData()) {
                    try {
                        HashMap hashMap2;
                        Object object = this.myQueue.dequeue();
                        if (object != null) {
                            if (object instanceof HashMap) {
                                hashMap = (HashMap)object;
                                this.flushDiscoveryData((HashMap)object, objectInputStream, objectOutputStream, string2, bTMSocket);
                            } else if (object instanceof MethodInfo) {
                                HashMap hashMap3;
                                hashMap2 = ((MethodInfo)object).getProperties();
                                hashMap = hashMap3 = this.extractDiscoveryDetails(hashMap2, string2);
                                this.flushDiscoveryData(hashMap3, objectInputStream, objectOutputStream, string2, bTMSocket);
                                this.sleep(30000L);
                            }
                        } else {
                            this.sleep(30000L);
                            hashMap2 = new HashMap();
                            if (BTMLog.logger.isDebugEnabled()) {
                                BTMLog.logger.debug("resendDiscoveryData() : {}", (Object)BTMOffLoadConfig.resendDiscoveryData());
                                BTMLog.logger.debug("isDiscoveryDetailsFinalized() : {}", (Object)BTMOffLoadConfig.isDiscoveryDetailsFinalized());
                                BTMLog.logger.debug("isAckReceivedForDiscovery - {}", (Object)BTMOffLoadConfig.isAckReceivedForDiscovery());
                                BTMLog.logger.debug("Request Discovery Details - {}", (Object)ContainerDiscovery.getDiscoveredDetailsByRequest());
                                BTMLog.logger.debug("Startup Discovery Details - {}", (Object)ContainerDiscovery.getDiscoveredDetailsByStartup());
                            }
                            this.isClassNameDiscoveryCompleted();
                            if (BTMOffLoadConfig.resendDiscoveryData()) {
                                Hashtable hashtable;
                                long l = System.currentTimeMillis() - this.startUpTime;
                                if (l >= BTMOffLoadConfig.getDiscoveryMaxWaitTime() && (hashtable = ContainerDiscovery.getDiscoveredDetailsByStartup()) != null && !hashtable.containsKey("DISCOVERED")) {
                                    hashtable.put("DISCOVERED", "DISCOVERED");
                                }
                                hashMap = hashMap2 = this.getDiscoveryData(new HashMap());
                                this.flushDiscoveryData(hashMap2, objectInputStream, objectOutputStream, string2, bTMSocket);
                            } else {
                                this.resetDiscoveryAckFlagsForAgentRestart();
                            }
                        }
                    }
                    catch (SocketException socketException) {
                        doOffloadCheck = true;
                        BTMOffLoadConfig.resetDiscoveryDataAckFlags();
                        BTMLog.logger.warn("{} Failed to send data to eG Agent : {} ", (Object)string, (Object)socketException.getMessage());
                        if (hashMap != null) {
                            this.myQueue.enqueue(hashMap);
                            BTMLog.logger.warn(" Enqueued data which is failed to send. Current Queue size : {} ", (Object)this.myQueue.getSize());
                        }
                        hashMap = null;
                        bl = true;
                    }
                    catch (NullPointerException nullPointerException) {
                        bl = true;
                        BTMLog.logger.warn("{}  Failed to send data to eG Agent : {}", (Object)string, (Object)nullPointerException.getMessage());
                    }
                    catch (Exception exception) {
                        bl = true;
                        doOffloadCheck = true;
                        BTMOffLoadConfig.resetDiscoveryDataAckFlags();
                        BTMLog.logger.warn("{} Failed to send data to eG Agent : {} ", (Object)string, (Object)exception.getMessage());
                    }
                    this.sleep(1L);
                }
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
                this.sleep(1000L);
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Exception occured in the worker thread {}", (Object)string, (Object)exception);
            }
            finally {
                this.closeAll(objectInputStream, objectOutputStream, bTMSocket);
            }
            this.sleep(100L);
        } while (this.runThis);
        BTMLog.logger.warn("{} INFO:- Worker destroyed!!!", (Object)string);
    }

    private void triggerOffloadAgentCheck(String string) {
        Worker.offLoadAgentCheck(string);
        this.sleep(30000L);
        doOffloadCheck = false;
        if (OffLoadAgentInfiniteCheck.getInstance().getCheckStatus().isStatusNone() && OffLoadAgentCheck.getInstance().getCheckStatus().isStatusNone()) {
            BTMOffLoadConfig.resetThisOffloadAgent();
        }
    }

    private void isClassNameDiscoveryCompleted() {
        ContainerDiscovery.storeClassNameDiscoveredDataToStartupDiscovery();
    }

    private void resetDiscoveryAckFlagsForAgentRestart() {
        try {
            BTMLog.logger.debug("Last Discovery data transfer time: {}", (Object)this.lastDiscoveryDataTransferTime);
            long l = System.currentTimeMillis() - this.lastDiscoveryDataTransferTime;
            if (l >= 900000L) {
                BTMOffLoadConfig.resetDiscoveryDataAckFlags();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Exception occurred", exception);
        }
    }

    private void closeAll(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, BTMSocket bTMSocket) {
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (bTMSocket != null) {
                bTMSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flushBtmData(MethodInfo methodInfo, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, String string, BTMSocket bTMSocket) throws Exception {
        block3: {
            if (methodInfo == null) break block3;
            this.tempMinfo = methodInfo;
            Map map = methodInfo.getProperties();
            map.put(JvmGUID, PropsManager.getJvmGUID());
            map.put(NodeID, BTMOffLoadConfig.getNodeID());
            map.put("appName", BTMOffLoadConfig.getApplicationName());
            map.put("tierName", BTMOffLoadConfig.getTierName());
            BTMDiscovery.updateCommonDetails(map);
            byte[] byArray = SerializationUtils.serialize(methodInfo);
            int n = byArray.length;
            int n2 = 2;
            for (int i = 1; i <= n2; ++i) {
                objectOutputStream.writeInt(n);
                objectOutputStream.write(byArray);
                objectOutputStream.flush();
                BTMLog.logger.debug("{} Sending BTM data, size of the byte is {}", (Object)string, (Object)n);
                boolean bl = this.dataReceiver(bTMSocket, objectInputStream, string);
                if (!bl) continue;
                this.tempMinfo = null;
                break;
            }
        }
    }

    private void flushJvmData(JVMMetricData jVMMetricData, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, String string, BTMSocket bTMSocket) throws Exception {
        Map map = jVMMetricData.getProperties();
        map.put(JvmGUID, PropsManager.getJvmGUID());
        byte[] byArray = SerializationUtils.serialize(jVMMetricData);
        int n = byArray.length;
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray);
        objectOutputStream.flush();
        BTMLog.logger.debug("{} Sending JVM data, size of the byte is {}", (Object)string, (Object)n);
        this.dataReceiver(bTMSocket, objectInputStream, string);
    }

    private void flushStringData(String string, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, String string2, BTMSocket bTMSocket) throws Exception {
        this.tempHeartBeatInfo = string;
        byte[] byArray = SerializationUtils.serialize((Serializable)((Object)new String(string)));
        int n = byArray.length;
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray);
        objectOutputStream.flush();
        BTMLog.logger.debug("Sending data {} & size of the byte is {}", (Object)string, (Object)n);
        boolean bl = this.dataReceiver(bTMSocket, objectInputStream, string2);
        if (bl) {
            this.tempHeartBeatInfo = null;
        }
    }

    private void flushDiscoveryData(HashMap hashMap, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, String string, BTMSocket bTMSocket) throws Exception {
        HashMap hashMap2 = null;
        if (hashMap != null) {
            hashMap = this.getDiscoveryData(hashMap);
            BTMLog.logger.debug(" discoveryInfo : {}", (Object)hashMap);
            BTMLog.logger.debug(" PropsManager.getJvmGUID() : {}", (Object)PropsManager.getJvmGUID());
            if (hashMap != null && hashMap.size() <= 0) {
                BTMLog.logger.warn("{} No Discovery details found, skipping flush discovery data..");
                return;
            }
            hashMap2 = hashMap;
            if (!PropsManager.getJvmGUID().startsWith("DISCOVER_ME")) {
                BTMLog.logger.warn("{} component managed, skipping flush discovery data..", (Object)PropsManager.getJvmGUID());
                return;
            }
            hashMap.put(JvmGUID, PropsManager.getJvmGUID());
            hashMap.put(NodeID, BTMOffLoadConfig.getNodeID());
            hashMap.put("SYSTEM_PROPERITES", PropsManager.getSystemProperties());
            hashMap.put("SYSTEM_ENVIRONMENT_VARIABLES", PropsManager.getSystemEnvVariable().toString());
            hashMap.put("appName", BTMOffLoadConfig.getApplicationName());
            hashMap.put("tierName", BTMOffLoadConfig.getTierName());
            if (!hashMap.containsKey("CONTAINER_NAME")) {
                hashMap.put("CONTAINER_NAME", ContainerDiscovery.getContainerName());
            }
            byte[] byArray = SerializationUtils.serialize(hashMap);
            int n = byArray.length;
            int n2 = 2;
            for (int i = 1; i <= n2; ++i) {
                objectOutputStream.writeInt(n);
                objectOutputStream.write(byArray);
                objectOutputStream.flush();
                this.lastDiscoveryDataTransferTime = System.currentTimeMillis();
                BTMLog.logger.debug("{} Sending BTM Discovery data, size of the byte is {}", (Object)string, (Object)n);
                BTMLog.logger.warn("{} INFO:- Transferred Discovery Info - {}", (Object)string, (Object)hashMap);
                boolean bl = this.dataReceiver(bTMSocket, objectInputStream, string);
                boolean bl2 = false;
                if (bl) {
                    if (hashMap2 == null || OffLoadAgentInfiniteCheck.getInstance().getCheckStatus() != STATUS.OFFLOAD) break;
                    Thread.sleep(30000L);
                    bl2 = true;
                    break;
                }
                if (hashMap2 != null) {
                    bl2 = true;
                }
                if (bl2) {
                    this.myQueue.enqueue(hashMap2);
                    BTMLog.logger.info(" Enqueued data which is has Discovery Details for Fail-Safe. Current Queue size : {} ", (Object)this.myQueue.getSize());
                }
                hashMap2 = null;
            }
            this.offloadDiscoveryCheck();
        }
    }

    private HashMap getDiscoveryData(HashMap hashMap) {
        Hashtable hashtable;
        hashMap = new HashMap<String, Hashtable>();
        boolean bl = false;
        Hashtable hashtable2 = ContainerDiscovery.getDiscoveredDetailsByStartup();
        if (hashtable2 != null && hashtable2.containsKey("DISCOVERED")) {
            hashMap.put("STARTUP_DISCOVERY_DETAILS", hashtable2);
            bl = true;
        }
        BTMLog.logger.debug("is On Startup discovery details found for sending- {}", (Object)bl);
        if (!(BTMOffLoadConfig.isAckReceivedForDiscovery() && bl || (hashtable = ContainerDiscovery.getDiscoveredDetailsByRequest()) == null || !hashtable.containsKey("DISCOVERED"))) {
            hashMap.put("REQUEST_DISCOVERY_DETAILS", hashtable);
        }
        if (hashMap != null && hashMap.size() <= 0 && !ContainerDiscovery.isThisDockerContainer()) {
            hashMap.put("DO_HTTP_REQ", hashtable2);
        }
        return hashMap;
    }

    public static void offLoadAgentCheck(String string) {
        if (BTMOffLoadConfig.isThisOffloadAgent()) {
            return;
        }
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        String string2 = "eG_BTM_OffLoad_Port_Finder";
        OffLoadAgentInfiniteCheck offLoadAgentInfiniteCheck = OffLoadAgentInfiniteCheck.getInstance();
        if (offLoadAgentInfiniteCheck.getCheckStatus() == STATUS.NONE) {
            offLoadAgentInfiniteCheck.setCheckStatus(STATUS.OFFLOAD);
            BTMOffLoadConfig.setFlagToSendOffloadData(false);
            BTMOffLoadConfig.resetNodeIDValidatedWithAgent();
            BTMOffLoadConfig.resetThisOffloadAgent();
            Thread thread = new Thread(offLoadAgentInfiniteCheck);
            thread.setDaemon(true);
            thread.setName(string2);
            thread.start();
            BTMLog.logger.warn("Started the thread {} by {} , to find OffLoad BTM Port !!! ", (Object)string2, (Object)string);
        }
        lock.unlock();
    }

    private void offloadDiscoveryCheck() {
        try {
            if (OffLoadAgentInfiniteCheck.getInstance().getCheckStatus().isStatusNone() && OffLoadAgentCheck.getInstance().getCheckStatus().isStatusNone()) {
                OffLoadAgentInfiniteCheck offLoadAgentInfiniteCheck = OffLoadAgentInfiniteCheck.getInstance();
                offLoadAgentInfiniteCheck.setCheckStatus(STATUS.DISCOVERY);
                BTMOffLoadConfig.resetValidComponentIDAssigned();
                BTMOffLoadConfig.resetThisComponentManaged();
                BTMOffLoadConfig.setAckReceivedForDiscovery(false);
                Thread thread = new Thread(offLoadAgentInfiniteCheck);
                thread.setDaemon(true);
                thread.setName("Discovery_Offload_Agent_Checker");
                thread.start();
                BTMLog.logger.warn("Discovery: Infinite Offload Agent Checker started For Component ID fetching and validation");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HashMap extractDiscoveryDetails(Map map, String string) {
        HashMap<String, Hashtable> hashMap = new HashMap<String, Hashtable>();
        try {
            if (map.containsKey("CONTAINER_NAME")) {
                Hashtable hashtable = ContainerDiscovery.getDiscoveredDetailsByRequest();
                if (hashtable != null && hashtable.containsKey("DISCOVERED")) {
                    hashMap.put("REQUEST_DISCOVERY_DETAILS", hashtable);
                }
                BTMLog.logger.trace(" {} Discovery details found on http request - {}", (Object)string, (Object)hashMap);
                if (!BTMOffLoadConfig.isMemoryCopyOnly()) {
                    PropsManager.writeDiscoveryProps(new Hashtable(hashMap));
                }
            }
            BTMLog.logger.info("{} OffLoadAgentInfiniteCheck.getInstance().getCheckStatus(): {}", (Object)string, (Object)OffLoadAgentInfiniteCheck.getInstance().getCheckStatus());
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Exception occurred while extracting discovery details from rootprops object: ", (Object)string, (Object)exception);
        }
        return hashMap;
    }

    private boolean dataReceiver(BTMSocket bTMSocket, ObjectInputStream objectInputStream, String string) {
        boolean bl = false;
        if (objectInputStream == null) {
            BTMOffLoadConfig.resetThisOffloadAgent();
            BTMLog.logger.debug("eG Agent OffLoad port is reachable but no response");
            return bl;
        }
        BTMLog.logger.debug("{} Trying to get message from eG Agent ", (Object)string);
        try {
            Object object = objectInputStream.readObject();
            BTMLog.logger.info("{} Got data from eG Agent : {}, JVM GUID : {}", string, object.toString(), PropsManager.getJvmGUID());
            if (object instanceof String) {
                String string2 = (String)object;
                return BTMOffLoadConfig.validateMessage(string2, bTMSocket, BTMOffLoadConfig.getCollectorAgentPortNo(), string);
            }
            if (object instanceof ArrayList) {
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList arrayList = (ArrayList)object;
                for (int i = 0; i < arrayList.size(); ++i) {
                    CharSequence charSequence;
                    Object object2;
                    Object e = arrayList.get(i);
                    if (e == null) continue;
                    if (e instanceof HashMap) {
                        String string3;
                        CharSequence charSequence2;
                        CharSequence charSequence3;
                        object2 = (HashMap)e;
                        if (((HashMap)object2).size() <= 0) continue;
                        charSequence = (String)((HashMap)object2).get("Entity");
                        if (charSequence != null) {
                            charSequence3 = this.updateEntityConfig((String)charSequence, (HashMap)object2);
                            stringBuilder.append(charSequence3);
                            bl = true;
                            PropsManager.setRequestConfigFromAgent(false);
                            continue;
                        }
                        charSequence3 = (String)((HashMap)object2).remove("Threshold");
                        if (charSequence3 != null) {
                            charSequence2 = this.updateThresholdDetails((String)charSequence3, (HashMap)object2);
                            stringBuilder.append(charSequence2);
                            bl = true;
                            continue;
                        }
                        charSequence2 = (String)((HashMap)object2).remove("JVMTestsInfo");
                        if (charSequence2 != null) {
                            BTMOffLoadConfig.writeOffloadConfigProps((HashMap)object2);
                            stringBuilder.append(OFFLOAD_CONFIG_OK).append("!;-;!");
                            PropsManager.setRequestConfigFromAgent(false);
                            bl = true;
                        }
                        if ((string3 = (String)((HashMap)object2).remove("cpcInfo")) == null) continue;
                        BTMOffLoadConfig.writeOffloadCpcProps((HashMap)object2);
                        stringBuilder.append(OFFLOAD_CPC_CONFIG_OK).append("!;-;!");
                        bl = true;
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    object2 = (String)e;
                    if (stringBuilder.length() > 0) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("ACK4BTM_").append("!;-;!");
                        ((StringBuilder)charSequence).append(PropsManager.getJvmGUID()).append("!;-;!");
                        ((StringBuilder)charSequence).append((CharSequence)stringBuilder);
                        this.myQueue.enqueue(((StringBuilder)charSequence).toString());
                    }
                    return BTMOffLoadConfig.validateMessage((String)object2, bTMSocket, BTMOffLoadConfig.getCollectorAgentPortNo(), string);
                }
            }
        }
        catch (EOFException eOFException) {
            BTMLog.logger.debug(" EOFException while reading data from BTM Agent.");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            BTMLog.logger.debug(" Read Timed out while reading data from BTM clients.");
        }
        catch (IOException iOException) {
            Worker.closeClientSocket(bTMSocket);
            BTMLog.logger.error(" IO error while reading data from BTM clients. {} ", iOException);
        }
        catch (Exception exception) {
            Worker.closeClientSocket(bTMSocket);
            BTMLog.logger.error(" Error while reading data from BTM clients.{} ", exception);
        }
        return bl;
    }

    private StringBuilder updateThresholdDetails(String string, HashMap hashMap) {
        PropsManager.writeThresholdProps(hashMap);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = threshMap.get(string);
        stringBuilder.append(string2).append("!;-;!");
        return stringBuilder;
    }

    private StringBuilder updateEntityConfig(String string, HashMap hashMap) {
        ArrayList arrayList = (ArrayList)hashMap.get("PropsValuesByOrder");
        HashMap hashMap2 = (HashMap)hashMap.get("ModifiedPropsTable");
        BTMLog.logger.debug("Updating config for the entity : {} Properties : {} Values : {}", string, arrayList, hashMap2);
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList != null && arrayList.size() > 0) {
            PropsManager.handlePropChangesFromTest(arrayList, string);
        }
        if (hashMap2 != null && hashMap2.size() > 0) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string2 = (String)hashMap2.get("APPLICATION_NAME");
            String string3 = (String)hashMap2.get("TIER_NAME");
            try {
                if (string2 != null && string2.length() > 0) {
                    if (string2.equals("MyTier") && !BTMOffLoadConfig.getApplicationName().equals("MyApp")) {
                        bl = true;
                    } else if (!string2.equals("MyApp")) {
                        bl = true;
                    }
                } else {
                    string2 = "none";
                }
                if (string3 != null && string3.length() > 0) {
                    if (string3.equalsIgnoreCase("MyTier") && !BTMOffLoadConfig.getTierName().equalsIgnoreCase("MyTier")) {
                        bl3 = true;
                    } else if (!string3.equalsIgnoreCase("MyTier")) {
                        bl3 = true;
                    }
                } else {
                    string3 = "none";
                }
                if (BTMOffLoadConfig.getApplicationName().equals(string2) || BTMOffLoadConfig.getTierName().equals(string3)) {
                    hashMap2.put("AUTO_NAMING", "true");
                }
            }
            catch (Exception exception) {
                BTMLog.logger.debug(" Unable to process App&Tier data from BTM Agent. {} ", exception);
            }
            if (!BTMOffLoadConfig.isAutoNamingEnabled()) {
                hashMap2.remove("APPLICATION_NAME");
                hashMap2.remove("TIER_NAME");
            } else {
                if (bl) {
                    BTMOffLoadConfig.assignApplicationName(string2);
                    bl2 = true;
                }
                if (bl3) {
                    BTMOffLoadConfig.assignTierName(string3);
                    bl4 = true;
                }
                if (bl2) {
                    stringBuilder.append("APP_RENAME_OK").append("!;-;!");
                }
                if (bl4) {
                    stringBuilder.append("TIER_RENAME_OK").append("!;-;!");
                }
            }
        }
        if (hashMap2 != null && hashMap2.size() > 0) {
            BTMOffLoadConfig.writeOffloadConfigProps(hashMap2);
        }
        String string4 = propsMap.get(string);
        stringBuilder.append(string4).append("!;-;!");
        return stringBuilder;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            BTMLog.logger.error(" Exception in Sleep method due to {}", exception);
        }
    }

    private static void closeClientSocket(Socket socket) {
        if (socket != null) {
            try {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        propsMap.put("BusinessTransTest", "BTM_PROPS_OK");
        propsMap.put("KBusinessTransTest", "KBTM_PROPS_OK");
        threshMap.put("BusinessTransTest", "BTM_THRESH_OK");
        threshMap.put("KBusinessTransTest", "KBTM_THRESH_OK");
        lock = new ReentrantLock();
    }
}

