/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.discovery;

import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.discovery.GlassFishDiscovery;
import com.eg.jtm.discovery.JbossDiscovery;
import com.eg.jtm.discovery.LibertyDiscovery;
import com.eg.jtm.discovery.ServerList;
import com.eg.jtm.discovery.TomcatDiscovery;
import com.eg.jtm.discovery.WeblogicDiscovery;
import com.eg.jtm.discovery.WebsphereDiscovery;
import com.eg.jtm.discovery.WildFlyDiscovery;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class AutoDiscovery {
    private static String serverName = null;
    private static String serverNameWithVersion = null;
    private static String serverIP = null;
    private static String serverScheme = null;
    private static String httpServerPort = null;
    private static String httpsServerPort = null;
    private static String managmentHttpServerPort = null;
    private static String managmentHttpsServerPort = null;
    private static String jmxPort = null;
    private static boolean isContainerNameFound = false;
    private static final String JAVAX_MANAGEMENT_BUILDER_INITIAL = "javax.management.builder.initial";
    private static MBeanServerConnection mServerConnection = null;
    private static boolean isClassNameDiscoveryCompleted = false;

    private AutoDiscovery() {
    }

    public static void collectOtherServerDetails(String string) {
        ServerList serverList = (ServerList)PropsManager.autoDiscoveryEnumMappings.get(string);
        switch (serverList) {
            case TOMCAT: {
                TomcatDiscovery tomcatDiscovery = new TomcatDiscovery();
                tomcatDiscovery.start();
                break;
            }
            case JBOSS: {
                JbossDiscovery jbossDiscovery = new JbossDiscovery();
                jbossDiscovery.start();
                break;
            }
            case WEBLOGIC: {
                WeblogicDiscovery weblogicDiscovery = new WeblogicDiscovery();
                weblogicDiscovery.start();
                break;
            }
            case WEBSPHERE: {
                WebsphereDiscovery websphereDiscovery = new WebsphereDiscovery();
                websphereDiscovery.start();
                break;
            }
            case WILDFLY: {
                WildFlyDiscovery wildFlyDiscovery = new WildFlyDiscovery();
                wildFlyDiscovery.start();
                break;
            }
            case GLASSFISH: {
                GlassFishDiscovery glassFishDiscovery = new GlassFishDiscovery();
                glassFishDiscovery.start();
                break;
            }
            case LIBERTY: {
                LibertyDiscovery libertyDiscovery = new LibertyDiscovery();
                libertyDiscovery.start();
                break;
            }
            default: {
                AutoDiscovery.setServerName("Java_virtual_machine");
            }
        }
    }

    public static boolean isPlatFormMbeanInitilized() {
        if ((System.getProperty(JAVAX_MANAGEMENT_BUILDER_INITIAL) != null || ManagementFactory.getRuntimeMXBean().getUptime() > 20000L) && (mServerConnection = ManagementFactory.getPlatformMBeanServer()) != null) {
            AutoDiscovery.setmServerConnection(mServerConnection);
            return true;
        }
        return false;
    }

    public static Object isAttributeAvailable(String string, ObjectName objectName, String string2) {
        Object object = null;
        try {
            object = AutoDiscovery.getmServerConnection().getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("unable to locate attribute Name [{}] in available server Mbean list : {} ", (Object)string2, (Object)string);
        }
        return object;
    }

    public static boolean isSystemPropertyKeyAvailable(String string) {
        return System.getProperty(string) != null;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static String getHttpServerPort() {
        return httpServerPort;
    }

    public static void setServerIP(String string) {
        serverIP = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] Server IP : " + AutoDiscovery.getServerIP());
    }

    public static void setHttpServerPort(String string) {
        httpServerPort = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] Server Port : " + AutoDiscovery.getHttpServerPort());
    }

    public static boolean isServerNameFound() {
        return isContainerNameFound;
    }

    public static void setServerNameFound(boolean bl) {
        isContainerNameFound = bl;
    }

    public static String getServerName() {
        return serverName;
    }

    public static void setServerName(String string) {
        serverName = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] Server Name : " + AutoDiscovery.getServerName());
    }

    public static MBeanServerConnection getmServerConnection() {
        return mServerConnection;
    }

    public static void setmServerConnection(MBeanServerConnection mBeanServerConnection) {
        mServerConnection = mBeanServerConnection;
    }

    public static String getServerScheme() {
        return serverScheme;
    }

    public static void setServerScheme(String string) {
        serverScheme = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] Server Scheme Type : " + AutoDiscovery.getServerScheme());
    }

    public static String getServerNameWithVersion() {
        return serverNameWithVersion;
    }

    public static void setServerNameWithVersion(String string) {
        serverNameWithVersion = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] Server Name-Version : " + AutoDiscovery.getServerNameWithVersion());
    }

    public static String getHttpsServerPort() {
        return httpsServerPort;
    }

    public static String getManagmentHttpServerPort() {
        return managmentHttpServerPort;
    }

    public static String getManagmentHttpsServerPort() {
        return managmentHttpsServerPort;
    }

    public static void setHttpsServerPort(String string) {
        httpsServerPort = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery] HTTPS Server Port : " + AutoDiscovery.getHttpsServerPort());
    }

    public static void setManagmentHttpServerPort(String string) {
        managmentHttpServerPort = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery]  Managment HTTP Server Port : " + AutoDiscovery.getManagmentHttpServerPort());
    }

    public static void setManagmentHttpsServerPort(String string) {
        managmentHttpsServerPort = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery]  Managment HTTPS Server Port : " + AutoDiscovery.getManagmentHttpsServerPort());
    }

    public static String getJmxPort() {
        return jmxPort;
    }

    public static void setJmxPort(String string) {
        jmxPort = string;
        BTMLog.logger.warn("INFO:- [Server Type Discovery]  Java Management Extensions (JMX) Port : " + AutoDiscovery.getJmxPort());
    }

    public static void setStausOfClassNameDiscovery(boolean bl) {
        isClassNameDiscoveryCompleted = bl;
        if (bl) {
            BTMLog.logger.warn("INFO:- isClassNameDiscoveryCompleted : true");
        }
    }

    public static boolean isClassNameDiscoveryCompleted() {
        return isClassNameDiscoveryCompleted;
    }

    public static void waitTime(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            BTMLog.logger.error("exception while trying to sleep using Thread.sleep method");
        }
    }
}

