/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.discovery;

import com.eg.jtm.BTMLog;
import com.eg.jtm.discovery.AutoDiscovery;
import com.eg.jtm.discovery.DiscoveryBase;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GlassFishDiscovery
extends DiscoveryBase {
    public void run() {
        super.run();
    }

    protected void getOtherDetailsUsingMBeanServer() {
        try {
            MBeanServerConnection mBeanServerConnection = AutoDiscovery.getmServerConnection();
            boolean bl = this.isDomainAvailable(mBeanServerConnection);
            if (!bl) {
                try {
                    mBeanServerConnection.invoke(new ObjectName("amx-support:type=boot-amx"), "bootAMX", new Object[0], new String[0]);
                    bl = this.isDomainAvailable(mBeanServerConnection);
                }
                catch (Exception exception) {
                    BTMLog.logger.error("exception while invkoing bootAMX mbean to load domain in GlassFish Server {} ", exception);
                }
            }
            if (bl) {
                String string;
                ObjectName objectName = new ObjectName("amx:pp=,type=domain-root");
                ObjectName objectName2 = new ObjectName("amx:pp=/domain/configs/config[server-config]/network-config/network-listeners,type=network-listener,name=admin-listener");
                ObjectName objectName3 = new ObjectName("amx:pp=/domain/configs/config[server-config]/network-config/network-listeners,type=network-listener,name=http-listener-1");
                ObjectName objectName4 = new ObjectName("amx:pp=/domain/configs/config[server-config]/network-config/network-listeners,type=network-listener,name=http-listener-2");
                ObjectName objectName5 = new ObjectName("amx:pp=/domain/configs/config[server-config]/admin-service,type=jmx-connector,name=system");
                Object object = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName, "ApplicationServerFullVersion");
                if (object != null) {
                    AutoDiscovery.setServerNameWithVersion(object.toString());
                }
                Object object2 = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName2, "Address");
                Object object3 = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName2, "Port");
                Object object4 = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName3, "Port");
                Object object5 = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName4, "Port");
                Object object6 = AutoDiscovery.isAttributeAvailable("[GlassFish Server]", objectName5, "Port");
                String string2 = object2 != null ? object2.toString() : "-";
                String string3 = object3 != null ? object3.toString() : "-";
                String string4 = object4 != null ? object4.toString() : "-";
                String string5 = object5 != null ? object5.toString() : "-";
                String string6 = string = object6 != null ? object6.toString() : "-";
                if (!string2.equals("-")) {
                    AutoDiscovery.setServerIP(string2);
                }
                AutoDiscovery.setManagmentHttpServerPort(string3);
                AutoDiscovery.setHttpServerPort(string4);
                AutoDiscovery.setHttpsServerPort(string5);
                AutoDiscovery.setJmxPort(string);
            } else {
                BTMLog.logger.error("domain AMX is not available at this point for GlassFish Server");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("exception while checking Platform MBean Server and Platform MXBeans GlassFish {} ", exception);
        }
    }

    private boolean isDomainAvailable(MBeanServerConnection mBeanServerConnection) {
        boolean bl = false;
        try {
            String[] stringArray = mBeanServerConnection.getDomains();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("amx")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("amx-support")) {
                    AutoDiscovery.setServerName("GlassFish_server");
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("boot-amx")) continue;
                AutoDiscovery.setServerName("GlassFish_server");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("exception while checking domain name availability in GlassFish server {} ", exception);
        }
        return bl;
    }

    protected boolean validateUsingSystemProperty() {
        if (AutoDiscovery.isSystemPropertyKeyAvailable("org.glassfish.additionalOSGiBundlesToStart") || AutoDiscovery.isSystemPropertyKeyAvailable("felix.fileinstall.dir") || AutoDiscovery.isSystemPropertyKeyAvailable("felix.fileinstall.dir")) {
            String string = System.getProperty("sun.java.command");
            if (string.indexOf("com.sun.enterprise.glassfish.bootstrap.ASMain") > -1 || string.indexOf("com.sun.enterprise.admin.cli.AdminMain") > -1) {
                AutoDiscovery.setServerName("GlassFish_server");
            }
            return true;
        }
        return false;
    }
}

