/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jvmmonitor.JVMMetric;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;

public class JVMFileDescriptorInfo
extends JVMMetric {
    private static final long serialVersionUID = 1L;

    public ArrayList pollMeasures() {
        ArrayList arrayList = new ArrayList();
        MBeanServerConnection mBeanServerConnection = JVMUtils.getMbeanServerConnection();
        if (mBeanServerConnection == null) {
            return arrayList;
        }
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            AttributeList attributeList = mBeanServerConnection.getAttributes(JVMUtils.getOperatingSystemMXBeanObjectName(), new String[]{"OpenFileDescriptorCount", "MaxFileDescriptorCount"});
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                hashtable.put(attribute.getName(), attribute.getValue());
            }
            arrayList.add(hashtable);
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMFileDescriptorInfo] - Exception occured. " + exception.getMessage());
        }
        return arrayList;
    }
}

