/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jvmmonitor.JVMMetric;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JVMMemoryPoolInfo
extends JVMMetric {
    private static final long serialVersionUID = 1L;

    public ArrayList pollMeasures() {
        MBeanServerConnection mBeanServerConnection = JVMUtils.getMbeanServerConnection();
        ArrayList arrayList = new ArrayList();
        if (mBeanServerConnection == null) {
            return arrayList;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Set<ObjectName> set = mBeanServerConnection.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null);
            for (ObjectName objectName : set) {
                ObjectName objectName2 = objectName;
                MemoryPoolMXBean memoryPoolMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName2.toString(), MemoryPoolMXBean.class);
                if (memoryPoolMXBean == null) continue;
                String string = memoryPoolMXBean.getName();
                String string2 = memoryPoolMXBean.getType().toString();
                String[] stringArray = memoryPoolMXBean.getMemoryManagerNames();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + ",");
                }
                String string3 = stringBuffer.toString();
                if (string3.endsWith(",")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                hashtable.put(string, string2 + "#" + string3);
            }
            arrayList.add(hashtable);
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMMemoryPoolInfo] - Exception occured. " + exception.getMessage());
        }
        return arrayList;
    }
}

