/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.time;

import java.util.Date;
import java.util.TimeZone;

class GmtTimeZone
extends TimeZone {
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    static final long serialVersionUID = 1L;
    private final int offset;
    private final String zoneId;

    GmtTimeZone(boolean bl, int n, int n2) {
        if (n >= 24) {
            throw new IllegalArgumentException(n + " hours out of range");
        }
        if (n2 >= 60) {
            throw new IllegalArgumentException(n2 + " minutes out of range");
        }
        int n3 = (n2 + n * 60) * 60000;
        this.offset = bl ? -n3 : n3;
        this.zoneId = GmtTimeZone.twoDigits(GmtTimeZone.twoDigits(new StringBuilder(9).append("GMT").append(bl ? (char)'-' : '+'), n).append(':'), n2).toString();
    }

    private static StringBuilder twoDigits(StringBuilder stringBuilder, int n) {
        return stringBuilder.append((char)(48 + n / 10)).append((char)(48 + n % 10));
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.offset;
    }

    public void setRawOffset(int n) {
        throw new UnsupportedOperationException();
    }

    public int getRawOffset() {
        return this.offset;
    }

    public String getID() {
        return this.zoneId;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public boolean inDaylightTime(Date date) {
        return false;
    }

    public String toString() {
        return "[GmtTimeZone id=\"" + this.zoneId + "\",offset=" + this.offset + ']';
    }

    public int hashCode() {
        return this.offset;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GmtTimeZone)) {
            return false;
        }
        return this.zoneId == ((GmtTimeZone)object).zoneId;
    }
}

