/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree;

import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.tree.AbstractInsnNode;
import com.eg.org.objectweb.asm.tree.LabelNode;
import com.eg.org.objectweb.asm.tree.Util;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode labelNode, int[] nArray, LabelNode[] labelNodeArray) {
        super(171);
        this.dflt = labelNode;
        this.keys = Util.asArrayList(nArray);
        this.labels = Util.asArrayList(labelNodeArray);
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        int[] nArray = new int[this.keys.size()];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.keys.get(i);
        }
        Label[] labelArray = new Label[this.labels.size()];
        int n2 = labelArray.length;
        for (n = 0; n < n2; ++n) {
            labelArray[n] = this.labels.get(n).getLabel();
        }
        methodVisitor.visitLookupSwitchInsn(this.dflt.getLabel(), nArray, labelArray);
        this.acceptAnnotations(methodVisitor);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        LookupSwitchInsnNode lookupSwitchInsnNode = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, map), null, LookupSwitchInsnNode.clone(this.labels, map));
        lookupSwitchInsnNode.keys.addAll(this.keys);
        return lookupSwitchInsnNode.cloneAnnotations(this);
    }
}

