/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;

public class DominoMailServerHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private BufferedReader br;
    public int timeOut;
    public boolean status;
    public boolean done;
    public boolean isDominoMailServer = false;

    public DominoMailServerHelperThread(String string, int n, int n2) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = n2;
        this.setName("DominoMailServerHelperThread");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        try {
            this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
            String string = null;
            if (this.br != null) {
                string = this.br.readLine();
            }
            if (string != null && string.indexOf("ESMTP") >= 0 && string.indexOf("Lotus Domino") >= 0) {
                this.isDominoMailServer = true;
            }
            this.done = true;
            this.cleanup();
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

