/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDiscInfo;
import com.eg.EgTestInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class EgAgentTopoInfo {
    private IniFile topoFilePtr;
    private String topoFileName;
    private String entity;
    private File topoFile;
    private boolean isManager = false;
    private static String webSiteMappingSection = "WEB_SITE_MAPPING";
    private static String webSiteTransactionSection = "TRANSACTIONS";
    private static String physTopoSection = "PHYSICAL_TOPOLOGY";
    private static String logicalTopoSection = "LOGICAL_TOPOLOGY";
    private static String webSiteAliasSection = "SITE_ALIAS";
    private static String ejbGroups = "EJB_GROUPS";
    private static String TestGroups = "TEST_GROUPS";
    private static String svcSection = "SERVICE";
    private static String groupRelationship = "GROUP_RELATIONSHIP";
    private static String aggregateSiteMapping = "AGG_SITE_MAP";
    public long lastModifiedTime;
    public long lastSize;
    public int maxWebSites = -1;
    private Hashtable compSegmentMap = new Hashtable();
    private Hashtable segmentCompMap = new Hashtable();
    private Hashtable compSiteMap = new Hashtable();
    private Hashtable siteCompMap = new Hashtable();
    private Class EgCrawler = null;
    private Constructor ctor = null;
    EgDiscInfo discinfo = null;

    public EgAgentTopoInfo(String string) {
        this.entity = string;
        this.isManager = !string.equals("agent");
        this.topoFileName = !this.isManager ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egTopologyConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTopologyConfigFile);
        this.topoFile = new File(this.topoFileName);
        this.lastModifiedTime = IniFile.getLastModified(this.topoFileName);
        this.lastSize = IniFile.getLastSize(this.topoFileName);
        this.topoFilePtr = new IniFile(this.topoFileName);
        this.compSegmentMap = new Hashtable();
        this.compSiteMap = new Hashtable();
        this.siteCompMap = new Hashtable();
        this.segmentCompMap = new Hashtable();
        if (this.isManager) {
            this.discinfo = new EgDiscInfo("manager");
            this.initCrawler();
        }
    }

    private void initCrawler() {
        try {
            this.EgCrawler = Class.forName("egurkha.EgCrawler");
            Class[] classArray = new Class[]{Class.forName("com.eg.IniFile"), Class.forName("java.lang.Boolean")};
            this.ctor = this.EgCrawler.getConstructor(classArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.EgCrawler = null;
        }
    }

    public EgAgentTopoInfo(String string, boolean bl) {
        this.isManager = !string.equals("agent");
        this.topoFileName = !this.isManager ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egTopologyConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTopologyConfigFile);
        this.topoFile = new File(this.topoFileName);
        this.lastModifiedTime = IniFile.getLastModified(this.topoFileName);
        this.lastSize = IniFile.getLastSize(this.topoFileName);
        this.topoFilePtr = new IniFile(this.topoFileName, bl);
        this.compSegmentMap = new Hashtable();
        this.compSiteMap = new Hashtable();
        this.siteCompMap = new Hashtable();
        this.segmentCompMap = new Hashtable();
        if (this.isManager) {
            this.initCrawler();
        }
    }

    public String getValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = this.topoFilePtr.getValue(string, string2);
        return string3;
    }

    public String[] getVariables(String string) {
        this.checkForUpdate();
        return this.topoFilePtr.getVariables(string);
    }

    public ArrayList getAgentSections() {
        ArrayList arrayList = this.getEntriesFor(webSiteMappingSection);
        ArrayList arrayList2 = this.getEntriesFor(webSiteTransactionSection);
        arrayList = this.merge(arrayList, arrayList2);
        arrayList2 = this.getEntriesFor(webSiteAliasSection);
        arrayList = this.merge(arrayList, arrayList2);
        arrayList2 = this.getEntriesFor(ejbGroups);
        arrayList = this.merge(arrayList, arrayList2);
        arrayList2 = this.getEntriesFor(TestGroups);
        arrayList = this.merge(arrayList, arrayList2);
        arrayList2 = this.getEntriesFor(groupRelationship);
        arrayList = this.merge(arrayList, arrayList2);
        return arrayList;
    }

    private ArrayList merge(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList2 == null) {
            return arrayList;
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)arrayList2.get(i));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getEntriesFor(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray = new StringBuffer(100);
        synchronized (stringArray) {
            stringArray.append("[");
            stringArray.append(string);
            stringArray.append("]");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            arrayList.add(stringArray.toString());
            stringArray2 = this.topoFilePtr.getVariables(string);
            Vector vector = this.topoFilePtr.getAllValues(string);
            if (stringArray2 == null || vector == null) {
                return arrayList;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                StringBuffer stringBuffer;
                String string2 = null;
                try {
                    string2 = (String)vector.get(i);
                }
                catch (Exception exception) {
                    continue;
                }
                if (string2 == null) continue;
                StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(512);
                synchronized (stringBuffer2) {
                    stringBuffer.append(stringArray2[i]);
                    stringBuffer.append("=");
                    stringBuffer.append(string2);
                }
                arrayList.add(stringBuffer.toString());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEjbGroups(String string, String string2) {
        String[] stringArray = this.topoFilePtr.getVariables(ejbGroups);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = null;
        String string4 = null;
        int n = 0;
        String string5 = string + string2 + '#';
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf(58);
            if (n < 0) continue;
            string3 = stringArray[i].substring(0, n);
            string4 = stringArray[i].substring(n + 1);
            if ((n = string4.indexOf(58)) < 0 || (n = (string4 = string4.substring(n + 1)).indexOf(35)) < 0 || !(string3 = string3 + string4).startsWith(string5) || (n = (string4 = string4.substring(n + 1)).indexOf(58)) < 0) continue;
            String string6 = string4.substring(0, n);
            String string7 = string4.substring(n + 1);
            String string8 = (String)hashtable.get(string6);
            if (string8 != null) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(512);
                synchronized (stringBuffer2) {
                    stringBuffer.append(string8);
                    stringBuffer.append(",");
                    stringBuffer.append(string7);
                }
                hashtable.put(string6, stringBuffer.toString());
                continue;
            }
            if (string7 == null) continue;
            hashtable.put(string6, string7);
        }
        return hashtable;
    }

    public ArrayList getEjbGroupNames(String string, String string2) {
        Hashtable hashtable = this.getEjbGroups(string, string2);
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return arrayList;
    }

    public boolean doesGroupExist(String string, String string2, String string3) {
        ArrayList arrayList = this.getEjbGroupNames(string, string2);
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        return arrayList.indexOf(string3) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjbGroup(String string, String string2, String string3, String string4, String string5) {
        Object object;
        EgTestInfo egTestInfo = new EgTestInfo(true);
        ArrayList arrayList = egTestInfo.getTestInfo(string, string2);
        if (arrayList != null && arrayList.indexOf(string4) >= 0) {
            StringBuffer stringBuffer;
            object = "";
            String string6 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                string6 = (String)arrayList.get(i);
                if (string6.equals(string4)) continue;
                object = (String)object + string6 + ",";
            }
            if (((String)object).length() != 0) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(256);
            synchronized (stringBuffer2) {
                stringBuffer.append(string3);
                stringBuffer.append(":");
                stringBuffer.append(string2);
            }
            egTestInfo.setTestInfo(stringBuffer.toString(), string, (String)object);
        }
        if ((object = this.tokenizeInfo(string5)) == null || ((ArrayList)object).size() == 0) {
            return;
        }
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            this.topoFilePtr.setValue(ejbGroups, string + "::" + string2 + '#' + string4 + ':' + (String)((ArrayList)object).get(i), "managed");
        }
        this.topoFilePtr.saveFile();
    }

    public void deleteEjbGroup(String string, String string2, String string3, String string4) {
        String[] stringArray = this.topoFilePtr.getVariables(ejbGroups);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n = 0;
        String string9 = string + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf(35);
            if (n < 0) continue;
            string5 = stringArray[i].substring(0, n);
            string8 = stringArray[i].substring(n + 1);
            n = string5.indexOf(58);
            if (n < 0) continue;
            string6 = string5.substring(0, n);
            string7 = string5.substring(n + 1);
            if ((n = string7.indexOf(58)) < 0) continue;
            string7 = string7.substring(n + 1);
            if (!(string6 + string7).equals(string9) || (n = string8.indexOf(58)) < 0 || !(string8 = string8.substring(0, n)).equals(string4)) continue;
            this.topoFilePtr.deleteValue(ejbGroups, stringArray[i]);
        }
        this.topoFilePtr.saveFile();
        EgTestInfo egTestInfo = new EgTestInfo(true);
        ArrayList arrayList = egTestInfo.getTestInfo(string, string2);
        if (arrayList == null || arrayList.size() == 0) {
            egTestInfo.setTestInfo(string3 + ":" + string2, string, string4);
        } else {
            string5 = "";
            String string10 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                string10 = (String)arrayList.get(i);
                string5 = string5 + string10 + ",";
            }
            string5 = string5 + string4;
            egTestInfo.setTestInfo(string3 + ":" + string2, string, string5);
        }
    }

    private ArrayList tokenizeInfo(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 1) {
            return arrayList;
        }
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (arrayList.indexOf(string2) >= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void release() {
        this.topoFilePtr = null;
    }

    public long lastModified() {
        if (!this.isManager) {
            return this.topoFile.lastModified();
        }
        return IniFile.getLastModified(this.topoFileName);
    }

    public long lastSize() {
        if (!this.isManager) {
            return this.topoFile.length();
        }
        return IniFile.getLastSize(this.topoFileName);
    }

    public synchronized boolean checkForUpdate() {
        long l = IniFile.getLastModified(this.topoFileName);
        long l2 = IniFile.getLastSize(this.topoFileName);
        if (l == this.lastModifiedTime && l2 == this.lastSize) {
            return false;
        }
        this.topoFile = new File(this.topoFileName);
        this.lastModifiedTime = IniFile.getLastModified(this.topoFileName);
        this.lastSize = IniFile.getLastSize(this.topoFileName);
        this.topoFilePtr = new IniFile(this.topoFileName);
        this.compSegmentMap = new Hashtable();
        this.compSiteMap = new Hashtable();
        this.siteCompMap = new Hashtable();
        this.segmentCompMap = new Hashtable();
        return true;
    }

    public String[] getWebSites(boolean bl) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if (bl) {
            return this.topoFilePtr.getVariables(webSiteMappingSection);
        }
        return this.getWebSites();
    }

    public String getDirection(String string) {
        return "N";
    }

    public String[] getWebSites() {
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteMappingSection)).length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(58);
            if (n < 0) continue;
            stringArray2[i] = stringArray[i].substring(n + 1);
        }
        return stringArray2;
    }

    public String[] getMappingForWebSite(String string) {
        String string2;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((string2 = this.topoFilePtr.getValue(webSiteMappingSection, "Web_site:" + string)) == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public String[] getWebSitesForServer(String string) {
        int n;
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteMappingSection)).length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf(58);
            if (n < 0) continue;
            stringArray2[i] = stringArray[i].substring(n + 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray2.length; ++n) {
            String string2 = this.topoFilePtr.getValue(webSiteMappingSection, "Web_site:" + stringArray2[n]);
            if (string2 == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken().trim();
                int n2 = string3.indexOf(58);
                string3 = string3.substring(n2 + 1);
                string3.trim();
                if (!string3.equals(string)) continue;
                arrayList.add(stringArray2[n]);
            }
        }
        String[] stringArray3 = new String[arrayList.size()];
        stringArray3 = arrayList.toArray(stringArray3);
        return stringArray3;
    }

    public String[] getTransactionsForWebSite(String string) {
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteTransactionSection)).length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(58);
            if (n < 0) continue;
            stringArray2[i] = stringArray[i].substring(0, n);
            if (!stringArray2[i].equals(string)) continue;
            arrayList.add(stringArray[i].substring(n + 1));
        }
        String[] stringArray3 = new String[arrayList.size()];
        stringArray3 = arrayList.toArray(stringArray3);
        return stringArray3;
    }

    public String[] getServersUnderTransactions() {
        int n;
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteTransactionSection)).length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = stringArray[n].lastIndexOf(":");
            if (n2 < 0) continue;
            stringArray2[n] = stringArray[n].substring(0, n2);
            String[] stringArray3 = this.getServersForSite(stringArray2[n]);
            if (stringArray3 == null || stringArray3.length == 0) continue;
            for (int i = 0; i < stringArray3.length; ++i) {
                if (arrayList.indexOf(stringArray3[i]) >= 0) continue;
                arrayList.add(stringArray3[i]);
            }
        }
        n = arrayList.size();
        String[] stringArray4 = new String[n];
        stringArray4 = arrayList.toArray(stringArray4);
        return stringArray4;
    }

    public String[] getServersUnderSites() {
        Object object;
        int n;
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteMappingSection)).length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = this.topoFilePtr.getValue(webSiteMappingSection, stringArray[n]);
            if (stringArray2[n] == null || stringArray2[n].equals("")) continue;
            object = new StringTokenizer(stringArray2[n], ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                int n2 = string.indexOf(":");
                if (n2 < 0 || arrayList.indexOf(string = string.substring(n2 + 1)) >= 0) continue;
                arrayList.add(string);
            }
        }
        n = arrayList.size();
        object = new String[n];
        object = arrayList.toArray((T[])object);
        return object;
    }

    public String[] getServersForSite(String string) {
        String string2 = this.topoFilePtr.getValue(webSiteMappingSection, "Web_site:" + string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(":");
            if (n < 0) continue;
            string3 = string3.substring(n + 1);
            arrayList.add(string3);
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getPatternForTransaction(String string, String string2) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String string3 = this.topoFilePtr.getValue(webSiteTransactionSection, string + ":" + string2).trim();
        return string3;
    }

    public String[] getAllServers() {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getVariables(physTopoSection);
    }

    public String[] getDependenciesForServer(String string) {
        String string2;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((string2 = this.topoFilePtr.getValue(physTopoSection, string)) == null || string2.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public String[] getDependenciesForComponent(String string, String string2) {
        Object object;
        int n;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        ArrayList arrayList = new ArrayList();
        this.getRhsDependentsOf(string, arrayList, string2);
        String[] stringArray = this.topoFilePtr.getVariables(string2);
        Vector vector = this.topoFilePtr.getAllValues(string2);
        if (stringArray == null) {
            return null;
        }
        String string3 = string + ':';
        if (stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                object = null;
                try {
                    object = (String)vector.get(n);
                }
                catch (Exception exception) {
                    continue;
                }
                if (((String)object).indexOf(string3) < 0) continue;
                this.getLhsDependentsOf(stringArray[n], arrayList, stringArray, string2);
            }
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        object = new String[n - 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string4 = (String)arrayList.get(i);
            if (string4.equals(string)) continue;
            object[n2] = string4;
            ++n2;
        }
        return object;
    }

    public String[] getDependenciesForComponent(String string) {
        Object object;
        int n;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        ArrayList arrayList = new ArrayList();
        this.getRhsDependentsOf(string, arrayList);
        String[] stringArray = this.topoFilePtr.getVariables(physTopoSection);
        if (stringArray == null) {
            return null;
        }
        String string2 = string + ":";
        if (stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                object = this.topoFilePtr.getValue(physTopoSection, stringArray[n]);
                if (((String)object).indexOf(string2) < 0) continue;
                this.getLhsDependentsOf(stringArray[n], arrayList, stringArray);
            }
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        object = new String[n - 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.equals(string)) continue;
            object[n2] = string3;
            ++n2;
        }
        return object;
    }

    private void getLhsDependentsOf(String string, ArrayList arrayList, String[] stringArray) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        String string2 = string + ":";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = this.topoFilePtr.getValue(physTopoSection, stringArray[i]);
            if (string3.indexOf(string2) < 0) continue;
            this.getLhsDependentsOf(stringArray[i], arrayList, stringArray);
        }
    }

    private void getLhsDependentsOf(String string, ArrayList arrayList, String[] stringArray, String string2) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        String string3 = string + ":";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = this.topoFilePtr.getValue(string2, stringArray[i]);
            if (string4.indexOf(string3) < 0) continue;
            this.getLhsDependentsOf(stringArray[i], arrayList, stringArray, string2);
        }
    }

    private void getRhsDependentsOf(String string, ArrayList arrayList) {
        String string2;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((string2 = this.topoFilePtr.getValue(physTopoSection, string)) == null) {
            return;
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        if (string2.equals("null")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = new String(stringTokenizer.nextToken().trim());
            stringArray[n] = string3.substring(0, string3.lastIndexOf(58));
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.getRhsDependentsOf(stringArray[n], arrayList);
        }
    }

    private void getRhsDependentsOf(String string, ArrayList arrayList, String string2) {
        String string3;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((string3 = this.topoFilePtr.getValue(string2, string)) == null) {
            return;
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        if (string3.equals("null")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string4 = new String(stringTokenizer.nextToken().trim());
            stringArray[n] = string4.substring(0, string4.lastIndexOf(58));
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.getRhsDependentsOf(stringArray[n], arrayList, string2);
        }
    }

    public boolean isWebSiteDependent(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String[] stringArray = this.getWebSites();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getMappingForWebSite(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Hashtable getAllLeftDependencies() {
        int n;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String[] stringArray = this.topoFilePtr.getVariables(physTopoSection);
        Vector vector = this.topoFilePtr.getAllValues(physTopoSection);
        if (stringArray == null || stringArray.length == 0 || vector == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (n = 0; n < stringArray.length; ++n) {
            StringTokenizer stringTokenizer;
            String string = null;
            try {
                string = (String)vector.get(n);
            }
            catch (Exception exception) {
                continue;
            }
            if (string == null || string.equals("") || string.equalsIgnoreCase("null") || (stringTokenizer = new StringTokenizer(string, ",")).countTokens() <= 0) continue;
            while (stringTokenizer.countTokens() > 0) {
                int n2;
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.endsWith(":L") || (n2 = string2.lastIndexOf(":")) < 0) continue;
                String string3 = string2.substring(0, n2);
                String string4 = stringArray[n] + "+" + string3;
                arrayList.add(string4);
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string5;
                    int n3;
                    String string6 = (String)arrayList.get(i);
                    if (string6.endsWith("+" + stringArray[n])) {
                        n3 = string6.indexOf(43);
                        string5 = string6.substring(0, n3);
                        arrayList.add(string5 + "+" + string3);
                        continue;
                    }
                    if (!string6.startsWith(string3 + "+")) continue;
                    n3 = string6.indexOf(43);
                    string5 = string6.substring(n3 + 1);
                    arrayList.add(stringArray[n] + "+" + string5);
                }
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((String)arrayList.get(n), new Boolean(true));
        }
        return hashtable;
    }

    public Hashtable getLeftDependencies(String string) {
        ArrayList<String> arrayList;
        Object object;
        String string2;
        Object object2;
        int n;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String[] stringArray = this.topoFilePtr.getVariables(string);
        Vector vector = this.topoFilePtr.getAllValues(string);
        if (stringArray == null || stringArray.length == 0 || vector == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        for (n = 0; n < stringArray.length; ++n) {
            StringTokenizer stringTokenizer;
            object2 = null;
            try {
                object2 = (String)vector.get(n);
            }
            catch (Exception exception) {
                continue;
            }
            if (object2 == null || ((String)object2).equals("") || ((String)object2).equalsIgnoreCase("null") || (stringTokenizer = new StringTokenizer((String)object2, ",")).countTokens() <= 0) continue;
            while (stringTokenizer.countTokens() > 0) {
                int n2;
                string2 = stringTokenizer.nextToken().trim();
                if (!string2.endsWith(":L") || (n2 = string2.lastIndexOf(":")) < 0) continue;
                object = string2.substring(0, n2);
                ArrayList<Object> arrayList3 = (ArrayList<Object>)hashtable2.get(stringArray[n]);
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<Object>();
                }
                if (!arrayList3.contains(object)) {
                    arrayList3.add(object);
                }
                hashtable2.put(stringArray[n], arrayList3);
                arrayList = (ArrayList)hashtable3.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (!arrayList.contains(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                hashtable3.put(object, arrayList);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            object2 = (ArrayList)hashtable2.get(stringArray[n]);
            if (object2 == null) continue;
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                int n3;
                string2 = (String)((ArrayList)object2).get(i);
                String string3 = stringArray[n] + '+' + string2;
                arrayList2.add(string3);
                object = (ArrayList)hashtable3.get(stringArray[n]);
                if (object != null) {
                    for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                        arrayList = (String)((ArrayList)object).get(n3);
                        arrayList2.add((String)((Object)arrayList) + '+' + string2);
                    }
                }
                if ((object = (ArrayList)hashtable2.get(string2)) == null) continue;
                for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                    arrayList = (String)((ArrayList)object).get(n3);
                    arrayList2.add(stringArray[n] + '+' + string2);
                }
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            hashtable.put((String)arrayList2.get(n), new Boolean(true));
        }
        return hashtable;
    }

    public String[] getNoncomponentsForWebSite(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String[] stringArray = this.topoFilePtr.getVariables(logicalTopoSection);
        Vector vector = this.topoFilePtr.getAllValues(logicalTopoSection);
        if (stringArray == null || stringArray.length == 0 || vector == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n = stringArray[i].indexOf(58);
            if (n < 0 || !(string2 = stringArray[i].substring(n + 1)).equals(string)) continue;
            String string3 = null;
            try {
                string3 = (String)vector.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (string3 == null || string3.equals("")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            if (stringTokenizer.countTokens() == 0) {
                return null;
            }
            String[] stringArray2 = new String[stringTokenizer.countTokens()];
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray2[j] = stringTokenizer.nextToken().trim();
                int n2 = stringArray2[j].lastIndexOf(58);
                if (n2 < 0) continue;
                stringArray2[j] = stringArray2[j].substring(0, n2);
            }
            return stringArray2;
        }
        return null;
    }

    public void logToTmpFile(String string) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string2 = egDateInfo.egetDate();
        try {
            printWriter = new PrintWriter(new FileWriter("/tmp/eg_debug", true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file /tmp/eg_debug");
            return;
        }
        String string3 = new String(string2 + " " + string);
        printWriter.println(string3);
        printWriter.close();
    }

    public String[] getAllComponents() {
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(physTopoSection)) == null) {
            return null;
        }
        return stringArray;
    }

    public String[] getSiteAlias(String string) {
        String[] stringArray;
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if ((stringArray = this.topoFilePtr.getVariables(webSiteAliasSection)) == null || stringArray.length == 0) {
            return null;
        }
        boolean bl = false;
        String string2 = "Web_site:" + string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            bl = true;
            string2 = stringArray[i];
            break;
        }
        if (!bl) {
            return null;
        }
        String string3 = this.topoFilePtr.getValue(webSiteAliasSection, string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = (String)stringTokenizer.nextElement();
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTestInfos(String string, String string2) {
        this.checkForUpdate();
        String[] stringArray = this.topoFilePtr.getVariables(TestGroups);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = null;
        String string4 = null;
        int n = 0;
        String string5 = string + string2 + "#";
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf(":");
            if (n < 0) continue;
            String string6 = string3 = stringArray[i].substring(0, n);
            string4 = stringArray[i].substring(n + 1);
            if ((n = string4.indexOf(":")) < 0 || (n = (string4 = string4.substring(n + 1)).indexOf("#")) < 0 || !(string3 = string3 + string4).startsWith(string5) && !this.doesThisGroupApplyToThisTest(string, string6) || !string4.substring(0, n).equals(string2) || (n = (string4 = string4.substring(n + 1)).indexOf(":")) < 0) continue;
            String string7 = string4.substring(0, n);
            String string8 = string4.substring(n + 1);
            String string9 = (String)hashtable.get(string7);
            if (string9 != null) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(512);
                synchronized (stringBuffer2) {
                    stringBuffer.append(string9);
                    stringBuffer.append(",");
                    stringBuffer.append(string8);
                }
                hashtable.put(string7, stringBuffer.toString());
                continue;
            }
            if (string8 == null) continue;
            hashtable.put(string7, string8);
        }
        return hashtable;
    }

    private boolean doesThisGroupApplyToThisTest(String string, String string2) {
        String string3 = this.topoFilePtr.getValue(groupRelationship, string2);
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteTestInfos(String string, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        Object object2;
        String[] stringArray = this.topoFilePtr.getVariables(TestGroups);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        int n = 0;
        String string11 = string + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf("#");
            if (n < 0) continue;
            string7 = stringArray[i].substring(0, n);
            string10 = stringArray[i].substring(n + 1);
            n = string7.indexOf(":");
            if (n < 0) continue;
            string8 = string7.substring(0, n);
            string9 = string7.substring(n + 1);
            if ((n = string9.indexOf(":")) < 0) continue;
            string9 = string9.substring(n + 1);
            if (string5 != null && string5.equalsIgnoreCase("empty")) {
                if (!(string8 + string9).equals(string11) || (n = string10.indexOf(":")) < 0 || !(string10 = string10.substring(0, n)).equals(string4)) continue;
                this.topoFilePtr.deleteValue(TestGroups, stringArray[i]);
                continue;
            }
            object2 = new StringTokenizer(string6, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (!(string8 + string9).equals((String)object + string2) && !this.doesThisGroupApplyToThisTest((String)object, string8) || (n = string10.indexOf(":")) < 0) continue;
                string10 = string10.substring(0, n);
                System.out.println("gp : " + string10 + ":" + stringArray[i]);
                if (!string10.equals(string4)) continue;
                this.topoFilePtr.deleteValue(TestGroups, stringArray[i]);
            }
        }
        this.topoFilePtr.saveFile();
        EgTestInfo egTestInfo = new EgTestInfo(true);
        object2 = new ArrayList();
        if (string5 != null && string5.equalsIgnoreCase("empty")) {
            object2 = egTestInfo.getTestInfo(string, string2);
        } else {
            object = new StringTokenizer(string6, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                object2 = egTestInfo.getTestInfo(((StringTokenizer)object).nextToken(), string2);
            }
        }
        if (object2 == null || ((ArrayList)object2).size() == 0) {
            if (string5 != null && string5.equalsIgnoreCase("empty")) {
                egTestInfo.setTestInfo(string3 + ":" + string2, string, string4);
            } else {
                object = new StringTokenizer(string6, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    egTestInfo.setTestInfo(string3 + ":" + string2, ((StringTokenizer)object).nextToken(), string4);
                }
            }
        } else {
            string7 = "";
            object = null;
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                object = (String)((ArrayList)object2).get(i);
                string7 = string7 + (String)object + ",";
            }
            string7 = string7 + string4;
            if (string5 != null && string5.equalsIgnoreCase("empty")) {
                egTestInfo.setTestInfo(string3 + ":" + string2, string, string7);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    egTestInfo.setTestInfo(string3 + ":" + string2, stringTokenizer.nextToken(), string7);
                }
            }
        }
    }

    public void deleteTestInfos(String string, Vector vector, String string2, String string3, String string4, String string5) {
        Object object;
        Object object2;
        String[] stringArray = this.topoFilePtr.getVariables(TestGroups);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (String)vector.get(i);
            String string10 = string + (String)object2;
            for (int j = 0; j < stringArray.length; ++j) {
                n = stringArray[j].indexOf("#");
                if (n < 0) continue;
                string6 = stringArray[j].substring(0, n);
                string9 = stringArray[j].substring(n + 1);
                n = string6.indexOf(":");
                if (n < 0) continue;
                string7 = string6.substring(0, n);
                string8 = string6.substring(n + 1);
                if ((n = string8.indexOf(":")) < 0) continue;
                string8 = string8.substring(n + 1);
                if (string4 != null && string4.equalsIgnoreCase("empty")) {
                    if (!(string7 + string8).equals(string10) || stringArray[j].indexOf(":" + (String)object2 + "#" + string3 + ":") <= -1) continue;
                    this.topoFilePtr.deleteValue(TestGroups, stringArray[j]);
                    continue;
                }
                object = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string11 = ((StringTokenizer)object).nextToken();
                    if (!(string7 + string8).equals(string11 + (String)object2) && !this.doesThisGroupApplyToThisTest(string11, string7) || stringArray[j].indexOf(":" + (String)object2 + "#" + string3 + ":") <= -1) continue;
                    this.topoFilePtr.deleteValue(TestGroups, stringArray[j]);
                }
            }
        }
        this.topoFilePtr.saveFile();
        ArrayList arrayList = new ArrayList();
        object2 = new EgTestInfo(true);
        ((EgTestInfo)object2).checkForUpdate();
        for (int i = 0; i < n2; ++i) {
            String string12 = (String)vector.get(i);
            if (string4 != null && string4.equalsIgnoreCase("empty")) {
                arrayList = ((EgTestInfo)object2).getTestInfo(string, string12, true);
            } else {
                object = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    arrayList = ((EgTestInfo)object2).getTestInfo(((StringTokenizer)object).nextToken(), string12, true);
                }
            }
            if (arrayList == null || arrayList.size() == 0) {
                if (string4 != null && string4.equalsIgnoreCase("empty")) {
                    ((EgTestInfo)object2).setTestInfo(string2 + ":" + string12, string, string3, true);
                    continue;
                }
                object = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((EgTestInfo)object2).setTestInfo(string2 + ":" + string12, ((StringTokenizer)object).nextToken(), string3, true);
                }
                continue;
            }
            string6 = "";
            object = null;
            for (int j = 0; j < arrayList.size(); ++j) {
                object = (String)arrayList.get(j);
                string6 = string6 + (String)object + ",";
            }
            string6 = string6 + string3;
            if (string4 != null && string4.equalsIgnoreCase("empty")) {
                ((EgTestInfo)object2).setTestInfo(string2 + ":" + string12, string, string6, true);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
            while (stringTokenizer.hasMoreTokens()) {
                ((EgTestInfo)object2).setTestInfo(string2 + ":" + string12, stringTokenizer.nextToken(), string6, true);
            }
        }
        ((EgTestInfo)object2).saveTestInfo();
    }

    public void addTestInfos(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        int n;
        int n2;
        Object object;
        EgTestInfo egTestInfo = new EgTestInfo(true);
        ArrayList arrayList = new ArrayList();
        if (string6.equalsIgnoreCase("empty")) {
            arrayList = egTestInfo.getTestInfo(string, string2);
        } else {
            object = new StringTokenizer(string7, ",");
            n2 = ((StringTokenizer)object).countTokens();
            for (n = 0; n < n2; ++n) {
                arrayList = egTestInfo.getTestInfo(((StringTokenizer)object).nextToken(), string2);
            }
        }
        if (arrayList != null && arrayList.indexOf(string4) >= 0) {
            object = "";
            String string8 = null;
            for (n = 0; n < arrayList.size(); ++n) {
                string8 = (String)arrayList.get(n);
                if (string8.equals(string4)) continue;
                object = (String)object + string8 + ",";
            }
            if (((String)object).length() != 0) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (string6.equalsIgnoreCase("empty")) {
                egTestInfo.setTestInfo(string3 + ":" + string2, string, (String)object);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                int n3 = stringTokenizer.countTokens();
                for (int i = 0; i < n3; ++i) {
                    egTestInfo.setTestInfo(string3 + ":" + string2, stringTokenizer.nextToken(), (String)object);
                }
            }
        }
        if ((object = this.tokenizeInfo(string5)) == null || ((ArrayList)object).size() == 0) {
            return;
        }
        for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
            if (string6 != null && string6.equalsIgnoreCase("empty")) {
                this.topoFilePtr.setValue(TestGroups, string + "::" + string2 + "#" + string4 + ":" + (String)((ArrayList)object).get(n2), "managed");
                continue;
            }
            this.topoFilePtr.setValue(TestGroups, string6 + "::" + string2 + "#" + string4 + ":" + (String)((ArrayList)object).get(n2), "managed");
        }
        this.topoFilePtr.saveFile();
    }

    public void addTestInfos(String string, Vector vector, String string2, String string3, String string4, String string5, String string6) {
        ArrayList arrayList = new ArrayList();
        EgTestInfo egTestInfo = new EgTestInfo(true);
        egTestInfo.checkForUpdate();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            int n2;
            Object object;
            String string7 = (String)vector.get(i);
            if (string5.equalsIgnoreCase("empty")) {
                arrayList = egTestInfo.getTestInfo(string, string7, true);
            } else {
                object = new StringTokenizer(string6, ",");
                n2 = ((StringTokenizer)object).countTokens();
                for (n = 0; n < n2; ++n) {
                    arrayList = egTestInfo.getTestInfo(((StringTokenizer)object).nextToken(), string7, true);
                }
            }
            if (arrayList != null && arrayList.indexOf(string3) >= 0) {
                object = "";
                String string8 = null;
                for (n = 0; n < arrayList.size(); ++n) {
                    string8 = (String)arrayList.get(n);
                    if (string8.equals(string3)) continue;
                    object = (String)object + string8 + ",";
                }
                if (((String)object).length() != 0) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if (string5.equalsIgnoreCase("empty")) {
                    egTestInfo.setTestInfo(string2 + ":" + string7, string, (String)object, true);
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                    int n3 = stringTokenizer.countTokens();
                    for (int j = 0; j < n3; ++j) {
                        egTestInfo.setTestInfo(string2 + ":" + string7, stringTokenizer.nextToken(), (String)object, true);
                    }
                }
            }
            if ((object = this.tokenizeInfo(string4)) == null || ((ArrayList)object).size() == 0) {
                return;
            }
            for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                if (string5 != null && string5.equalsIgnoreCase("empty")) {
                    this.topoFilePtr.setValue(TestGroups, string + "::" + string7 + "#" + string3 + ":" + (String)((ArrayList)object).get(n2), "managed");
                    continue;
                }
                this.topoFilePtr.setValue(TestGroups, string5 + "::" + string7 + "#" + string3 + ":" + (String)((ArrayList)object).get(n2), "managed");
            }
        }
        this.topoFilePtr.saveFile();
        egTestInfo.saveTestInfo();
    }

    public boolean doesInfoGroupExist(String string, String string2, String string3) {
        ArrayList arrayList = this.getEjbGroupNames(string, string2);
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        return arrayList.indexOf(string3) >= 0;
    }

    public boolean isSiteService(String string) {
        String string2 = this.topoFilePtr.getValue(svcSection, string);
        if (string2 == null || string2.equals("")) {
            return true;
        }
        return string2.equalsIgnoreCase("service");
    }

    public boolean isSiteSegment(String string) {
        Vector vector = this.getAssociatesForSegment(string, 2);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            if (string2.indexOf("IIS_web_server") > -1) {
                return true;
            }
            if (string2.indexOf("IIS_ssl_server") > -1) {
                return true;
            }
            if (string2.indexOf("Ssl_web_server") > -1) {
                return true;
            }
            if (string2.indexOf("Web_server") <= -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNickInTopology(String string, String[] stringArray, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        if (string2 == null || string2.length() == 0) {
            bl2 = true;
        }
        String[] stringArray2 = this.getSegmentNames();
        if (this.topoFilePtr == null) {
            this.topoFileName = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTopologyConfigFile;
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        if (!bl2 && string.equals("Oracle_server")) {
            int n;
            if (string2 == null) {
                return false;
            }
            int n2 = string2.indexOf(":");
            if (n2 < 0) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n2 + 1), ",");
            if (stringTokenizer.countTokens() == 0) {
                return false;
            }
            String[] stringArray3 = new String[stringTokenizer.countTokens()];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray3[n] = stringTokenizer.nextToken();
            }
            string2 = string2.substring(0, n2);
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    StringBuffer stringBuffer = new StringBuffer(512);
                    CharSequence charSequence = stringBuffer;
                    synchronized (charSequence) {
                        if (stringArray.length == 1) {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(":");
                        stringBuffer.append(stringArray[n]);
                        stringBuffer.append(":");
                        stringBuffer.append(string2);
                        stringBuffer.append(":");
                        stringBuffer.append(stringArray3[i]);
                    }
                    charSequence = stringBuffer.toString();
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String[] stringArray4 = this.topoFilePtr.getVariables(stringArray2[j]);
                        for (int k = 0; k < stringArray4.length; ++k) {
                            int n3;
                            if (stringArray4[k].indexOf((String)charSequence) <= -1 || (n3 = stringArray4[k].indexOf(":")) < 0) continue;
                            String string3 = stringArray4[k];
                            if (((String)charSequence).startsWith(":")) {
                                string3 = string3.substring(n3);
                            }
                            if (!string3.startsWith((String)charSequence)) continue;
                            bl = true;
                            return bl;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer(512);
                CharSequence charSequence = stringBuffer;
                synchronized (charSequence) {
                    if (stringArray.length == 1) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(":");
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(":");
                    stringBuffer.append(string2);
                }
                charSequence = stringBuffer.toString();
                for (int j = 0; j < stringArray2.length; ++j) {
                    String[] stringArray5 = this.topoFilePtr.getVariables(stringArray2[j]);
                    for (int k = 0; k < stringArray5.length; ++k) {
                        int n;
                        if (stringArray5[k].indexOf((String)charSequence) <= -1 || (n = stringArray5[k].indexOf(":")) < 0) continue;
                        String string4 = stringArray5[k];
                        if (((String)charSequence).startsWith(":")) {
                            string4 = string4.substring(n);
                        }
                        if (!string4.startsWith((String)charSequence)) continue;
                        bl = true;
                        return bl;
                    }
                }
            }
        }
        return bl;
    }

    public boolean isComponentMapsToSite(String string) {
        String[] stringArray = this.getWebSitesForServer(string);
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        ArrayList arrayList = this.getAllSitesOnly();
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.indexOf(stringArray[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAllSitesOnly() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.topoFilePtr.getVariables(svcSection);
        Vector vector = this.topoFilePtr.getAllValues(svcSection);
        if (stringArray == null || stringArray.length == 0 || vector == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            try {
                string = (String)vector.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (!string.equalsIgnoreCase("site")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String[] getSegmentNames() {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getVariables("TOPOLOGY_SEGMENTS");
    }

    public String[] getSegmentsForComponent(String string) {
        String[] stringArray = this.getSegmentNames();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getAllServers(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(string)) continue;
                stringBuffer.append(stringArray[i] + ",");
            }
        }
        String string2 = stringBuffer.toString();
        if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.lastIndexOf(","));
        }
        if (string2.equals("")) {
            string2 = "NULL";
        }
        return EgAgentTopoInfo.getTokens(string2, ",");
    }

    public String[] getSegment(String string, String string2, boolean bl) {
        if (bl) {
            String[] stringArray = this.getSegment(string, string2);
            if (stringArray == null) {
                return null;
            }
            if (stringArray[0].equals("NULL")) {
                return new String[]{"Independent_servers"};
            }
            return stringArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSegment(String string, String string2) {
        this.checkForUpdate();
        String string3 = string2 + ":" + string;
        String[] stringArray = (String[])this.compSegmentMap.get(string3);
        if (stringArray != null) {
            return stringArray;
        }
        stringArray = this.getSegmentsForComponent(string3);
        if (stringArray == null) {
            return null;
        }
        String string4 = webSiteMappingSection;
        synchronized (string4) {
            this.compSegmentMap.put(string3, stringArray);
        }
        return stringArray;
    }

    public String[] getAllServers(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getVariables(string);
    }

    public String getSegmentsForSite(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getValue("WEB_SITE_SEGMENTS", "Web_site:" + string);
    }

    public String getDisassociatedComponents(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getValue("LOGICAL_TOPOLOGY", "Web_site:" + string);
    }

    public ArrayList getSitesForComponent(String string) {
        String string2 = string.substring(0, string.indexOf(":"));
        String string3 = string.substring(string.indexOf(":") + 1);
        return this.getSitesForComponent(string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSitesForComponent(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.checkForUpdate();
        String string3 = string + ':' + string2;
        try {
            arrayList = (ArrayList<String>)this.compSiteMap.get(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList != null && arrayList.size() >= 0) {
            return (ArrayList)arrayList.clone();
        }
        String[] stringArray = this.getWebSites();
        if (stringArray == null || stringArray.length == 0) {
            arrayList = new ArrayList<String>();
            String string4 = webSiteMappingSection;
            synchronized (string4) {
                this.compSiteMap.put(string3, arrayList);
            }
            return arrayList;
        }
        arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector = this.getComponentsForSite(stringArray[i]);
            if (vector == null || vector.size() == 0 || vector.indexOf(string3) < 0 || arrayList.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList != null && arrayList.size() >= 0) {
            String string5 = webSiteMappingSection;
            synchronized (string5) {
                this.compSiteMap.put(string3, arrayList);
            }
        }
        return (ArrayList)arrayList.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getComponentsForSite(String string) {
        this.checkForUpdate();
        Vector vector = (Vector)this.siteCompMap.get(string);
        if (vector != null && vector.size() > 0) {
            return vector;
        }
        vector = this.getAssociatesForSite(string, 3);
        if (vector == null) {
            return null;
        }
        String string2 = webSiteMappingSection;
        synchronized (string2) {
            this.siteCompMap.put(string, vector);
        }
        return vector;
    }

    public Vector getComponentsForSite(String string, int n) {
        this.checkForUpdate();
        Vector vector = this.getAssociatesForSite(string, n);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getComponentsForSegment(String string) {
        this.checkForUpdate();
        if (string == null) {
            return null;
        }
        Vector vector = (Vector)this.segmentCompMap.get(string);
        if (vector != null && vector.size() > 0) {
            return vector;
        }
        vector = this.getAssociatesForSegment(string, 3);
        if (vector == null) {
            return null;
        }
        String string2 = webSiteMappingSection;
        synchronized (string2) {
            this.segmentCompMap.put(string, vector);
        }
        return vector;
    }

    public Vector getAssociatesForSite(String string) {
        return this.getAssociatesForSite(string, 2);
    }

    private Vector getAssociatesForSite(String string, int n) {
        Vector vector = new Vector();
        String string2 = "";
        if (this.EgCrawler == null) {
            return vector;
        }
        try {
            Object[] objectArray = new Object[]{this.topoFilePtr, new Boolean(false)};
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Object t = this.ctor.newInstance(objectArray);
            Object[] objectArray2 = new Object[]{string};
            vector = (Vector)this.EgCrawler.getMethod("getAssociates", classArray).invoke(t, objectArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return vector;
        }
        for (int i = 0; i < vector.size(); ++i) {
            string2 = (String)vector.get(i);
            int n2 = string2.indexOf(":");
            if (n2 < 0) continue;
            if (n == 0) {
                string2 = string2.substring(0, n2);
            } else if (n == 1) {
                string2 = string2.substring(n2 + 1, string2.length());
            } else if (n == 3) {
                string2 = string2.substring(n2 + 1, string2.length()) + ":" + string2.substring(0, n2);
            }
            vector.set(i, string2);
        }
        return vector;
    }

    public Vector getAssociatesForSegment(String string, int n) {
        Vector vector = new Vector();
        String[] stringArray = this.topoFilePtr.getVariables(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("#Format:")) continue;
            if (n == 0) {
                this.addUniqueData(vector, stringArray[i].substring(0, stringArray[i].indexOf(":")));
                continue;
            }
            if (n == 1) {
                this.addUniqueData(vector, stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()));
                continue;
            }
            if (n == 3) {
                this.addUniqueData(vector, stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()) + ":" + stringArray[i].substring(0, stringArray[i].indexOf(":")));
                continue;
            }
            this.addUniqueData(vector, stringArray[i]);
        }
        return vector;
    }

    private void addUniqueData(Vector vector, Object object) {
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }

    public ArrayList getRhsDependents(String string, ArrayList arrayList, String string2) {
        this.getRhsDependentsOf(string, arrayList, string2);
        return arrayList;
    }

    public ArrayList getRhsDependents(String string, String string2) {
        this.checkForUpdate();
        ArrayList arrayList = new ArrayList();
        this.getRhsDependentsOf(string, arrayList, string2);
        return arrayList;
    }

    public ArrayList getLhsDependents(String string, String string2) {
        this.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getAllServers(string2);
        if (stringArray.length == 0) {
            return arrayList;
        }
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        String string3 = string + ":";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = this.topoFilePtr.getValue(string2, stringArray[i]);
                if (string4.indexOf(string3) < 0) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    public ArrayList getSitesForSegment(String string) {
        this.checkForUpdate();
        String[] stringArray = this.getWebSites();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = this.topoFilePtr.getValue("WEB_SITE_SEGMENTS", "Web_site:" + stringArray[i]);
                if (string2.indexOf(string) <= -1) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    public TreeSet getRelatedSegmentsForSegment(String string) {
        this.checkForUpdate();
        String[] stringArray = this.getVariables(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray == null) {
            return treeSet;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = this.getSegmentsForComponent(string2);
            if (stringArray2 == null) continue;
            treeSet.addAll(Arrays.asList(stringArray2));
        }
        treeSet.remove(string);
        return treeSet;
    }

    public ArrayList getSegmentsForSite(String string, boolean bl) {
        this.checkForUpdate();
        String string2 = this.getSegmentsForSite(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.indexOf(",") > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }
        arrayList.add(string2);
        return arrayList;
    }

    public Hashtable getSegmentServiceAssociation() {
        String[] stringArray;
        String[] stringArray2;
        String string;
        Object object;
        String[] stringArray3;
        TreeSet<String> treeSet;
        int n;
        this.checkForUpdate();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray4 = this.discinfo.getServerTypes();
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                String[] stringArray5 = this.discinfo.getAllServersOfType(stringArray4[i]);
                if (stringArray5 == null) continue;
                for (n = 0; n < stringArray5.length; ++n) {
                    int n2;
                    treeSet = new TreeSet();
                    stringArray3 = this.getSegmentsForComponent(stringArray5[n]);
                    object = this.getSitesForComponent(stringArray5[n]);
                    if (object != null) {
                        for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                            treeSet.add("Service:" + ((ArrayList)object).get(n2) + ":NULL");
                        }
                    }
                    if (stringArray3 != null) {
                        for (n2 = 0; n2 < stringArray3.length; ++n2) {
                            string = stringArray3[n2];
                            if (string.equals("NULL") || string.equalsIgnoreCase("Independent_servers")) continue;
                            treeSet.add("Segment:" + string + ":NULL");
                            treeSet.addAll(this.addAssociationsForSegment(string));
                        }
                    }
                    hashtable.put(stringArray5[n], treeSet);
                }
            }
        }
        if ((stringArray2 = this.getSegmentNames()) != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                treeSet = new TreeSet<String>();
                treeSet.addAll(this.addAssociationsForSegment(stringArray2[n]));
                hashtable.put("Segment:" + stringArray2[n] + ":NULL", treeSet);
            }
        }
        if ((stringArray = this.getWebSites()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray3 = new TreeSet();
                object = this.getSegmentsForSite(stringArray[i]);
                if (object == null || ((String)object).equals("NULL")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String[] stringArray6;
                    string = stringTokenizer.nextToken();
                    if (!string.equals("NULL") && !string.equalsIgnoreCase("Independent_servers")) {
                        stringArray3.add("Segment:" + string + ":NULL");
                        stringArray3.addAll(this.addAssociationsForSegment(string));
                    }
                    if (!string.equalsIgnoreCase("Independent_servers") || (stringArray6 = this.getVariables(stringArray[i] + "_INDEPENDENT")) == null) continue;
                    for (int j = 0; j < stringArray6.length; ++j) {
                        int n3;
                        String[] stringArray7 = this.getSegmentsForComponent(stringArray6[j]);
                        ArrayList arrayList = this.getSitesForComponent(stringArray6[j]);
                        if (arrayList != null) {
                            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                                stringArray3.add("Service:" + arrayList.get(n3) + ":NULL");
                            }
                        }
                        if (stringArray7 != null) {
                            for (n3 = 0; n3 < stringArray7.length; ++n3) {
                                String string2 = stringArray7[n3];
                                if (string2.equals("NULL") || string2.equalsIgnoreCase("Independent_servers")) continue;
                                stringArray3.add("Segment:" + string2 + ":NULL");
                                stringArray3.addAll(this.addAssociationsForSegment(string2));
                            }
                        }
                        hashtable.put(stringArray6[j], stringArray3);
                    }
                }
                hashtable.put("Service:" + stringArray[i] + ":NULL", stringArray3);
            }
        }
        return hashtable;
    }

    public TreeSet addAssociationsForSegment(String string) {
        this.checkForUpdate();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet treeSet2 = null;
        if (!string.equals("NULL") && !string.equalsIgnoreCase("Independent_servers")) {
            treeSet2 = this.getRelatedSegmentsForSegment(string);
            treeSet2.add(string);
        } else {
            treeSet2 = new TreeSet();
        }
        for (String string2 : treeSet2) {
            ArrayList arrayList;
            if (!string2.equals("NULL") && !string2.equalsIgnoreCase("Independent_servers")) {
                treeSet.add("Segment:" + string2 + ":NULL");
            }
            if ((arrayList = this.getSitesForSegment(string2)) == null) {
                return treeSet;
            }
            while (arrayList.size() > 0) {
                String string3 = (String)arrayList.get(0);
                treeSet.add("Service:" + string3 + ":NULL");
                String string4 = this.getSegmentsForSite(string3);
                if (string4 == null || string4.equals("NULL")) {
                    return treeSet;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (treeSet.contains("Segment:" + string5 + ":NULL") || string5.equals("NULL") || string5.equalsIgnoreCase("Independent_servers")) continue;
                    treeSet.add("Segment:" + string5 + ":NULL");
                    ArrayList arrayList2 = this.getSitesForSegment(string5);
                    if (arrayList2 == null) {
                        return treeSet;
                    }
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string6 = (String)arrayList2.get(i);
                        if (arrayList.contains(string6)) continue;
                        arrayList.add(string6);
                    }
                }
                arrayList.remove(string3);
            }
            treeSet.addAll(arrayList);
        }
        return treeSet;
    }

    public TreeSet addAssociationsForService(String string) {
        String string2;
        String[] stringArray;
        this.checkForUpdate();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!string.equals("NULL") && !string.equalsIgnoreCase("Independent_servers")) {
            treeSet.add("service:" + string + ":NULL");
        }
        if ((stringArray = EgAgentTopoInfo.getTokens(string2 = this.getSegmentsForSite(string), ",")) == null) {
            return treeSet;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            treeSet.add("Segment:" + string3 + ":NULL");
            treeSet.addAll(this.addAssociationsForSegment(string3));
        }
        return treeSet;
    }

    public TreeSet getAllElementsTypeUnderSegment(String string) {
        this.checkForUpdate();
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.indexOf("#") > -1) continue;
            treeSet.add(string2.substring(0, string2.indexOf(":")));
        }
        return treeSet;
    }

    public TreeSet getAllElementsTypeUnderService(String string) {
        this.checkForUpdate();
        TreeSet<String> treeSet = new TreeSet<String>();
        Vector vector = this.getAssociatesForSite(string, 2);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            if (string2.indexOf("#") > -1) continue;
            treeSet.add(string2.substring(0, string2.indexOf(":")));
        }
        return treeSet;
    }

    public TreeSet getAllElementsFromSegments() {
        this.checkForUpdate();
        TreeSet treeSet = new TreeSet();
        String[] stringArray = this.getSegmentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.addAll(this.getAssociatesForSegment(stringArray[i], 2));
        }
        return treeSet;
    }

    public TreeSet getAllElementsFromServices() {
        this.checkForUpdate();
        TreeSet treeSet = new TreeSet();
        String[] stringArray = this.getWebSites();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet.addAll(this.getAssociatesForSegment(stringArray[i], 2));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return treeSet;
    }

    public Vector getSiteServers(boolean bl, Vector vector, Vector vector2) {
        if (bl) {
            return vector2;
        }
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            for (int j = 0; j < vector2.size(); ++j) {
                String string2 = (String)vector2.get(j);
                if (string2 == null || !string2.startsWith(string)) continue;
                vector3.add(string2);
            }
        }
        return vector3;
    }

    public static final String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String getSiteForAggregateSite(String string) {
        if (this.topoFilePtr == null) {
            this.topoFilePtr = new IniFile(this.topoFileName);
        }
        return this.topoFilePtr.getValue(aggregateSiteMapping, string);
    }

    public static void main(String[] stringArray) {
        EgAgentTopoInfo egAgentTopoInfo = new EgAgentTopoInfo("manager");
        System.out.println(egAgentTopoInfo.getSegmentServiceAssociation());
    }
}

