/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.util.MibTreeNode;
import com.ireasoning.util.TrapNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class EgMibUtil {
    public static boolean needToReload = true;
    public static String sync = "flag";
    public static boolean expandMIB = false;
    public static MibTreeNode root = null;
    public static Hashtable oidNameMap = new Hashtable();
    public static Hashtable oidDescMap = new Hashtable();

    public static void reload() {
        needToReload = true;
        EgMibUtil.loadMibs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMibs() {
        if (needToReload) {
            String string = sync;
            synchronized (string) {
                if (needToReload) {
                    String string2 = EgInstallInfo.getInstallDir() + "/.snmp/";
                    File file = new File(string2);
                    if (!file.exists()) {
                        return;
                    }
                    File[] fileArray = file.listFiles();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (fileArray != null && fileArray.length > 0) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            String string3 = fileArray[i].getAbsolutePath();
                            String string4 = string3;
                            if (!string4.toLowerCase().endsWith(".txt") && !string4.toLowerCase().endsWith(".mib") && !string4.toLowerCase().endsWith(".my")) continue;
                            try {
                                MibUtil.loadMib((String)string3);
                                System.out.println("Loaded Mib " + string3);
                                arrayList.add(string3);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        MibUtil.setResolveSyntax((boolean)true);
                        String[] stringArray = new String[arrayList.size()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = (String)arrayList.get(i);
                        }
                        try {
                            root = MibUtil.parseMibs((String[])stringArray, (boolean)false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    oidDescMap.clear();
                    needToReload = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadMib(String string) {
        String string2 = "success~!~" + string + "true";
        String string3 = sync;
        synchronized (string3) {
            ArrayList arrayList = new ArrayList();
            String string4 = EgInstallInfo.getInstallDir() + "/.snmp/" + string;
            File file = new File(string4);
            if (!file.exists()) {
                string2 = "failure~!~" + string4 + " file not exist";
                return string2;
            }
            String string5 = file.getAbsolutePath();
            if (!(string.toLowerCase().endsWith(".txt") || string.toLowerCase().endsWith(".mib") || string.toLowerCase().endsWith(".my"))) {
                string2 = "failure~!~" + string4 + " file format issue";
                return string2;
            }
            try {
                MibUtil.loadMib((String)string5, (boolean)false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string2 = "failure~!~" + exception.getMessage();
            }
            MibUtil.setResolveSyntax((boolean)true);
            try {
                root = MibUtil.parseMib((String)string5, (boolean)false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string2 = "failure~!~" + exception.getMessage();
            }
            oidDescMap.clear();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unloadMib(String string) {
        boolean bl = false;
        String string2 = sync;
        synchronized (string2) {
            String string3 = EgInstallInfo.getInstallDir() + "/.snmp/" + string;
            File file = new File(string3);
            if (!file.exists()) {
                return false;
            }
            String string4 = file.getAbsolutePath();
            if (!(string.toLowerCase().endsWith(".txt") || string.toLowerCase().endsWith(".mib") || string.toLowerCase().endsWith(".my"))) {
                return false;
            }
            try {
                MibUtil.unloadMib((String)string4);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
                throwable.printStackTrace();
            }
            oidDescMap.clear();
        }
        return bl;
    }

    public static String translateOID(String string) {
        EgMibUtil.loadMibs();
        return MibUtil.translateOID((String)string, (boolean)expandMIB);
    }

    public static String translateOID(String string, boolean bl) {
        EgMibUtil.loadMibs();
        return MibUtil.translateOID((String)string, (boolean)bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDescription(String string) {
        EgMibUtil.loadMibs();
        if (root == null) {
            return string;
        }
        String string2 = (String)oidDescMap.get(string);
        if (string2 != null) {
            return string2;
        }
        MibTreeNode mibTreeNode = null;
        MibTreeNode mibTreeNode2 = null;
        Object object = sync;
        synchronized (object) {
            mibTreeNode2 = root;
        }
        mibTreeNode = mibTreeNode2.searchByOID(new SnmpOID(string));
        if (mibTreeNode != null) {
            object = mibTreeNode.getDescription();
            if (object == null || ((String)object).trim().length() == 0) {
                oidDescMap.put(string, string);
                return string;
            }
            oidDescMap.put(string, object);
            return object;
        }
        object = mibTreeNode2.getTrapNodes();
        if (object != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n;
                TrapNode trapNode = (TrapNode)((Vector)object).get(i);
                String string3 = trapNode.getEnterpriseOID();
                if (!string.startsWith(string3) || (n = trapNode.getVersion()) != 0) continue;
                int n2 = trapNode.getTrapNumber();
                String string4 = string3 + ".0." + n2;
                String string5 = string3 + "." + n2;
                if (!string4.equals(string) && !string5.equals(string)) continue;
                String string6 = trapNode.getDescription();
                if (string6 != null && string6.trim().length() > 0) {
                    oidDescMap.put(string, string6);
                    return string6;
                }
                oidDescMap.put(string, string);
                return string;
            }
        }
        oidDescMap.put(string, string);
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(EgMibUtil.getDescription(stringArray[0]));
    }
}

