/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.MultiThreadDDConfigTask;
import com.eg.MultiThreadDDLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgThreadPoolExecutor
extends ThreadPoolExecutor {
    private static EgThreadPoolExecutor executor = null;

    private EgThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> blockingQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, blockingQueue);
    }

    public static EgThreadPoolExecutor getExecutor(boolean shutdown) {
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EgThreadPoolExecutor getExecutor(int corePoolSize, int maxPoolSize, int queueCapacity, long keepAliveTime) {
        if (executor != null) return executor;
        boolean debugEnabled = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
        Class<EgThreadPoolExecutor> clazz = EgThreadPoolExecutor.class;
        synchronized (EgThreadPoolExecutor.class) {
            if (executor != null) return executor;
            ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(queueCapacity);
            executor = new EgThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, blockingQueue);
            if (debugEnabled) {
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "**********************************************************************************************************************************************");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "                                       EgThreadPoolExecutor is created with the following properties                                           ");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "**********************************************************************************************************************************************");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "CorePool Size :" + corePoolSize + " Max.Pool Size : " + maxPoolSize + " KeepAlive Time :" + keepAliveTime + " ms & Queue Size :" + blockingQueue.remainingCapacity());
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "***********************************************************************************************************************************************");
            }
            executor.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("DD-DataInsertThread");
                    t.setDaemon(true);
                    return t;
                }
            });
            executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    System.err.println("EgThreadPoolExecutor : DDDataPacket got rejected");
                    boolean debugEnabled = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
                    if (debugEnabled) {
                        MultiThreadDDLogger.logToErrorFile("ERROR", "EgThreadPoolExecutor", "DDDataPacket got rejected");
                    }
                    int active = executor.getActiveCount();
                    int remainCapacity = executor.getQueue().remainingCapacity();
                    boolean isShutdown = executor.isShutdown();
                    if (debugEnabled) {
                        MultiThreadDDLogger.logToErrorFile("ERROR", "EgThreadPoolExecutor", "ActiveCount  :" + active + " remainCapacity :" + remainCapacity + " isShutdown " + isShutdown);
                    }
                }
            });
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return executor;
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }

    public void shutDown() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
            boolean debugEnabled = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
            if (debugEnabled) {
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "EgThreadPoolExecutor is shutdown successfully !!!");
            }
        }
    }
}

