/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class RabbitMQNodeDiscovery {
    private String user;
    private String password;
    private String host;
    private String port;
    private String ssl = null;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static final String METHOD_GET = "GET";
    private static final String AUTHORIZATION_KEY = "Authorization";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String CACHE_CONTROL_KEY = "Cache-Control";
    private static final String CACHE_CONTROL_VALUE = "no-cache";
    private String token = null;
    private boolean isSSL = false;
    private String urlStr = null;
    private String logMessage = "";

    public RabbitMQNodeDiscovery(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.port = string2;
        this.user = string3;
        this.password = string4;
        this.ssl = string5;
        if (string5.equalsIgnoreCase("false") || string5.equalsIgnoreCase("no")) {
            this.isSSL = false;
            this.urlStr = "http://" + string + ":" + string2 + "/api/overview";
        } else {
            this.isSSL = true;
            this.urlStr = "https://" + string + ":" + string2 + "/api/overview";
        }
        System.out.println("URL " + this.urlStr);
        this.token = this.createBasicAuthToken(string3, string4);
    }

    private String createBasicAuthToken(String string, String string2) {
        String string3 = string + ":" + string2;
        byte[] byArray = Base64.encodeBase64((byte[])string3.getBytes());
        String string4 = new String(byArray);
        return "Basic " + string4;
    }

    public Hashtable executeAPIRequest() {
        Object var1_1 = null;
        String string = this.getJSONDataFromURL(this.urlStr, this.host, this.port);
        if (string != null) {
            System.out.println("responseString " + string);
            Hashtable hashtable = this.getRabbitMQClusterOverview(string);
            System.out.println("getMeasureDataList " + hashtable);
            return hashtable;
        }
        return null;
    }

    public String getJSONDataFromURL(String string, String string2, String string3) {
        HttpURLConnection httpURLConnection = null;
        String string4 = null;
        String string5 = "[getJSONDataFromURL] :";
        this.enableSSLForRabbitMQRESTAPI();
        URL uRL = null;
        try {
            uRL = new URL(null, string);
            System.out.println(string5 + " Endpoint URL  :" + uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(string5 + " MalformedURLException " + malformedURLException);
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            System.out.println("HttpURLConnection  error " + iOException);
            iOException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            System.out.println("Your HTTP connection does not support  setRequestMethod " + protocolException);
            protocolException.printStackTrace();
            return null;
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        httpURLConnection.setRequestProperty(AUTHORIZATION_KEY, this.token);
        httpURLConnection.setRequestProperty(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        RabbitMQConnectionThread rabbitMQConnectionThread = new RabbitMQConnectionThread(httpURLConnection, string5);
        int n = 0;
        boolean bl = this.checkForTimeout(rabbitMQConnectionThread);
        if (bl) {
            n = rabbitMQConnectionThread.code;
            if (n != 200) {
                System.out.println("Invalid response code: " + n);
            }
            string4 = rabbitMQConnectionThread.responseString;
        }
        if (!bl || n != 200) {
            System.out.println("Timing out or invalid response code:" + n);
        }
        httpURLConnection.disconnect();
        System.out.println(string5 + " Final Response for the given URL  :" + string4);
        return string4;
    }

    void enableSSLForRabbitMQRESTAPI() {
        if (this.isSSL) {
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var2_2 = null;
            RabbitMQX509TrustManager rabbitMQX509TrustManager = new RabbitMQX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{rabbitMQX509TrustManager};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.logMessage = "[enableSSLForRabbitMQRESTAPI]";
                noSuchAlgorithmException.printStackTrace();
                return;
            }
            try {
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                this.logMessage = "[enableSSLForRabbitMQRESTAPI]";
                keyManagementException.printStackTrace();
                return;
            }
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new RabbitMQHostnameVerifier());
        }
    }

    protected String decodeResponse(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private boolean checkForTimeout(RabbitMQConnectionThread rabbitMQConnectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < 120L) {
                l3 = 120L;
            }
            this.suspendForPeriod(l3);
            if (rabbitMQConnectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.logMessage = "Timed out and hence going to kill the thread :" + System.currentTimeMillis();
                this.logMessage = "";
                rabbitMQConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.logMessage = " Timed out and killed the thread :" + System.currentTimeMillis();
                this.logMessage = "";
                rabbitMQConnectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.logMessage = " sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis();
        this.logMessage = "";
        rabbitMQConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        rabbitMQConnectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public Hashtable getRabbitMQClusterOverview(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        String string2 = "[getRabbitMQClusterOverview] :";
        Object var5_5 = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        try {
            JSONParser jSONParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"contexts");
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                String string3 = this.getValueFromJSONObject(jSONObject2, "node");
                String string4 = string3.substring(string3.indexOf("@") + 1);
                if (hashtable2.contains(string4)) continue;
                String string5 = this.getIP(string4);
                if (string5 == null) {
                    hashtable2.put(string4, string4);
                    continue;
                }
                hashtable2.put(string4, string5);
            }
        }
        catch (Exception exception) {
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable2;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            this.logMessage = string3 + " [Error] Object " + string + " not found assing default values";
            this.logMessage = "";
        }
        return string2;
    }

    protected JSONObject getJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        String string2 = "[getJSONObject] :";
        try {
            if (jSONObject == null) {
                return jSONObject2;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.logMessage = string2 + " [Error] Object " + string + " not found return null value JSONObject";
            this.logMessage = "";
        }
        return jSONObject2;
    }

    private String getIP(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            System.out.println(inetAddress.getHostAddress());
            return inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        RabbitMQNodeDiscovery rabbitMQNodeDiscovery = new RabbitMQNodeDiscovery("192.168.9.166", "15672", "admin", "password", "false");
        rabbitMQNodeDiscovery.executeAPIRequest();
    }

    class RabbitMQConnectionThread
    extends Thread {
        private HttpURLConnection connection;
        private String methodName = "[run]:";
        public String responseString = null;
        public boolean done = false;
        public int code = 0;

        public RabbitMQConnectionThread(HttpURLConnection httpURLConnection, String string) {
            this.connection = httpURLConnection;
            this.methodName = this.methodName + string;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.connection.connect();
            }
            catch (IOException iOException) {
                RabbitMQNodeDiscovery.this.logMessage = this.methodName + " Error : URL connect and returned ";
                RabbitMQNodeDiscovery.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                RabbitMQNodeDiscovery.this.logMessage = this.methodName + " and its Response code :" + this.connection.getResponseCode();
                RabbitMQNodeDiscovery.this.logMessage = "";
            }
            catch (IOException iOException) {
                RabbitMQNodeDiscovery.this.logMessage = this.methodName + " Error ";
                RabbitMQNodeDiscovery.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            InputStream inputStream = null;
            try {
                this.code = this.connection.getResponseCode();
                inputStream = this.code == 200 ? this.connection.getInputStream() : this.connection.getErrorStream();
            }
            catch (IOException iOException) {
                RabbitMQNodeDiscovery.this.logMessage = this.methodName + " response  exception ";
                RabbitMQNodeDiscovery.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                this.responseString = RabbitMQNodeDiscovery.this.decodeResponse(inputStream);
            }
            catch (IOException iOException) {
                RabbitMQNodeDiscovery.this.logMessage = this.methodName + " response after decode , Error ";
                RabbitMQNodeDiscovery.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        RabbitMQNodeDiscovery.this.logMessage = this.methodName + "  response close error ";
                        RabbitMQNodeDiscovery.this.logMessage = "";
                        iOException.printStackTrace();
                        return;
                    }
                }
            }
            this.done = true;
        }
    }

    class RabbitMQX509TrustManager
    implements X509TrustManager {
        RabbitMQX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    class RabbitMQHostnameVerifier
    implements HostnameVerifier {
        RabbitMQHostnameVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        public boolean verify(String string, String string2) {
            return true;
        }
    }
}

