<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page errorPage = "../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import = "com.eg.EgMemCheck"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameComparator"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ include file="../../EgTrackerAJSON.jsp"%>

<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	JSONObject rootJson = new JSONObject();
	String moduleName =request.getParameter("moduleName");
	String modules[] = {"Please choose a module","Admin","Monitor","Reporter","Configuration"};
	String modules_A[] = {"admin","monitor","reporter","configmgmt"};

	String newWindow = request.getParameter("newwindow");
	String entry = null;
	if (StringUtils.isNull(newWindow))
	{
		entry = (String) session.getAttribute("egEntryMain");
	}
	else
	{
		entry = (String) session.getAttribute("egEntryChild");
	}

	if (entry == null || entry.equalsIgnoreCase("null"))
	{
		entry = "admin";
	}

	if (entry.equalsIgnoreCase("admin"))
	{
		entry = "Admin";
	}
	else if (entry.equalsIgnoreCase("monitor"))
	{
		entry = "Monitor";
	}
	else if(entry.equalsIgnoreCase("reporter"))
	{
		entry = "Reporter";
	}
	else if(entry.equalsIgnoreCase("config"))
	{
		entry = "Configuration";
	}
	rootJson.put("entrySet",entry);
	
	EgCrypt egCrypt = new EgCrypt();
	boolean javaVersion = egCrypt.checkJavaVersion();

	EgServicesInfo serviceInfo = new EgServicesInfo("manager");
	boolean isAuditlogEnabled = serviceInfo.isAuditlogEnabled();
	boolean isCapacityReportEnabled = serviceInfo.isCapacityReportEnabled();
	boolean isAutoConfigureEnabled = serviceInfo.isAutoConfigureEnabled();
	boolean isWyseReportEnabled = serviceInfo.isWyseReportEnabled();
	boolean isBillingDataEnabled = serviceInfo.isBillingDataEnabled();

	String userName = _user.getLoginID();
	boolean changePwd = true;
	if (userName.indexOf("/") != -1)
	{
		changePwd = false;
	}

	EgUserRole userRole = _user.getUserRole();
	boolean hasAdminTab = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
	boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

	boolean mapEnabled = false;
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile serIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String mapLicense = uiIni.getValue("ZONE_MAP","mapEnabled");
	mapEnabled = (mapLicense != null && mapLicense.equalsIgnoreCase("yes"));

	boolean isCustomDashboardEnabled = false;
	String customDashboardFlag = uiIni.getValue("MULTISERVER_CUSTOM_DASHBOARD","ShowCustomDashboard");
	isCustomDashboardEnabled = (customDashboardFlag != null && customDashboardFlag.equalsIgnoreCase("yes"));

	EgMemCheck memCheck = new EgMemCheck();
	boolean isMetricAggregationEnabled = memCheck.isMAEnabled();
	boolean isIntegrationConsoleEnabled = memCheck.isExtensible();
	String strSubject = "";
	String strModule_A = "";
	ArrayList aListQuickMenuItems = new ArrayList();
	ArrayList aListAvailableQMs = new ArrayList();
	ArrayList aListQMMappings = new ArrayList();

	if (moduleName != null && !moduleName.equals("-1"))
	{
		if (moduleName.equalsIgnoreCase("Admin"))
		{
			strSubject = "ADMIN_QUICK_MENU";
			strModule_A = modules_A[0];
		}
		else if (moduleName.equalsIgnoreCase("Monitor"))
		{
			strSubject = "MONITOR_QUICK_MENU";
			strModule_A = modules_A[1];
		}
		else if (moduleName.equalsIgnoreCase("Reporter"))
		{
			strSubject = "REPORTER_QUICK_MENU";
			strModule_A = modules_A[2];
		}
		else if (moduleName.equalsIgnoreCase("Configuration"))
		{
			strSubject = "CONFIG_QUICK_MENU";
			strModule_A = modules_A[3];
		}

		IniFile QMIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_quickmenu.ini");
		String strQuickMenuItems = QMIni.getValue(userName,moduleName);
		if (strQuickMenuItems != null && strQuickMenuItems.length() > 0)
		{
			StringTokenizer strTokens = new StringTokenizer(strQuickMenuItems,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken();
				if (!isIntegrationConsoleEnabled && (strToken.equalsIgnoreCase("BackupAndRevertConfig") || 
				strToken.equalsIgnoreCase("ICComponent") || strToken.equalsIgnoreCase("ICLayer") || 
				strToken.equalsIgnoreCase("ICTest")))
				{
					continue;
				} 
				else
				{
					aListQuickMenuItems.add(strToken);
				}
				
			}
		}

		String[] quickMenus = uiIni.getVariables(strSubject);
		if (quickMenus != null && quickMenus.length > 0)
		{
			for (int i=0;i<quickMenus.length;i++)
			{
				String strMenuVar = quickMenus[i];
				if (moduleName.equalsIgnoreCase("Admin"))
				{
					//Product and User specific controls
					if (!javaVersion && strMenuVar.equalsIgnoreCase("ConfigureDomains"))
					{
						continue;
					}
					else if (!isAuditlogEnabled && 
							(strMenuVar.equalsIgnoreCase("SuccessfulLogons") || 
							strMenuVar.equalsIgnoreCase("FailedLogons") || 
							strMenuVar.equalsIgnoreCase("AdminAuditlogReports") || 
							strMenuVar.equalsIgnoreCase("MonitorAuditlogReports") || 
							strMenuVar.equalsIgnoreCase("ReporterAuditlogReports") || 
							strMenuVar.equalsIgnoreCase("ConfigAuditlogReports")))
					{
						continue;
					}
					else if (!isCapacityReportEnabled && 
							(strMenuVar.equalsIgnoreCase("PercentileOperations") || 
							strMenuVar.equalsIgnoreCase("ReportSetting")))
					{
						continue;
					}
					else if (!isAutoConfigureEnabled && strMenuVar.equalsIgnoreCase("AutoConfiguration"))
					{
						continue;
					}
					else if (!changePwd && strMenuVar.equalsIgnoreCase("ChangePassword"))
					{
						continue;
					}
					else if (!hasMonitorTab && strMenuVar.equalsIgnoreCase("MonitorAuditlogReports"))
					{
						continue;
					}
					else if (!hasReporterTab && strMenuVar.equalsIgnoreCase("ReporterAuditlogReports"))
					{
						continue;
					}
					else if (!hasConfigTab && strMenuVar.equalsIgnoreCase("ConfigAuditlogReports"))
					{
						continue;
					}
					else if (!isMetricAggregationEnabled && 
							(strMenuVar.equalsIgnoreCase("AddModifyAggregates") || 
							strMenuVar.equalsIgnoreCase("AggregateTest") || 
							strMenuVar.equalsIgnoreCase("UpdateAggTestPeriod")))
					{
						continue;
					}
					else if (!isIntegrationConsoleEnabled && 
							(strMenuVar.equalsIgnoreCase("BackupAndRevertConfig") || 
							strMenuVar.equalsIgnoreCase("ICComponent") || 
							strMenuVar.equalsIgnoreCase("ICLayer") || 
							strMenuVar.equalsIgnoreCase("ICTest")))
					{
						continue;
					}
				}
				else if (moduleName.equalsIgnoreCase("Monitor"))
				{
					if (!mapEnabled && strMenuVar.equalsIgnoreCase("ZonesMap"))
					{
						continue;
					}
					else if (!isMetricAggregationEnabled && strMenuVar.equalsIgnoreCase("ComponentsAggregates"))
					{
						continue;
					}
					else if (!hasAllComponentAccess && strMenuVar.equalsIgnoreCase("UserViewOption"))
					{
						continue;
					}
					else if (!isCustomDashboardEnabled && strMenuVar.equalsIgnoreCase("MyDashboardsOption"))
					{
						continue;
					}
				}
				else if (moduleName.equalsIgnoreCase("Reporter"))
				{
					if (!isWyseReportEnabled && strMenuVar.equalsIgnoreCase("ThinClientWyse"))
					{
						continue;
					}
					else if (!isBillingDataEnabled && strMenuVar.equalsIgnoreCase("ThinClientUserBilling"))
					{
						continue;
					}
					else if (!isCapacityReportEnabled && 
							(strMenuVar.equalsIgnoreCase("CapacityPlanningOverview") || 
							strMenuVar.equalsIgnoreCase("CapacityPlanningPrediction") || 
							strMenuVar.equalsIgnoreCase("CapacityPlanningCorrelation") || 
							strMenuVar.equalsIgnoreCase("CapacityPlanningCumulation")))
					{
						continue;
					}
				}
				
				if (aListQuickMenuItems != null && aListQuickMenuItems.contains(strMenuVar))
				{
					continue;
				}

				aListAvailableQMs.add(strMenuVar);
			}
		}
		String strQuickMenuItem = "";
		if (aListAvailableQMs != null && !aListAvailableQMs.isEmpty())
		{
			for (int i=0;i<aListAvailableQMs.size();i++)
			{
				strQuickMenuItem = (String)aListAvailableQMs.get(i);
				String strMappingName = _mapping.getQuickLinkDescription(strModule_A+".quickmenu."+strQuickMenuItem);
				aListQMMappings.add(new EgName(strQuickMenuItem,strMappingName));	
			}
			Collections.sort(aListQMMappings,new MappingNameComparator());
		}
	}

	String fromSm = (String)session.getAttribute("fromSm");
	if (newWindow != null && newWindow.trim().length() > 0 && newWindow.equals("yes"))
	{
		if(fromSm != null && (fromSm.equals("yes") || fromSm.equals("home")))
		{
			// Coming from super manager so all tabs are necessary, dont limit any tab.
		}
		else
		{
			if (entry.equalsIgnoreCase("admin"))
			{
				modules = new String[]{"Admin"};
			}
			else if (entry.equalsIgnoreCase("monitor"))
			{
				modules = new String[]{"Monitor"};
			}
			else if (entry.equalsIgnoreCase("reporter"))
			{
				modules = new String[]{"Reporter"};
			}
			else if (entry.equalsIgnoreCase("configuration"))
			{
				modules = new String[]{"Configuration"};
			}
		}
	}

	boolean isSecondaryManager = false;
	EgManagersIniForManager mi = null;
	if (EgInstallInfo.isClusterSupported)
	{
		mi = EgManagersIniForManager.getInstance();
		if (!mi.isPrimaryManager())
		{
			isSecondaryManager = true;
		}
	}

	JSONArray mList = new JSONArray();
	for (int i=0;i<modules.length;i++)
	{
		String strModuleName = modules[i];
		if (strModuleName.equalsIgnoreCase("Admin") && (!hasAdminTab || isSecondaryManager))
		{
			continue;
		}
		else if (strModuleName.equalsIgnoreCase("Monitor") && !hasMonitorTab)
		{
			continue;
		}
		else if (strModuleName.equalsIgnoreCase("Reporter") && 
		(!EgInstallInfo.isReporterSupported || !hasReporterTab))
		{
			continue;
		}
		else if (strModuleName.equalsIgnoreCase("Configuration") && 
				(!EgInstallInfo.isConfigSupported || !hasConfigTab))
		{
			continue;
		}
		String selected = "";
		if (moduleName != null && moduleName.equalsIgnoreCase(strModuleName))
		{
			selected = "selected";
		}
		JSONObject jobj = new JSONObject();
		if( strModuleName.equals(_mapping.getTextDescription("admin.common.Please choose a module")))
		{
			jobj.put("displayField",_mapping.getTextDescription("admin.common."+strModuleName));
			jobj.put("valueField",-1);
		}
		jobj.put("displayField",_mapping.getTextDescription("admin.common."+strModuleName));
		jobj.put("valueField",strModuleName);
		mList.add(jobj);
	}
	rootJson.put("SelectedModule",mList);

	JSONArray listArr = new JSONArray();
	JSONArray selectedEnabledList = new JSONArray();
	String chCkcomp = serIni.getValue("MISC_ARGS","DisableTrendComputation");
	for (int i=0;i<aListQuickMenuItems.size();i++)
	{
		JSONObject enabledlist = new JSONObject();
		String strQuickMenuItem = (String)aListQuickMenuItems.get(i);
		enabledlist.put("valueField",strQuickMenuItem);
		enabledlist.put("displayField",_mapping.getQuickLinkDescription(strModule_A+".quickmenu."+strQuickMenuItem));
		if(chCkcomp != null && (chCkcomp.equalsIgnoreCase("YES") || chCkcomp.equalsIgnoreCase("TRUE")))
		{
			if(strQuickMenuItem != null && !(strQuickMenuItem.equalsIgnoreCase("TrendGraph") || strQuickMenuItem.equalsIgnoreCase("SummaryGraph")))
			{
				selectedEnabledList.add(enabledlist);
				listArr.add(enabledlist);
			}
		}
		else
		{
			selectedEnabledList.add(enabledlist);
			listArr.add(enabledlist);
		}
	}
	rootJson.put("selectedEnabledList",selectedEnabledList);

	JSONArray disabledList = new JSONArray();
	JSONArray selectedDisabled  = new JSONArray();
	for (int i=0;i<aListQMMappings.size();i++)
	{
		JSONObject deslist = new JSONObject();
		EgName nameObj = (EgName)aListQMMappings.get(i);
		String actualName = nameObj.getActualName();
		String localName = nameObj.getLocalName();
		deslist.put("valueField",actualName);
		deslist.put("displayField",localName);
		if(chCkcomp != null && (chCkcomp.equalsIgnoreCase("YES") || chCkcomp.equalsIgnoreCase("TRUE")))
		{
			if(localName != null && !(localName.equalsIgnoreCase("Trend Graph") || localName.equalsIgnoreCase("Summary Graph")))
			{
				selectedDisabled.add(actualName);
				disabledList.add(deslist);
				listArr.add(deslist);
			}
		}
		else
		{
			selectedDisabled.add(actualName);
			disabledList.add(deslist);
			listArr.add(deslist);
		}
	}
	rootJson.put("selecteddisabledList",selectedDisabled);
	rootJson.put("disabledList",disabledList);
	rootJson.put("enableDisableList",listArr);

	response.getWriter().write(rootJson.toString());
	
}
catch(Exception e)
{
	e.printStackTrace();
}
%>



