<%
/**
 *	Name		:	EgConfigAggregateJson.jsp
 *	Version		:	1.0
 */
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import="java.sql.*" %>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String test = request.getParameter("test");
	String comp = request.getParameter("comp");

	// aggregate components dont have port. so appending NULL is not a problem
	if(comp != null && !comp.endsWith(":NULL"))
		comp = comp+":NULL";

	String server = request.getParameter("server");
	//out.println("server : " + server);

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager"); 
	String aggregate_test = aggregateInfo.getValue("AGGREGATE_TEST",test);
	rootJson.put("aggregate_test",_mapping.getTestDescription(aggregate_test));
	rootJson.put("compAggName",(comp != null && comp.endsWith(":NULL") ? comp.substring(0,comp.indexOf(":NULL")) : comp));
	rootJson.put("testt",_mapping.getTestDescription(test));
	
	ArrayList alCompTypes = aggregateInfo.getAssociatedComponentTypes(server+":"+comp);

	//StringTokenizer strTokens = new StringTokenizer(associated_comp_types,",");
	//while(strTokens.hasMoreTokens())
	//	alCompTypes.add(strTokens.nextToken());
	//out.println(alCompTypes);

	List listOfAssociatedComponents = aggregateInfo.getComponentsForDb(server,comp,aggregate_test,alCompTypes);

	//out.println(l);

	ArrayList al_managed = null;
	ArrayList al_managed_WithDescriptors = null;

	ArrayList al_unmanaged = null;
	ArrayList al_unmanaged_WithDescriptors = null;

	ArrayList al_temp = new ArrayList();
	ArrayList al_temp_WithDescriptors = new ArrayList();

	EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
	String status = egDb.setConnection();
	ResultSet rs = null;

	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			for(int i=0;i<listOfAssociatedComponents.size();i++)
			{
				//ResultSet getDetailedMeasuresForAggregateTest(String s_test,String howManyDaysBack,String commaSeparatedComponents)
				rs = egDb.getDetailedMeasuresForAggregateTest(aggregate_test,"1",(String)listOfAssociatedComponents.get(i));
				while(rs.next())
				{
					//TRGT_HOST,PORT_NO,SITE_NAME,INFO (measure_last)
					String trgt_host = rs.getString(1);
					String port_no = rs.getString(2);
					String site_name = rs.getString(3);
					String info = rs.getString(4);

					//if (site_name.equals("NULL"))
					//		site_name = "NONE";
					
					if (info.startsWith("+"))
					{
						if (info.equals("+"))
						{
							if (site_name.equals("NULL"))
								al_temp.add(trgt_host + ":" + port_no + ":NONE");
							else
								al_temp.add(trgt_host + ":" + port_no + ":" + site_name);
							al_temp_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
						}
						else
						{
							if (site_name.equals("NULL"))
								al_temp.add(trgt_host + ":" + port_no + ":NONE:" + info.substring(1,info.length()));	
							else
								al_temp.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info.substring(1,info.length()));	
							al_temp_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
						}
					}
					else
					{
						if (info.endsWith("+"))
						{
							al_temp.add(trgt_host + ":" + port_no + ":" + info.substring(0,info.indexOf('+')));	
							al_temp_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
						}
						else 
						{
							al_temp.add(trgt_host + ":" + port_no + ":" + info.substring(0,info.indexOf('+')) + ":" + info.substring(info.indexOf('+')+1,info.length()));	
							al_temp_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
						}
					}
				}
			}
			if (rs != null)
			{
				rs.close();
			}
		}
		egDb.releaseConnection(false);
	}
	catch(Exception e)
	{
		egDb.releaseConnection(true);
		e.printStackTrace();
	}
	EgDbAdapterTypeUI.releaseObject(egDb);

	al_unmanaged = new ArrayList();
	al_unmanaged_WithDescriptors = new ArrayList();

	String[] variables = aggregateInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");

	if ((variables != null) && (variables.length > 0))
	{
		for(int j=0;j<variables.length;j++)
		{
			if (variables[j].startsWith(test+":"+server+":"+comp))
			{
				//al_unmanaged.add(variables[j].substring(variables[j].indexOf("#")+1,variables[j].length()));
				
				String s1 = variables[j].substring(variables[j].indexOf("#")+1,variables[j].length());
				boolean infoEndsWithColon = false;
				if(s1.endsWith(":"))
					infoEndsWithColon = true;
				StringTokenizer st = new StringTokenizer(s1,":");

				String trgt_host = st.nextToken();
				String port_no = st.nextToken();
				String site_name = st.nextToken();
				String info ="";
				while(st.hasMoreTokens())
				{
					if(info.equals(""))
						info = st.nextToken();
					else
						info = info+":"+st.nextToken();
				}
				if(infoEndsWithColon)
					info = info+":";

				if (info.startsWith("+"))
				{
					if (info.equals("+"))
					{
						if (site_name.equals("NULL"))
							al_unmanaged.add(trgt_host + ":" + port_no + ":NONE");
						else
							al_unmanaged.add(trgt_host + ":" + port_no + ":" + site_name);
						al_unmanaged_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
					else
					{
						if (site_name.equals("NULL"))
							al_unmanaged.add(trgt_host + ":" + port_no + ":NONE:" + info.substring(1,info.length()));	
						else
							al_unmanaged.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info.substring(1,info.length()));	
						al_unmanaged_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
				}
				else
				{
					if (info.endsWith("+"))
					{
						al_unmanaged.add(trgt_host + ":" + port_no + ":" + info.substring(0,info.indexOf('+')));	
						al_unmanaged_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
					else
					{
						al_unmanaged.add(trgt_host + ":" + port_no + ":" + info.substring(0,info.indexOf('+')) + ":" + info.substring(info.indexOf('+')+1,info.length()));	
						al_unmanaged_WithDescriptors.add(trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
				}
			}
		}
	}

	if (al_unmanaged.size() == 0)
	{
		al_managed = al_temp;
		al_managed_WithDescriptors = al_temp_WithDescriptors;
	}
	else
	{
		al_managed = new ArrayList();
		al_managed_WithDescriptors = new ArrayList();

		for(int i=0;i<al_temp.size();i++)
		{
			Object temp = al_temp.get(i);
			if (!al_unmanaged.contains(temp))
			{
				al_managed.add(temp);
				al_managed_WithDescriptors.add(al_temp_WithDescriptors.get(i));
			}
		}
	}
	String previousIncludedDescriptors = null;

	JSONArray enabledTestsArr = new JSONArray();
	JSONObject enabledTests = new JSONObject();
	JSONArray commonTests = new JSONArray();
	JSONObject commonObject = new JSONObject();

	for(int i=0;i<al_managed.size();i++)
	{
		String mStr = (String) al_managed_WithDescriptors.get(i);
		//if(mStr.indexOf("+") != -1)
		//{
			//mStr = StringUtils.replace(mStr,"+","");
		//}
		if(mStr.indexOf(":NULL") != mStr.lastIndexOf(":NULL"))
		{
			int idx = mStr.lastIndexOf(":NULL");
			mStr = new StringBuffer(mStr).replace(idx+1,idx+5,"NULL").toString();
		}

		if(i==0)
			previousIncludedDescriptors = mStr;
		else
			previousIncludedDescriptors += "," + mStr;
		
		
		commonObject.put("displayField",deleteNull((String)al_managed.get(i)));
		commonObject.put("valueField",(String)al_managed_WithDescriptors.get(i));
		commonTests.add(commonObject);

		enabledTests.put("displayField",deleteNull((String)al_managed.get(i)));
		enabledTests.put("valueField",(String)al_managed_WithDescriptors.get(i));
		enabledTestsArr.add(enabledTests);

		//enabledTests.add((String)al_managed_WithDescriptors.get(i));
	}

	JSONArray disableTestsArr = new JSONArray();
	JSONObject disableTests = new JSONObject();

	for(int i=0;i<al_unmanaged.size();i++)
	{
		commonObject.put("displayField",deleteNull((String)al_unmanaged.get(i)));
		commonObject.put("valueField",(String)al_unmanaged_WithDescriptors.get(i));
		commonTests.add(commonObject);
		disableTests.put("displayField",deleteNull((String)al_unmanaged.get(i)));
		disableTests.put("valueField",(String)al_unmanaged_WithDescriptors.get(i));
		disableTestsArr.add(disableTests);
	}

	if (previousIncludedDescriptors == null)
	{
		rootJson.put("previousIncludedDescriptors","null");
	}
	else
	{
		rootJson.put("previousIncludedDescriptors",previousIncludedDescriptors);
	}
	rootJson.put("itemSelectorValue",commonTests);
	rootJson.put("disableTests",disableTestsArr);
	rootJson.put("enabledTests",enabledTestsArr);
	out.println(rootJson.toString());
%>

<%!
	private String deleteNull(String desc)
	{
		int nullIndex =  desc.indexOf(":NULL:");
		if(nullIndex != -1)
		{
			return desc.substring(0,nullIndex)+desc.substring(nullIndex+5);
		}		
		return desc;
	}
%>



