<%
/*******************************************************************************
*	File name		:	alarmWindow.jsp
*	Purpose			:	To show the zone alarms. This is being used with the maps.
*	Version			:	eG 4.0
*	Authtor			:	N.Gokulanand
*	Creation Date	:	July-23-2007
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "java.sql.Statement"%>
<%@ page import = "java.sql.ResultSet" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "com.eg.EgAlarmTable"%>
<%@ page import = "com.eg.EgAgentInfo"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="net.sf.json.*"%>
<%@page import = "java.util.*"%>
<%@ page import = "com.eg.EgFormatInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.monitor.EgServerDashBoardDAO"%>
<%@ page import = "com.egurkha.monitor.MonitorDAOFactory"%>
<%@ page import = "java.text.*" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgUtils"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	String fromPage=request.getParameter("fromPage");
	boolean isPublishedMyDashboard=false;
	if(fromPage!=null && fromPage.equalsIgnoreCase("mydashboard"))
	{
		String anonymousUser=request.getParameter("anonymousUser");
		if(anonymousUser!=null && anonymousUser.equalsIgnoreCase("true"))
		{
			isPublishedMyDashboard = true;
		}
	}
	User user=null;
	if(isPublishedMyDashboard)
	{
		String profName = request.getParameter("profileName");
		if(!StringUtils.isNull(profName))
		{
			profName=StringUtils.decodeSecurityChar(profName);
		}
		String userId=null;
		ArrayList profWithUser=EgUtils.egTokenizer(profName,"|USRSEP|",false,false,false);
		if ( profWithUser != null && profWithUser.size()==2 )
		{
			userId = (String) profWithUser.get(1);
		}
		if(!StringUtils.isNull(userId))
		{
			ErUserData userData = new ErUserData(userId,false);
			if(userData!=null)
			{
				user=userData.usr;
				if(user==null)
				{
					user = userData.getUser(userId);
				}
			}
		}
	}
	else
	{
		UserRegistry userReg = UserRegistry.getInstance();
		user = userReg.getUser(session.getId());
	}
	response.setContentType("application/json");
	EgSpecsInfo specObj = new EgSpecsInfo("manager");
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String zoneName = request.getParameter("zone");
	String subZone = request.getParameter("subZone");
	int subZoneCount = Integer.parseInt(subZone);
	boolean emptyCheck = false;
	//UserRegistry registry = UserRegistry.getInstance();
	//User user = registry.getUser(session.getId());
	String loginid = user.getLoginID();
	String thisLanguage = ui.getDefaultLanguage();
	boolean from_sm = false;
	String sessionId_sm = null;
	String monitor_Skin = null;
	TreeMap linksMap = new TreeMap();
	User u_ser = null;
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
	}
	if (u_ser!=null)
	{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
	}
	
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList elementList = groupInfo.getAllComponentsUnderZone(zoneName);
	ArrayList componentList = new ArrayList();
	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	
	for(int i=0; i<elementList.size(); i++)
	{
		String compWithType = (String)elementList.get(i);
		if(compWithType != null && compWithType.startsWith("Group"))
		{
			ArrayList grpComps = groupInfo.getAllComponentsUnderGroup(compWithType);
			componentList.addAll(grpComps);
		}
		else
			componentList.add(compWithType);
	}
	//String s_optionValue = "";
	//String arr_optionsValue[] = StringUtils.getTokens(s_optionValue,",");
	
	JSONObject componentsObject  = new JSONObject();
	JSONObject errorObject = new JSONObject();
	JSONObject screenLabels  = new JSONObject();
	JSONArray  zoneArray = new JSONArray();
	
	String selectedOption = request.getParameter("showAlarms");
	if(selectedOption==null)
		selectedOption = "";
	int[] priorities = {10, 2, 1};
	
	screenLabels.put("admin.zoneMap.Dashboard",mappingInfo.getTextDescription("admin.zoneMap.Dashboard"));
	
	if(subZoneCount!= 0){
		String subZoneMap = "/final/monitor/zoneMap.jsp?Zone="+EgURLEncoder.encode(zoneName,"UTF-8");
		screenLabels.put("admin.zoneMap.Subzone Map",mappingInfo.getTextDescription("admin.zoneMap.Subzone Map"));
		screenLabels.put("subZoneMap",subZoneMap);
	}else{
		screenLabels.put("admin.zoneMap.Subzone Map","");
		screenLabels.put("subZoneMap","");
	}
	
	String bulletImageSrc = EgStateZone.getState("Zone:"+zoneName+":NULL");

	String Dashboard = "/final/monitor/zoneDash.jsp?selectNode=Zone$cap$"+EgURLEncoder.encode(zoneName,"UTF-8")+"&selectedParam="+EgURLEncoder.encode(zoneName,"UTF-8")+"&currentTab=details&zoneName="+EgURLEncoder.encode(zoneName,"UTF-8")+"&openNode=null&treeFlag=false&outsideZone=true&titleText="+EgURLEncoder.encode(zoneName,"UTF-8")+"&zoneFromZone="+EgURLEncoder.encode(zoneName,"UTF-8")+"&fromPageView=ZoneMap";
	screenLabels.put("bulletImageSrc",bulletImageSrc);
	screenLabels.put("Dashboard",Dashboard); 
	screenLabels.put("zoneName",zoneName); 
	
%>

<%
	//Local Variable declarations
	String status="";
	String strName="";
	String strType="";
	String disp_strType="";
	String strLayer="";
	String strTime="";
	String strPriority="";
	String strProblem="";
	Vector v_alarms = new Vector();
	String str_site = "";
	String str_test = "";

	//one of the new strings for vips
	String str_u_comp = "";
	Statement st=null;
	ResultSet rs=null;
	boolean b_state = false;
	boolean b_recordspresent = false;
	/*
	 * Increment values used for alarms DIV display.
	 * DO NOT CHANGE IT UNLESS YOU KNOW WHAT YOU ARE DOING.
	 */
	int k;
	int noalarms = 0;
	/*
	 * For showing last measurement value
	 */
	boolean showLastMeasurementValue = false;
	//showLastMeasurementValue = si.getMailLastValue();
	List siteNames = new LinkedList();
	siteNames.addAll(user.getSites());
	siteNames.addAll(user.getServices());
	boolean isDeleteAllowed = ui.isDeleteAlarmsEnabled(user.getLoginID());
	boolean isAcknowledgeAllowed = ui.isAcknowledgeEnabled(user.getLoginID());
	Vector v_user_comp = new Vector();
	v_user_comp.addAll(user.getServers(false));
	Vector v_user_comp_notype = new Vector();
	Map tests = null;
	if (!user.isSuperMonitor())
		tests = user.getTests();
	for(int x=0;x < v_user_comp.size();x++)
	{
		String s_tmp = (String)v_user_comp.elementAt(x);
		s_tmp = s_tmp.substring(s_tmp.indexOf(":") + 1);
		s_tmp = s_tmp.substring(0,s_tmp.indexOf(":"));
		s_tmp = s_tmp + ":NULL";
		v_user_comp_notype.add(s_tmp);
	}
	String dashboardConfig = "eg_dashboardConfig.ini";
	String egConfigDir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile dashboardConfigIni = new IniFile(egConfigDir + dashboardConfig);
	String hide_Test[] = dashboardConfigIni.getVariables("HIDE_MEASURES_FROM_UI_ALARMS");
	ArrayList hideAllTest = new ArrayList();
	Hashtable hideMeasures = new Hashtable();
	
	if(hide_Test!=null && hide_Test.length>0)
	{
		for(int m=0; m<hide_Test.length; m++)
		{	
			String test_val = hide_Test[m];
			String hide_TestVal=(String)dashboardConfigIni.getValue("HIDE_MEASURES_FROM_UI_ALARMS",test_val);
			
			if(hide_TestVal!= null && hide_TestVal.equalsIgnoreCase("All"))
			{
				hideAllTest.add(test_val);
			}
			else
			{
				if(hide_TestVal!= null && hide_TestVal.trim().length() >0 && !hide_TestVal.equalsIgnoreCase("All"))
				{
					ArrayList hide_Measure = com.egurkha.util.StringUtils.egTokenizer(hide_TestVal, ",", false,true,false);
					hideMeasures.put(test_val,hide_Measure);
				}
				
			}
		}
	}		
	EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
	status=egDb.setConnection();
	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			String str_user_comp = null;
			String str_tmpcomp = null;
			String str_u_comp_type = null;
			StringBuffer sb = new StringBuffer(128);
			v_alarms.clear();
			rs = egDb.SelectAlarms(StringUtils.replace(selectedOption,'&',','));
			b_state=egDb.getState();
			while(rs.next())
			{
				sb = new StringBuffer(128);
				str_u_comp = rs.getString("COMP_NAME");
				str_u_comp_type = rs.getString("COMP_TYPE");
				str_user_comp = str_u_comp_type + ":" + str_u_comp;
						
				String prob_desc_temp = rs.getString("PROBLEM_DESC");
				StringBuffer tempSb = new StringBuffer();
				if( (hideAllTest != null && hideAllTest.size() > 0 ) || (hideMeasures != null && hideMeasures.size() > 0) )
				{
					if(prob_desc_temp != null && prob_desc_temp.trim().length() > 0)
					{
						ArrayList st_probs = StringUtils.egTokenizer(prob_desc_temp,",",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
						for(int i=0;i<st_probs.size();i++)
						{
							String problem_Desc = (String)st_probs.get(i);
							ArrayList prob_List = StringUtils.egTokenizer(problem_Desc,"|",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(prob_List != null && prob_List.size() == 5)
							{
								String testName = (String)prob_List.get(2);
								String measureName = (String)prob_List.get(3);						
								if(hideAllTest != null && hideAllTest.size() > 0 && hideAllTest.contains(testName))
								{
									continue;
								}
								else if(hideMeasures != null && hideMeasures.containsKey(testName))
								{
									ArrayList measureList = (ArrayList)hideMeasures.get(testName);
									
									if(measureList != null && measureList.size() > 0 && measureList.contains(measureName))
									{
										continue;
									}
									else
									{
										tempSb.append(problem_Desc+",");
									}
								}
								else
								{
									tempSb.append(problem_Desc+",");
								}
							}
						}
						prob_desc_temp = tempSb.toString();
						if(prob_desc_temp != null && prob_desc_temp.endsWith(","))
							prob_desc_temp = prob_desc_temp.substring(0,prob_desc_temp.length()-1);
					}
				}

				if(prob_desc_temp == null || prob_desc_temp.trim().length() == 0)
					continue;

				boolean bf = false;
				if(str_user_comp.startsWith("Host_system"))
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp,"/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp_notype.contains(str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp_notype.contains(str_u_comp))
					{
						bf = true;
					}
				}
				else
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp, "/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp.contains(str_u_comp_type + ":" + str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp.contains(str_user_comp))
					{
						bf = true;
					}
				}
				if(bf)
				{
					//String prob_desc = rs.getString("PROBLEM_DESC");
					String prob_desc = prob_desc_temp;
					boolean pd_flag = false;
					boolean isSuperMonitor = user.isSuperMonitor();
					if (user.isSuperMonitor())
						pd_flag = true;
					StringTokenizer st_tmp = new StringTokenizer(prob_desc, ",");
					prob_desc = "";
					str_site = "";
					str_test = "";
					StringTokenizer st_ftmp = null;
					int i_ctr;
					int i_tokens = st_tmp.countTokens();
					for(i_ctr=0;i_ctr < i_tokens; i_ctr++)
					{
						String tmp_sitestr = st_tmp.nextToken();
						if (isSuperMonitor)
						{
							prob_desc += ","+tmp_sitestr;
							continue;
						}
						st_ftmp = new StringTokenizer(tmp_sitestr,"|");
						str_site = st_ftmp.nextToken();
						String inf = st_ftmp.nextToken();
						String test = st_ftmp.nextToken();
						if(siteNames.contains(str_site) || str_site.equals("NULL"))
						{
							if (tests != null &&
								tests.containsKey(test))
							{
								prob_desc += "," + tmp_sitestr;
								pd_flag = true;
							}
						}
					}
					if(pd_flag)
					{
						b_recordspresent=true;
						v_alarms.add(str_u_comp);
						v_alarms.add(str_u_comp_type);
						v_alarms.add(rs.getString("LAYER_NAME"));
						v_alarms.add(rs.getString("MS_TIME"));
						v_alarms.add(rs.getString("PRIORITY"));
						v_alarms.add(prob_desc.substring(1,prob_desc.length()));
						v_alarms.add(rs.getString("ALARM_ID"));
					}
				}
			}
			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception bug123)
				{
				}
			}
			if(b_recordspresent==false)
			{
				noalarms = 1;
			}
			b_recordspresent=false;
		}
		egDb.releaseConnection(false);
	}
	catch(Exception e)
	{
		String s_errmsg = "";
		if(!status.equals("CONNECTED"))
		{
			s_errmsg = "Could not establish connection with the database";
		}
		else if(b_state == false)
		{
			s_errmsg = "Error in query due to invalid connection";
		}
		else
		{
			s_errmsg = e.toString();
		}
		if (rs != null)
		{
			try
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ec)
		{
		}
		s_errmsg = "EgProbsM.jsp?msg=" + s_errmsg;
%>
	
<%
		return;
	}
	EgDbAdapterTypeUI.releaseObject(egDb);
	if(noalarms!=1)
	{
		k=0;
		DateTimeTokenizer dtt = new DateTimeTokenizer();
		dtt.setDateFormat(DateTimeTokenizer.MDY);
		dtt.setTimeFormat(DateTimeTokenizer.HMS);
		egDb = EgDbAdapterTypeUI.getObject();
		status=egDb.setConnection();
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		String compLink = "";
		String compDescriptionLink = "";
		String componentName = "";
		ArrayList excludeDDTestList = formatInfo.getHideDDTestList();
		Hashtable alertParams = new Hashtable();
		
		for(int v_ctr=0; v_ctr < v_alarms.size(); v_ctr=v_ctr + 7)//--------------------------------------------------------
		{
			strName=(String) v_alarms.elementAt(v_ctr);
			strType=(String) v_alarms.elementAt(v_ctr + 1);
			if(strType.indexOf("_") > 0 && !strType.endsWith("_ex"))
			{
				String tmpstrType=strType.toUpperCase();
				if (tmpstrType.endsWith("_SYSTEM") || tmpstrType.endsWith("_SERVER"))
					disp_strType = strType.substring(0, strType.lastIndexOf("_"));
				else
					disp_strType=strType;
			}
			else
			{
				disp_strType = strType;
			}
			strLayer=(String) v_alarms.elementAt(v_ctr + 2);
			dtt.setYearAsYY(true);
			dtt.setStartDateTime((String) v_alarms.elementAt(v_ctr + 3));
			strTime = dtt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR) + DateTimeTokenizer.BLANK_SPACE + dtt.getStartTimeAsFormat(DateTimeTokenizer.HM,DateTimeTokenizer.COLON_SEPARATOR);
			strPriority = (String) v_alarms.elementAt(v_ctr + 4);	
			int priority = priorities[0];	//At the moment equals 10
			if(strPriority.equalsIgnoreCase(AlarmPriorities.HIGH_PRIORITY))
			{
				priority = 2;
			}
			else if(strPriority.equalsIgnoreCase(AlarmPriorities.MEDIUM_PRIORITY))
			{
				priority = 1;
			}
			else
			{
				priority = 0;
			}
			String[] compNameTokens = StringUtils.getTokens(strName, "/");
			str_u_comp = compNameTokens[0];

			strProblem = (String) v_alarms.elementAt(v_ctr + 5);
			StringTokenizer sta = new StringTokenizer(strProblem, ",");
			int index = -1;
			String mHost = "";
			int tokensCount = sta.countTokens();
			List row = new LinkedList();
			String inf = "";
			String tmpInf = "";
			int noOftoken = 0;
			String infoForFirstAlert= "";
			while (sta.hasMoreTokens())
			{
				try
				{
					String problemDesc = sta.nextToken();
					StringTokenizer st_ftmp = new StringTokenizer(problemDesc ,"|");
					str_site =st_ftmp.nextToken();
					inf = st_ftmp.nextToken();
					tmpInf = inf;
					noOftoken +=1;
					if(tmpInf!=null && tmpInf.indexOf("+")>-1)
					{
						if(tmpInf.startsWith("+"))
						{
							tmpInf="+"+com.egurkha.util.StringUtils.replace(tmpInf.substring(1),"+","|plus|");
						}
						else
						{
							tmpInf=com.egurkha.util.StringUtils.replace(tmpInf,"+","|plus|");
						}
					}
					if(tmpInf!=null && tmpInf.indexOf("&")>-1)
					{
						tmpInf=com.egurkha.util.StringUtils.replace(tmpInf,"&","|amp|");
					}
					if(tmpInf!=null && tmpInf.indexOf("%")>-1)
					{
						tmpInf=com.egurkha.util.StringUtils.replace(tmpInf,"%","|pct|");
					}
					if(tmpInf.startsWith("+"))
						tmpInf = EgURLEncoder.encode(tmpInf.substring(1),"UTF-8");
					String test = st_ftmp.nextToken();
					str_test = test + "- " + tmpInf;
					String measure = st_ftmp.nextToken();
					if((!siteNames.contains(str_site)) && (!str_site.equals("NULL")))
					{
						continue;
					}
					String[] values;
					if (showLastMeasurementValue)
					{
						values = new String[6];
					}
					else
					{
						values = new String[5];
					}
					values[0] = test;
					values[1] = measure;
					values[2] = str_site;
					values[3] = inf;
					values[4] = st_ftmp.nextToken();

					/*
					 * For clubbed alarms, the DispLayers page shows information for
					 * the first component. So use the measurement host of the first
					 * component only.
					 */

					 if(noOftoken==1)
					 {
						infoForFirstAlert = inf;
					 }
					if((","+mHost+",").indexOf("," + values[4] + ",")==-1)
					mHost += values[4]+",";
					if (showLastMeasurementValue && status != null && status.equals("CONNECTED"))
					{
						int count = 0;
						while (count < compNameTokens.length)
						{
							/*
							 * Use the measurement host of each individual row to
							 * get the last measured value.
							 */
							double lastValue = getLastValue(compNameTokens[count], str_site, test, measure, inf, values[4], egDb);
							if (lastValue != -1)
							{
								values[5] = String.valueOf(lastValue);
								row.add(values);
								break;
							}
							count++;
						}
					}
					else
					{
						row.add(values);
					}
				}catch(Exception e){}
			}
			
			if (mHost!=null && mHost.length()>0) 
				mHost = java.net.URLEncoder.encode(mHost.substring(0,mHost.length()-1));
			StringBuffer value = new StringBuffer(64);
			if(isDeleteAllowed || isAcknowledgeAllowed)
			{
				char separator = '@';
				for(int i = 0; i<compNameTokens.length;i++)
				{
					if (i!=0) value.append("#");
					String s_comp=compNameTokens[i];
					value.append(s_comp);		//CompName
					//Check for the number of : in str_u_comp
					index = s_comp.indexOf(":");
					int lastIndex = s_comp.lastIndexOf(":");
					if ((index == lastIndex) && (index != -1))
					{//Only one : is present
						value.append(":");
					}
					//description
					value.append(separator);
					value.append(strType);			//CompType
					value.append(separator);
					value.append(strLayer);			//Layer
					value.append(separator);
					value.append(strProblem);		//That which contains , and |
				}
				value.append("$");
				value.append(v_alarms.elementAt(v_ctr+6));
			}
			boolean dispAckImg = false;
			String dispDesc = "";
			String dispUser = "";
			EgAlarmTable.clearAckAlarms();
			Hashtable usersAlarm = EgAlarmTable.getAllUsersAckAlarms();
			if(usersAlarm!=null && usersAlarm.size() > 0)
			{
				Enumeration users = usersAlarm.keys();
				while(users.hasMoreElements())
				{
					String us = (String)users.nextElement();
					Hashtable usAlarm = (Hashtable)usersAlarm.get(us);
					if(usAlarm!=null && usAlarm.size() > 0)
					{
						Enumeration alarmIds = usAlarm.keys();
						while(alarmIds.hasMoreElements())
						{
							String alarmId = (String)alarmIds.nextElement();
							String alarmDesc = (String)usAlarm.get(alarmId);
							if(alarmId.equals(v_alarms.elementAt(v_ctr+6)))
							{
								dispAckImg = true;
								dispDesc = alarmDesc.trim();
								dispUser = us;
								break;
							}
						}	
					}	
				}
			}
			String displayString = null;
			displayString = strName;
			boolean isOracleComp=false;
			String sid = "";
			if(displayString!= null && displayString.trim().length()>0)
			{
				StringTokenizer valTokens_1 = new StringTokenizer(displayString,":");
				int count_1 = valTokens_1.countTokens(); 						
				String h_Name = "";
				String h_Port = "";
				if(count_1==3)
				{
					isOracleComp=true;
					h_Name = valTokens_1.nextToken();
					h_Port = valTokens_1.nextToken();
					sid = valTokens_1.nextToken();
				}  
			}
			StringBuffer disp_key = new StringBuffer();
			String disp_vals[] = null;
			try
			{
				disp_vals = (String[])row.get(0);
				disp_key.append(disp_vals[0]);
				disp_key.append(":");
				disp_key.append(disp_vals[1]);
			}
			catch(Exception disp){}
			
			String[] values1 = null;
			for (Iterator iterator = row.iterator(); iterator.hasNext();)
			{
				values1 = (String[]) iterator.next();
				break;
			}
			String tmpInfo = null;
			alertParams = new Hashtable();
			alertParams.put("$componentType",mappingInfo.getComponentTypeDescription(strType));
			alertParams.put("$componentName",Server.getServerNameWithoutPort(strName, false));
			if(disp_vals[3]!=null && disp_vals[3].trim().length()>1){
				if(disp_vals[3].startsWith("+")){
					tmpInfo = disp_vals[3].substring(1);
					alertParams.put("$info",tmpInfo);
				}
				else
					alertParams.put("$info",disp_vals[3]);
			}
			 String measureAlert = tablesInfo.getMeasureAlert(disp_key.toString(),disp_vals[3],thisLanguage,alertParams);
			if(measureAlert != null && measureAlert.indexOf("~!~") != -1){
				boolean infoAdded = Boolean.parseBoolean(measureAlert.substring(measureAlert.indexOf("~!~")+3));
				measureAlert = measureAlert.substring(0,measureAlert.indexOf("~!~"));
				if(measureAlert != null && !infoAdded && tmpInfo!=null && tmpInfo.trim().length()>1)
						 measureAlert += "{"+tmpInfo+"}";
			}
			String qtipText = "";
			if(measureAlert != null && measureAlert.indexOf("<span") != -1){
				qtipText = measureAlert.substring(0,measureAlert.indexOf("<span"));
			}

			/*if (measureAlert.length() > 70)
			{
				measureAlert = StringUtils.elipsis(measureAlert, 70);
			}*/
			
			if (infoForFirstAlert.startsWith("+"))
			{
				infoForFirstAlert = infoForFirstAlert.substring(1);
			}
			
			if(infoForFirstAlert!=null && !infoForFirstAlert.equals(""))
			{
				if(isOracleComp)
				{ 	
					if(infoForFirstAlert!=null && infoForFirstAlert.startsWith("*"))
						infoForFirstAlert=sid+"*";
					else
						infoForFirstAlert=sid+"*"+infoForFirstAlert;
				}
				else
				{
					if(infoForFirstAlert!=null && infoForFirstAlert.startsWith("*"))
						infoForFirstAlert=infoForFirstAlert;
					else
						infoForFirstAlert="*"+infoForFirstAlert;
				}
				
			}
			else
			{
				infoForFirstAlert=sid+"*"+infoForFirstAlert;
			}
			StringTokenizer sbComp = new StringTokenizer(displayString, "/");
			while(sbComp.hasMoreTokens())
			{
				String thisToken = sbComp.nextToken();
				String compInfo = thisToken;
				int colonIndex = thisToken.indexOf(":");
				String serverName = "";
				serverName = strType+":"+thisToken;

				String name ="";
				for(int i=0; i<componentList.size(); i++)
				{
					JSONObject JSONComponent = new JSONObject();
					String compName = Server.getServerName(componentList.get(i).toString());
					String componentType = Server.getServerType(componentList.get(i).toString());
					boolean zoneServers = false;
					String zServers = componentType+":"+compName;
					int hostCompIndex = compName.indexOf(":");
					String hostCompName ="";
					String oraCompName ="";
					boolean isDDExists  =  formatInfo.isDdEnabled(values1[0].trim(), values1[1].trim());
					boolean isScreenShotEnabled = false;
					//Fix to hide DD icon based on Ini entry
					if(excludeDDTestList != null && excludeDDTestList.size() > 0 && excludeDDTestList.contains(values1[0].trim()))
					{
						isDDExists = false;
					}
					if(isDDExists)
					{
						isScreenShotEnabled = formatInfo.isSSHandledTest(values1[0].trim());	
						if(EgInstallInfo.isSuperManager)
							isScreenShotEnabled =false;
					}
					//end
					String dbMeasure = dbInfo.getColumnForMeasure(values1[0].trim(), values1[1].trim());
					if(hostCompIndex != -1)
					{
						hostCompName  =  compName.substring(0,hostCompIndex)+":NULL";
						oraCompName = compName.substring(0,hostCompIndex);
					}
					else
						hostCompName = compName;
					String zServer = "Host_system:"+hostCompName;
					String oraServer = "Host_system:"+oraCompName;
					if(serverName.equals(zServer))
						zoneServers = true;
					else if(serverName.equals(zServers))
						zoneServers = true;
					else if(serverName.equals(oraServer))
						zoneServers = true;
					if(zoneServers)
					{
						emptyCheck = true;

						String msmtHost = "";
						boolean isExternalTest = specObj.isExternalTest( str_test.substring(0, str_test.indexOf("-")) );
						if(isExternalTest)
							msmtHost = mHost;
					

%>
<%
						JSONComponent.put("rowId",strPriority);
						String testNow = str_test.substring(0, str_test.indexOf("-"));
						if((testNow.endsWith("_ag") || testNow.endsWith("_agx")) && EgInstallInfo.isAggregationSupported())
						{
							String strTypeNow = strType;
							if(strTypeNow.equalsIgnoreCase("Host_system"))
							{
								String foundoutNick = thisToken.indexOf(":")>-1?(thisToken.substring(0,thisToken.indexOf(":"))):thisToken;
								List foundoutServerTypes = new com.eg.EgDiscInfo("manager").getServerTypesForNick(foundoutNick);
								if(foundoutServerTypes !=null && foundoutServerTypes.size() >0)
									strTypeNow = foundoutServerTypes.get(0).toString();
							}
%>		
<%
							 compLink = "/final/monitor/aggDashboard.jsp?layerTestMeasure=true&msmt_host="+msmtHost+"&qctr=2&fromalarm=1&host="+thisToken+"&layer="+
								strLayer+"&site=NULL&test="+str_test+"&comptype="+strTypeNow; 
								componentName = thisToken.endsWith(":NULL")?thisToken.substring(0, thisToken.lastIndexOf(":")):thisToken;
								JSONComponent.put("compLink",compLink);
								JSONComponent.put("compName",componentName);
						}
						else
						{
%>
							
<%
							 compLink = "EgSiteInfraView.jsp?qctr=2&fromalarm=1&host="+EgURLEncoder.encode(thisToken,"UTF-8")+"&layer="
										+EgURLEncoder.encode(strLayer,"UTF-8")
									    +"&site="+EgURLEncoder.encode(str_site,"UTF-8")+"&test="+str_test+"&comptype="+EgURLEncoder.encode(strType,"UTF-8")+"&msmt_host="
										+msmtHost+"&toDashBoardLayer=true&gotoLayerModel=true&treeTitle=zoneMap";
							componentName = thisToken.endsWith(":NULL")?thisToken.substring(0, thisToken.lastIndexOf(":")):thisToken;
							JSONComponent.put("compLink",compLink);
							JSONComponent.put("compName",componentName);
						}
%>
						
<%
						testNow = str_test.substring(0, str_test.indexOf("-"));
						if((testNow.endsWith("_ag") || testNow.endsWith("_agx")) && EgInstallInfo.isAggregationSupported())
						{
							String strTypeNow = strType;
							if(strTypeNow.equalsIgnoreCase("Host_system"))
							{
								String foundoutNick = thisToken.indexOf(":")>-1?(thisToken.substring(0,thisToken.indexOf(":"))):thisToken;
								List foundoutServerTypes = new com.eg.EgDiscInfo("manager").getServerTypesForNick(foundoutNick);
								if(foundoutServerTypes !=null && foundoutServerTypes.size() >0)
									strTypeNow = foundoutServerTypes.get(0).toString();
							}
%>		
<%
							compDescriptionLink = "/final/monitor/aggDashboard.jsp?layerTestMeasure=true&msmt_host="+msmtHost+"&qctr=2&fromalarm=1&host="+
													thisToken+"&layer="+strLayer+"&site=NULL&test="+str_test+"&comptype="+strTypeNow ;
							JSONComponent.put("compDescriptionLink",compDescriptionLink);
							JSONComponent.put("compDescription",measureAlert);
							JSONComponent.put("qtipText",qtipText);
						}
						else
						{
%>
							
<%
						compDescriptionLink = "EgSiteInfraView.jsp?qctr=2&fromalarm=1&host="+EgURLEncoder.encode(thisToken,"UTF-8")+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+
						"&site="+EgURLEncoder.encode(str_site,"UTF-8")+"&test="+str_test+"&comptype="+EgURLEncoder.encode(strType,"UTF-8")+"&msmt_host="+msmtHost+"&toDashBoardLayer=true&gotoLayerModel=true&treeTitle=zoneMap";
						JSONComponent.put("compDescriptionLink",compDescriptionLink);
						JSONComponent.put("compDescription",measureAlert);
						JSONComponent.put("qtipText",qtipText);
						}
						
						StringTokenizer valTokens = new StringTokenizer(compInfo,":");
						int count = valTokens.countTokens();
						String hostName = "";
						String hostNamePort = "";
						if(count>=1){
							hostName = valTokens.nextToken();
							hostNamePort = valTokens.nextToken();
						}else{
							hostName = valTokens.nextToken();
						}

						String msmtHostIp = "";
						List agents=egExternalInfo.getAgentsFor(values1[0],strType,hostName);
						if(agents!=null && agents.size()>0)
							msmtHostIp=(String)agents.get(0);
						else
							msmtHostIp=hostName;
						
						String measureLink = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(strType,"UTF-8")+"&site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&info="+EgURLEncoder.encode(infoForFirstAlert,"UTF-8")+"&state="+strPriority+"&messy="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&from=measurespage&userID="+EgURLEncoder.encode(user.getLoginID(),"UTF-8")+"&clicked=graph"+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+ "&test=" + values1[0];
						
						String ddLink = "-";
						if(isDDExists)
						{
							ddLink = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(strType,"UTF-8")+"&site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&info="+EgURLEncoder.encode(infoForFirstAlert,"UTF-8")+"&state="+strPriority+"&messy="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&from=measurespage&dd=yes&userID="+EgURLEncoder.encode(user.getLoginID(),"UTF-8")+"&isScreenShotEnabled="+isScreenShotEnabled+"&clicked=dd"+ "&test=" +values1[0]+"&show=graph";
							measureLink =measureLink +"&show=dd";
						}
						JSONComponent.put("ddLink",ddLink);
						
						JSONComponent.put("graphLink",measureLink);
						
						String compgraphLink = null;
						String graphLink = null;
						String compsummarygraphLink = null;
						String summarygraphLink = null;
						String comptrendgraphLink = null;
						String trendgraphLink = null;
						String historyLink = null;
						String feedbackLink = null;
						String aggLink = null;
						String aggregateLink = null;
						String compddLink =null;
						String dLink = null;
						String feedLink = null;
						String histLink=null;
						String displayname = null;
						String temp_ddLink=null;
						String sessionId = session.getId();
						String windowName = null;						

						dLink = "/final/monitor/EgDiagnosis.jsp?site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&test="+values1[0]+"&isPopUp=true";

						feedLink="/final/monitor/dispComponentFeedback.jsp?site="+str_site+"&trgthost="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&port="+hostNamePort+"&test="+values1[0]+"&comptype="+EgURLEncoder.encode(strType,"UTF-8");

						if(hostName!=null)
						{
							String temp_info="";
							temp_info=infoForFirstAlert;
							temp_info="";
							String component_temp =str_u_comp+":"+strType;
							histLink="/final/monitor/dispComponentHistory.jsp?site="+str_site+"&info=" +EgURLEncoder.encode(temp_info,"UTF-8") + "&test="+values1[0]+ "&component=" +EgURLEncoder.encode(component_temp,"UTF-8");
						}
						else
						{
							String temp_info="";
							temp_info=infoForFirstAlert;
							temp_info="";
							String component_temp =str_u_comp+":"+strType;
							histLink="/final/monitor/dispComponentHistory.jsp?site="+str_site+"&info=" +EgURLEncoder.encode(temp_info,"UTF-8") + "&test="+values1[0]+ "&component="+component_temp;
						}
						String infoForGraphLink = "";
						if(infoForFirstAlert!=null && infoForFirstAlert.equals("") && infoForFirstAlert.trim().length()==0)
							infoForGraphLink = "*";
						else
							infoForGraphLink = infoForFirstAlert;

						compgraphLink = "/final/monitor/dispComponentGraphs.jsp?site="+str_site+"&host=" +EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+"&test="+values1[0]+"&comptype="+EgURLEncoder.encode(strType,"UTF-8");
						
						graphLink = compgraphLink+"&info="+EgURLEncoder.encode(infoForGraphLink,"UTF-8")+"&gtype=1&measure="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&state="+strPriority;

						compsummarygraphLink="/final/monitor/dispComponentSummaryGraphs.jsp?site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+"&test="+values1[0]+"&comptype="+EgURLEncoder.encode(strType,"UTF-8");

						summarygraphLink = compsummarygraphLink+"&info="+EgURLEncoder.encode(infoForFirstAlert,"UTF-8")+"&gtype=1&measure="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&state="+strPriority;

						comptrendgraphLink="/final/monitor/dispComponentTrendGraphs.jsp?site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+"&test="+values1[0]+"&comptype="+EgURLEncoder.encode(strType,"UTF-8");

						trendgraphLink = comptrendgraphLink+"&info="+EgURLEncoder.encode(infoForGraphLink,"UTF-8")+"&gtype=1&measure="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&state="+strPriority;

						aggLink = "/final/monitor/dispAggComponentGraphs.jsp?site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&layer="+EgURLEncoder.encode(strLayer,"UTF-8")+"&test="+values1[0]+"&comptype="+EgURLEncoder.encode(strType,"UTF-8");
						
						historyLink = histLink+"&measure="+dbMeasure;

						String portForMsmtTime="NULL";
						boolean isPortRelevantForTest=false;
						if(specObj.isPortRelevantForTest(values1[0]))
						{
							isPortRelevantForTest=true;
							portForMsmtTime=hostNamePort;
						}
						String key=hostName+":"+portForMsmtTime+":"+values1[0]+":"+msmtHostIp;
						String msmtTimeStr=dashboardDAO.getMeasureLastMsmtTime(key,infoForFirstAlert);
						String msmtTimeStr2="";
						try
						{
							SimpleDateFormat df=new SimpleDateFormat("MM/dd/yyyy*HH:mm:ss");
							SimpleDateFormat sdf2=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							java.util.Date msd=sdf2.parse(msmtTimeStr);
							msmtTimeStr2 =df.format(msd);
						}
						catch(Exception eex)
						{
							System.out.println("Exception--->"+eex.getMessage());
							eex.printStackTrace();
						}
						String measure = values1[1].trim();
						feedbackLink = feedLink +"&info="+EgURLEncoder.encode(infoForGraphLink,"UTF-8")+"&measure="+measure+"&msmttime="+msmtTimeStr2+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8");
						
						aggregateLink = aggLink+"&info="+EgURLEncoder.encode(infoForFirstAlert,"UTF-8")+"&gtype=1&measure="+dbMeasure+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&state="+strPriority;
						
						String infoFordd = null;
						if(infoForFirstAlert==null || infoForFirstAlert.trim().equals(""))
						{
							infoFordd = "NONE";
						}
						else if(infoForFirstAlert!=null && infoForFirstAlert.equals("*"))
						{
							infoFordd = "NONE";
						}
						else
						{
							infoFordd = infoForFirstAlert;
						}
						
						String measureDisplayName = dbInfo.getMeasureForColumn(values1[0].trim(), values1[1].trim());
						if (measureDisplayName==null || measureDisplayName.equalsIgnoreCase("null"))
						{
							measureDisplayName=values1[1].trim();
						}

						dLink = "/final/monitor/EgDiagnosis.jsp?site="+str_site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+hostNamePort+"&test="+values1[0]+"&isPopUp=true";
						compddLink = dLink+"&info="+EgURLEncoder.encode(infoFordd,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHostIp,"UTF-8")+"&measure="+measureDisplayName+"&from=0&firsttime=true&flag=1";
						
						// Rights Symbol replace
						infoForFirstAlert = com.egurkha.util.StringUtils.replace(infoForFirstAlert,"\u00AE","|rights|");
						if(isDDExists)
						{
							linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"compddlink", compddLink);
						}
						
						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"compfeedbacklink", aggregateLink); 

						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"compgraphlink", graphLink);

						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"compsummarygraphlink", summarygraphLink);

						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"comptrendgraphlink", trendgraphLink);

						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"comphistorylink", historyLink);

						linksMap.put(values1[0]+"#"+dbMeasure+"#"+infoForFirstAlert+"#"+msmtHostIp+"compfeedbacklink", feedbackLink);
						
%>
						
				<%
				zoneArray.add(JSONComponent);
					}
				}
			}
			
		}//FOR VALARMS END

		session.setAttribute("Tablinks", linksMap);
		
		try
		{
			if(status != null && status.equals("CONNECTED"))
			{
				egDb.releaseConnection(false);
			}
		}
		catch(Exception e)
		{
			egDb.releaseConnection(true);
		}
		EgDbAdapterTypeUI.releaseObject(egDb);
	}//IF noalarms
	if(!emptyCheck)
	{
		errorObject.put("errorMessage",mappingInfo.getTextDescription("monitor.egNewAlert.No alarms found"));
		errorObject.put("errorImage","/final/images/"+monitor_Skin+"/iconSmiley.png");
%>
				
<%
	}else{
			errorObject.put("errormessage","noError");
	}
		
	componentsObject.put("componentArray",zoneArray);
	componentsObject.put("screenLabels",screenLabels);
	componentsObject.put("errorObject",errorObject);
	
	response.getWriter().write(componentsObject.toString());
%>
<%!

	EgDbInfo dbInfo = new EgDbInfo(EgConstants.MANAGER);
	EgServicesInfo si = new EgServicesInfo("manager");
	EgFormatInfo formatInfo = new EgFormatInfo(EgConstants.MANAGER);
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

	/*
	 * Taken from EgMailManager.java
	 */
	private double getLastValue(
		String cname,
		String site,
		String test,
		String meas,
		String des,
		String mhost,
		EgDbAdapterUI egDb)
	{
		if (site.equalsIgnoreCase("NONE"))
			site = "NULL";

		StringTokenizer st = new StringTokenizer(cname, ":");
		int c = st.countTokens();
		if (c < 2)
			return (-1);

		String host = st.nextToken();
		String port = st.nextToken();
		String finfo = "";

		if (c > 2)
			finfo = st.nextToken();

		if (des != null && des.startsWith("+"))
		{
			des = des.substring(1);
		}
		String realInfo = finfo + EgConfigInfo.infoFieldSeparator + des;
		EgDbInfo dbInfo = new EgDbInfo(EgConstants.MANAGER);
		String col = dbInfo.getColumnForMeasure(test, meas);
		if (col == null || col.length() == 0)
			return (-1);

		String table = EgDbInfo.getTableForTest(test);
		StringBuffer queryStr = new StringBuffer(512);
		queryStr.append("SELECT ");
		queryStr.append(col);
		queryStr.append(" FROM ");
		queryStr.append(table);
		queryStr.append(" WHERE trgt_host='");
		queryStr.append(host);
		queryStr.append("' AND port_no='");
		queryStr.append(port);
		queryStr.append("' AND site_name='");
		queryStr.append(site);
		queryStr.append("' AND info='");
		queryStr.append(realInfo);
		queryStr.append("' AND msmt_time=(SELECT MAX(msmt_time) FROM measure_last WHERE test_name='");
		queryStr.append(test);
		queryStr.append("' AND trgt_host='");
		queryStr.append(host);
		queryStr.append("' AND port_no='");
		queryStr.append(port);
		queryStr.append("' AND site_name='");
		queryStr.append(site);
		queryStr.append("' AND info='");
		queryStr.append(realInfo);
		queryStr.append("' AND msmt_host='");
		queryStr.append(mhost);
		queryStr.append("') AND msmt_host='");
		queryStr.append(mhost);
		queryStr.append("'");

		ResultSet rs = null;
		double val = -1;
		try
		{
			if(EgInstallInfo.isSuperManager)
			{
				Hashtable ht = new Hashtable();
				ht.put("OracleQuery",queryStr.toString());
				ht.put("SqlQuery",queryStr.toString());
				if(host.indexOf(":")>-1)
				{
					host = host.substring(0,host.indexOf(":"));
				}
				ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",host);
				if(managerIds != null && !managerIds.isEmpty())
				{
					ht.put("special_case_mgr_ids",managerIds);
				}
				rs = new EgSMDBHelper().getResultSet(ht);
			}
			else
			{
				rs = egDb.dbselect(queryStr.toString());
			}
			while (rs.next())
			{
				val = rs.getDouble(1);
			}
			rs.close();
		}
		catch (Exception grr)
		{
			grr.printStackTrace();
			if (rs != null)
			try
			{
				rs.close();
			}
			catch (Exception g)
			{
			}
		}
		return (val);
	}
%>