/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgDbInfo;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;

public class APMHashingMsmtUpdater
extends Thread {
    private String tableName;
    private Set hashDetails;

    public APMHashingMsmtUpdater(String string, Set set) {
        this.tableName = string;
        this.hashDetails = set;
        this.setName("APM-MsmtUpdater");
        this.setDaemon(true);
        this.start();
    }

    private Object getPoolManagerInstance(ClassLoader classLoader) {
        Class<?> clazz = null;
        Object object = null;
        try {
            Method method;
            clazz = classLoader.loadClass("egurkhaConnectionPooling.PoolManager");
            if (clazz != null && (method = clazz.getDeclaredMethod("getInstance", new Class[0])) != null) {
                method.setAccessible(true);
                object = method.invoke(clazz, new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private Connection getDbConnection(Object object) {
        Connection connection = null;
        try {
            Method method;
            if (object != null && (method = object.getClass().getDeclaredMethod("getConnection", String.class)) != null) {
                method.setAccessible(true);
                connection = (Connection)method.invoke(object, "sql");
                if (connection != null) {
                    System.out.println("[APMHashingMsmtUpdater] - Got DB connection  @ " + new Date());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[APMHashingMsmtUpdater] - Unable to get DB connection due to " + exception.getMessage() + "@ " + new Date());
        }
        return connection;
    }

    private void freeConnection(Object object, Connection connection) {
        try {
            Method method;
            if (object != null && connection != null && (method = object.getClass().getDeclaredMethod("freeConnection", String.class, Connection.class)) != null) {
                method.setAccessible(true);
                method.invoke(object, "sql", connection);
                System.out.println("[APMHashingMsmtUpdater] - Invoked free connection successfully !!! @ " + new Date());
            }
        }
        catch (Exception exception) {
            System.out.println("[APMHashingMsmtUpdater] - Exception while closing the connection " + exception.getMessage() + " @ " + new Date());
            try {
                connection.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = EgDbInfo.isSqlAdapter;
        String string = this.updateMsmtTimeQuery(this.tableName, bl);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        Object object = null;
        Connection connection = null;
        if (classLoader == null) {
            System.out.println("[UpdateTimeOnAPMHashingTable] -CurrentThread context classloader is null, so exiting !!! @ " + new Date());
            return;
        }
        object = this.getPoolManagerInstance(classLoader);
        if (object != null) {
            connection = this.getDbConnection(object);
        }
        if (connection != null) {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(string);
                int n = 0;
                for (Object object2 : this.hashDetails) {
                    int n2;
                    preparedStatement.setTimestamp(1, timestamp);
                    preparedStatement.setString(2, (String)object2);
                    preparedStatement.addBatch();
                    if ((n2 = ++n % 1000) != 0) continue;
                    int[] nArray = preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                    n = 0;
                    System.out.println("APMHashingMsmtUpdater - preparedUpdateStmt.executeBatch() done for 1000 records @ " + new Date() + " for the Query :" + string);
                }
                if (n > 0) {
                    Object object2;
                    object2 = preparedStatement.executeBatch();
                    System.out.println("APMHashingMsmtUpdater - preparedUpdateStmt.executeBatch() done for remaining records  @ " + new Date() + " for the Query :" + string);
                }
                System.out.println("[APMHashingMsmtUpdater] - Successfully Updated msmt_time column for the table " + this.tableName + " @ " + new Date());
            }
            catch (Exception exception) {
                System.out.println("[UpdateTimeOnAPMHashingTable] - Failure while updating msmt_time column for the table " + this.tableName + " @ " + new Date());
                exception.printStackTrace();
            }
            finally {
                this.closeStmt(preparedStatement);
                this.commitConnection(false, connection);
                this.freeConnection(object, connection);
            }
        } else {
            System.out.println("[UpdateTimeOnAPMHashingTable] - Unable to get DB connection.So returning !!! @ " + new Date());
        }
    }

    private void closeStmt(PreparedStatement preparedStatement) {
        if (preparedStatement == null) {
            return;
        }
        try {
            preparedStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void commitConnection(boolean bl, Connection connection) {
        if (bl) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String updateMsmtTimeQuery(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("UPDATE ").append(string).append(" WITH (ROWLOCK) SET MSMT_TIME = ? WHERE ");
        } else {
            stringBuilder.append("UPDATE ").append(string).append(" SET MSMT_TIME = ? WHERE ");
        }
        if (string.equals("BTM_EXN_STACKTRACE")) {
            stringBuilder.append(" STACK_HASH = ?");
        } else if (string.equals("BTM_EXN_MASTER")) {
            stringBuilder.append(" EXN_HASH = ?");
        } else {
            stringBuilder.append(" QUERY_HASH = ?");
        }
        return stringBuilder.toString();
    }
}

