/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgMaintenanceInfo {
    private static String entity = null;
    private static IniFile maintenanceFilePointer = null;
    private static File maintenanceFile = null;
    private static String maintenanceFileName = null;
    private static long lastModifiedTime = 0L;
    private static long lastSize = 0L;
    private static final String egMaintenanceFile = "eg_maintenance.ini";
    private static final String policySection = "POLICIES";
    private static final String groupSection = "GROUPS";
    private static final String serverSection = "SERVERS";
    private static final String defaultGroup = "default";
    private static final String unplannedPolicySection = "UNPLANNED_POLICIES";
    private static final String unplannedPolicyMappingSection = "UNPLANNED_POLICY_MAPPING";
    private static ConcurrentHashMap maintenancePeriods = new ConcurrentHashMap();
    private static ConcurrentHashMap maintenanceDetails = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenancePeriods = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenanceDetails = new ConcurrentHashMap();

    public static void main(String[] stringArray) {
        EgMaintenanceInfo egMaintenanceInfo = new EgMaintenanceInfo("manager");
        ArrayList arrayList = egMaintenanceInfo.getMaintenancePeriods("192.168.10.37", "NULL", null);
        System.out.println(egMaintenanceInfo.isItMaintenanceTime("31/12/2003 21:30:00", arrayList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EgMaintenanceInfo(String string) {
        entity = string;
        if (maintenanceFile != null) return;
        String string2 = policySection;
        synchronized (policySection) {
            maintenanceFileName = string.equalsIgnoreCase("agent") ? new String(EgConfigInfo.egAgentConfigDir + egMaintenanceFile) : new String(EgConfigInfo.egMgrConfigDir + egMaintenanceFile);
            File file = new File(maintenanceFileName);
            maintenancePeriods = new ConcurrentHashMap();
            unplannedMaintenancePeriods = new ConcurrentHashMap();
            lastModifiedTime = EgMaintenanceInfo.lastModified();
            lastSize = EgMaintenanceInfo.lastSize();
            maintenanceFilePointer = new IniFile(maintenanceFileName, false);
            maintenanceFile = file;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static ArrayList removeDuplicates(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList;
        }
        HashSet hashSet = new HashSet(arrayList);
        arrayList.clear();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static long lastModified() {
        long l = 0L;
        if (maintenanceFile != null) {
            l = entity.equalsIgnoreCase("agent") ? maintenanceFile.lastModified() : IniFile.getLastModified(maintenanceFileName);
        }
        return l;
    }

    public static long lastSize() {
        long l = 0L;
        if (maintenanceFile != null) {
            l = entity.equalsIgnoreCase("agent") ? maintenanceFile.length() : IniFile.getLastSize(maintenanceFileName);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean checkForUpdate() {
        long l = EgMaintenanceInfo.lastModified();
        long l2 = EgMaintenanceInfo.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = policySection;
        synchronized (policySection) {
            lastModifiedTime = l;
            lastSize = l2;
            maintenanceFilePointer = new IniFile(maintenanceFile.getAbsolutePath());
            maintenancePeriods = new ConcurrentHashMap();
            maintenanceDetails = new ConcurrentHashMap();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            unplannedMaintenancePeriods = new ConcurrentHashMap();
            unplannedMaintenanceDetails = new ConcurrentHashMap();
            return true;
        }
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3.trim());
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3.trim());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPolicyInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        String string3 = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(policySection, string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getGroupInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        Object object = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(groupSection, string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase("none")) {
                return null;
            }
            object = EgMaintenanceInfo.myTokenizer(string2, ",");
            if (object == null || ((ArrayList)object).size() == 0) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList2;
                String string3 = this.getPolicyInfo((String)((ArrayList)object).get(i));
                if (string3 == null || (arrayList2 = EgMaintenanceInfo.myTokenizer(string3, ",")) == null) continue;
                int n2 = arrayList2.size();
                for (int j = 0; j < n2; ++j) {
                    String string4 = (String)arrayList2.get(j);
                    arrayList.add(string4);
                }
            }
            arrayList = EgMaintenanceInfo.removeDuplicates(arrayList);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string4 = string + ":" + string2;
        String string5 = string;
        String string6 = null;
        String string7 = string4;
        if (string3 != null && string3.length() > 0) {
            string7 = string6 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string7)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string8 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string7, arrayList2);
                    // ** MonitorExit[var12_13] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5) && !stringArray[i].equals(string4) && (string6 == null || !stringArray[i].equals(string6))) continue;
                bl = true;
                String string9 = null;
                string9 = (String)vector.get(i);
                if (string9 == null || string9.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string10);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string11 = (String)arrayList3.get(j);
                        arrayList2.add(string11);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string7, arrayList2);
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, String string5) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string6 = "";
        string6 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string + ":" + string5;
        String string7 = string2 + '#' + string + ":" + string5;
        String string8 = null;
        String string9 = string6;
        if (string4 != null && string4.length() > 0) {
            string8 = string6 + ":" + string4;
            string9 = string8 = string8 + '#' + string + ":" + string5;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string9)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var13_13] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string10 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string9, arrayList2);
                    // ** MonitorExit[var14_15] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string7) && !stringArray[i].equalsIgnoreCase(string6) && (string8 == null || !stringArray[i].equalsIgnoreCase(string8))) continue;
                bl = true;
                String string11 = null;
                string11 = (String)vector.get(i);
                if (string11 == null || string11.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string11, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string12 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string12);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string13 = (String)arrayList3.get(j);
                        arrayList2.add(string13);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            String string14 = policySection;
            synchronized (policySection) {
                maintenancePeriods.put(string9, arrayList2);
                // ** MonitorExit[var15_19] (shouldn't be in output)
                return arrayList2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string5 = "";
        string5 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string;
        String string6 = string2 + '#' + string;
        String string7 = null;
        String string8 = string5;
        if (string4 != null && string4.length() > 0) {
            string7 = string5 + ":" + string4;
            string8 = string7 = string7 + '#' + string;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string8)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string9 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string8, arrayList2);
                    // ** MonitorExit[var13_14] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6) && !stringArray[i].equals(string5) && (string7 == null || !stringArray[i].equals(string7))) continue;
                bl = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string11);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string12 = (String)arrayList3.get(j);
                        arrayList2.add(string12);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string8, arrayList2);
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = '#' + string;
        ArrayList arrayList = (ArrayList)maintenancePeriods.get(string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string3 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string2, arrayList2);
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl = true;
                String string4 = null;
                string4 = (String)vector.get(i);
                if (string4 == null || string4.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string5);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string6 = (String)arrayList3.get(j);
                        arrayList2.add(string6);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string2, arrayList2);
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2) {
        EgMaintenanceInfo.checkForUpdate();
        String string3 = '#' + string + ":" + string2;
        ArrayList arrayList = (ArrayList)maintenancePeriods.get(string3);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string4 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string3, arrayList2);
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string3)) continue;
                bl = true;
                String string5 = null;
                string5 = (String)vector.get(i);
                if (string5 == null || string5.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string6);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string7 = (String)arrayList3.get(j);
                        arrayList2.add(string7);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string3, arrayList2);
            return arrayList2;
        }
    }

    private static ArrayList splitDate(String string) {
        ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string, " ");
        String string2 = (String)arrayList.get(0);
        String string3 = (String)arrayList.get(1);
        arrayList = EgMaintenanceInfo.myTokenizer(string2, "/");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add((String)arrayList.get(0));
        arrayList2.add((String)arrayList.get(1));
        arrayList2.add((String)arrayList.get(2));
        arrayList = EgMaintenanceInfo.myTokenizer(string3, ":");
        arrayList2.add((String)arrayList.get(0));
        arrayList2.add((String)arrayList.get(1));
        return arrayList2;
    }

    public boolean isItMaintenanceTime(String string, ArrayList arrayList) {
        EgMaintenanceInfo.checkForUpdate();
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        ArrayList arrayList2 = EgMaintenanceInfo.splitDate(string);
        String string2 = (String)arrayList2.get(0);
        String string3 = (String)arrayList2.get(1);
        String string4 = (String)arrayList2.get(2);
        String string5 = (String)arrayList2.get(3);
        String string6 = (String)arrayList2.get(4);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string7 = (String)arrayList.get(i);
            if (!this.isMatch(string2, string3, string4, string5, string6, string7)) continue;
            return true;
        }
        return false;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        arrayList = this.getMaintenancePeriods(string2, string3, string4);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        arrayList3 = this.getUnplannedMaintenancePeriods(string2, string3, string4);
        boolean bl = false;
        if (arrayList != null) {
            arrayList2.addAll(arrayList);
        }
        if (arrayList2 != null) {
            if (arrayList3 != null) {
                arrayList2.addAll(arrayList3);
            }
        } else if (arrayList3 != null) {
            arrayList2 = arrayList3;
        }
        if (arrayList2 != null && arrayList2.size() > 0 && this.isItMaintenanceTime(string, arrayList2)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2) {
        ArrayList arrayList = this.getMaintenancePeriods(string);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, string6);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, string6);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, boolean bl) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3);
        ArrayList arrayList3 = new ArrayList();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, string6);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, string6);
        ArrayList arrayList3 = new ArrayList();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl2 = true;
        }
        return bl2;
    }

    public int convertTimeInMinutes(String string) {
        int n;
        if (string != null && (n = string.indexOf(":")) != -1) {
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Integer.parseInt(string.substring(n + 1));
            int n4 = n2 * 60 + n3;
            return n4;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMatch(String string, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        String string7;
        int n;
        int n2;
        String string8;
        String string9;
        String string10;
        String string11;
        GregorianCalendar gregorianCalendar;
        int n3;
        int n4;
        int n5;
        block33: {
            int n6;
            block34: {
                n5 = 0;
                n4 = 0;
                n3 = 0;
                try {
                    n5 = Integer.parseInt(string);
                    n4 = Integer.parseInt(string2);
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                gregorianCalendar = new GregorianCalendar(n3, n4 - 1, 1);
                ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string6, "#");
                string11 = (String)arrayList.get(1);
                string10 = (String)arrayList.get(0);
                string9 = "";
                string8 = "";
                if (string10 != null && string10.indexOf("-") > 0) {
                    string9 = string10.substring(0, string10.indexOf("-"));
                    string8 = string10.substring(string10.indexOf("-") + 1, string10.length());
                }
                n2 = this.convertTimeInMinutes(string9);
                n = this.convertTimeInMinutes(string8);
                if (!string11.equals("*")) break block34;
                n6 = 0;
                int n7 = 0;
                if (string9 != null && string9.indexOf(":") > 0) {
                    n6 = Integer.parseInt(string9.substring(0, string9.indexOf(":")));
                }
                if (string8 != null && string8.indexOf(":") > 0) {
                    n7 = Integer.parseInt(string8.substring(0, string8.indexOf(":")));
                }
                if (n6 > n7) {
                    string7 = string9 + "-23:59";
                    object = "00:00-" + string8;
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime((String)object, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else if (n2 > n) {
                    string7 = string9 + "-23:59";
                    object = "00:00-" + string8;
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime((String)object, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else {
                    if (!this.checkTime(string10, string4, string5)) return false;
                    return true;
                }
            }
            if (string11.equalsIgnoreCase("LDM")) {
                n6 = gregorianCalendar.getActualMaximum(5);
                if (n5 != n6) return false;
                if (n2 > n) {
                    String string12 = string9 + "-23:59";
                    string7 = "00:00-" + string8;
                    if (this.checkTime(string12, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else {
                    if (!this.checkTime(string10, string4, string5)) return false;
                    return true;
                }
            }
            if (string11.equalsIgnoreCase("FDM")) {
                if (n5 != 1) return false;
                if (n2 > n) {
                    String string13 = string9 + "-23:59";
                    String string14 = "00:00-" + string8;
                    if (this.checkTime(string13, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime(string14, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
            if (string11.indexOf("Every") > -1) {
                String string15 = string11.substring(6);
                int n8 = Integer.parseInt(string15);
                if (n5 != n8) return false;
                if (n2 > n) {
                    String string16 = string9 + "-23:59";
                    String string17 = "00:00-" + string8;
                    if (this.checkTime(string16, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime(string17, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
        }
        gregorianCalendar = new GregorianCalendar(n3, n4 - 1, n5);
        if (string11.startsWith("Sun") && gregorianCalendar.get(7) == 1 || string11.startsWith("Mon") && gregorianCalendar.get(7) == 2 || string11.startsWith("Tue") && gregorianCalendar.get(7) == 3 || string11.startsWith("Wed") && gregorianCalendar.get(7) == 4 || string11.startsWith("Thu") && gregorianCalendar.get(7) == 5 || string11.startsWith("Fri") && gregorianCalendar.get(7) == 6 || string11.startsWith("Sat") && gregorianCalendar.get(7) == 7) {
            if (string11 != null && string11.indexOf("$") > 0 && string11.indexOf("_") > 0) {
                String string18 = string11.substring(string11.indexOf("_") + 1);
                int n9 = gregorianCalendar.get(4);
                if (Integer.parseInt(string18) != n9) return false;
                if (n2 > n) {
                    string7 = string9 + "-23:59";
                    object = "00:00-" + string8;
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime((String)object, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
            if (n2 > n) {
                String string19 = string9 + "-23:59";
                String string20 = "00:00-" + string8;
                if (this.checkTime(string19, string4, string5)) {
                    return true;
                }
                if (!this.checkTime(string20, string4, string5)) return false;
                return true;
            }
            if (!this.checkTime(string10, string4, string5)) return false;
            return true;
        }
        if (string11.indexOf("/") <= 1) return false;
        String string21 = "";
        String string22 = "";
        if (string11 != null && string11.indexOf("|") > 0) {
            string21 = string11.substring(0, string11.indexOf("|"));
            string22 = string11.substring(string11.indexOf("|") + 1, string11.length());
        } else {
            string21 = string11.substring(string11.indexOf("#") + 1, string11.length());
            string22 = string11.substring(string11.indexOf("#") + 1, string11.length());
        }
        string7 = n5 + "/" + n4 + "/" + n3;
        object = new Date(string21 + " " + string9);
        Date date = new Date(string22 + " " + string8);
        Date date2 = new Date(n4 + "/" + n5 + "/" + n3 + " " + string4 + ":" + string5);
        if (!date2.after((Date)object)) {
            if (!date2.equals(object)) return false;
        }
        if (date2.before(date)) return true;
        if (!date2.equals(date)) return false;
        return true;
    }

    private boolean checkTime(String string, String string2, String string3) {
        try {
            long l;
            ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string, "-");
            String string4 = (String)arrayList.get(0);
            String string5 = (String)arrayList.get(1);
            arrayList = EgMaintenanceInfo.myTokenizer(string4, ":");
            int n = Integer.parseInt((String)arrayList.get(0));
            int n2 = Integer.parseInt((String)arrayList.get(1));
            arrayList = EgMaintenanceInfo.myTokenizer(string5, ":");
            int n3 = Integer.parseInt((String)arrayList.get(0));
            int n4 = Integer.parseInt((String)arrayList.get(1));
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return false;
            }
            long l2 = n * 60 + n2;
            long l3 = n3 * 60 + n4;
            long l4 = Integer.parseInt(string2);
            long l5 = l4 * 60L + (l = (long)Integer.parseInt(string3));
            return l5 >= l2 && l5 <= l3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, boolean bl) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string2, string3, string4, true);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string2, string3, string4, true);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string, arrayList3)) {
            bl2 = true;
        }
        return bl2;
    }

    public Hashtable getMaintenanceTimePeriod(String string, String string2, String string3, String string4, boolean bl) {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string2, string3, string4, true);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string2, string3, string4, true);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        try {
            if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string, arrayList3)) {
                bl2 = true;
                hashtable.put("isUnderMaintenance", new Boolean(bl2));
                hashtable.put("MaintenancePeriods", arrayList3);
            } else {
                hashtable.put("isUnderMaintenance", new Boolean(bl2));
                hashtable.put("MaintenancePeriods", new ArrayList());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            hashtable = new Hashtable();
            hashtable.put("isUnderMaintenance", new Boolean(false));
            hashtable.put("MaintenancePeriods", new ArrayList());
        }
        return hashtable;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, boolean bl) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, true);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, true);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isItMaintenanceTime(String string, String string2, boolean bl) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string, true);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, true);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3)) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = '#' + string;
        ArrayList arrayList = (ArrayList)maintenanceDetails.get(string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string2, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl2 = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string4);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string5 = (String)arrayList3.get(j);
                        arrayList2.add(string5);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string2, arrayList2);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, boolean bl) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string4 = string;
        if (string2 != null && !string2.equals("")) {
            string4 = string + ":" + string2;
        }
        String string5 = null;
        String string6 = string4;
        if (string3 != null && string3.length() > 0) {
            string6 = string5 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)maintenanceDetails.get(string6)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string6, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6)) continue;
                bl2 = true;
                String string7 = null;
                string7 = (String)vector.get(i);
                if (string7 == null || string7.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string8);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string9 = (String)arrayList3.get(j);
                        arrayList2.add(string9);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string6, arrayList2);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string5 = string2;
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + ":" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + ":" + string4;
            string5 = string5 + '#' + string;
        } else {
            string5 = string5 + '#' + string;
        }
        ArrayList arrayList = (ArrayList)maintenanceDetails.get(string5);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string5, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5)) continue;
                bl2 = true;
                String string6 = null;
                string6 = (String)vector.get(i);
                if (string6 == null || string6.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string7);
                    if (arrayList3 == null) continue;
                    int n = arrayList3.size();
                    for (int j = 0; j < n; ++j) {
                        String string8 = (String)arrayList3.get(j);
                        arrayList2.add(string8);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string5, arrayList2);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string4 = string + ":" + string2;
        String string5 = string;
        String string6 = null;
        String string7 = string4;
        if (string3 != null && string3.length() > 0) {
            string7 = string6 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string7)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5) && !stringArray[i].equals(string4) && (string6 == null || !stringArray[i].equals(string6))) continue;
                bl = true;
                String string8 = null;
                string8 = (String)vector.get(i);
                if (string8 == null || string8.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string9 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string9);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string10 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string10);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string7, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getUnplannedPolicyInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(unplannedPolicySection, string);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string5 = "";
        string5 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string;
        String string6 = string2 + '#' + string;
        String string7 = null;
        String string8 = string5;
        if (string4 != null && string4.length() > 0) {
            string7 = string5 + ":" + string4;
            string8 = string7 = string7 + '#' + string;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string8)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6) && !stringArray[i].equals(string5) && (string7 == null || !stringArray[i].equals(string7))) continue;
                bl = true;
                String string9 = null;
                string9 = (String)vector.get(i);
                if (string9 == null || string9.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string10);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string11 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string11);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string8, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, String string5) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string6 = "";
        string6 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string + ":" + string5;
        String string7 = string2 + '#' + string + ":" + string5;
        String string8 = null;
        String string9 = string6;
        if (string4 != null && string4.length() > 0) {
            string8 = string6 + ":" + string4;
            string9 = string8 = string8 + '#' + string + ":" + string5;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string9.trim())) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var13_13] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string7) && !stringArray[i].equalsIgnoreCase(string6) && (string8 == null || !stringArray[i].equalsIgnoreCase(string8))) continue;
                bl = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string11);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string12 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string12);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string9, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = '#' + string;
        ArrayList arrayList = (ArrayList)unplannedMaintenancePeriods.get(string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string4);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string5 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string5);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string2, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2) {
        EgMaintenanceInfo.checkForUpdate();
        String string3 = '#' + string + ":" + string2.trim();
        ArrayList arrayList = (ArrayList)unplannedMaintenancePeriods.get(string3);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string3)) continue;
                bl = true;
                String string4 = null;
                string4 = (String)vector.get(i);
                if (string4 == null || string4.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string5);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string6 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string6);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string3, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = '#' + string;
        ArrayList arrayList = (ArrayList)unplannedMaintenanceDetails.get(string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl2 = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string4);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string5 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string5);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string2, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, boolean bl) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string4 = string;
        if (string2 != null && !string2.equals("")) {
            string4 = string + ":" + string2;
        }
        String string5 = null;
        String string6 = string4;
        if (string3 != null && string3.length() > 0) {
            string6 = string5 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)unplannedMaintenanceDetails.get(string6)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6)) continue;
                bl2 = true;
                String string7 = null;
                string7 = (String)vector.get(i);
                if (string7 == null || string7.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string8);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string9 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string9);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string6, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string5 = string2;
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + ":" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + ":" + string4;
            string5 = string5 + '#' + string;
        } else {
            string5 = string5 + '#' + string;
        }
        ArrayList arrayList = (ArrayList)unplannedMaintenanceDetails.get(string5);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5)) continue;
                bl2 = true;
                String string6 = null;
                string6 = (String)vector.get(i);
                if (string6 == null || string6.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string7);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string8 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string8);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string5, object);
            }
            return object;
        }
    }
}

