/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDiscInfo;
import com.eg.EgDnsManager;
import com.eg.EgServicesInfo;
import com.eg.EgTraceRoute;
import com.eg.IniFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgNetworkDiscovery
extends Thread {
    public static int status = -1;
    private static Vector sync = new Vector();
    public static boolean running = false;
    private long sleepTime = 3600000L;
    private String entity = "manager";
    private String router_section = "ROUTERS";
    private EgConfigInfo configInfo = new EgConfigInfo(this.entity);
    private StringTokenizer st = null;
    private EgServicesInfo servicesInfo = new EgServicesInfo(this.entity);
    private EgDiscInfo discInfo = new EgDiscInfo(this.entity);
    String[] sr_iprange = this.servicesInfo.getIpRange();
    String s_display = null;
    private String s_mgr_os = this.servicesInfo.getManagerOs();
    long[] l_minIp = null;
    long[] l_maxIp = null;
    int i_no_ipranges = 0;
    int i_no_hops = 30;
    int i_secs_wait = 3;
    int i_secs_wait_win = 3000;
    int i_no_out = 1;
    Hashtable ipNickMap = null;
    EgDnsManager dnsMgr = EgDnsManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgNetworkDiscovery(Hashtable hashtable) {
        if (running) {
            return;
        }
        this.ipNickMap = hashtable;
        this.s_display = this.servicesInfo.getDiscoveryType();
        this.s_display = this.s_display.equals("DNS") ? "H" : "I";
        if (this.populateIPRange()) {
            Vector vector = sync;
            synchronized (vector) {
                status = -1;
                running = true;
            }
            this.setName("EgNetworkDiscovery");
            this.setDaemon(true);
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            boolean bl = this.discInfo.checkForUpdate();
            ArrayList arrayList = this.runDisc();
            if (arrayList != null && arrayList.size() > 0) {
                this.writeToNwFile(arrayList);
                status = 1;
            } else {
                status = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (running) {
            Vector vector = sync;
            synchronized (vector) {
                running = false;
            }
        }
    }

    private ArrayList runDisc() {
        int n;
        ArrayList arrayList = this.discInfo.getAllIps();
        ArrayList arrayList2 = new ArrayList();
        int n2 = 0;
        int n3 = arrayList.size();
        n2 = n3 > 0 && n3 < 6 ? 1 : (n3 < 50 ? n3 / 8 : (n3 < 100 ? n3 / 18 : (n3 < 500 ? n3 / 30 : n3 / 75)));
        int n4 = 1;
        for (n = n2; n > 0; n /= 10) {
            n4 *= 10;
        }
        n = 0;
        while (arrayList2.size() < n2) {
            n = (int)Math.round(Math.random() * (double)n4);
            if (n <= -1 || n > n3 - 1 || arrayList2.contains(arrayList.get(n))) continue;
            arrayList2.add(arrayList.get(n));
        }
        arrayList2.add("64.58.76.223");
        EgTraceRoute egTraceRoute = new EgTraceRoute();
        Hashtable hashtable = null;
        long l = 0L;
        String string = "";
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            hashtable = this.s_mgr_os.equals("WINDOWS") ? egTraceRoute.runTraceForWin((String)arrayList2.get(i), this.i_no_hops, this.i_secs_wait_win) : egTraceRoute.runTrace((String)arrayList2.get(i), this.i_no_hops, this.i_secs_wait, this.i_no_out, "I", false);
            if (hashtable == null) continue;
            for (int j = 1; j <= hashtable.size(); ++j) {
                string = (String)hashtable.get(Integer.toString(j));
                if (string != null && string.equals((String)arrayList2.get(i)) || (l = this.getLongIp(string)) == -1L || !this.isIpInRange(l) || arrayList3.contains(string)) continue;
                arrayList3.add(string);
            }
        }
        return arrayList3;
    }

    private boolean isCiscoDevice(String string) {
        return true;
    }

    private boolean writeToNwFile(ArrayList arrayList) {
        IniFile iniFile = new IniFile(EgConfigInfo.egNwDiscFile, true);
        iniFile.deleteSubject(this.router_section);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = null;
            String string2 = (String)arrayList.get(i);
            string = this.getHostName(string2);
            iniFile.setValue(this.router_section, string, string2);
        }
        iniFile.saveFile();
        return true;
    }

    private String getHostName(String string) {
        String string2;
        String string3 = null;
        if (this.ipNickMap != null && this.ipNickMap.containsKey(string)) {
            string2 = (String)this.ipNickMap.get(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equalsIgnoreCase(string)) continue;
                string3 = string4;
                int n = string3.indexOf(":");
                if (n < 0) break;
                string3 = string3.substring(0, n);
                break;
            }
        }
        if (string3 != null) {
            return string3;
        }
        if (this.s_display.equals("H")) {
            string2 = this.dnsMgr.getHostName(string);
            if (string2 == null || string2.length() == 0) {
                return string;
            }
            return string2;
        }
        return string;
    }

    private boolean isIpInRange(long l) {
        for (int i = 0; i < this.i_no_ipranges; ++i) {
            if (l < this.l_minIp[i] || l > this.l_maxIp[i]) continue;
            return true;
        }
        return false;
    }

    private long getLongIp(String string) {
        try {
            this.st = new StringTokenizer(string, ".");
            string = "";
            String string2 = "";
            while (this.st.hasMoreTokens()) {
                string2 = this.st.nextToken();
                if (string2.length() == 1) {
                    string2 = "00" + string2;
                } else if (string2.length() == 2) {
                    string2 = "0" + string2;
                }
                string = string + string2;
            }
            long l = Long.parseLong(string);
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private boolean populateIPRange() {
        if (this.sr_iprange == null || this.sr_iprange.length == 0) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < this.sr_iprange.length; ++i) {
            if (this.sr_iprange[i].startsWith("Format:")) continue;
            arrayList.add(this.sr_iprange[i]);
        }
        this.i_no_ipranges = arrayList.size();
        if (this.i_no_ipranges == 0) {
            return false;
        }
        this.l_minIp = new long[this.i_no_ipranges];
        this.l_maxIp = new long[this.i_no_ipranges];
        int n = -1;
        for (int i = 0; i < this.i_no_ipranges; ++i) {
            String string = (String)arrayList.get(i);
            this.st = new StringTokenizer(string, ".");
            string = "";
            while (this.st.hasMoreTokens()) {
                String string2 = this.st.nextToken();
                if (string2.length() == 1) {
                    string2 = "00" + string2;
                } else if (string2.length() == 2) {
                    string2 = "0" + string2;
                }
                n = string2.indexOf("-");
                if (n != -1) {
                    string2 = "000" + string2.substring(0, n + 1) + "000" + string2.substring(n + 1);
                    n = string2.indexOf("-");
                    string2 = string2.substring(n - 3, n + 1) + string2.substring(string2.length() - 3, string2.length());
                }
                string = string + string2;
            }
            this.l_minIp[i] = this.getLongIp(string.substring(0, string.indexOf("-")));
            this.l_maxIp[i] = this.getLongIp(string.substring(string.indexOf("-") + 1));
        }
        return true;
    }
}

