/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgDateInfo;
import com.eg.EgDbBackup;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SaveEgConfig {
    long maxDays = 14L;
    long msecPerDay = 86400000L;
    EgDateInfo dateInfo = new EgDateInfo();
    String backupDir = EgInstallInfo.getInstallDir() + "/manager/backup/";
    EgDbInfo dInfo = new EgDbInfo("manager");
    boolean isDbBackupEnabled = false;

    public static void main(String[] stringArray) {
        SaveEgConfig saveEgConfig = new SaveEgConfig(14L);
        saveEgConfig.takeBackup();
    }

    public SaveEgConfig(long l) {
        this.maxDays = l;
        this.isDbBackupEnabled = this.dInfo.getBackupDefaultTables();
    }

    public void takeBackup() {
        File file = new File(this.backupDir);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        long l = this.dateInfo.egetUTCDate();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((long)n < this.maxDays) {
            String string;
            long l2 = l - (long)n * this.msecPerDay;
            String string2 = this.dateInfo.egetDate(l2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() >= 1 && (stringTokenizer = new StringTokenizer(string = stringTokenizer.nextToken(), "/")).countTokens() >= 3) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = string4 + string3 + string5;
                if (n == 0) {
                    this.saveConfig(string6);
                }
                if (!arrayList.contains(string6)) {
                    arrayList.add(string6);
                }
            }
            ++n;
        }
        String[] stringArray = this.getDirs(this.backupDir);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = string.lastIndexOf("/");
            int n3 = string.lastIndexOf("\\");
            if (n2 < 0) {
                if (n3 >= 0) {
                    string = string.substring(n3 + 1);
                }
            } else if (n3 < 0) {
                if (n2 >= 0) {
                    string = string.substring(n2 + 1);
                }
            } else {
                string = n3 > n2 ? string.substring(n3 + 1) : string.substring(n2 + 1);
            }
            if (arrayList.contains(string)) continue;
            this.removeDir(stringArray[i]);
        }
    }

    public String[] getDirs(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            if (!fileArray[i].isDirectory() || arrayList.contains(string2 = fileArray[i].toString())) continue;
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getFiles(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            if (fileArray[i].isDirectory() || arrayList.contains(string2 = fileArray[i].toString())) continue;
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void removeDir(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.removeDir(fileArray[i].toString());
                    continue;
                }
                try {
                    fileArray[i].delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveConfig(String string) {
        int n;
        int n2;
        Object object;
        int n3;
        String[] stringArray;
        File file = new File(this.backupDir + string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        if (this.isDbBackupEnabled) {
            stringArray = new EgDbBackup(this.backupDir + string);
            stringArray.start();
        }
        if ((stringArray = this.getFiles(EgInstallInfo.getInstallDir() + "/manager/config/")) == null || stringArray.length == 0) {
            return;
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            object = stringArray[n3];
            n2 = ((String)object).lastIndexOf("/");
            n = ((String)object).lastIndexOf("\\");
            if (n2 < 0) {
                if (n >= 0) {
                    object = ((String)object).substring(n + 1);
                }
            } else if (n < 0) {
                if (n2 >= 0) {
                    object = ((String)object).substring(n2 + 1);
                }
            } else {
                object = n > n2 ? ((String)object).substring(n + 1) : ((String)object).substring(n2 + 1);
            }
            try {
                SaveEgConfig.copy(stringArray[n3], this.backupDir + string + "/" + (String)object);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to copy " + stringArray[n3] + " " + this.backupDir + string + "/" + (String)object);
            }
        }
        stringArray = this.getFiles(EgInstallInfo.getInstallDir() + "/manager/logs/");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            object = stringArray[n3];
            if (!((String)object).endsWith("_log") || ((String)object).startsWith("Copy")) continue;
            n2 = ((String)object).lastIndexOf("/");
            n = ((String)object).lastIndexOf("\\");
            if (n2 < 0) {
                if (n >= 0) {
                    object = ((String)object).substring(n + 1);
                }
            } else if (n < 0) {
                if (n2 >= 0) {
                    object = ((String)object).substring(n2 + 1);
                }
            } else {
                object = n > n2 ? ((String)object).substring(n + 1) : ((String)object).substring(n2 + 1);
            }
            try {
                SaveEgConfig.copy(stringArray[n3], this.backupDir + string + "/" + (String)object);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to copy " + stringArray[n3] + " " + this.backupDir + string + "/" + (String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String string, String string2) throws IOException {
        Object object;
        Object object2;
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            SaveEgConfig.abort("FileCopy: no such source file: " + string);
        }
        if (!file.isFile()) {
            SaveEgConfig.abort("FileCopy: can't copy directory: " + string);
        }
        if (!file.canRead()) {
            SaveEgConfig.abort("FileCopy: source file is unreadable: " + string);
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (!file2.canWrite()) {
                SaveEgConfig.abort("FileCopy: destination file is unwriteable: " + string2);
            }
        } else {
            object2 = file2.getParent();
            if (object2 == null) {
                object2 = System.getProperty("user.dir");
            }
            if (!((File)(object = new File((String)object2))).exists()) {
                SaveEgConfig.abort("FileCopy: destination directory doesn't exist: " + (String)object2);
            }
            if (((File)object).isFile()) {
                SaveEgConfig.abort("FileCopy: destination is not a directory: " + (String)object2);
            }
            if (!((File)object).canWrite()) {
                SaveEgConfig.abort("FileCopy: destination directory is unwriteable: " + (String)object2);
            }
        }
        object2 = null;
        object = null;
        try {
            int n;
            object2 = new FileInputStream(file);
            object = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n = ((FileInputStream)object2).read(byArray)) != -1) {
                ((FileOutputStream)object).write(byArray, 0, n);
            }
        }
        finally {
            if (object2 != null) {
                try {
                    ((FileInputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void abort(String string) throws IOException {
        throw new IOException(string);
    }
}

