/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.eg.EgInstallInfo;
import com.eg.HelperThread;
import com.eg.IniFile;
import com.eg.KerberosCallbackHandler;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;

class UserSearch
implements PrivilegedAction {
    String searchDomain;
    String userToSearch;
    String searchDomainPort;
    String searchBase;
    String ssl;
    boolean sslenabled = false;
    public ArrayList errorList = new ArrayList();

    public UserSearch(String string, String string2, String string3) {
        this.searchDomain = string;
        this.userToSearch = string2;
        this.searchDomainPort = "389";
        this.searchBase = string3;
    }

    public UserSearch(String string, String string2, String string3, String string4) {
        this.searchDomain = string;
        this.userToSearch = string2;
        this.ssl = string4;
        if (string4 != null && string4.equalsIgnoreCase("true")) {
            this.searchDomainPort = "636";
            this.sslenabled = true;
        } else {
            this.searchDomainPort = "389";
            this.sslenabled = false;
        }
        this.searchBase = string3;
    }

    public Object run() {
        if (this.performUserSearch(this.searchDomainPort).booleanValue()) {
            return Boolean.TRUE;
        }
        if (this.ssl != null && this.ssl.equalsIgnoreCase("true")) {
            this.searchDomainPort = "3269";
            this.sslenabled = true;
        } else {
            this.searchDomainPort = "3268";
            this.sslenabled = false;
        }
        return this.performUserSearch(this.searchDomainPort);
    }

    private Boolean performUserSearch(String string) {
        Object object;
        Object object2;
        ArrayList arrayList = null;
        String string2 = null;
        arrayList = this.getIPAddressesByDomainName(this.searchDomain);
        string2 = this.getValidFQDomainName(arrayList, string);
        if (string2 == null) {
            return Boolean.FALSE;
        }
        String string3 = "LDAP://" + string2 + ":" + string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.sslenabled) {
            string3 = "LDAPS://" + string2 + ":" + string;
            object2 = System.getProperty("java.home");
            object = (String)object2 + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", (String)object);
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string3);
        hashtable.put("java.naming.security.authentication", "GSSAPI");
        hashtable.put("javax.security.sasl.qop", "auth,auth-conf,auth-int");
        try {
            object2 = new InitialDirContext(hashtable);
            object = new SearchControls();
            String[] stringArray = new String[]{"distinguishedName"};
            ((SearchControls)object).setReturningAttributes(stringArray);
            ((SearchControls)object).setSearchScope(2);
            this.userToSearch = this.getUserAsPreWindows2000Format(this.userToSearch);
            String string4 = "(&(objectCategory=person)(objectClass=user)(sAMAccountName=" + this.userToSearch + "))";
            String string5 = this.searchBase;
            int n = 0;
            NamingEnumeration<SearchResult> namingEnumeration = object2.search(string5, string4, (SearchControls)object);
            while (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = namingEnumeration.next();
                String string6 = searchResult.getName();
                System.out.println("[[UserName Found]]: " + string6);
                ++n;
            }
            object2.close();
            hashtable = null;
            if (n > 0) {
                return Boolean.TRUE;
            }
            this.errorList.add("USER_NOT_AVAILABLE");
            return Boolean.FALSE;
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            hashtable = null;
            this.errorList.add("EXCEPTION");
            this.errorList.add(namingException);
            return Boolean.FALSE;
        }
    }

    public ArrayList getIPAddressesByDomainName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                String string2 = inetAddressArray[i].getHostAddress();
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Could not find IP address for " + exception.getMessage());
        }
        return arrayList;
    }

    public String getValidFQDomainName(ArrayList arrayList, String string) {
        String string2 = null;
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (!this.checkPort(string3, string)) continue;
                string2 = this.getFQDomainName(string3);
                System.out.println("validIP is : " + string3);
                System.out.println("FQDomainName is : " + string2);
                break;
            }
        }
        return string2;
    }

    public String getFQDomainName(String string) {
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getCanonicalHostName();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        return string2;
    }

    public boolean checkPort(String string, String string2) {
        long l;
        int n = 1000;
        HelperThread helperThread = new HelperThread(string, string2, n);
        long l2 = 0L;
        long l3 = 5L;
        do {
            this.suspendForPeriod(l3);
            if (helperThread.done) {
                return helperThread.status;
            }
            if ((l2 += l3) >= (long)n) {
                helperThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                helperThread = null;
                return false;
            }
            l = l3;
            if ((long)n - l2 >= l) continue;
            l = (long)n - l2;
        } while ((l3 = l) > 0L);
        helperThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        helperThread = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public String getUserAsPreWindows2000Format(String string) {
        String string2 = "/\\[]:;|=,+*?<>@";
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (string.indexOf(c) == -1) continue;
            string = string.replace(c, '_');
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length != 2) {
            System.out.println("Usage: java com.eg.UserSearch <domainDisplayName> <userToSearch>");
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_authenticate.ini");
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = iniFile.getValue(string, "user");
        String string4 = iniFile.getValue(string, "domain_name");
        String string5 = iniFile.getValue(string, "password");
        string5 = EgCrypt.decrypt(string5);
        String string6 = iniFile.getValue(string, "isSSL");
        String string7 = "";
        String string8 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            object = stringTokenizer.nextToken();
            string8 = i == 0 || string8.equals("") ? "DC=" + (String)object : string8 + ",DC=" + (String)object;
        }
        LoginContext loginContext = null;
        try {
            Serializable serializable;
            Object object2;
            Object[] objectArray;
            try {
                object = EgInstallInfo.getInstallDir() + "/manager/config/egAD_" + string4 + ".ini";
                objectArray = EgInstallInfo.getInstallDir() + "/manager/config/KerberosAuth.config";
                System.setProperty("java.security.auth.login.config", (String)objectArray);
                System.setProperty("java.security.krb5.conf", (String)object);
                System.out.println("connectuser====:" + string3);
                System.out.println("connectpwd====:*************");
                loginContext = new LoginContext("KerberosAuth", new KerberosCallbackHandler(string3, string5));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                objectArray = exception.getMessage();
                if (objectArray.indexOf("Clock skew too great") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Clock skew too great");
                }
                if (objectArray.indexOf("Identifier doesn't match expected value") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Identifier");
                }
                if (objectArray.indexOf("Client not found in Kerberos database") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Client not found in Kerberos database");
                }
                if (objectArray.indexOf("Pre-authentication information was invalid") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Pre-authentication");
                }
                if (objectArray.indexOf("Receive timed out") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Receive timed out");
                }
                if (objectArray.indexOf("Clients credentials have been revoked") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Clients credentials have been revoked");
                }
                if (objectArray.indexOf("Server not found in Kerberos database") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Server not found in Kerberos database");
                }
                if (objectArray.indexOf("KDC has no support for encryption type") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("KDC has no support for encryption type");
                }
                if (objectArray.indexOf("Password has expired - change password to reset") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Password has expired - change password to reset");
                }
                if (objectArray.indexOf("Cannot get kdc for realm") > -1) {
                    arrayList.add("KERBEROS");
                    object2 = objectArray;
                    object2 = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                    object2 = ((String)object2).trim();
                    arrayList.add(object2);
                }
                arrayList.add("KERBEROS");
                arrayList.add("Error in Connecting with AD sever");
            }
            try {
                loginContext.login();
                System.out.println("Connected");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                loginContext = null;
                objectArray = exception.getMessage();
                if (objectArray.indexOf("Clock skew too great") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Clock skew too great");
                } else if (objectArray.indexOf("Identifier doesn't match expected value") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Invalid Credentials");
                } else if (objectArray.indexOf("Client not found in Kerberos database") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Client not found in Kerberos database");
                } else if (objectArray.indexOf("Pre-authentication information was invalid") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Pre-authentication");
                } else if (objectArray.indexOf("Receive timed out") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Receive timed out");
                } else if (objectArray.indexOf("Clients credentials have been revoked") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Clients credentials have been revoked");
                } else if (objectArray.indexOf("Server not found in Kerberos database") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Server not found in Kerberos database");
                } else if (objectArray.indexOf("KDC has no support for encryption type") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("KDC has no support for encryption type");
                } else if (objectArray.indexOf("Password has expired - change password to reset") > -1) {
                    arrayList.add("KERBEROS");
                    arrayList.add("Password has expired - change password to reset");
                } else if (objectArray.indexOf("Cannot get kdc for realm") > -1) {
                    arrayList.add("KERBEROS");
                    object2 = objectArray;
                    object2 = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                    object2 = ((String)object2).trim();
                    arrayList.add(object2);
                }
                arrayList.add("KERBEROS");
                arrayList.add("Error in Connecting with AD sever");
            }
            object = loginContext.getSubject();
            objectArray = ((Subject)object).getPrincipals().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof KerberosPrincipal)) continue;
                serializable = (KerberosPrincipal)objectArray[i];
                string7 = ((KerberosPrincipal)serializable).getName();
                break;
            }
            System.out.println("The logged in user is " + string7);
            UserSearch userSearch = new UserSearch(string4, string2, string8, string6);
            serializable = (Boolean)Subject.doAs(loginContext.getSubject(), userSearch);
            try {
                if (loginContext != null) {
                    loginContext.logout();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((Boolean)serializable).booleanValue()) {
                System.out.println("User found");
            } else {
                arrayList.add("KERBEROS");
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = userSearch.errorList;
                System.out.println("##domainErrors=" + arrayList2);
                int n2 = arrayList2.indexOf("EXCEPTION");
                if (n2 > -1) {
                    Exception exception = (Exception)arrayList2.get(n2 + 1);
                    arrayList.add("PRE_EXCEPTION");
                    arrayList.add(exception);
                } else {
                    arrayList.add("USER_EXCEPTION");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

