/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.InstrumentationHelper;
import com.eg.agent.LazyInstrumentationThread;
import com.eg.agent.Utilities;
import com.eg.agent.attach.ApplicationServerCategory;
import com.eg.agent.attach.AttachSupportedType;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.PropsManager;
import com.eg.jtm.discovery.AutoDiscovery;
import com.eg.jtm.learning.Method;
import com.eg.jtm.learning.Methods;
import com.eg.org.apache.commons.lang3.StringUtils;
import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.util.CheckClassAdapter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EgClassFileTransformer
implements ClassFileTransformer {
    private boolean checkExcludeFlag = false;
    private boolean isJDK5 = false;
    private static final String ThreadClassName = "java/lang/Thread";
    private static HashMap classNameMap = null;
    private static final HashMap<String, String> LOOKUP = new HashMap();
    private static final HashMap<String, String> MAPPINGS = new HashMap();
    private static final HashMap<String, String> INTERFACE_MAPPING = new HashMap();
    private static final HashMap<String, String> SPECIAL_INTERFACE_MAPPING = new HashMap();
    private AttachSupportedType attachSupported = null;

    public EgClassFileTransformer(Instrumentation instrumentation, boolean bl, boolean bl2, boolean bl3) {
        this.checkExcludeFlag = bl2;
        Utilities.prepareExcludeList();
        boolean bl4 = false;
        this.attachSupported = new AttachSupportedType();
        bl4 = bl3 ? this.attachSupported.isSupportProvided(instrumentation) : true;
        boolean bl5 = instrumentation.isRetransformClassesSupported();
        if (bl4) {
            if (bl5) {
                Object object;
                if (Utilities.LazyList != null && Utilities.LazyList.size() > 0) {
                    try {
                        object = new LazyInstrumentationThread(instrumentation, bl5, Utilities.LazyList);
                        ((Thread)object).start();
                    }
                    catch (Exception exception) {
                        BTMLog.logger.warn("Exception occured while starting LazyInstrumentationThread {}", (Object)exception.getMessage());
                        BTMLog.logger.error("{}", exception);
                    }
                }
                this.attachTranformer(instrumentation, bl, bl5);
                object = instrumentation.getAllLoadedClasses();
                String string = "[BASE Class] ";
                ArrayList<Class<?>> arrayList = null;
                if (bl3) {
                    string = "[VM Attach] ";
                    BTMLog.logger.debug("{} - Retransforming already loaded classes", (Object)string);
                    arrayList = this.getRetransformAllClasses(instrumentation, (Class<?>[])object, string);
                } else {
                    BTMLog.logger.debug("Retransforming only java.net.URLConnection, java.lang.Thread & java.lang.Runtime classes");
                    arrayList = this.getRetransformBaseClasses(instrumentation, (Class<?>[])object, string);
                }
                int n = arrayList.size();
                BTMLog.logger.info("{} - No of Retransform class list size is  {} ", (Object)string, (Object)n);
                if (n > 0) {
                    this.startRetransformProcess(instrumentation, arrayList, string);
                }
            }
        } else {
            BTMLog.logger.warn("eG BTM does not trace anything, since not able to find Web (or) Application servertype !!!");
        }
    }

    private void attachTranformer(Instrumentation instrumentation, boolean bl, boolean bl2) {
        if (bl) {
            BTMLog.logger.info("isRetransformClassesSupported ? :{}  Is JRE 6 or above? :{}", (Object)bl2, (Object)bl);
            try {
                instrumentation.addTransformer(this, bl2);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occured while doing Instrumentation.addTransformer(ClassFileTransformer,boolean)");
                BTMLog.logger.error("{}", exception);
            }
        } else {
            this.isJDK5 = true;
            try {
                instrumentation.addTransformer(this);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occured while doing Instrumentation.addTransformer(ClassFileTransformer)");
                BTMLog.logger.error("{}", exception);
            }
        }
        BTMLog.logger.info("BTM Home : {}", (Object)PropsManager.EG_BTM_HOME);
        BTMLog.logger.info("BTM-Debug is enabled and can be viewed {}", (Object)(PropsManager.EG_BTM_HOME + BTMOffLoadConfig.getBtmLogFolderName()));
    }

    public EgClassFileTransformer(boolean bl) {
        this.checkExcludeFlag = bl;
    }

    private boolean isValidClassByteArray(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == -54 && byArray[0] == -2 && byArray[0] == -70 && byArray[0] == -66;
    }

    public boolean isInterface(ClassReader classReader) {
        return (classReader.getAccess() & 0x200) != 0;
    }

    private static int getClassJavaVersion(ClassReader classReader) {
        return classReader.readUnsignedShort(6);
    }

    public static String verifyClass(byte[] byArray, ClassLoader classLoader) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CheckClassAdapter.verify(new ClassReader(byArray), classLoader, false, printWriter);
        return stringWriter.toString();
    }

    private boolean isRetransformRequired(Class<?> clazz, Instrumentation instrumentation) {
        String string = clazz.getName();
        if (string == null) {
            return false;
        }
        if (clazz.isEnum() || clazz.isInterface()) {
            return false;
        }
        String string2 = StringUtils.replace(string, ".", "/");
        this.classNameBasedDiscovery(string2);
        if (this.getCallType(string2) != null) {
            return true;
        }
        boolean bl = false;
        if (this.checkExcludeFlag) {
            bl = Utilities.isEligible(string2);
        }
        boolean bl2 = false;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = EgClassFileTransformer.getSuperClassNames(string2, arrayList, clazz.getClassLoader());
            boolean bl3 = false;
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null && classArray.length > 0) {
                bl3 = true;
            }
            if (!bl3 && arrayList2 != null && arrayList2.size() == 1 && arrayList2.contains("java/lang/Object")) {
                bl2 = false;
            } else {
                ArrayList arrayList3 = EgClassFileTransformer.getAllInterFaces(string, arrayList2, clazz.getClassLoader());
                String string3 = this.findType(string, arrayList2, arrayList3);
                BTMLog.logger.debug("isRetransformRequired - callType - {} - {} ", (Object)string3, (Object)string);
                if (!string3.equals("POJO") && !string3.equals("Others")) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private String getInterfaceMatchingType(ArrayList<String> arrayList) {
        String string = null;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = arrayList.get(i);
                if (!INTERFACE_MAPPING.containsKey(string2)) continue;
                string = INTERFACE_MAPPING.get(string2);
                break;
            }
        }
        return string;
    }

    private void startRetransformProcess(Instrumentation instrumentation, ArrayList<Class<?>> arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Class[] classArray = new Class[1];
            try {
                classArray[0] = arrayList.get(i);
                BTMLog.logger.debug("{} - Retransforming the class {} isRetransformClassesSupported ? {} :", string, classArray[0].getName(), instrumentation.isRetransformClassesSupported());
                instrumentation.retransformClasses(classArray);
            }
            catch (Throwable throwable) {
                BTMLog.logger.warn("{} - Failure occured while retransforming class {} : {} ", string, classArray[0].getName(), throwable.getMessage());
                BTMLog.logger.error("{} {} ", throwable);
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ArrayList<Class<?>> getRetransformBaseClasses(Instrumentation instrumentation, Class<?>[] classArray, String string) {
        ArrayList arrayList = new ArrayList();
        try {
            for (int i = 0; i < classArray.length; ++i) {
                if (!instrumentation.isModifiableClass(classArray[i]) || LOOKUP.get(classArray[i].getName()) == null) continue;
                arrayList.add(classArray[i]);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} - Exception occured while adding Retransform classs {}", (Object)string, (Object)exception.getMessage());
            BTMLog.logger.error("{} {}", (Object)string, (Object)exception);
        }
        return arrayList;
    }

    private ArrayList<Class<?>> getRetransformAllClasses(Instrumentation instrumentation, Class<?>[] classArray, String string) {
        ArrayList arrayList = new ArrayList();
        try {
            for (int i = 0; i < classArray.length; ++i) {
                if (instrumentation.isModifiableClass(classArray[i]) && this.isRetransformRequired(classArray[i], instrumentation)) {
                    arrayList.add(classArray[i]);
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} - Exception occured while adding Retransform classs {}", (Object)string, (Object)exception.getMessage());
            BTMLog.logger.error("{} {}", (Object)string, (Object)exception);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        String string2;
        if (string == null) {
            return byArray;
        }
        if (classLoader == null && this.isJDK5) {
            return byArray;
        }
        if (this.isValidClassByteArray(byArray)) {
            return byArray;
        }
        if (this.attachSupported.isAttach()) {
            if (!this.attachSupported.getContainerType().isProceed()) return byArray;
            if (this.attachSupported.getContainerType() == ApplicationServerCategory.OSGI) {
                try {
                    int n = this.attachSupported.patchDone(classLoader);
                    if (n == 10) {
                        BTMLog.logger.warn("eG BTM found this as OSGI {}, but unable to add bootdelegation !!!", (Object)this.attachSupported.getOSGIType());
                        return byArray;
                    }
                }
                catch (Throwable throwable) {
                    String string3 = MAPPINGS.get(string);
                    if (string3 == null) {
                        return byArray;
                    }
                    BTMLog.debugLogger.info("[CLASS NAME (loaded by BootClassLoader)] {} ==> [CALL TYPE] : {} ", (Object)string, (Object)string3);
                    return InstrumentationHelper.getModifiedClassFileBuffer(string, byArray, string3, classLoader);
                }
            }
        } else {
            this.classNameBasedDiscovery(string);
        }
        if ((string2 = this.getCallType(string)) != null) {
            BTMLog.debugLogger.info("[CLASS NAME] {} ==> [CALL TYPE] : {} ", (Object)string, (Object)string2);
            return InstrumentationHelper.getModifiedClassFileBuffer(string, byArray, string2, classLoader);
        }
        boolean bl = false;
        if (this.checkExcludeFlag) {
            bl = Utilities.isEligible(string);
        }
        if (!bl) {
            return byArray;
        }
        if (Utilities.isLazyList(string)) {
            return byArray;
        }
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(byArray);
        }
        catch (Throwable throwable) {
            return byArray;
        }
        int n = EgClassFileTransformer.getClassJavaVersion(classReader);
        String string4 = classReader.getSuperName();
        boolean bl2 = false;
        String[] stringArray = classReader.getInterfaces();
        if (stringArray != null && stringArray.length > 0) {
            bl2 = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = null;
        string2 = null;
        arrayList.add(string4);
        ArrayList<String> arrayList3 = EgClassFileTransformer.getSuperClassNames(string4, arrayList, classLoader);
        if (!bl2 && arrayList3 != null && arrayList3.size() == 1 && arrayList3.contains("java/lang/Object")) {
            string2 = MAPPINGS.get(string);
            if (string2 == null) {
                string2 = "POJO";
            }
        } else {
            arrayList2 = EgClassFileTransformer.getAllInterFaces(string, arrayList3, classLoader);
            if (arrayList2 != null && arrayList2.size() == 0 && bl2) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList2.add(stringArray[i]);
                }
            }
        }
        if (string2 == null) {
            string2 = this.findType(string, arrayList3, arrayList2);
        }
        BTMLog.debugLogger.info("[CLASS NAME] :{} ==> [SUPER CLASSES] :{} ==> [CALL TYPE] :{} ==> [ALL-INTERFACES] :{}  classfileVersion {}", string, arrayList3, string2, arrayList2, n);
        try {
            if (string2.equals("Others")) return InstrumentationHelper.getModifiedClassFileBuffer(string, byArray, arrayList2, arrayList3, classLoader);
            if (!string2.equals("VALID")) return InstrumentationHelper.getModifiedClassFileBuffer(string, byArray, arrayList3, string2, classLoader);
            return InstrumentationHelper.getModifiedClassFileBuffer(string, byArray, arrayList2, arrayList3, classLoader);
        }
        catch (Exception exception) {
            BTMLog.debugLogger.warn(" {} ", (Object)exception.getMessage());
            BTMLog.debugLogger.error(" {} ", exception);
            return null;
        }
    }

    public void classNameBasedDiscovery(String string) {
        String string2;
        if (!AutoDiscovery.isServerNameFound() && (string2 = PropsManager.autoDiscoveryHTable.get(string)) != null) {
            BTMLog.logger.info("[Server Type Discovery] Identification of server type is sucessfull : {}", (Object)string2);
            AutoDiscovery.setServerNameFound(true);
            AutoDiscovery.collectOtherServerDetails(string2);
        }
    }

    private String getCallType(String string) {
        String string2 = null;
        string2 = MAPPINGS.get(string);
        if (string2 == null && string.startsWith("com/ibm/mq/")) {
            string2 = "IBMMQ";
        }
        return string2;
    }

    private String findType(String string, ArrayList arrayList, ArrayList arrayList2) {
        String string2 = this.getCallType(string);
        if (string2 == null) {
            int n = 0;
            if (arrayList != null) {
                String string3;
                n = arrayList.size();
                for (int i = 0; i < n && (string2 = this.getCallType(string3 = (String)arrayList.get(i))) == null; ++i) {
                }
            }
        }
        if (string2 == null || string2.equals("Others")) {
            String string4 = this.getInterfaceMatchingType(arrayList2);
            string2 = string4 == null ? "Others" : (SPECIAL_INTERFACE_MAPPING.containsKey(string4) ? string4 : "VALID");
        }
        if (string2 != null && string2.equals("EJB") && arrayList2 != null) {
            if (arrayList2.indexOf("java/rmi/Remote") >= 0 || arrayList.indexOf("org/omg/CORBA/portable/ObjectImpl") >= 0 && arrayList2.indexOf("org/omg/CORBA/Object") >= 0) {
                string2 = "EJB";
            } else if (arrayList2.indexOf("weblogic/rmi/extensions/server/Stub") >= 0) {
                string2 = "EJB";
            }
        }
        string2 = string2 == null ? "Others" : string2;
        return string2;
    }

    private static ArrayList<String> getSuperClassNames(String string, ArrayList<String> arrayList, ClassLoader classLoader) {
        ClassReader classReader = null;
        String string2 = null;
        try {
            classReader = EgClassFileTransformer.getClassReader(string, classLoader);
            string2 = classReader.getSuperName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            arrayList.add(string2);
            if (!string2.equals("java/lang/Object")) {
                arrayList.add(string2);
                String string3 = StringUtils.replace(string2, ".", "/");
                EgClassFileTransformer.getSuperClassNames(string3, arrayList, classLoader);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader getClassReader(String string, ClassLoader classLoader) {
        ClassReader classReader = null;
        InputStream inputStream = null;
        try {
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(StringUtils.replace(string, ".", "/") + ".class");
                classReader = new ClassReader(inputStream);
            } else {
                classReader = new ClassReader(string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return classReader;
    }

    public static ArrayList findSuperInterface(String string, ArrayList arrayList, ClassLoader classLoader) {
        ClassReader classReader = null;
        try {
            String[] stringArray = null;
            classReader = EgClassFileTransformer.getClassReader(string, classLoader);
            if (classReader != null) {
                stringArray = classReader.getInterfaces();
            }
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    arrayList.add(string2);
                    EgClassFileTransformer.findSuperInterface(string2, arrayList, classLoader);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.debugLogger.debug("InterFACE NAME :{}", (Object)string);
        }
        return arrayList;
    }

    public static ArrayList getAllInterFaces(String string, ArrayList arrayList, ClassLoader classLoader) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ClassReader classReader = null;
        try {
            Object object;
            String string2;
            int n;
            Object object2;
            classReader = EgClassFileTransformer.getClassReader(string, classLoader);
            if (classReader != null && (object2 = classReader.getInterfaces()) != null && ((String[])object2).length > 0) {
                for (n = 0; n < ((String[])object2).length; ++n) {
                    string2 = object2[n];
                    arrayList2.add(string2);
                    object = EgClassFileTransformer.findSuperInterface(string2, new ArrayList(), classLoader);
                    if (object == null || ((ArrayList)object).size() <= 0) continue;
                    arrayList2.addAll((Collection<String>)object);
                }
            }
            object2 = null;
            for (n = 0; n < arrayList.size(); ++n) {
                string2 = (String)arrayList.get(n);
                object = null;
                try {
                    object2 = EgClassFileTransformer.getClassReader(string2, classLoader);
                    if (object2 != null) {
                        object = ((ClassReader)object2).getInterfaces();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object == null || (object).length <= 0) continue;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string3 = object[i];
                    arrayList2.add(string3);
                    ArrayList arrayList3 = EgClassFileTransformer.findSuperInterface(string3, new ArrayList(), classLoader);
                    if (arrayList3 == null || arrayList3.size() <= 0) continue;
                    arrayList2.addAll(arrayList3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList2;
    }

    public static HashMap getMethodMap(String string) {
        List<Method> list;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (classNameMap == null) {
            return hashMap;
        }
        Methods methods = (Methods)classNameMap.get(string);
        if (methods != null && (list = methods.getList()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Method method = list.get(i);
                if (method == null) continue;
                String string2 = method.getMethod();
                List<String> list2 = method.getSignature();
                hashMap.put(string2, list2);
            }
        }
        return hashMap;
    }

    static {
        MAPPINGS.put("java/net/HttpURLConnection", "HTTP");
        MAPPINGS.put("com/sun/net/ssl/internal/www/protocol/https/HttpsURLConnectionOldImpl", "HTTP");
        MAPPINGS.put("java/net/URLConnection", "HTTP");
        MAPPINGS.put("sun/net/www/protocol/http/HttpURLConnection", "HTTP");
        MAPPINGS.put("org/apache/commons/httpclient/HttpMethodDirector", "HTTP");
        MAPPINGS.put("org/apache/http/impl/client/CloseableHttpClient", "HTTP");
        MAPPINGS.put("sun/net/www/protocol/https/AbstractDelegateHttpsURLConnection", "HTTP");
        MAPPINGS.put("org/apache/struts/action/ActionServlet", "STRUTS");
        MAPPINGS.put("org/apache/struts2/dispatcher/FilterDispatcher", "STRUTS2");
        MAPPINGS.put("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareAndExecuteFilter", "STRUTS2");
        MAPPINGS.put("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareFilter", "STRUTS2");
        MAPPINGS.put("org/apache/struts2/dispatcher/ng/filter/StrutsExecuteFilter", "STRUTS2");
        MAPPINGS.put("org/apache/struts2/dispatcher/ActionContextCleanUp", "STRUTS2");
        MAPPINGS.put("org/springframework/web/servlet/DispatcherServlet", "SpringDispatcher");
        MAPPINGS.put("org/apache/jasper/runtime/HttpJspBase", "JSP");
        MAPPINGS.put("com/caucho/jsp/JavaPage", "JSP");
        MAPPINGS.put("org/jboss/portal/core/servlet/jsp/PortalJsp", "JSP");
        MAPPINGS.put("com/bea/portlet/jsp/PortletJspBase", "JSP");
        MAPPINGS.put("com/ibm/ws/jsp/runtime/HttpJspBase", "JSP");
        MAPPINGS.put("com/ibm/ws/webcontainer/jsp/runtime/HttpJspBase", "JSP");
        MAPPINGS.put("weblogic/servlet/jsp/JspBase", "JSP");
        MAPPINGS.put("javax/faces/webapp/FacesServlet", "JSF");
        MAPPINGS.put("javax/faces/lifecycle/Lifecycle", "JSF");
        MAPPINGS.put("com/sap/mw/jco/JCO$Client", "SAP JCO");
        MAPPINGS.put("javax/xml/soap/SOAPConnection", "WEBSERVICE");
        MAPPINGS.put("org/apache/cxf/endpoint/ClientImpl", "WEBSERVICE");
        MAPPINGS.put("org/apache/cxf/interceptor/ServiceInvokerInterceptor", "WEBSERVICE_ENTRY");
        MAPPINGS.put(ThreadClassName, "THREAD");
        MAPPINGS.put("javax/servlet/http/HttpServlet", "HTTPSERVLET");
        MAPPINGS.put("javax/servlet/GenericServlet", "GENERICSERVLET");
        MAPPINGS.put("java/lang/Object", "Others");
        MAPPINGS.put("javax/mail/Transport", "EMAIL");
        MAPPINGS.put("java/lang/Runtime", "RUNTIME");
        MAPPINGS.put("java/lang/ProcessBuilder", "RUNTIME");
        MAPPINGS.put("java/lang/ProcessImpl", "WAITFOR");
        MAPPINGS.put("sun/rmi/transport/StreamRemoteCall", "RMI");
        MAPPINGS.put("com/sun/jndi/ldap/LdapClient", "LDAP1");
        MAPPINGS.put("com/sun/jndi/ldap/LdapClientFactory", "LDAP2");
        MAPPINGS.put("com/sun/jndi/ldap/LdapNamingEnumeration", "LDAP3");
        MAPPINGS.put("javax/naming/directory/InitialDirContext", "LDAP4");
        MAPPINGS.put("weblogic/rmi/internal/BasicRemoteRef", "EJB_HIDE");
        MAPPINGS.put("weblogic/rmi/cluster/ClusterableRemoteRef", "EJB_HIDE");
        MAPPINGS.put("com/ibm/ws/wlm/client/WLMClientRequestInterceptor", "EJB_HIDE");
        MAPPINGS.put("org/jboss/ejb/client/remoting/RemotingConnectionEJBReceiver", "EJB_HIDE");
        MAPPINGS.put("org/mule/transport/AbstractTransportMessageProcessTemplate", "MULE");
        MAPPINGS.put("com/mongodb/DBCollection", "MONGODB");
        MAPPINGS.put("redis/clients/jedis/Connection", "REDIS");
        MAPPINGS.put("javax/rmi/CORBA/Stub", "EJB");
        MAPPINGS.put("org/omg/CORBA_2_3/portable/ObjectImpl", "EJB");
        MAPPINGS.put("weblogic/rmi/internal/Stub", "EJB");
        LOOKUP.put("java.net.URLConnection", "HTTP");
        LOOKUP.put("java.lang.Thread", "THREAD");
        LOOKUP.put("java.lang.Runtime", "RUNTIME");
        if (PropsManager.getInstrumentationLevel().getTraceLevel() < 3) {
            MAPPINGS.put("java/io/PrintWriter", "PrintWriter");
            MAPPINGS.put("javax/servlet/jsp/JspWriter", "JspWriter");
            MAPPINGS.put("javax/servlet/jsp/JspContext", "JspContext");
            MAPPINGS.put("java/io/OutputStream", "OutputStream");
        }
        MAPPINGS.put("net/sf/ehcache/Cache", "EHCACHE");
        INTERFACE_MAPPING.put("java/sql/CallableStatement", "SQL");
        INTERFACE_MAPPING.put("java/sql/PreparedStatement", "SQL");
        INTERFACE_MAPPING.put("java/sql/Statement", "SQL");
        INTERFACE_MAPPING.put("java/sql/Driver", "SQL");
        INTERFACE_MAPPING.put("java/sql/Connection", "SQL");
        INTERFACE_MAPPING.put("javax/servlet/Filter", "FILTER");
        INTERFACE_MAPPING.put("javax/servlet/http/HttpServletResponse", "HTTP_RESPONSE");
        INTERFACE_MAPPING.put("javax/jms/Connection", "JMS");
        INTERFACE_MAPPING.put("javax/jms/Session", "JMS");
        INTERFACE_MAPPING.put("javax/jms/JMSContext", "JMS");
        INTERFACE_MAPPING.put("javax/jms/MessageProducer", "JMS");
        INTERFACE_MAPPING.put("javax/jms/MessageConsumer", "JMS");
        INTERFACE_MAPPING.put("java/lang/Runnable", "THREAD");
        INTERFACE_MAPPING.put("javax/xml/rpc/Call", "WEBSERVICE");
        INTERFACE_MAPPING.put("javax/jms/MessageListener", "JMS_ENTRY");
        INTERFACE_MAPPING.put("javax/servlet/RequestDispatcher", "RequestDispatcher");
        INTERFACE_MAPPING.put("org/apache/ibatis/executor/statement/StatementHandler", "iBatis");
        SPECIAL_INTERFACE_MAPPING.put("WEBSERVICE", "WEBSERVICE");
        SPECIAL_INTERFACE_MAPPING.put("JMS_ENTRY", "JMS_ENTRY");
        SPECIAL_INTERFACE_MAPPING.put("RequestDispatcher", "RequestDispatcher");
        SPECIAL_INTERFACE_MAPPING.put("iBatis", "iBatis");
    }
}

