/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.Agent;
import com.eg.agent.JavaAgent;
import com.eg.agent.Utilities;
import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyInstrumentationThread
extends Thread {
    private Instrumentation instrumentation;
    private ArrayList<String> lazyList = null;
    private boolean isRetransSupported;

    public LazyInstrumentationThread(Instrumentation instrumentation, boolean bl, ArrayList<String> arrayList) {
        this.instrumentation = instrumentation;
        this.lazyList = arrayList;
        this.isRetransSupported = bl;
        this.setName("eG BTM Lazy Retransform");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        if (this.lazyList == null || this.lazyList.size() == 0) {
            return;
        }
        if (this.isRetransSupported) {
            int n = PropsManager.getLazyPeriod();
            BTMLog.logger.info("[LAZY] Lazy time period for class retransform :{} ", (Object)n);
            try {
                boolean bl;
                int n2;
                Object object;
                long l = (long)n * 1000L;
                Thread.sleep(l);
                BTMLog.debugLogger.info("[LAZY] - R  E  T  R  A  N  S  F  O  R  M  Starting now !!!");
                BTMLog.debugLogger.info("[LAZY] - lazyList : {}", (Object)this.lazyList);
                Hashtable<Object, Category> hashtable = new Hashtable<Object, Category>();
                for (int i = 0; i < this.lazyList.size(); ++i) {
                    object = this.lazyList.get(i);
                    n2 = ((String)object).length();
                    boolean bl2 = false;
                    bl = false;
                    Category category = Category.D;
                    char c = ((String)object).charAt(0);
                    char c2 = ((String)object).charAt(n2 - 1);
                    if (c == '/') {
                        bl2 = true;
                    }
                    if (c2 == '/') {
                        bl = true;
                    }
                    if ((category = bl2 && bl ? Category.A : (bl2 ? Category.B : (bl ? Category.C : Category.D))) == null) continue;
                    hashtable.put(object, category);
                }
                Class[] classArray = this.instrumentation.getAllLoadedClasses();
                object = new ArrayList();
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    if (!this.instrumentation.isModifiableClass(classArray[n2])) continue;
                    String string = classArray[n2].getName();
                    bl = false;
                    bl = this.isRetransformRequired(string, hashtable);
                    if (!bl) continue;
                    BTMLog.debugLogger.info("[LAZY] - className  ==>" + string);
                    ((ArrayList)object).add(classArray[n2]);
                }
                BTMLog.debugLogger.info("[LAZY] - No.Of Classes : {} isRetransSupported : {}", (Object)((ArrayList)object).size(), (Object)this.isRetransSupported);
                BTMLog.debugLogger.info("[LAZY] - Retransform the Following classes only : {}", object);
                if (((ArrayList)object).size() > 0) {
                    JavaAgent javaAgent = Agent.getJavaAgentObject();
                    if (javaAgent == null) {
                        BTMLog.logger.warn("[LAZY] Object egJavaAgent is either null or invalid, Retransform not possible.");
                        return;
                    }
                    javaAgent.startRetransformProcess((ArrayList<Class<?>>)object);
                }
            }
            catch (Exception exception) {
                BTMLog.debugLogger.error("[LAZY] - Exception during Lazy Retransform {} ", exception);
            }
        }
    }

    private boolean isRetransformRequired(String string, Hashtable hashtable) {
        int n;
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        String string2 = string.replace('.', '/');
        boolean bl2 = false;
        Category category = null;
        for (n = 0; n < this.lazyList.size(); ++n) {
            String string3 = this.lazyList.get(n);
            Category category2 = (Category)((Object)hashtable.get(string3));
            switch (category2) {
                case A: {
                    if (string2.indexOf(string3) <= 0) break;
                    bl2 = true;
                    category = category2;
                    break;
                }
                case B: {
                    if (!string2.endsWith(string3)) break;
                    bl2 = true;
                    category = category2;
                    break;
                }
                case C: {
                    if (!string2.startsWith(string3)) break;
                    bl2 = true;
                    category = category2;
                    break;
                }
                case D: {
                    if (!string2.equals(string3)) break;
                    bl2 = true;
                    category = category2;
                }
            }
            if (bl2) break;
        }
        if (bl2) {
            bl = true;
            if (category == Category.D) {
                n = this.checkClasses(string2) ? 1 : 0;
                if (n != 0) {
                    bl = false;
                }
            } else {
                boolean bl3;
                boolean bl4;
                n = this.checkClasses(string2) ? 1 : 0;
                if (n != 0) {
                    bl = false;
                }
                if (bl && (bl4 = this.checkPackages(string2))) {
                    bl = false;
                }
                if (bl && (bl3 = this.checkPatterns(string2))) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkPatterns(String string) {
        boolean bl = false;
        ArrayList<String> arrayList = Utilities.getExcludePatternList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = arrayList.get(i);
            if (!string.startsWith(string2) && string.indexOf("/" + string2) <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkPackages(String string) {
        boolean bl = false;
        ArrayList<String> arrayList = Utilities.getExcludePackageList();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkClasses(String string) {
        boolean bl = false;
        if (Utilities.getExcludeClassList().contains(string)) {
            bl = true;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Category {
        A,
        B,
        C,
        D;

    }
}

