/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.attach;

import com.eg.agent.attach.ApplicationServerCategory;
import com.eg.agent.attach.Attacher;
import com.eg.agent.attach.Catalina;
import com.eg.agent.attach.JBossOSGI;
import com.eg.agent.attach.JavaAttachHelper;
import com.eg.agent.attach.OSGIType;
import com.eg.agent.attach.SpringBootApp;
import com.eg.jtm.BTMLog;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachSupportedType {
    private static final HashMap<String, Attacher> NON_OSGI_MAPPINGS = new HashMap();
    private static final String logPrefix = "[" + AttachSupportedType.class.getName() + "]";
    private ApplicationServerCategory containerType = ApplicationServerCategory.STANDALONE;
    private OSGIType osgiType = OSGIType.UNKNOWN;
    private boolean vmattach = false;
    private static final String FELIX_LOADER = "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader";
    private static final String EQUIONX_LOADER = "org.eclipse.osgi.internal.loader.EquinoxClassLoader";

    public boolean isSupportProvided(Instrumentation instrumentation) {
        this.vmattach = true;
        Class[] classArray = instrumentation.getAllLoadedClasses();
        int n = classArray.length;
        BTMLog.logger.info("{} - No.of classes loaded already {}", (Object)logPrefix, (Object)n);
        boolean bl = this.isSupportedNonOSGI(classArray);
        if (bl) {
            this.containerType = ApplicationServerCategory.NON_OSGI;
            this.containerType.setFlag(true);
        } else {
            int n2 = this.isSupportedOSGI(classArray);
            if (n2 == 1 || n2 == 2) {
                bl = true;
                this.containerType = ApplicationServerCategory.OSGI;
                this.containerType.setFlag(true);
            }
        }
        return bl;
    }

    private int isSupportedOSGI(Class<?>[] classArray) {
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            try {
                String string;
                ClassLoader classLoader;
                String string2 = clazz.getName();
                if (string2 == null || (classLoader = clazz.getClassLoader()) == null) continue;
                BTMLog.logger.debug("[isSupportedOSGI] - className - {}, its class loader {} ", (Object)string2, (Object)classLoader);
                if (classLoader.toString() != null && classLoader.toString().contains(EQUIONX_LOADER)) {
                    BTMLog.logger.info("{} - Found Equinox OSGI container !!!", (Object)logPrefix);
                    this.osgiType = OSGIType.EQUINOX;
                    n = 1;
                }
                if ((string = classLoader.getClass().toString()).contains(FELIX_LOADER)) {
                    BTMLog.logger.info("{} - Found Felix OSGI container !!!", (Object)logPrefix);
                    this.osgiType = OSGIType.FELIX;
                    n = 2;
                }
                if (n <= 0) continue;
                boolean bl = this.isSupportedByEg(this.osgiType);
                if (bl) {
                    BTMLog.logger.info("{} - eG BTM supports this server type for dynamic attach !!!", (Object)logPrefix);
                }
                if (bl) break;
                BTMLog.logger.warn("{} - eG BTM doesn't supports this server type for dynamic attach !!!", (Object)logPrefix);
                n = 0;
                break;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{}- Exception due to {}", (Object)logPrefix, (Object)exception);
            }
        }
        return n;
    }

    private boolean isSupportedNonOSGI(Class<?>[] classArray) {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            try {
                String string = clazz.getName();
                if (string == null || !(bl = this.mappingExists(string, clazz))) continue;
                break;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{}- Exception due to {}", (Object)logPrefix, (Object)exception);
            }
        }
        return bl;
    }

    private boolean mappingExists(String string, Class<?> clazz) {
        if (NON_OSGI_MAPPINGS.containsKey(string)) {
            Attacher attacher = NON_OSGI_MAPPINGS.get(string);
            attacher.setClazz(clazz);
            return attacher.execute();
        }
        return false;
    }

    public ApplicationServerCategory getContainerType() {
        return this.containerType;
    }

    public OSGIType getOSGIType() {
        return this.osgiType;
    }

    public boolean isAttach() {
        return this.vmattach;
    }

    public int patchDone(ClassLoader classLoader) {
        boolean bl;
        int n = 0;
        OSGIType oSGIType = this.getOSGIType();
        String string = classLoader.getClass().toString();
        if (oSGIType == OSGIType.FELIX) {
            if (string.contains(FELIX_LOADER)) {
                bl = JavaAttachHelper.patchOSGiFelix(classLoader);
                n = bl ? 5 : 10;
            }
        } else if (oSGIType == OSGIType.EQUINOX && string.contains(EQUIONX_LOADER)) {
            bl = JavaAttachHelper.patchOSGiForEquinox(classLoader);
            n = bl ? 5 : 10;
        }
        if (n == 0) {
            BTMLog.logger.debug("patchDone is 0 , {} & osgiType is {} ", (Object)classLoader, (Object)oSGIType);
            try {
                bl = JavaAttachHelper.checkAgentCanBeLoaded(classLoader);
                BTMLog.logger.debug("patchDone is 0 , {} & osgiType is {} & agentBeLoaded {} ", new Object[]{classLoader, oSGIType, bl});
            }
            catch (ClassNotFoundException classNotFoundException) {
                BTMLog.logger.debug("patchDone is 0  ClassNotFoundException , {} & osgiType is {} & agentBeLoaded {} ,e is {} ", new Object[]{classLoader, oSGIType, classNotFoundException});
            }
        }
        return n;
    }

    private boolean isSupportedByEg(OSGIType oSGIType) {
        boolean bl = false;
        String string = System.getProperty("sun.java.command");
        if (string != null && string.trim().startsWith("com.sun.enterprise.glassfish.bootstrap.ASMain")) {
            bl = true;
        }
        return bl;
    }

    static {
        NON_OSGI_MAPPINGS.put("org.apache.catalina.startup.Bootstrap", new Catalina());
        NON_OSGI_MAPPINGS.put("org.jboss.modules.Module", new JBossOSGI());
        NON_OSGI_MAPPINGS.put("org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory", new SpringBootApp("Tomcat"));
        NON_OSGI_MAPPINGS.put("org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory", new SpringBootApp("Jetty"));
        NON_OSGI_MAPPINGS.put("org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory", new SpringBootApp("Undertow"));
    }
}

