/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.attach;

import com.eg.jtm.BTMLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static Object invokeProperty(Object object, String string, boolean bl) {
        Object object2 = null;
        try {
            Class<?> clazz = object.getClass();
            Field field = ReflectionUtil.getFieldAccesible(clazz, string);
            if (field != null) {
                object2 = field.get(object);
            }
        }
        catch (SecurityException securityException) {
            object2 = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object2 = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = null;
        }
        return object2;
    }

    private static Field getFieldAccesible(Class clazz, String string) {
        Field field = ReflectionUtil.getField(clazz, string);
        if (field != null && !field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Field getField(Class clazz, String string) {
        Field field = null;
        if (clazz != null) {
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = null;
            }
            if (field == null) {
                Class clazz2 = clazz.getSuperclass();
                field = ReflectionUtil.getField(clazz2, string);
            }
        }
        return field;
    }

    public static Object invoke(Object object, String string) {
        return ReflectionUtil.invoke(object, string, null, null);
    }

    public static Object invoke(Object object, String string, Object object2) {
        return ReflectionUtil.invoke(object, string, new Class[]{object2.getClass()}, new Object[]{object2});
    }

    public static Object invoke(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Class<?> clazz = object.getClass();
            String string2 = ReflectionUtil.getKey(clazz.hashCode(), clazz.getName(), string, classArray);
            Method method = ReflectionUtil.getMethod(clazz, string, classArray);
            if (method != null) {
                method.setAccessible(true);
                object2 = method.invoke(object, objectArray);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("ERROR {} ", throwable);
            object2 = null;
        }
        return object2;
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        if (clazz != null) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (SecurityException securityException) {
                method = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = null;
            }
            if (method == null) {
                Class clazz2 = clazz.getSuperclass();
                method = ReflectionUtil.getMethod(clazz2, string, classArray);
            }
        }
        return method;
    }

    private static String getKey(int n, String string, String string2, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        if (classArray != null) {
            stringBuffer.append(ReflectionUtil.ClassArrayToString(classArray));
        }
        return stringBuffer.toString();
    }

    private static String ClassArrayToString(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(":");
                stringBuffer.append(classArray[i].getName());
            }
        }
        return stringBuffer.toString();
    }
}

