/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace.utils;

import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.BTMLog;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseUtils {
    private static final String PORTNUMBER = "PORTNUMBER=";
    private static final String SERVERNAME = "SERVERNAME=";
    private static final String DATABASE = "DATABASE=";
    private static final String DATABASENAME = "DATABASENAME=";
    private static final String LOCATIONNAME = "LOCATIONNAME=";
    private static final String ALTERNATESERVERS = "ALTERNATESERVERS=";
    private static final String DRIVER_NAME = "DRIVER_NAME";
    private static final String DRIVER_VERSION = "DRIVER_VERSION";
    private static final String JDBC_URL = "JDBC_URL";

    public static Hashtable<String, String> getDBInfo(Object object) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Object object2;
            String string = null;
            String string2 = null;
            String string3 = null;
            try {
                object2 = object.getClass().getMethod("getMetaData", new Class[0]);
                ((Method)object2).setAccessible(true);
                Object object3 = ((Method)object2).invoke(object, TraceUtils.ARGS);
                if (object3 != null) {
                    Method method = object3.getClass().getMethod("getURL", new Class[0]);
                    method.setAccessible(true);
                    Object object4 = method.invoke(object3, TraceUtils.ARGS);
                    string = object4.toString();
                    Method method2 = object3.getClass().getMethod("getDriverName", new Class[0]);
                    method2.setAccessible(true);
                    Object object5 = method2.invoke(object3, TraceUtils.ARGS);
                    string2 = object5.toString();
                    Method method3 = object3.getClass().getMethod("getDriverVersion", new Class[0]);
                    method3.setAccessible(true);
                    Object object6 = method3.invoke(object3, TraceUtils.ARGS);
                    string3 = object6.toString();
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.warn("Could not find DB information due to the following error {}", throwable);
            }
            if (string == null) {
                return hashtable;
            }
            object2 = "UnKnown";
            if (string.startsWith("jdbc:sqlserver:") || string.startsWith("jdbc:jtds:sqlserver:") || string.startsWith("jdbc:jtds:sybase:") || string.startsWith("jdbc:microsoft:sqlserver:")) {
                object2 = "Microsoft SQL Server";
                hashtable = DataBaseUtils.getSQLDBInfo(string);
            } else if (string.startsWith("jdbc:oracle:")) {
                object2 = "Oracle";
                hashtable = DataBaseUtils.getOracleDBInfo(string);
            } else if (string.startsWith("jdbc:mysql:") || string.startsWith("jdbc:mariadb")) {
                object2 = "MySQL";
                hashtable = DataBaseUtils.getMySQLDBInfo(string);
            } else if (string.startsWith("jdbc:db2:")) {
                object2 = "DB2";
                hashtable = DataBaseUtils.getDB2Info(string);
            } else if (string.startsWith("jdbc:weblogic:db2:")) {
                object2 = "DB2";
                hashtable = DataBaseUtils.getWeblogicDB2Info(string);
            } else if (string.startsWith("jdbc:hsqldb:")) {
                object2 = "HSQL";
                hashtable = DataBaseUtils.getHSQLDBInfo(string);
            } else if (string.startsWith("jdbc:informix-sqli:")) {
                object2 = "Informix Dynamic Server";
                hashtable = DataBaseUtils.getInformixDBInfo(string);
            } else if (string.startsWith("jdbc:postgresql:")) {
                object2 = "PostgreSQL";
                hashtable = DataBaseUtils.getPostgreSQLDBInfo(string);
            } else {
                object2 = "UNKnown";
                hashtable = DataBaseUtils.getUNKnownDBInfo(string);
            }
            if (string2 == null) {
                string2 = "-";
            }
            if (string3 == null) {
                string3 = "-";
            }
            hashtable.put(DRIVER_NAME, string2);
            hashtable.put(DRIVER_VERSION, string3);
            BTMLog.logger.info("DataBaseUtils.getDBInfo : {} ProductName : {}", (Object)string, object2);
            BTMLog.debugLogger.debug(" Database Details - JDBC URL : {} Driver Name & Version : {} {} DB Server Details : {} ", string, string2, string3, hashtable);
        }
        catch (Exception exception) {
            BTMLog.debugLogger.error("[Exception Occured in DataBaseUtils - getDBInfo] {}", exception);
        }
        BTMLog.logger.info("DataBaseUtils.getDBInfo : {} ", (Object)hashtable);
        return hashtable;
    }

    private static Hashtable<String, String> getUNKnownDBInfo(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SERVERTYPE", "-");
        hashtable.put("DATABASENAME", "-");
        hashtable.put("SERVERNAME", "-");
        hashtable.put("PORTNUMBER", "-");
        return hashtable;
    }

    private static Hashtable<String, String> getInformixDBInfo(String string) {
        int n;
        int n2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SERVERTYPE", "Informix_server");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "1526";
        String string7 = string.substring(string.indexOf("://") + 3);
        int n3 = string7.indexOf(";");
        if (n3 > 0) {
            string7 = string7.substring(0, n3);
        }
        String string8 = string7.substring(string7.indexOf("INFORMIXSERVER"));
        string5 = string8.substring(string8.indexOf("=") + 1);
        int n4 = (string7 = string7.substring(0, string7.indexOf(":INFORMIXSERVER"))).indexOf("/");
        if (n4 > 0) {
            String string9 = string7.substring(n4 + 1);
            string7 = string7.substring(0, n4);
            n2 = string9.indexOf(":");
            if (n2 > 0) {
                string9 = string9.substring(0, n2);
            }
            string4 = string9;
        } else {
            string4 = "-";
        }
        boolean bl = false;
        n2 = string7.lastIndexOf(":");
        if (n2 > 0) {
            String string10 = string7.substring(n2 + 1);
            if (string10 != null && string10.length() > 0) {
                if (string10.equals(string5)) {
                    string3 = string10;
                    bl = true;
                } else {
                    try {
                        n = Integer.parseInt(string10);
                        string3 = string10;
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        string3 = string6;
                    }
                }
            } else {
                bl = false;
                string3 = string6;
            }
        } else {
            bl = false;
            string3 = string6;
        }
        int n5 = string7.indexOf("::");
        if (n5 > 0) {
            if (string7.startsWith("[")) {
                n = string7.indexOf("]");
                if (n > 0) {
                    string2 = string7.substring(0, n + 1);
                }
            } else {
                string2 = bl ? string7.substring(0, string7.lastIndexOf(":")) : string7;
            }
        } else {
            string2 = bl ? string7.substring(0, string7.lastIndexOf(":")) : string7;
        }
        if (string2 != null && string2.trim().length() == 0) {
            string2 = "127.0.0.1";
        }
        hashtable.put("DATABASENAME", string4);
        hashtable.put("SERVERNAME", string2);
        hashtable.put("PORTNUMBER", string3);
        hashtable.put("INFORMIXSERVER", string5);
        return hashtable;
    }

    private static Hashtable getWeblogicDB2Info(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        String string6 = null;
        int n = string.indexOf("://");
        if (n > 0) {
            int n2;
            String string7 = string.substring(0, n);
            String string8 = string.substring(n + 3).trim();
            if (string7 != null && string7.startsWith("jdbc:weblogic:db2")) {
                string2 = "IBM_Db2_server";
                string6 = "50000";
            }
            if ((n2 = string8.indexOf(";")) >= 0) {
                int n3;
                String string9 = string8.substring(n2 + 1);
                string8 = string8.substring(0, n2);
                boolean bl = false;
                if (string8 != null && string8.length() > 0) {
                    if (string8.startsWith(":")) {
                        string3 = "localhost";
                        string4 = string8.substring(1);
                    } else {
                        bl = true;
                    }
                } else {
                    string3 = "localhost";
                    string4 = string6;
                }
                if (bl) {
                    int n4;
                    n3 = string8.indexOf("]");
                    if (n3 > 0) {
                        string3 = string8.substring(0, n3 + 1);
                        string4 = string6;
                        n4 = string8.lastIndexOf(":");
                        if (n4 > n3) {
                            string4 = string8.substring(n4);
                        }
                    } else {
                        string3 = "localhost";
                        string4 = string6;
                        n4 = string8.lastIndexOf(":");
                        if (n4 > 0) {
                            string3 = string8.substring(0, n4);
                            string4 = string8.substring(n4 + 1);
                        } else {
                            string3 = string8;
                        }
                    }
                }
                if (string9 != null && string9.length() > 0) {
                    String string10;
                    int n5;
                    String string11;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    string9 = string9.toUpperCase();
                    n3 = string9.indexOf(ALTERNATESERVERS);
                    String string12 = null;
                    if (n3 > 0) {
                        String string13 = string9.substring(n3);
                        n9 = string13.indexOf("(");
                        n8 = string13.indexOf(")");
                        String string14 = string13.substring(n8 + 1).trim();
                        if (string14 != null && string14.startsWith(";")) {
                            string14 = string14.substring(1);
                        }
                        if (n9 > 0 && n8 > 0 && n8 > n9) {
                            string13 = string13.substring(n9 + 1, n8);
                        }
                        string12 = string9.substring(0, n3);
                        if (string14 != null && string14.trim().length() > 0) {
                            string12 = string12 + string14;
                        }
                    } else {
                        string12 = string9;
                    }
                    boolean bl2 = false;
                    n9 = string12.indexOf(LOCATIONNAME);
                    if (n9 >= 0) {
                        bl2 = true;
                        String string15 = string12.substring(n9 + LOCATIONNAME.length());
                        int n10 = string15.indexOf(";");
                        string5 = n10 > 0 ? string15.substring(0, n10) : string15;
                    }
                    if (!bl2) {
                        n8 = string12.indexOf(DATABASENAME);
                        int n11 = string12.indexOf(DATABASE);
                        n7 = 0;
                        n6 = 0;
                        if (n8 >= 0 && n11 >= 0) {
                            if (n8 > n11) {
                                n7 = 1;
                            } else {
                                n6 = 1;
                            }
                        } else if (n8 >= 0) {
                            n7 = 1;
                        } else if (n11 >= 0) {
                            n6 = 1;
                        }
                        if (n7 != 0) {
                            String string16 = string12.substring(n8 + DATABASENAME.length());
                            int n12 = string16.indexOf(";");
                            if (n12 > 0) {
                                string16 = string16.substring(0, n12);
                            }
                            string5 = string16;
                        } else if (n6 != 0) {
                            String string17 = string12.substring(n11 + DATABASE.length());
                            int n13 = string17.indexOf(";");
                            if (n13 > 0) {
                                string17 = string17.substring(0, n13);
                            }
                            string5 = string17;
                        }
                    }
                    n8 = string12.indexOf(SERVERNAME);
                    if (n8 >= 0 && (n7 = (string11 = string12.substring(n8 + SERVERNAME.length())).indexOf(";")) > 0) {
                        string3 = string11.substring(0, n7);
                    }
                    if ((n5 = string12.indexOf(PORTNUMBER)) > 0 && (n6 = (string10 = string12.substring(n5 + PORTNUMBER.length())).indexOf(";")) > 0) {
                        string4 = string10.substring(0, n6);
                    }
                }
            }
        }
        hashtable.put("SERVERTYPE", string2);
        hashtable.put("SERVERNAME", string3);
        hashtable.put("PORTNUMBER", string4);
        hashtable.put("DATABASENAME", string5);
        BTMLog.logger.info("DataBaseUtils - getWeblogicDB2Info :" + hashtable);
        return hashtable;
    }

    private static Hashtable getPostgreSQLDBInfo(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SERVERTYPE", "PostgreSQL");
        int n = 0;
        if (n != 3) {
            int n2 = string.indexOf("?");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            BTMLog.logger.info("getPostgreSQLDBInfo - INPUT : {} ", (Object)string);
            String string2 = "jdbc:postgresql:";
            int n3 = string2.length();
            if (string.startsWith(string2)) {
                string = string.substring(n3);
            }
            String string3 = string;
            int n4 = string3.lastIndexOf("/");
            String string4 = string3;
            String string5 = "127.0.0.1";
            String string6 = "5432";
            boolean bl = false;
            if (n4 > 0) {
                string4 = string3.substring(n4 + 1);
                string3 = string3.substring(0, n4);
                bl = true;
            }
            if (bl) {
                boolean bl2 = false;
                if (string3.startsWith("//[")) {
                    bl2 = true;
                }
                if (bl2) {
                    int n5 = string3.indexOf("]");
                    int n6 = string3.indexOf("]:");
                    if (n5 > 0) {
                        string5 = string3.substring(string3.indexOf("[") + 1, n5);
                    }
                    if (n6 > 0) {
                        string6 = string3.substring(n6 + 2);
                    }
                } else {
                    int n7 = string3.indexOf(":");
                    if (n7 > 0) {
                        string6 = string3.substring(n7 + 1);
                        string5 = string3.substring(0, n7);
                    } else {
                        string5 = string3;
                    }
                    if (string5.startsWith("//")) {
                        string5 = string5.substring(2);
                    }
                }
            }
            if (string5 == null || string5.equals("") || string5.equalsIgnoreCase("localhost") || string5.equalsIgnoreCase("127.0.0.1")) {
                string5 = "127.0.0.1";
                try {
                    String string7;
                    string5 = string7 = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            hashtable.put("DATABASENAME", string4);
            hashtable.put("SERVERNAME", string5);
            hashtable.put("PORTNUMBER", string6);
        }
        BTMLog.logger.info("DataBaseUtils - getPostgreSQLDBInfo : {}", (Object)hashtable);
        return hashtable;
    }

    private static Hashtable getHSQLDBInfo(String string) {
        Hashtable<String, String> hashtable;
        block13: {
            hashtable = new Hashtable<String, String>();
            hashtable.put("SERVERTYPE", "HyperSQL");
            try {
                String string2;
                int n;
                StringTokenizer stringTokenizer;
                int n2;
                int n3 = string.indexOf(";");
                if (n3 > 0) {
                    string = string.substring(0, n3);
                }
                if ((n2 = (stringTokenizer = new StringTokenizer(string, ":")).countTokens()) <= 3) break block13;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("mem") || string3.equals(".") || string3.equals("file") || string3.equals("res")) {
                    String string4 = string.substring(string.indexOf(string3));
                    String string5 = string4.substring(string4.indexOf(":") + 1);
                    hashtable.put("SERVERNAME", "hsqldb");
                    hashtable.put("PORTNUMBER", string3);
                    hashtable.put("DATABASENAME", string5);
                    break block13;
                }
                if (!string3.startsWith("hsql") && !string3.startsWith("http") || (n = (string2 = string.substring(string.indexOf(string3))).indexOf("//")) <= 0) break block13;
                int n4 = (string2 = string2.substring(n + 2)).lastIndexOf("/");
                if (n4 > 0) {
                    String string6 = string2.substring(n4 + 1);
                    string2 = string2.substring(0, n4);
                    hashtable.put("DATABASENAME", string6);
                }
                int n5 = string2.lastIndexOf(":");
                String string7 = "9001";
                if (string3.startsWith("https")) {
                    string7 = "443";
                } else if (string3.startsWith("http")) {
                    string7 = "80";
                }
                String string8 = null;
                if (n5 > 0) {
                    string7 = string2.substring(n5 + 1);
                    string8 = string2.substring(0, n5);
                } else {
                    string8 = string2;
                }
                if (string8 == null || string8.equals("") || string8.equalsIgnoreCase("localhost")) {
                    string8 = "127.0.0.1";
                    try {
                        String string9;
                        string8 = string9 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hashtable.put("PORTNUMBER", string7);
                hashtable.put("SERVERNAME", string8);
            }
            catch (Exception exception) {
                BTMLog.logger.error("[Exception Occured in DataBaseUtils - getHSQLDBInfo] {} ", exception);
            }
        }
        return hashtable;
    }

    private static Hashtable getDB2Info(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "IBM_Db2_server";
        String string3 = "Default*";
        String string4 = "localhost";
        String string5 = "50000";
        try {
            if (string != null && string.startsWith("jdbc:db2:")) {
                int n = (string = string.substring(string.indexOf(":db2:") + 5)).lastIndexOf("/");
                if (n > 1) {
                    string3 = string.substring(n + 1);
                    if (string3 != null && string3.indexOf(";") > -1) {
                        string3 = string3.substring(0, string3.indexOf(";"));
                    }
                    string = string.substring(0, n);
                }
                if (string3.length() == 0) {
                    string3 = "Default*";
                }
                if (string != null && string.startsWith("//")) {
                    if ((string = string.substring(2)).indexOf("]") > 0) {
                        string4 = string.substring(0, string.indexOf("]") + 1);
                        if ((string = string.substring(string.indexOf("]") + 1)).startsWith(":")) {
                            string5 = string.substring(1);
                        }
                    } else {
                        int n2 = string.indexOf(":");
                        if (n2 > 0) {
                            string5 = string.substring(n2 + 1);
                            string4 = string = string.substring(0, n2);
                        } else if (string != null && string.length() > 0) {
                            string4 = string;
                        }
                    }
                } else {
                    string3 = string;
                    if (string3 != null && string3.indexOf(";") > -1) {
                        string3 = string3.substring(0, string3.indexOf(";"));
                    }
                }
                hashtable.put("SERVERTYPE", string2);
                hashtable.put("SERVERNAME", string4);
                hashtable.put("PORTNUMBER", string5);
                hashtable.put("DATABASENAME", string3);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[Exception Occured in DataBaseUtils - getDB2info] {} ", exception);
        }
        return hashtable;
    }

    private static Hashtable getSQLDBInfo(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (string.startsWith("jdbc:sqlserver://") || string.startsWith("jdbc:microsoft:sqlserver://")) {
                String string2 = "MS_sql_server";
                String string3 = "localhost";
                String string4 = "1433";
                String string5 = "Default*";
                String string6 = string;
                int n = string.indexOf("://");
                if (n > 0) {
                    string6 = string6.substring(n + 3);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n2 = string6.indexOf(";");
                    boolean bl = false;
                    if (n2 > -1) {
                        String string7 = string6.substring(n2 + 1);
                        string6 = string6.substring(0, n2);
                        if (string7 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string7, ";");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string8 = stringTokenizer.nextToken();
                                if (string8 == null || string8.indexOf("=") <= 0) continue;
                                String string9 = string8.substring(0, string8.indexOf("="));
                                if (string9.indexOf("\\") > -1) {
                                    string9 = string9.substring(0, string9.indexOf("\\"));
                                }
                                String string10 = string8.substring(string8.indexOf("=") + 1);
                                hashMap.put(string9.toLowerCase(), string10);
                            }
                        }
                        if (hashMap.containsKey("databasename")) {
                            string5 = (String)hashMap.get("databasename");
                        }
                        if (hashMap.containsKey("servername")) {
                            string3 = (String)hashMap.get("servername");
                            bl = true;
                        }
                        if (hashMap.containsKey("port")) {
                            string4 = (String)hashMap.get("port");
                        }
                    }
                    if (string6 != null && string6.length() > 0) {
                        int n3 = string6.indexOf(":");
                        if (n3 == 0) {
                            string4 = string6.substring(n3 + 1);
                        } else if (n3 > 0) {
                            string4 = string6.substring(n3 + 1);
                            if (!bl) {
                                string3 = string6.substring(0, n3);
                            }
                        } else if (n3 == -1 && !bl) {
                            string3 = string6;
                        }
                    }
                    if (string3.indexOf("\\") > 0) {
                        string3 = string3.substring(0, string3.indexOf("\\"));
                    }
                    hashtable.put("SERVERTYPE", string2);
                    hashtable.put("PORTNUMBER", string4);
                    hashtable.put("SERVERNAME", string3);
                    hashtable.put("DATABASENAME", string5);
                }
            } else if (string.startsWith("jdbc:jtds:sqlserver://") || string.startsWith("jdbc:jtds:sybase://")) {
                String string11 = "MS_sql_server";
                String string12 = "localhost";
                String string13 = "1433";
                String string14 = "Default*";
                String string15 = string;
                int n = string.indexOf("://");
                if (n > 0) {
                    int n4;
                    string15 = string.substring(n + 3);
                    String string16 = string.substring(0, n);
                    if (string16.indexOf(":sqlserver") > 0) {
                        string11 = "MS_sql_server";
                    } else if (string16.indexOf(":sybase") > 0) {
                        string11 = "Sybase_server";
                    }
                    int n5 = string15.indexOf(";");
                    if (n5 > -1) {
                        String string17 = string15.substring(n5 + 1);
                        string15 = string15.substring(0, n5);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (string17 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string17, ";");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string18 = stringTokenizer.nextToken();
                                if (string18 == null || string18.indexOf("=") <= 0) continue;
                                String string19 = string18.substring(0, string18.indexOf("="));
                                if (string19.indexOf("\\") > -1) {
                                    string19 = string19.substring(0, string19.indexOf("\\"));
                                }
                                String string20 = string18.substring(string18.indexOf("=") + 1);
                                hashMap.put(string19.toLowerCase(), string20);
                            }
                        }
                        if (hashMap.containsKey("databasename")) {
                            string14 = (String)hashMap.get("databasename");
                        }
                        if (hashMap.containsKey("servername")) {
                            string12 = (String)hashMap.get("servername");
                        }
                        if (hashMap.containsKey("port")) {
                            string13 = (String)hashMap.get("port");
                        }
                    }
                    if ((n4 = string15.lastIndexOf("/")) == 0) {
                        string14 = string15.substring(n4 + 1);
                    } else if (n4 > 0) {
                        int n6;
                        string14 = string15.substring(n4 + 1);
                        string15 = string15.substring(0, n4);
                        int n7 = string15.indexOf("]");
                        boolean bl = false;
                        if (n7 > -1) {
                            string12 = string15.substring(0, n7 + 1);
                            string15 = string15.substring(n7 + 1);
                            bl = true;
                        }
                        if ((n6 = string15.indexOf(":")) > -1) {
                            string13 = string15.substring(n6 + 1);
                            string15 = string15.substring(0, n6);
                        }
                        if (!bl) {
                            if (string15.indexOf("/") > 0) {
                                string12 = string15.substring(0, string15.indexOf("/"));
                            } else if (string15 != null && string15.length() > 0) {
                                string12 = string15;
                            }
                        }
                    } else if (n4 == -1) {
                        int n8;
                        int n9 = string15.indexOf("]");
                        boolean bl = false;
                        if (n9 > -1) {
                            string12 = string15.substring(0, n9 + 1);
                            string15 = string15.substring(n9 + 1);
                            bl = true;
                        }
                        if ((n8 = string15.indexOf(":")) > -1) {
                            string13 = string15.substring(n8 + 1);
                            string15 = string15.substring(0, n8);
                        }
                        if (!bl) {
                            if (string15.indexOf("/") > 0) {
                                string12 = string15.substring(0, string15.indexOf("/"));
                            } else if (string15 != null && string15.length() > 0) {
                                string12 = string15;
                            }
                        }
                    }
                }
                hashtable.put("SERVERTYPE", string11);
                hashtable.put("PORTNUMBER", string13);
                hashtable.put("SERVERNAME", string12);
                hashtable.put("DATABASENAME", string14);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[Exception Occured in DataBaseUtils - getSQLDBInfo] {}", exception);
        }
        return hashtable;
    }

    private static Hashtable getMySQLDBInfo(String string) {
        Hashtable<String, String> hashtable;
        block18: {
            hashtable = new Hashtable<String, String>();
            try {
                int n;
                hashtable.put("SERVERTYPE", "MySql_server");
                String string2 = "3306";
                if (string == null || string.indexOf("://") <= 0) break block18;
                int n2 = (string = string.substring(string.indexOf("://") + 3)).indexOf("?");
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                if ((n = string.lastIndexOf("/")) < 0) break block18;
                String string3 = string.substring(string.lastIndexOf("/") + 1);
                string = string.substring(0, string.lastIndexOf("/"));
                if (string3 != null && string3.length() == 0) {
                    string3 = "-";
                }
                hashtable.put("DATABASENAME", string3);
                int n3 = string.indexOf("=");
                if (n3 > 0) {
                    String string4;
                    String string5;
                    String string6 = string.toLowerCase();
                    int n4 = string6.indexOf("(host=");
                    int n5 = string6.indexOf("(port=");
                    if (n4 >= 0) {
                        string5 = string6.substring(n4 + 6);
                        string4 = string5.substring(0, string5.indexOf(")"));
                        hashtable.put("SERVERNAME", string4);
                    } else {
                        hashtable.put("SERVERNAME", "localhost");
                    }
                    if (n5 >= 0) {
                        string5 = string6.substring(n5 + 6);
                        string4 = string5.substring(0, string5.indexOf(")"));
                        hashtable.put("PORTNUMBER", string4);
                    } else {
                        hashtable.put("PORTNUMBER", string2);
                    }
                    break block18;
                }
                if (string.indexOf(":") >= 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                    String string7 = "127.0.0.1";
                    int n6 = stringTokenizer.countTokens();
                    if (n6 == 1) {
                        String string8 = stringTokenizer.nextToken();
                        hashtable.put("PORTNUMBER", string8);
                        hashtable.put("SERVERNAME", string7);
                        break block18;
                    }
                    if (n6 != 2) break block18;
                    String string9 = stringTokenizer.nextToken();
                    String string10 = stringTokenizer.nextToken();
                    hashtable.put("PORTNUMBER", string10);
                    if (string9 == null || string9.equals("") || string9.equalsIgnoreCase("localhost")) {
                        try {
                            String string11;
                            string7 = string11 = InetAddress.getLocalHost().getHostName();
                        }
                        catch (Exception exception) {
                            string7 = "127.0.0.1";
                        }
                        hashtable.put("SERVERNAME", string7);
                        break block18;
                    }
                    hashtable.put("SERVERNAME", string9);
                    break block18;
                }
                String string12 = "127.0.0.1";
                if (string != null && string.length() > 0) {
                    string12 = string;
                }
                if (string12 != null && string12.equalsIgnoreCase("localhost")) {
                    try {
                        String string13;
                        string12 = string13 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hashtable.put("SERVERNAME", string12);
                hashtable.put("PORTNUMBER", string2);
            }
            catch (Exception exception) {
                BTMLog.logger.error("[Exception Occured in DataBaseUtils - getMySQLDBInfo] {} ", exception);
            }
        }
        return hashtable;
    }

    public static Hashtable getOracleDBInfo(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string.startsWith("jdbc")) {
            String string2 = "localhost";
            String string3 = "1521";
            String string4 = "";
            String string5 = string;
            if (string.indexOf("@") > -1) {
                string5 = string.substring(string.indexOf("@") + 1);
            } else if (string.indexOf(":oci:") > -1) {
                string5 = string.substring(string.lastIndexOf(":") + 1);
            }
            if (string5.startsWith("(")) {
                String string6;
                int n;
                int n2;
                int n3;
                int n4 = string5.indexOf("(HOST=");
                if (n4 == -1) {
                    n4 = string5.indexOf("(host=");
                }
                if ((n3 = string5.indexOf("(PORT=")) == -1) {
                    n3 = string5.indexOf("(port=");
                }
                if ((n2 = string5.indexOf("(SID=")) == -1) {
                    n2 = string5.indexOf("(sid=");
                }
                if ((n = string5.indexOf("(SERVICE_NAME=")) == -1) {
                    n = string5.indexOf("(service_name=");
                }
                if (n4 > 0) {
                    string6 = string5.substring(n4 + 6);
                    string2 = string6.substring(0, string6.indexOf(")"));
                }
                if (n3 > 0) {
                    string6 = string5.substring(n3 + 6);
                    string3 = string6.substring(0, string6.indexOf(")"));
                }
                if (n2 > 0) {
                    string6 = string5.substring(n2 + 5);
                    string4 = string6.substring(0, string6.indexOf(")"));
                } else if (n > 0) {
                    string6 = string5.substring(n + 14);
                    string4 = string6.substring(0, string6.indexOf(")"));
                }
            } else if (string5.indexOf("[") >= 0) {
                int n;
                if (string5.indexOf("[") > 0) {
                    string5 = string5.substring(string5.indexOf("["));
                }
                int n5 = string5.indexOf("]");
                String string7 = string5;
                if (n5 > 0) {
                    string2 = string7.substring(0, n5 + 1);
                    string7 = string7.substring(n5 + 1);
                }
                if (string7.startsWith(":")) {
                    string7 = string7.substring(1);
                }
                if ((n = string7.indexOf("/")) >= 0) {
                    string4 = string7.substring(n + 1);
                    string7 = string7.substring(0, n);
                } else {
                    int n6 = string7.lastIndexOf(":");
                    if (n6 > 0) {
                        string4 = string7.substring(n6 + 1);
                        string7 = string7.substring(0, n6);
                    }
                }
                string3 = string7;
            } else if (string5.startsWith("//")) {
                int n = (string5 = string5.substring(2)).indexOf(":");
                if (n > 0) {
                    string2 = string5.substring(0, n);
                    String string8 = string5.substring(n + 1);
                    int n7 = string8.indexOf("/");
                    if (n7 > 0) {
                        string3 = string8.substring(0, n7);
                        string4 = string8.substring(n7 + 1);
                    }
                } else if (n == 0) {
                    int n8 = string5.indexOf("/");
                    if (n8 > 0) {
                        string3 = string5.substring(1, n8);
                        string4 = string5.substring(n8 + 1);
                    }
                } else {
                    int n9 = string5.indexOf("/");
                    if (n9 == 0) {
                        string4 = string5.substring(n9 + 1);
                    }
                    if (n9 > 0) {
                        string2 = string5.substring(0, n9);
                        string4 = string5.substring(n9 + 1);
                    }
                }
            } else {
                StringTokenizer stringTokenizer;
                int n;
                if (string5.startsWith(":")) {
                    string5 = " " + string5;
                }
                if ((n = (stringTokenizer = new StringTokenizer(string5, ":")).countTokens()) == 3) {
                    string2 = stringTokenizer.nextToken().trim();
                    if (string2.length() == 0) {
                        string2 = "localhost";
                    }
                    if ((string3 = stringTokenizer.nextToken().trim()).length() == 0) {
                        string3 = "1521";
                    }
                    string4 = stringTokenizer.nextToken();
                } else if (n == 2) {
                    string2 = stringTokenizer.nextToken();
                    String string9 = stringTokenizer.nextToken();
                    if (string9.indexOf("/") > -1) {
                        string3 = string9.substring(0, string9.indexOf("/"));
                        string4 = string9.substring(string9.indexOf("/") + 1);
                    } else {
                        try {
                            int n10 = Integer.parseInt(string9);
                            string3 = Integer.toString(n10);
                        }
                        catch (Exception exception) {
                            string4 = string9;
                        }
                    }
                } else if (n == 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 == null || string3.equals("")) {
                string3 = "1521";
            }
            if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("localhost")) {
                string2 = "127.0.0.1";
                try {
                    String string10;
                    string2 = string10 = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            hashtable.put("SERVERTYPE", "Oracle_server");
            hashtable.put("SERVERNAME", string2);
            hashtable.put("PORTNUMBER", string3);
            hashtable.put("DATABASENAME", string4);
        }
        return hashtable;
    }
}

