/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.adapter.EgJMSConnectionMethodAdviceAdapter;
import com.eg.agent.adapter.EgServletFilterMethodAdviceAdapter;
import com.eg.agent.adapter.EgServletResponseAdviceAdapter;
import com.eg.agent.adapter.EgThreadMethodAdviceAdapter;
import com.eg.agent.visitor.EgBaseClassVisitor;
import com.eg.jtm.BTMLog;
import com.eg.jtm.EgCustomPointCutManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.HashMap;

public class EgOtherClassVisitor
extends EgBaseClassVisitor {
    private boolean servletFilter = false;
    private boolean servletResponse = false;
    private boolean pojoFlag = false;
    private boolean jmsFlag = false;
    private boolean runnableFlag = false;
    private boolean bootLoader = false;
    private boolean isExcludePojoClass = false;
    private boolean byteCodeChanged = false;
    private boolean isInterface;
    private int classFileVersion;
    private static final HashMap<String, String> JMSMapping = new HashMap();

    public EgOtherClassVisitor(ClassVisitor classVisitor, String string, ArrayList arrayList, ArrayList arrayList2, HashMap hashMap, boolean bl, ClassLoader classLoader, int n) {
        super(458752, classVisitor);
        this.className = string;
        this.methodMap = hashMap;
        this.classFileVersion = n;
        this.bootLoader = classLoader == null;
        this.isExcludePojoClass = bl;
        this.customPCmethodList = null;
        if (this.isExcludePojoClass) {
            this.customPCpresent = false;
        } else {
            this.customPCmethodList = EgCustomPointCutManager.getInstance().getCustomPointCutMethodList(string);
            if (this.customPCmethodList != null && this.customPCmethodList.size() > 0) {
                this.customPCpresent = true;
            }
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            if (arrayList2.indexOf("javax/servlet/Filter") >= 0) {
                this.servletFilter = true;
            }
            if (arrayList2.indexOf("javax/servlet/http/HttpServletResponse") >= 0) {
                this.servletResponse = true;
            }
            if (arrayList2.indexOf("javax/jms/Connection") >= 0 || arrayList2.indexOf("javax/jms/Session") >= 0 || arrayList2.indexOf("javax/jms/MessageProducer") >= 0 || arrayList2.indexOf("javax/jms/MessageConsumer") >= 0 || arrayList2.indexOf("javax/jms/JMSContext") >= 0) {
                this.jmsFlag = true;
            }
            if (arrayList2.indexOf("java/lang/Runnable") >= 0) {
                this.runnableFlag = true;
            }
            this.pojoFlag = !(this.servletFilter || this.jmsFlag || this.servletResponse);
        } else {
            this.pojoFlag = true;
        }
        if (this.pojoFlag && (bl || this.bootLoader)) {
            this.pojoFlag = false;
        }
        BTMLog.debugLogger.info("[EgOtherClassVisitor] : {} : \t {} : \t servletFilter : {} \t servletResponse : {} \t pojoFlag : {}  & Loader is {} ", string, arrayList2, this.servletFilter, this.servletResponse, this.pojoFlag, classLoader);
    }

    public boolean isPojoFlag() {
        return this.pojoFlag;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.cv != null) {
            this.isInterface = (n2 & 0x200) != 0;
            this.cv.visit(n, n2, string, string2, string3, stringArray);
        }
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
        if (methodVisitor != null) {
            if (this.isInterface || (n & 0x100) != 0 || (n & 0x400) != 0) {
                return methodVisitor;
            }
            if (string.equals("<clinit>") || string.equals("<init>")) {
                return methodVisitor;
            }
            if (this.servletFilter && (string.equals("doFilter") || string.equals("init"))) {
                methodVisitor = new EgServletFilterMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            }
            if (this.servletResponse) {
                if (string.equals("sendError") || string.equals("setStatus")) {
                    methodVisitor = new EgServletResponseAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
                } else if (string.equals("getWriter") && string2.equals("()Ljava/io/PrintWriter;")) {
                    methodVisitor = new EgServletResponseAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion, 1);
                } else if (string.equals("getOutputStream") && string2.equals("()Ljavax/servlet/ServletOutputStream;")) {
                    methodVisitor = new EgServletResponseAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion, 2);
                }
            }
            if (this.jmsFlag && JMSMapping.containsKey(string)) {
                methodVisitor = new EgJMSConnectionMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.runnableFlag, this.classFileVersion);
            }
            if (this.runnableFlag && string.equals("run")) {
                methodVisitor = new EgThreadMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            }
            if (this.pojoFlag) {
                ArrayList arrayList;
                boolean bl = false;
                if (this.methodMap != null && this.methodMap.containsKey(string) && (arrayList = (ArrayList)this.methodMap.get(string)) != null && arrayList.contains(string2)) {
                    bl = true;
                }
                if (!(bl || this.runnableFlag && string.equals("run"))) {
                    methodVisitor = this.visitPointcutForCustomAndPojo(n, methodVisitor, string, string2);
                }
            }
        }
        return methodVisitor;
    }

    public boolean isByteCodeChanged() {
        return this.byteCodeChanged;
    }

    static {
        JMSMapping.put("receive", "JMS");
        JMSMapping.put("receiveNoWait", "JMS");
        JMSMapping.put("createSession", "JMS");
        JMSMapping.put("createContext", "JMS");
        JMSMapping.put("createQueueSession", "JMS");
        JMSMapping.put("createTopicSession", "JMS");
        JMSMapping.put("createProducer", "JMS");
        JMSMapping.put("send", "JMS");
        JMSMapping.put("createConsumer", "JMS");
        JMSMapping.put("close", "JMS");
        JMSMapping.put("createSender", "JMS");
        JMSMapping.put("createReceiver", "JMS");
        JMSMapping.put("createSubscriber", "JMS");
        JMSMapping.put("createDurableSubscriber", "JMS");
        JMSMapping.put("createPublisher", "JMS");
        JMSMapping.put("run", "JMS");
    }
}

