/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.adapter.ConnectionPoolMethodAdviceAdapter;
import com.eg.agent.adapter.EgDriverMethodAdviceAdapter;
import com.eg.agent.adapter.EgMySQLStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLCallableStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLConnectionMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLPreparedStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLStatmentMethodAdviceAdapter;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.HashMap;

public class EgSQLClassVisitor
extends ClassVisitor {
    private String className;
    private boolean driverFlag = false;
    private boolean connectionFlag = false;
    private boolean connectionPoolFlag = false;
    private boolean isCallableStmt = false;
    private boolean isPreparedStmt = false;
    private boolean isStmt = false;
    private boolean isMySQL = false;
    private int classFileVersion;
    private static final HashMap<String, String> CONNECTION_POOL_METHODS = new HashMap();
    private static final HashMap<String, String> STATMENT_METHODS = new HashMap();
    private static final HashMap<String, String> CONNECTION_METHODS = new HashMap();

    public EgSQLClassVisitor(ClassVisitor classVisitor, String string, ArrayList arrayList, int n) {
        super(458752, classVisitor);
        this.className = string;
        this.classFileVersion = n;
        this.isMySQL = string.startsWith("com/mysql/jdbc/");
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.indexOf("java/sql/CallableStatement") >= 0) {
                this.isCallableStmt = true;
            } else if (arrayList.indexOf("java/sql/PreparedStatement") >= 0) {
                this.isPreparedStmt = true;
            } else if (arrayList.indexOf("java/sql/Statement") >= 0) {
                this.isStmt = true;
            } else if (arrayList.indexOf("java/sql/Driver") >= 0) {
                this.driverFlag = true;
            } else if (arrayList.indexOf("java/sql/Connection") >= 0) {
                this.connectionFlag = true;
            } else if (arrayList.indexOf("javax/sql/DataSource") >= 0 || arrayList.indexOf("javax/sql/ConnectionPoolDataSource") >= 0 || arrayList.indexOf("javax/sql/XADataSource") >= 0) {
                this.connectionPoolFlag = true;
            }
        }
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
        if ((n & 0x100) != 0 || (n & 0x400) != 0) {
            return methodVisitor;
        }
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return methodVisitor;
        }
        if (methodVisitor != null) {
            if (this.driverFlag && string.equals("connect")) {
                methodVisitor = new EgDriverMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.connectionPoolFlag && CONNECTION_POOL_METHODS.containsKey(string)) {
                methodVisitor = new ConnectionPoolMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.connectionFlag && CONNECTION_METHODS.containsKey(string)) {
                methodVisitor = new EgSQLConnectionMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isCallableStmt && STATMENT_METHODS.containsKey(string)) {
                methodVisitor = new EgSQLCallableStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isPreparedStmt && STATMENT_METHODS.containsKey(string)) {
                methodVisitor = new EgSQLPreparedStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isStmt && STATMENT_METHODS.containsKey(string)) {
                methodVisitor = this.isMySQL ? new EgMySQLStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion) : new EgSQLStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            }
        }
        return methodVisitor;
    }

    static {
        CONNECTION_POOL_METHODS.put("getConnection", "getConnection");
        CONNECTION_POOL_METHODS.put("getPooledConnection", "getPooledConnection");
        CONNECTION_POOL_METHODS.put("getXAConnection", "getXAConnection");
        STATMENT_METHODS.put("close", "close");
        STATMENT_METHODS.put("cancel", "cancel");
        STATMENT_METHODS.put("getResultSet", "getResultSet");
        STATMENT_METHODS.put("executeBatch", "executeBatch");
        STATMENT_METHODS.put("executeUpdate", "executeUpdate");
        STATMENT_METHODS.put("executeQuery", "executeQuery");
        STATMENT_METHODS.put("addBatch", "addBatch");
        CONNECTION_METHODS.put("commit", "commit");
        CONNECTION_METHODS.put("close", "close");
        CONNECTION_METHODS.put("rollback", "rollback");
        CONNECTION_METHODS.put("prepareCall", "prepareCall");
        CONNECTION_METHODS.put("prepareStatement", "prepareStatement");
        CONNECTION_METHODS.put("clientPrepareStatement", "clientPrepareStatement");
        CONNECTION_METHODS.put("serverPrepareStatement", "serverPrepareStatement");
    }
}

