/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.net;

import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.net.ReceiverBase;
import com.eg.ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.net.DefaultSocketConnector;
import com.eg.ch.qos.logback.core.net.SocketConnector;
import com.eg.ch.qos.logback.core.util.CloseUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketReceiver
extends ReceiverBase
implements Runnable,
SocketConnector.ExceptionHandler {
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private String remoteHost;
    private InetAddress address;
    private int port;
    private int reconnectionDelay;
    private int acceptConnectionTimeout = 5000;
    private String receiverId;
    private volatile Socket socket;
    private Future<Socket> connectorTask;

    @Override
    protected boolean shouldStart() {
        int n = 0;
        if (this.port == 0) {
            ++n;
            this.addError("No port was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_port");
        }
        if (this.remoteHost == null) {
            ++n;
            this.addError("No host name or address was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_host");
        }
        if (this.reconnectionDelay == 0) {
            this.reconnectionDelay = 30000;
        }
        if (n == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                this.addError("unknown host: " + this.remoteHost);
                ++n;
            }
        }
        if (n == 0) {
            this.receiverId = "receiver " + this.remoteHost + ":" + this.port + ": ";
        }
        return n == 0;
    }

    @Override
    protected void onStop() {
        if (this.socket != null) {
            CloseUtil.closeQuietly(this.socket);
        }
    }

    @Override
    protected Runnable getRunnableTask() {
        return this;
    }

    @Override
    public void run() {
        try {
            LoggerContext loggerContext = (LoggerContext)this.getContext();
            while (!Thread.currentThread().isInterrupted()) {
                SocketConnector socketConnector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay);
                this.connectorTask = this.activateConnector(socketConnector);
                if (this.connectorTask != null) {
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket != null) {
                        this.dispatchEvents(loggerContext);
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addInfo("shutting down");
    }

    private SocketConnector createConnector(InetAddress inetAddress, int n, int n2, int n3) {
        SocketConnector socketConnector = this.newConnector(inetAddress, n, n2, n3);
        socketConnector.setExceptionHandler(this);
        socketConnector.setSocketFactory(this.getSocketFactory());
        return socketConnector;
    }

    private Future<Socket> activateConnector(SocketConnector socketConnector) {
        try {
            return this.getContext().getScheduledExecutorService().submit(socketConnector);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
    }

    private Socket waitForConnectorToReturnASocket() throws InterruptedException {
        try {
            Socket socket = this.connectorTask.get();
            this.connectorTask = null;
            return socket;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dispatchEvents(LoggerContext loggerContext) {
        HardenedLoggingEventInputStream hardenedLoggingEventInputStream = null;
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            hardenedLoggingEventInputStream = new HardenedLoggingEventInputStream(this.socket.getInputStream());
            this.socket.setSoTimeout(0);
            this.addInfo(this.receiverId + "connection established");
            while (true) {
                ILoggingEvent iLoggingEvent;
                Logger logger;
                if (!(logger = loggerContext.getLogger((iLoggingEvent = (ILoggingEvent)hardenedLoggingEventInputStream.readObject()).getLoggerName())).isEnabledFor(iLoggingEvent.getLevel())) {
                    continue;
                }
                logger.callAppenders(iLoggingEvent);
            }
        }
        catch (EOFException eOFException) {
            this.addInfo(this.receiverId + "end-of-stream detected");
            CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
        }
        catch (IOException iOException) {
            this.addInfo(this.receiverId + "connection failed: " + iOException);
            CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.addInfo(this.receiverId + "unknown event class: " + classNotFoundException);
            {
                catch (Throwable throwable) {
                    CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
                    CloseUtil.closeQuietly(this.socket);
                    this.socket = null;
                    this.addInfo(this.receiverId + "connection closed");
                    throw throwable;
                }
            }
            CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
        }
    }

    @Override
    public void connectionFailed(SocketConnector socketConnector, Exception exception) {
        if (exception instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (exception instanceof ConnectException) {
            this.addInfo(this.receiverId + "connection refused");
        } else {
            this.addInfo(this.receiverId + exception);
        }
    }

    protected SocketConnector newConnector(InetAddress inetAddress, int n, int n2, int n3) {
        return new DefaultSocketConnector(inetAddress, n, n2, n3);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setReconnectionDelay(int n) {
        this.reconnectionDelay = n;
    }

    public void setAcceptConnectionTimeout(int n) {
        this.acceptConnectionTimeout = n;
    }
}

