/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.pattern;

import com.eg.ch.qos.logback.classic.pattern.ClassicConverter;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDCConverter
extends ClassicConverter {
    private String key;
    private String defaultValue = "";

    @Override
    public void start() {
        String[] stringArray = OptionHelper.extractDefaultReplacement(this.getFirstOption());
        this.key = stringArray[0];
        if (stringArray[1] != null) {
            this.defaultValue = stringArray[1];
        }
        super.start();
    }

    @Override
    public void stop() {
        this.key = null;
        super.stop();
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        Map<String, String> map = iLoggingEvent.getMDCPropertyMap();
        if (map == null) {
            return this.defaultValue;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys(map);
        }
        String string = map.get(this.key);
        if (string != null) {
            return string;
        }
        return this.defaultValue;
    }

    private String outputMDCForAllKeys(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

