/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.selector.servlet;

import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import com.eg.ch.qos.logback.classic.util.JNDIUtil;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Object object;
        String string = null;
        try {
            object = JNDIUtil.getInitialContext();
            string = JNDIUtil.lookup((Context)object, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (string != null) {
            System.out.println("About to detach context named " + string);
            object = ContextSelectorStaticBinder.getSingleton().getContextSelector();
            if (object == null) {
                System.out.println("Selector is null, cannot detach context. Skipping.");
                return;
            }
            LoggerContext loggerContext = object.getLoggerContext(string);
            if (loggerContext != null) {
                Logger logger = loggerContext.getLogger("ROOT");
                logger.warn("Stopping logger context " + string);
                object.detachLoggerContext(string);
                loggerContext.stop();
            } else {
                System.out.println("No context named " + string + " was found.");
            }
        }
    }
}

