/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.CustomQueue;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BTMQueue<E>
implements CustomQueue<E> {
    private Queue<E> queue = null;
    private int maxLimit = 0;

    public BTMQueue(int n) {
        this.maxLimit = n;
        this.queue = new LinkedBlockingQueue(this.maxLimit);
    }

    @Override
    public boolean enqueue(E e) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException illegalStateException) {
            int n = this.queue.size();
            BTMLog.logger.warn("Could not add element to Queue, queue size is {} ", (Object)n);
            try {
                this.queue.poll();
                BTMLog.logger.warn("Removed and Discarded the old(head) elements from queue");
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Could not delete element from Queue, due to the exception {} ", exception);
            }
            BTMLog.logger.debug("Attempting to add element into queue after removing old(head) element");
            return this.enqueue(e, true);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Could not add element to queue, due to the exception {} ", exception);
            return false;
        }
    }

    public boolean enqueue(E e, boolean bl) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException illegalStateException) {
            int n = this.queue.size();
            BTMLog.logger.warn("The second attempt to add element into queue is failed. Queue size is :{} ", (Object)n);
            BTMLog.logger.warn("Discarding element .... {} ", (Object)e.toString());
            return false;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Could not add element to Queue, due to the exception {} ", exception);
            return false;
        }
    }

    @Override
    public E dequeue() {
        E e = null;
        try {
            e = this.queue.poll();
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Could not delete element from Queue, due to the exception {} ", exception);
        }
        return e;
    }

    final void clearQueue() {
        try {
            this.queue.clear();
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Could not clear elements from Queue, due to the exception {} ", exception);
        }
    }

    public int getSize() {
        return this.queue.size();
    }
}

