/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.ACTION;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.LogCleanUp;
import com.eg.jtm.ThreadPoolManager;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;

public class ContainerDiscoveryHelperThread
extends Thread {
    private boolean done = false;
    private boolean status = false;
    private static boolean isDockerContainerCheckDone = false;
    private ACTION actionItem = ACTION.NONE;
    private static final String LOG_HEADER = "[CONTAINER DISCOVERY HELPER] ";

    public ContainerDiscoveryHelperThread(ACTION aCTION) {
        String string = "eG_BTM_" + (Object)((Object)aCTION);
        this.setName(string);
        this.setDaemon(true);
        this.actionItem = aCTION;
        this.start();
        BTMLog.logger.info("{} Thread - {} initiated", (Object)LOG_HEADER, (Object)string);
    }

    boolean isDone() {
        return this.done;
    }

    public boolean isStatus() {
        return this.status;
    }

    private void submitDiscoveryDetails() {
        if (BTMOffLoadConfig.isDiscoveryMode()) {
            try {
                Thread.sleep(30000L);
                ContainerDiscovery.storeClassNameDiscoveredDataToStartupDiscovery();
                Hashtable hashtable = ContainerDiscovery.getDiscoveredDetailsByStartup();
                if (hashtable != null && hashtable.containsKey("DISCOVERED")) {
                    HashMap<String, Hashtable> hashMap = new HashMap<String, Hashtable>();
                    hashMap.put("STARTUP_DISCOVERY_DETAILS", hashtable);
                    ThreadPoolManager.getThreadPoolManager().submitTask(hashMap);
                    BTMLog.logger.info("{} Discovered details are submitted on the startup successfully !!!", (Object)LOG_HEADER);
                } else {
                    BTMLog.logger.warn("{} Due to absence of discovered details, skipping startup discovery submission !!!", (Object)LOG_HEADER);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Exception during startup discovery submission due to {} ", (Object)LOG_HEADER, (Object)exception);
            }
        }
    }

    private void updateConfigWithDockerHostIP() {
        String string = ContainerDiscovery.getDockerContainerHostIp();
        BTMLog.logger.info("{} Found DOCKER Host IP Address {}", (Object)LOG_HEADER, (Object)string);
        if (string != null && string.length() > 0) {
            BTMOffLoadConfig.writeDetailsInConfig("AGENT_CONTAINER_IP", string);
            BTMLog.logger.info("{} DOCKER Host IP Address Stored into config.props", (Object)LOG_HEADER);
        }
    }

    public void run() {
        if (this.actionItem == ACTION.SUBMIT_DISCOVERD_CONTAINER_DETAILS) {
            this.submitDiscoveryDetails();
            this.status = true;
            this.done = true;
            return;
        }
        if (this.actionItem == ACTION.GRANT_BTM_LOGS_FILE_ACCESS) {
            this.grantBtmLogsFileAccess();
            this.status = true;
            this.done = true;
            return;
        }
        if (this.actionItem == ACTION.DELETE_BTM_LOG_FILES) {
            LogCleanUp.doLogDeletionProcess();
            this.status = true;
            this.done = true;
            return;
        }
        try {
            if (!isDockerContainerCheckDone) {
                ContainerDiscovery.isDockerContainer();
                if (!ContainerDiscovery.isThisDockerContainer()) {
                    ContainerDiscovery.isCrioContainer();
                }
                isDockerContainerCheckDone = true;
            }
            BTMLog.logger.debug("{} DOCKER Container Check Done? {}", (Object)LOG_HEADER, (Object)isDockerContainerCheckDone);
            boolean bl = ContainerDiscovery.isThisDockerContainer();
            BTMLog.logger.info("{} eG BTM Running on DOCKER Container? {}", (Object)LOG_HEADER, (Object)bl);
            BTMLog.logger.debug("{} Docker Container - {}, Crio Container - {}, K8POD - {} ", LOG_HEADER, bl, ContainerDiscovery.isCrioContainer(), ContainerDiscovery.isKubernetesPOD());
            if (bl) {
                if (this.actionItem == ACTION.DISCOVER_CONTAINER_HOST_IP) {
                    this.updateConfigWithDockerHostIP();
                } else if (this.actionItem == ACTION.DISCOVER_FULL_CONTAINER_DETAILS) {
                    boolean bl2 = ContainerDiscovery.isPODContainer();
                    if (!bl2) {
                        bl2 = ContainerDiscovery.isKubernetesPOD();
                    }
                    ContainerDiscovery.printOutLog("INFO", "[CONTAINER DISCOVERY HELPER]  Is this DOCKER Container? " + bl + " & Is this POD? " + bl2);
                    BTMLog.logger.info("{} Is eG BTM Running on DOCKER Container inside of POD? {}", (Object)LOG_HEADER, (Object)bl2);
                    String string = "NONE";
                    String string2 = "NONE";
                    String string3 = "NONE";
                    if (bl2) {
                        string = ContainerDiscovery.getDockerContainerIDFromPod();
                        if (string != null && string.length() > 0 && (string = string.trim()).length() >= 64) {
                            string = string.trim().substring(0, 12);
                        }
                        if ((string2 = ContainerDiscovery.getDockerContainerIdOrPodName()) != null && string2.length() > 0) {
                            string2 = string2.trim();
                        }
                        if ((string3 = ContainerDiscovery.getKubernetesNameSpaceName()) != null && string3.length() > 0) {
                            string3 = string3.trim();
                        }
                    } else {
                        string = ContainerDiscovery.getDockerContainerIdOrPodName();
                        if (string != null && string.length() > 0 && (string = string.trim()).length() >= 64) {
                            string = string.trim().substring(0, 12);
                        }
                    }
                    ContainerDiscovery.setContainerName(string);
                    String string4 = ContainerDiscovery.getDockerContainerIp();
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("IS_CONTAINER", "true");
                    hashtable.put("IS_KUBERNETES", bl2 ? "true" : "false");
                    hashtable.put("CONTAINER_ID", string);
                    hashtable.put("CONTAINER_NAME", string);
                    hashtable.put("CONTAINER_IP", string4);
                    hashtable.put("POD_NAME", string2);
                    hashtable.put("POD_NAME_SPACE", string3);
                    hashtable.put("POD_IP", string4);
                    ContainerDiscovery.getDiscoveredDetailsByRequest().putAll(hashtable);
                    ContainerDiscovery.getDiscoveredDetailsByStartup().putAll(hashtable);
                    if (BTMLog.logger.isInfoEnabled()) {
                        BTMLog.logger.info("{} DOCKER ID                  : {}", (Object)LOG_HEADER, (Object)string);
                        BTMLog.logger.info("{} DOCKER CONTAINER_IP        : {}", (Object)LOG_HEADER, (Object)string4);
                        BTMLog.logger.info("{} DOCKER POD NAME            : {}", (Object)LOG_HEADER, (Object)string2);
                        BTMLog.logger.info("{} DOCKER POD NAMESPACE      : {}", (Object)LOG_HEADER, (Object)string3);
                        BTMLog.logger.info("{} DOCKER Discovery Details   : {}", (Object)LOG_HEADER, (Object)ContainerDiscovery.getDiscoveredDetailsByRequest());
                        ContainerDiscovery.printOutLog("INFO", "DOCKER ID             : " + string);
                        ContainerDiscovery.printOutLog("INFO", "DOCKER CONTAINER_IP   : " + string4);
                        ContainerDiscovery.printOutLog("INFO", "DOCKER POD NAME       : " + string2);
                        ContainerDiscovery.printOutLog("INFO", "DOCKER POD NAMESPACE  : " + string3);
                        ContainerDiscovery.printOutLog("INFO", "On Memory Docker ID   : " + ContainerDiscovery.getContainerName());
                    }
                }
            } else {
                ContainerDiscovery.addToStartupDiscoveryDetails("IS_STANDALONE", "true");
            }
            this.status = true;
            this.done = true;
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            this.done = true;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("DOCKER Discovery Failure due to ", exception);
            this.done = true;
            this.status = false;
        }
    }

    private void grantBtmLogsFileAccess() {
        try {
            String string = BTMOffLoadConfig.getLogPathWithSubFolderName();
            BTMLog.logger.info("{} Granting permission for cleaning BTM log files to eG Users/Groups {} ", (Object)LOG_HEADER, (Object)string);
            File file = new File(string);
            if (file.exists()) {
                ContainerDiscovery.grantBtmLogFolderAccess(string);
            } else {
                BTMLog.logger.debug("{} {} Does not exist, Skipping file permission granting process.", (Object)LOG_HEADER, (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Exception during Granting permission for cleaning BTM log files ", (Object)LOG_HEADER, (Object)exception);
        }
    }
}

