/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;

public class JavaAgentCommunicator
implements Runnable {
    private Socket socket;
    private boolean usingDesignatedIP = false;
    private static final String egAgentSharedSecretKey = "BTM";
    private static InetAddress registeredAgentIpAddress = null;
    private static long registeredAgentLastCommunicationTime = 0L;
    private static boolean isBTMFirstTime = false;
    private static boolean isKeyBTMFirstTime = false;

    JavaAgentCommunicator(boolean bl, Socket socket) {
        this.socket = socket;
        this.usingDesignatedIP = bl;
    }

    public void run() {
        try {
            if (registeredAgentLastCommunicationTime == 0L && registeredAgentIpAddress == null) {
                isBTMFirstTime = true;
                isKeyBTMFirstTime = true;
            }
            this.agentCommunicationHandler();
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception while handling request from Agent (Test) {}", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void agentCommunicationHandler() throws IOException {
        block63: {
            block62: {
                block64: {
                    var1_1 = null;
                    var2_2 = null;
                    var3_3 = null;
                    this.socket.setTcpNoDelay(true);
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    var6_6 = this.socket.getInetAddress();
                    BTMLog.logger.info("Socket connection has established from the client IP : {} ", (Object)var6_6);
                    var4_4 = new ObjectOutputStream(this.socket.getOutputStream());
                    var5_5 = new ObjectInputStream(this.socket.getInputStream());
                    var7_7 = var5_5.readObject();
                    if (!(var7_7 instanceof ArrayList)) break block62;
                    var1_1 = (ArrayList)var7_7;
                    BTMLog.logger.info("agentDataList :{} ", (Object)var1_1);
                    if (var1_1 == null || var1_1.size() <= 0) break block63;
                    if (!"BTM".equals((String)var1_1.remove(0))) ** GOTO lbl47
                    if (JavaAgentCommunicator.registeredAgentIpAddress == null) {
                        this.performAgentRegistration(var6_6);
                        break block63;
                    }
                    var8_11 = (int)this.performAgentRejection(var6_6);
                    if (var8_11 == 0) break block64;
                    BTMLog.logger.warn(" Invalid Agent !! {} :==> {} Registered Agent is : {} ", new Object[]{var6_6, var1_1, JavaAgentCommunicator.registeredAgentIpAddress});
                    var4_4.writeObject(new String("Invalid Agent !!!!"));
                    var4_4.flush();
                    try {
                        if (var1_1 != null) {
                            var1_1.clear();
                            var1_1 = null;
                        }
                        if (var5_5 != null) {
                            var5_5.close();
                            var5_5 = null;
                        }
                        if (var4_4 != null) {
                            var4_4.close();
                            var4_4 = null;
                        }
                        if (this.socket != null) {
                            this.socket.close();
                            this.socket = null;
                        }
                    }
                    catch (Exception var9_15) {
                        // empty catch block
                    }
                    return;
                }
                break block63;
lbl47:
                // 1 sources

                BTMLog.logger.warn(" Invalid Agent !!! {} :==> {} Registered Agent is : {} ", new Object[]{var6_6, var1_1, JavaAgentCommunicator.registeredAgentIpAddress});
                var4_4.writeObject(new String("Invalid Agent !!!!"));
                var4_4.flush();
                try {
                    if (var1_1 != null) {
                        var1_1.clear();
                        var1_1 = null;
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                        var5_5 = null;
                    }
                    if (var4_4 != null) {
                        var4_4.close();
                        var4_4 = null;
                    }
                    if (this.socket != null) {
                        this.socket.close();
                        this.socket = null;
                    }
                }
                catch (Exception var8_12) {
                    // empty catch block
                }
                return;
            }
            BTMLog.logger.warn(" Invalid Agent !!!! {} :==> {} Registered Agent is : {} ", new Object[]{var6_6, var1_1, JavaAgentCommunicator.registeredAgentIpAddress});
            var4_4.writeObject(new String("Invalid Request !!!!" + var6_6 + " ==> " + var1_1));
            var4_4.flush();
            try {
                if (var1_1 != null) {
                    var1_1.clear();
                    var1_1 = null;
                }
                if (var5_5 != null) {
                    var5_5.close();
                    var5_5 = null;
                }
                if (var4_4 != null) {
                    var4_4.close();
                    var4_4 = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (Exception var8_13) {
                // empty catch block
            }
            return;
        }
        try {
            block65: {
                try {
                    var8_11 = var1_1.size();
                    if (var8_11 > 0) {
                        var3_3 = (String)var1_1.remove(0);
                    }
                    try {
                        var9_16 = var5_5.readObject();
                        if (var9_16 instanceof Hashtable) {
                            var2_2 = (Hashtable)var9_16;
                            BTMLog.logger.info("Threshold information from eG Agent : {} ", (Object)var2_2);
                            break block65;
                        }
                        var9_16 = null;
                    }
                    catch (Exception var9_17) {
                        BTMLog.logger.error("Exception Occured while reading thresholdObject {}", var9_17);
                    }
                }
                catch (Exception var7_8) {
                    BTMLog.logger.error("Error reading AgentData ArrayList from Test {}", var7_8);
                    try {
                        if (var1_1 != null) {
                            var1_1.clear();
                            var1_1 = null;
                        }
                        if (var5_5 != null) {
                            var5_5.close();
                            var5_5 = null;
                        }
                        if (var4_4 != null) {
                            var4_4.close();
                            var4_4 = null;
                        }
                        if (this.socket != null) {
                            this.socket.close();
                            this.socket = null;
                        }
                    }
                    catch (Exception var8_14) {
                        // empty catch block
                    }
                    return;
                }
            }
            this.socket.setSoTimeout(1000);
            BTMLog.logger.info("Received request for data from agent : {} & Registered Agent is {} Entity : {}", new Object[]{var6_6, JavaAgentCommunicator.registeredAgentIpAddress, var3_3});
            var7_9 = var1_1.size();
            if (var3_3 != null && var3_3.length() > 0) {
                if (var3_3.equals("BusinessTransTest")) {
                    if (var1_1.size() > 0 && JavaAgentCommunicator.registeredAgentIpAddress.equals(var6_6)) {
                        PropsManager.handlePropChangesFromTest(var1_1, var3_3);
                        JavaAgentCommunicator.isBTMFirstTime = false;
                    }
                    if (JavaAgentCommunicator.registeredAgentIpAddress.equals(var6_6)) {
                        if (JavaAgentCommunicator.isBTMFirstTime && var7_9 == 0) {
                            BTMLog.logger.warn("Web/Application server has rebooted, so it requires initial config data from eG Agent for the test {} ", (Object)"BusinessTransTest");
                            UPDManager.sendMeasures(var4_4, var5_5, true, var3_3);
                            JavaAgentCommunicator.isBTMFirstTime = false;
                        } else {
                            UPDManager.sendMeasures(var4_4, var5_5, false, var3_3);
                        }
                    }
                } else if (var3_3.equals("KBusinessTransTest")) {
                    if (var1_1.size() > 0 && JavaAgentCommunicator.registeredAgentIpAddress.equals(var6_6)) {
                        PropsManager.handlePropChangesFromTest(var1_1, var3_3);
                        JavaAgentCommunicator.isKeyBTMFirstTime = false;
                    }
                    if (JavaAgentCommunicator.registeredAgentIpAddress.equals(var6_6)) {
                        if (JavaAgentCommunicator.isKeyBTMFirstTime && var7_9 == 0) {
                            BTMLog.logger.warn("Web/Application server has rebooted, so it requires initial config data from eG Agent for the test {} ", (Object)"KBusinessTransTest");
                            UPDManager.sendMeasures(var4_4, var5_5, true, var3_3);
                            JavaAgentCommunicator.isKeyBTMFirstTime = false;
                        } else {
                            UPDManager.sendMeasures(var4_4, var5_5, false, var3_3);
                        }
                    }
                }
            }
        }
        catch (Throwable var10_18) {
            throw var10_18;
        }
        finally {
            try {
                if (var1_1 != null) {
                    var1_1.clear();
                    var1_1 = null;
                }
                if (var5_5 != null) {
                    var5_5.close();
                    var5_5 = null;
                }
                if (var4_4 != null) {
                    var4_4.close();
                    var4_4 = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (Exception var11_19) {}
        }
        if (var2_2 != null && var2_2.size() > 0) {
            if (var3_3.equals("BusinessTransTest")) {
                PropsManager.updateAutoPatternThreshold(var2_2);
            } else if (var3_3.equals("KBusinessTransTest")) {
                PropsManager.updateManualPatternThreshold(var2_2);
            }
        }
    }

    private boolean performAgentRejection(InetAddress inetAddress) {
        boolean bl = false;
        if (!registeredAgentIpAddress.equals(inetAddress)) {
            if (!PropsManager.isTalkingToAgent()) {
                long l = System.currentTimeMillis() - registeredAgentLastCommunicationTime;
                BTMLog.logger.info("Milliseconds since registered agent has contacted : {}", (Object)l);
                if (l > PropsManager.getRASwitchOverCutoff()) {
                    registeredAgentIpAddress = inetAddress;
                    BTMLog.logger.info("Since no designated agent was specified and registered agent switched over cutoff has exceeded, registered agent is now the currently active agent at : {} ", (Object)registeredAgentIpAddress);
                } else {
                    BTMLog.logger.warn("Rejecting request from unregistered agent at {}  Registered IP is : {} ", (Object)inetAddress.toString(), (Object)registeredAgentIpAddress);
                    bl = true;
                }
            } else {
                BTMLog.logger.warn("Rejecting Request from Invalid Client !!! {}  Registered IP is : {} ", (Object)inetAddress.toString(), (Object)registeredAgentIpAddress);
                bl = true;
            }
        } else {
            registeredAgentLastCommunicationTime = System.currentTimeMillis();
        }
        return bl;
    }

    private void performAgentRegistration(InetAddress inetAddress) {
        if (this.usingDesignatedIP) {
            if (registeredAgentIpAddress == null || UPDManager.hasDesigAgtChanged()) {
                registeredAgentIpAddress = UPDManager.getDesigAgtInetAddr();
                BTMLog.logger.info("Registered the designated agent {} ", (Object)registeredAgentIpAddress.toString());
                UPDManager.resetDesigAgtChanged();
            }
        } else if (registeredAgentIpAddress == null) {
            registeredAgentIpAddress = inetAddress;
            BTMLog.logger.info("Registering agent {} ", (Object)registeredAgentIpAddress.toString());
        }
    }
}

