/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.EgCustomPointCutManager;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.Threshold;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = "Unknown";
    private List<Long> children = null;
    private MethodInfo parent = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private long executionTime = -1L;
    private Map properties = null;
    private transient int status = 0;
    private transient boolean isStartComponent = false;
    private transient boolean slowURL = false;
    private transient boolean errorURL = false;
    private transient boolean isStalled = false;
    private transient boolean isSQLPresent = false;
    private static final transient String DDCellColSep = "#=#";
    private static final transient String DDCellRowSep = "%*%";
    private static final transient String ExtCallSep = "[*#*]";
    private transient String urlPatternsMatched = null;
    private String className = null;
    private String methodName = null;
    private String desc = null;
    private long id = -999L;

    public MethodInfo() {
        this.isStartComponent = false;
        this.children = new ArrayList<Long>();
        this.id = -1L;
    }

    public MethodInfo(String string, String string2, String string3, MethodInfo methodInfo, long l, HashMap<Long, MethodInfo> hashMap) {
        this.className = string;
        this.methodName = string2;
        this.desc = string3;
        this.parent = methodInfo;
        this.children = new ArrayList<Long>();
        this.isStartComponent = false;
        this.id = l;
        hashMap.put(this.id, this);
    }

    public MethodInfo(String string, String string2, String string3, MethodInfo methodInfo, String string4, long l, HashMap<Long, MethodInfo> hashMap) {
        this.className = string;
        this.methodName = string2;
        this.desc = string3;
        this.parent = methodInfo;
        this.urlPatternsMatched = string4;
        this.children = new ArrayList<Long>();
        this.isStartComponent = true;
        this.id = 0L;
        hashMap.put(this.id, this);
    }

    public MethodInfo(String string) {
    }

    public String getLearningKey() {
        return this.className + "#" + this.methodName + "#" + this.desc;
    }

    public StringBuffer getMethodDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.className);
        stringBuffer.append(".");
        stringBuffer.append(this.methodName);
        stringBuffer.append(".");
        stringBuffer.append(this.desc);
        stringBuffer.append(".");
        return stringBuffer;
    }

    public String getUrlPatternsMatched() {
        return this.urlPatternsMatched;
    }

    public String getGuidString() {
        if (this.isStartComponent) {
            return (String)this.properties.get("GUID");
        }
        return "";
    }

    public void setErrorURL(boolean bl) {
        this.errorURL = bl;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getRawURL() {
        if (this.isStartComponent) {
            return (String)this.properties.get("requestID");
        }
        return "";
    }

    public boolean isStartComponent() {
        return this.isStartComponent;
    }

    public List<Long> getChildMinfos() {
        return this.children;
    }

    public void addToChildInfo(HashMap<Long, MethodInfo> hashMap, MethodInfo methodInfo) {
        long l = methodInfo.getId();
        this.children.add(l);
        hashMap.put(l, methodInfo);
    }

    public void clearAllChildInfos(HashMap<Long, MethodInfo> hashMap) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Long l = this.children.get(i);
            hashMap.remove(l);
        }
        this.children.clear();
    }

    void addChildMinfo(MethodInfo methodInfo, HashMap<Long, MethodInfo> hashMap) {
        long l = methodInfo.getId();
        hashMap.put(l, methodInfo);
        if (!this.children.add(l)) {
            BTMLog.logger.warn("Could not add child Minfo to list. Child Minfo {} ", (Object)methodInfo.toSimpleString());
            hashMap.remove(l);
        }
    }

    void removeChildMinfo(MethodInfo methodInfo, HashMap<Long, MethodInfo> hashMap) {
        long l = methodInfo.getId();
        hashMap.remove(l);
        if (!this.children.remove(l)) {
            hashMap.put(l, methodInfo);
        }
    }

    public MethodInfo getParent() {
        return this.parent;
    }

    public void setParent(MethodInfo methodInfo) {
        this.parent = methodInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long l) {
        this.startTime = l;
        this.status = 0;
    }

    public long getEndTime() {
        return this.endTime;
    }

    void setEndTime(long l, boolean bl) {
        this.endTime = l;
        this.status = bl ? 2 : 1;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isStalled() {
        return this.isStalled;
    }

    public static boolean isFrontEndComponent(String string) {
        return BTMUtils.FRONT_END_MAPPING.containsKey(string);
    }

    public long getExecutionTime() {
        if (this.executionTime == -1L) {
            if (this.isCompleted()) {
                this.executionTime = this.endTime - this.startTime;
                return this.executionTime;
            }
            long l = System.currentTimeMillis() - this.startTime;
            return l;
        }
        return this.executionTime;
    }

    public void setExecutionTime() {
        this.executionTime = 0L;
    }

    public int getStatus() {
        return this.status;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public boolean isCompleted() {
        return this.status != 0;
    }

    private String toSimpleString() {
        if (this.isStartComponent) {
            BTMLog.logger.info(this.printTree());
            return this.getMethodDisplayName() + " - " + this.getExecutionTime();
        }
        return this.getMethodDisplayName() + " - " + this.getExecutionTime();
    }

    public String printTree() {
        String string = this.status == 0 ? "Starting." : (this.status == 1 ? "Completed successfully." : (this.status == 2 ? "Completed with Execption!." : "Completed with unknown status!!!!."));
        return new StringBuffer((String)this.getProperties().get("requestID")).append(" - ").append(this.getExecutionTime()).append(". [ SLOW = ").append(this.isSlowURL()).append(" ] [ ERROR = ").append(this.isErrorURL()).append(" ] [ STALLED = ").append(this.isStalled()).append(" ] [ Patterns = ").append(this.getUrlPatternsMatched() != null ? this.getUrlPatternsMatched().toString() : "none").append(" ] [ AT TREE TOP = ").append(this.isStartComponent).append(" ]. ").append(string).toString() + "GUID :" + this.getGuidString();
    }

    private String getTree(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.printNodes(stringBuilder, this, this, "0", bl);
        return stringBuilder.toString();
    }

    private StringBuffer getNodeLabelAndURLParam(MethodInfo methodInfo, String string) {
        String string2;
        String string3 = methodInfo.getType();
        long l = methodInfo.getExecutionTime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l);
        stringBuffer.append(DDCellColSep).append(methodInfo.getMethodDisplayName());
        stringBuffer.append(DDCellColSep).append(string3);
        String string4 = BTMUtils.EXTERNAL_MAPPING.get(string3);
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            stringBuffer.append(ExtCallSep).append(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                String string6 = (String)methodInfo.getProperties().get(string5);
                if (string6 == null) {
                    string6 = "-";
                }
                stringBuffer.append(DDCellColSep).append(string6);
            }
        } else if (string3.equals("EXCEPTION")) {
            String string7 = (String)methodInfo.getProperties().get("EXCEPTION");
            if (string7 != null && string7.length() > 0) {
                stringBuffer.append(ExtCallSep).append(string);
                stringBuffer.append(DDCellColSep).append(string7.substring(0, string7.indexOf("?^?")));
                stringBuffer.append(DDCellColSep).append(string7);
            }
        } else if (string3.startsWith("Custom_") && (string2 = EgCustomPointCutManager.getInstance().getCustomPointCutDisplayName(string3)) != null && string2.length() > 0) {
            stringBuffer.append(ExtCallSep).append(string);
            stringBuffer.append(DDCellColSep).append(string2);
        }
        return stringBuffer;
    }

    private void printNodes(StringBuilder stringBuilder, MethodInfo methodInfo, MethodInfo methodInfo2, String string, boolean bl) {
        HashMap hashMap = this.prepareOrderMap();
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        TreeSet treeSet = new TreeSet(hashMap.keySet());
        int n = treeSet.size();
        Iterator iterator = treeSet.iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            MethodInfo methodInfo3 = (MethodInfo)hashMap.get(string2);
            String string3 = methodInfo3.getType();
            if (bl) {
                stringBuilder.append(string2);
                stringBuilder.append(DDCellColSep).append(this.getNodeLabelAndURLParam(methodInfo3, string2));
                if (n2 < n) {
                    stringBuilder.append(DDCellRowSep);
                }
            } else if (string3.equals("SQL") || string3.equals("HTTP") || string3.equals("THREAD_INIT") || string3.equals("THREAD_JOIN") || string3.equals("WEBSERVICE") || string3.equals("JMS") || string3.equals("SAP JCO") || string3.startsWith("Custom_")) {
                stringBuilder.append(string2);
                stringBuilder.append(DDCellColSep).append(this.getNodeLabelAndURLParam(methodInfo3, string2));
                if (n2 < n) {
                    stringBuilder.append(DDCellRowSep);
                }
            }
            ++n2;
        }
    }

    public void calculateMinfo(RequestIdentifier requestIdentifier, boolean bl, String string) {
        if (!this.isStartComponent) {
            return;
        }
        if (requestIdentifier.isErrorOutBoundHTTP()) {
            this.setErrorURL(true);
        }
        boolean bl2 = requestIdentifier.isKeyTransactionRequest();
        Threshold threshold = PropsManager.getThreshold(bl2, string);
        double d = threshold.getSlowThreshold();
        double d2 = threshold.getStalledThreshold();
        BTMLog.logger.debug("Slow & Stalled Threshold for the {} is {} & {} ", string, d, d2);
        boolean bl3 = false;
        boolean bl4 = false;
        if (threshold.isValidThreshold()) {
            this.properties.put("SlowLimit", d);
            this.properties.put("StalledLimit", d2);
        } else {
            bl3 = threshold.isNoneThreshold();
            if (bl3) {
                this.properties.put("SlowLimit", -1.0);
                this.properties.put("StalledLimit", -1.0);
            }
            if (bl4 = threshold.isStalledUnLimited()) {
                this.properties.put("SlowLimit", d);
                this.properties.put("StalledLimit", -1.0);
            }
        }
        if (this.getExecutionTime() == 0L) {
            this.executionTime = 1L;
        }
        if (bl) {
            requestIdentifier.removeFromScheduledThreadPoolExecutor();
            if (!this.isErrorURL() && !bl3 && (double)this.getExecutionTime() > d) {
                this.slowURL = true;
                if ((double)this.getExecutionTime() > d2 && !bl4) {
                    this.isStalled = true;
                    this.slowURL = false;
                }
            }
        } else if (!this.isErrorURL() && !bl3) {
            if (bl4) {
                this.slowURL = true;
            } else {
                this.isStalled = true;
            }
        }
        if (PropsManager.isShowTraceInLog() && BTMLog.logger.isInfoEnabled()) {
            BTMLog.logger.info(this.getTree(true));
            BTMLog.logger.debug("Fast SQL: {} {} {} ", this.properties.get("Fast_Method_Map"), this.getRawURL(), this.getGuidString());
        }
    }

    public boolean isSlowURL() {
        return this.slowURL;
    }

    public boolean isErrorURL() {
        return this.errorURL;
    }

    public boolean isSQLPresent() {
        return this.isSQLPresent;
    }

    public void setSQLPresent(boolean bl) {
        this.isSQLPresent = bl;
    }

    public void clearURLTree() {
        try {
            HashMap hashMap = (HashMap)this.properties.remove("CHILD_MAP");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HashMap prepareOrderMap() {
        HashMap<String, MethodInfo> hashMap = new HashMap<String, MethodInfo>();
        try {
            Stack<MethodInfo> stack = new Stack<MethodInfo>();
            MethodInfo methodInfo = this;
            stack.push(methodInfo);
            HashMap<MethodInfo, String> hashMap2 = new HashMap<MethodInfo, String>();
            hashMap2.put(methodInfo, "0");
            hashMap.put("0", methodInfo);
            HashMap hashMap3 = (HashMap)this.properties.get("CHILD_MAP");
            while (!stack.isEmpty()) {
                methodInfo = (MethodInfo)stack.pop();
                String string = (String)hashMap2.get(methodInfo);
                ArrayList arrayList = (ArrayList)methodInfo.getChildMinfos();
                if (arrayList == null || arrayList.size() <= 0) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Long l = (Long)arrayList.get(i);
                    MethodInfo methodInfo2 = (MethodInfo)hashMap3.get(l);
                    if (methodInfo2 == null || methodInfo2.equals(methodInfo)) continue;
                    stack.push(methodInfo2);
                    hashMap2.put(methodInfo2, string + "." + i);
                    hashMap.put(string + "." + i, methodInfo2);
                }
            }
            stack = null;
        }
        catch (Exception exception) {
            BTMLog.logger.error(" Error Occured in prepareOrderMap {}", exception);
        }
        return hashMap;
    }

    public long getId() {
        return this.id;
    }
}

