/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.utils.CustomConfigurationManager;
import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.EgCustomPointCutManager;
import com.eg.jtm.EgProperties;
import com.eg.jtm.ExceptionTestConfigManager;
import com.eg.jtm.JVMConfig;
import com.eg.jtm.LogCleanUp;
import com.eg.jtm.Mode;
import com.eg.jtm.OtherAPMTestConfiguration;
import com.eg.jtm.RumPropsManager;
import com.eg.jtm.SnapshotManager;
import com.eg.jtm.StartServer;
import com.eg.jtm.StatusCodeErrorRange;
import com.eg.jtm.ThreadDiagnosis;
import com.eg.jtm.Threshold;
import com.eg.jtm.TimeZoneManager;
import com.eg.jtm.TraceLevel;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternMeasure;
import com.eg.jtm.discovery.ServerList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsManager {
    public static final String requestIDSep = " @ ";
    private static final int defaultLimit = 10;
    private static int Max_Slow_URLs = 10;
    private static int Max_Error_URLs = 10;
    private static int Max_Healthy_URLs = 10;
    private static int Max_Stalled_URLs = 10;
    private static double Meth_Exec_CutOff = 250.0;
    private static double Sql_Exec_CutOff = 10.0;
    private static boolean TraceHealthyURL = false;
    public static String EG_BTM_HOME = "";
    private static long requestInvokeCount = 100L;
    private static String JVM_GUID = "NONE";
    private static String REMOTE_ADDRESS_HEADER_NAME = null;
    public static int BTM_Port = -1;
    public static int prev_BTM_Port = -1;
    public static InetAddress DesigAgtInetAddr;
    public static boolean useDesigAgtOnly;
    public static boolean portChanged;
    public static boolean measPeriodChanged;
    public static boolean desigAgtChanged;
    private static volatile boolean requestConfigFromAgent;
    private static double Slow_URL_Threshold;
    private static long egMeasPeriod;
    private static long RASwitchOverCutoff;
    private static Vector excludeCharsList;
    private static final String[] subCompNames;
    private static int compNameLength;
    private static final Properties BTMProps;
    private static final Properties onMemoryBTMProps;
    private static boolean TalkingToAgent;
    private static int URLLevel;
    private static int lazyTimeInseconds;
    private static long maxTraceLines;
    private static long pojoTracePeriod;
    private static long maxTracePeriod;
    private static long maxSQLTraceCount;
    private static long maxSQLCountLimitPerBT;
    private static long maxSQLErrorTraceCount;
    private static int maxExceptionLineCount;
    private static int maxMongoDbQueryLimit;
    private static long captureExceptionsWithStackTraceLimit;
    private static long captureExceptionsWithFQENLimit;
    private static long captureExceptionsMaxTraceLimit;
    public static final String STALLED_THRESHOLD_PERIOD = "STALLED_THRESHOLD_PERIOD";
    private static long stalledThreshold;
    private static int Monitoring_Mode;
    private static final String MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT = "MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT";
    private static final String MAX_EXCE_FQEN_CAPTURE_LIMIT = "MAX_EXCE_FQEN_CAPTURE_LIMIT";
    private static final String MAX_EXCE_TRACE_COUNT_LIMIT = "MAX_EXCE_TRACE_COUNT_LIMIT";
    private static final String MAX_POJO_CALL_TRACE_COUNT = "MAX_POJO_CALL_TRACE_COUNT";
    private static final String MAX_POJO_CALL_TRACE_TIME = "MAX_POJO_CALL_TRACE_TIME";
    private static final String MAX_SQL_QUERY_COUNT = "MAX_SQL_QUERY_COUNT";
    private static final String MAX_SQL_ERROR_QUERY_COUNT = "MAX_SQL_ERROR_QUERY_COUNT";
    private static final String MAX_SQL_CALL_COUNT_LIMIT = "MAX_SQL_CALL_COUNT_LIMIT";
    private static final String Chars_TO_Exclude = "Chars_TO_Exclude";
    private static final String IGNORE_EXCEPTIONS = "IGNORE_EXCEPTIONS";
    private static final String INCLUDE_EXCEPTIONS = "INCLUDE_EXCEPTIONS";
    private static final String MAX_EXCEPTION_TRACE_LINE_COUNT = "MAX_EXCEPTION_TRACE_LINE_COUNT";
    private static final String MAX_POINTCUT_LIMIT = "MAX_POINTCUT_LIMIT";
    private static final String RECURSION_TRACE_LIMIT = "RECURSION_TRACE_LIMIT";
    private static final String SHOW_CALLGRAPH_IN_LOG = "SHOW_CALLGRAPH_IN_LOG";
    private static final String MAX_MONGODB_QUERY_LENGTH = "MAX_MONGODB_QUERY_LENGTH";
    private static final String MONITORING_MODE = "Monitoring_Mode";
    private static final String MAX_URL_SEGMENTS = "Max_URL_Segments";
    private static final String EXCLUDED_PATTERNS = "Excluded_Patterns";
    private static final String MANUAL_EXCLUDED_PATTERNS = "Manual_Excluded_Patterns";
    private static final String SLOW_URL_THRESHOLD = "Slow_URL_Threshold";
    private static final String STALLED_URL_THRESHOLD = "Stalled_URL_Threshold";
    private static final String METHOD_EXEC_CUTOFF = "Method_Exec_CutOff";
    private static final String SQL_EXEC_CUTOFF = "SQL_Exec_CutOff";
    private static final String MAX_SLOW_URLS_PER_TEST_PERIOD = "Max_Slow_URLs_Per_Test_Period";
    private static final String MAX_ERROR_URLS_PER_TEST_PERIOD = "Max_Error_URLs_Per_Test_Period";
    private static final String MAX_HEALTHY_URLS_PER_TEST_PERIOD = "Max_Healthy_URLs_Per_Test_Period";
    private static final String MAX_STALLED_URLS_PER_TEST_PERIOD = "Max_Stalled_URLs_Per_Test_Period";
    private static final String HEALTHY_URL_TRACE = "Healthy_URL_Trace";
    private static final String EGMEASPERIOD = "egMeasPeriod";
    private static final String URL_PATTERNS = "URL_Patterns";
    private static final String REQUEST_INVOKE_COUNT = "REQUEST_INVOKE_COUNT";
    private static final String REMOTE_HEADER_ADDRESS = "REMOTE_HEADER_ADDRESS";
    private static final String MAX_AUTO_GROUPED_URLS = "MAX_AUTO_GROUPED_URLS";
    private static final String MAX_MANUAL_GROUPED_URLS = "MAX_MANUAL_GROUPED_URLS";
    private static final int defaultLimit4GroupedURL = 50;
    private static int maxLimit4AutoGroupedURL;
    private static int maxLimit4ManualGroupedURL;
    private static final String HTTP_STATUS_CODE = "HTTP_STATUS_CODE";
    private static final String HTTP_COOKIES = "HTTP_COOKIES";
    private static final String HTTP_HEADERS = "HTTP_HEADERS";
    private static boolean CaptureHttpStatus;
    private static boolean CaptureHttpHeaders;
    private static boolean CaptureHttpCookies;
    private static final String ERROR_STATUS_CODE_RANGE = "ERROR_STATUS_CODE_RANGE";
    private static ArrayList ignoreExceptionList;
    private static ArrayList includeExceptionList;
    private static int otherPointcutMethodLimit;
    private static int recursionTraceLimit;
    private static boolean showTraceInLog;
    private static final String TRACK_CPU_TIME = "TRACK_CPU_TIME";
    private static final String TRACK_BLOCKED_WAITED_TIME = "TRACK_BLOCKED_WAITED_TIME";
    private static boolean isNewAgent;
    private static final String DEFAULT_EXCLUDED_URL = "*.ttf,*.otf,*.woff,*.woff2,*.eot,*.cff,*.afm,*.lwfn,*.ffil,*.fon,*.pfm,*.pfb,*.std,*.pro,*.xsf,*.jpg,*.jpeg,*.jpe,*.jif,*.jfif,*.jfi,*.jp2,*.j2k,*.jpf,*.jpx,*.jpm,*.jxr,*.hdp,*.wdp,*.mj2,*.webp,*.gif,*.png,*.apng,*.mng,*.tiff,*.tif,*.xbm,*.bmp,*.dib,*.svg,*.svgz,*.mpg,*.mpeg,*.mpeg2,*.avi,*.wmv,*.mov,*.rm,*.ram,*.swf,*.flv,*.ogg,*.webm,*.mp4,*.ts,*.mid,*.midi,*.rm,*.ram,*.wma,*.aac,*.wav,*.ogg,*.mp3,*.mp4,*.css,*.js,*.ico,*.cur,/egurkha*";
    public static File logPropsFile;
    public static File otherPropsFile;
    public static File configPropsFile;
    public static File cpcPropsFile;
    public static File thresholdPropsFile;
    public static File discoveryPropsFile;
    public static String logPropsFileName;
    public static String otherPropsFileName;
    private static String configPropsFileName;
    private static String cpcPropsFileName;
    private static String thresholdPropsFileName;
    private static String discoveryPropsFileName;
    private static String excludePropsFileName;
    private static File excludePropsFile;
    private static String commonPropsFileName;
    private static File commonPropsFile;
    private static boolean commonGuidPropsFileAvailable;
    public static Hashtable<String, String> manualPatternTable;
    public static Hashtable<String, String> autoPatternTable;
    public static Vector autoFilteredPatternsList;
    public static Vector manualFilteredPatternsList;
    private static final ConcurrentHashMap<String, Threshold> autoPatternThreshold;
    private static final ConcurrentHashMap<String, Threshold> manualPatternThreshold;
    private static final Threshold GLOBAL_THRESHOLD;
    public static boolean oldModel;
    private static TraceLevel instrumentationLevel;
    private static final String INSTRUMENTATION_LEVEL = "INSTRUMENTATION_LEVEL";
    public static Hashtable<String, String> autoDiscoveryHTable;
    public static final HashMap<String, Enum<ServerList>> autoDiscoveryEnumMappings;

    private PropsManager() {
    }

    static void initProps() {
        BTMProps.clear();
        BTMProps.putAll((Map<?, ?>)PropsManager.getBTMDefaultProperties());
        BTMProps.put("COMPONENT_GUID", "None");
        BTMProps.put("NODE_ID", "None");
        new TimeZoneManager();
    }

    static void loadPropsFromFile(boolean bl) {
        boolean bl2 = false;
        try {
            PropsManager.getConfigFromPropsFile();
            PropsManager.getAutoDiscoveryPropsFile();
            BTMProps.load(new BufferedInputStream(new FileInputStream(otherPropsFileName)));
            BTMLog.logger.info("Using the following parameters from file {} ", (Object)otherPropsFileName);
            BTMLog.logger.info(BTMProps.toString());
            bl2 = true;
            PropsManager.discoverCommonPropsFileLocation();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn(" BTM props file not found {} ", fileNotFoundException);
            bl2 = false;
        }
        catch (IOException iOException) {
            BTMLog.logger.warn(" IOException while trying to read from BTM props file {} ", iOException);
            bl2 = false;
        }
        if (bl & bl2) {
            String string = BTMProps.getProperty("PUSH_TO_AGENT_MODE");
            oldModel = string == null || !string.equalsIgnoreCase("true");
        }
    }

    static void discoverCommonPropsFileLocation() {
        if (commonGuidPropsFileAvailable) {
            return;
        }
        if (BTMOffLoadConfig.isDataCollectionMode()) {
            String string = PropsManager.getJvmGUID().replaceAll(":", "_");
            commonPropsFileName = EG_BTM_HOME + File.separatorChar + "conf" + File.separatorChar + string + ".props";
            commonPropsFile = new File(commonPropsFileName);
            if (commonPropsFile.exists()) {
                commonGuidPropsFileAvailable = true;
            } else {
                commonPropsFileName = EG_BTM_HOME + File.separatorChar + string + ".props";
                commonPropsFile = new File(commonPropsFileName);
                if (commonPropsFile.exists()) {
                    commonGuidPropsFileAvailable = true;
                }
            }
        }
        if (commonGuidPropsFileAvailable) {
            BTMLog.logger.warn("INFO:- Common Props file name : {} ", (Object)commonPropsFileName);
        }
    }

    public static boolean isCommonGuidPropsFileAvailable() {
        return commonGuidPropsFileAvailable;
    }

    private static void getAutoDiscoveryPropsFile() {
        String string = EG_BTM_HOME + File.separatorChar + "autodiscovery.props";
        try {
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            if (properties.isEmpty()) {
                BTMLog.logger.error("{} is empty, checking other possibility for auto discovery ", (Object)"autodiscovery.props");
                return;
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = string2.substring(string2.indexOf("_") + 1);
                String string4 = properties.getProperty(string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreElements()) {
                    autoDiscoveryHTable.put(stringTokenizer.nextToken().replace(".", "/"), string3);
                }
                autoDiscoveryEnumMappings.put(string3, ServerList.valueOf(string3.toUpperCase()));
            }
            BTMLog.logger.info("[Server Type Discovery] class name based identifications list : {} {}", (Object)autoDiscoveryHTable, (Object)autoDiscoveryEnumMappings);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("discovery file not found {} : {} ", (Object)string, (Object)exception);
        }
    }

    static void getConfigFromPropsFile() {
        String string = EG_BTM_HOME + File.separatorChar + "config.props";
        try {
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            if (properties.isEmpty()) {
                BTMLog.logger.error("{} is empty. Please download new {} file ", (Object)string, (Object)"config.props");
            } else {
                BTMLog.logger.info("Using the following parameters from file {} ", (Object)string);
                BTMLog.logger.info(BTMProps.toString());
                BTMProps.putAll((Map<?, ?>)properties);
                if (BTMOffLoadConfig.isMemoryCopyOnly()) {
                    BTMLog.logger.info("Loading on-memory of config into BTMProps : {} ", (Object)onMemoryBTMProps);
                    BTMProps.putAll((Map<?, ?>)onMemoryBTMProps);
                }
                BTMOffLoadConfig.updateOffLoadConfiguration();
                boolean bl = PropsManager.setValidJvmGUID(string);
                BTMLog.logger.debug("Is JVM GUID [{}] valid ? {} ", (Object)JVM_GUID, (Object)bl);
                JVMConfig.updateJVMTestConfigs();
                PropsManager.checkBTMTestStatus(false);
                BTMLog.logger.info("Common Props file name available: {} file name : {} ", (Object)PropsManager.isCommonGuidPropsFileAvailable(), (Object)PropsManager.getCommonFileName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn("Config file not found {} : {} ", (Object)string, (Object)fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            BTMLog.logger.warn("IOException while trying to read from {} : {} ", (Object)string, (Object)iOException);
        }
    }

    private static void checkBTMTestStatus(boolean bl) {
        Object object;
        if (BTMProps.containsKey("TransactionFlowTest") && BTMProps.getProperty("TransactionFlowTest").equalsIgnoreCase("true")) {
            OtherAPMTestConfiguration.setFlowTestRunning(true);
        } else {
            OtherAPMTestConfiguration.setFlowTestRunning(false);
        }
        if (BTMProps.containsKey("HttpStatusCodeTest") && BTMProps.getProperty("HttpStatusCodeTest").equalsIgnoreCase("true")) {
            OtherAPMTestConfiguration.setStatusCodeTestRunning(true);
        } else {
            OtherAPMTestConfiguration.setStatusCodeTestRunning(false);
        }
        if (!BTMProps.containsKey("KBusinessTransTest") && !BTMProps.containsKey("BusinessTransTest")) {
            return;
        }
        if (BTMProps.getProperty("KBusinessTransTest").equalsIgnoreCase("false")) {
            manualPatternTable.clear();
            PropsManager.setTalkingToAgent(false);
            object = (String)BTMProps.get(URL_PATTERNS);
            if (!((String)object).equalsIgnoreCase("none")) {
                BTMProps.setProperty(URL_PATTERNS, "none");
                if (!bl) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(URL_PATTERNS, "none");
                    BTMOffLoadConfig.writeOffloadConfigProps(hashMap);
                }
            }
            BTMLog.logger.debug(" KBusinessTransTest test is disabled.");
            PropsManager.clearThresholdData("Thresh4KB>", bl);
        }
        if (BTMProps.getProperty("BusinessTransTest").equalsIgnoreCase("false")) {
            BTMLog.logger.debug(" BusinessTransTest test is disabled.");
            PropsManager.setTalkingToAgent(false);
            PropsManager.clearThresholdData("Thresh4B>", bl);
        }
        if (BTMProps.getProperty("BusinessTransTest").equalsIgnoreCase("false") && BTMProps.getProperty("KBusinessTransTest").equalsIgnoreCase("false")) {
            object = PropsManager.getBTMDefaultProperties();
            if (bl) {
                BTMProps.putAll((Map<?, ?>)object);
            } else {
                BTMOffLoadConfig.writeOffloadConfigProps((HashMap)object);
            }
        }
        if ((BTMProps.getProperty("KBusinessTransTest").equalsIgnoreCase("true") || BTMProps.getProperty("BusinessTransTest").equalsIgnoreCase("true")) && !PropsManager.isTalkingToAgent()) {
            PropsManager.setTalkingToAgent(true);
        }
    }

    private static void clearThresholdData(String string, boolean bl) {
        if (bl) {
            return;
        }
        String string2 = EG_BTM_HOME + File.separatorChar + "threshold.props";
        try {
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string2)));
            BTMLog.logger.info("Using the following parameters from file {} ", (Object)string2);
            BTMLog.logger.info(properties.toString());
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(properties);
            Set<Object> set = hashtable.keySet();
            for (String string3 : set) {
                if (!string3.startsWith(string)) continue;
                properties.remove(string3);
            }
            properties.store(new FileOutputStream(thresholdPropsFile), "Please, Don't edit below threshold.details for the component : " + BTMOffLoadConfig.getNodeID());
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn("Thresh file not found {} : {}", (Object)string2, (Object)fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            BTMLog.logger.warn("IOException while trying to read from {} : {}", (Object)string2, (Object)iOException);
        }
    }

    static void getThreshFromPropsFile() {
        if (!BTMProps.containsKey("KBusinessTransTest") && !BTMProps.containsKey("BusinessTransTest")) {
            return;
        }
        String string = EG_BTM_HOME + File.separatorChar + "threshold.props";
        try {
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            BTMLog.logger.info("Using the following parameters from file {}", (Object)string);
            BTMLog.logger.info(properties.toString());
            if (((String)BTMProps.get("BusinessTransTest")).equalsIgnoreCase("true")) {
                PropsManager.updateAutoPatternThreshold(PropsManager.spiltThresh(properties, "Thresh4B>"));
            }
            if (((String)BTMProps.get("KBusinessTransTest")).equalsIgnoreCase("true")) {
                PropsManager.updateManualPatternThreshold(PropsManager.spiltThresh(properties, "Thresh4KB>"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn("Config file not found {} : {}", (Object)string, (Object)fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            BTMLog.logger.warn("IOException while trying to read from {} : {}", (Object)string, (Object)iOException);
        }
    }

    private static Hashtable spiltThresh(Properties properties, String string) {
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)properties.get(string2);
            if (!string2.startsWith(string)) continue;
            string2 = string2.replace(string, "");
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    private static boolean setValidJvmGUID(String string) {
        boolean bl = false;
        String string2 = System.getProperty("eG_Component_GUID");
        if (string2 == null || string2.length() <= 0) {
            string2 = BTMProps.getProperty("COMPONENT_GUID");
        }
        if (string2 != null && string2.length() > 0) {
            JVM_GUID = string2;
            BTMLog.logger.info("JVM is assigned with the GUID : {}", (Object)JVM_GUID);
            bl = true;
        } else {
            BTMLog.logger.warn("JVM GUID is not available in the {} ", (Object)string);
        }
        return bl;
    }

    public static boolean isOldModel() {
        return oldModel;
    }

    private static void updateThreshold(Hashtable<String, String> hashtable, ConcurrentHashMap<String, Threshold> concurrentHashMap) {
        Set<String> set = hashtable.keySet();
        for (String string : set) {
            Threshold threshold;
            double d;
            String string2 = hashtable.get(string);
            int n = string2.indexOf("/");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            int n2 = string2.indexOf("Unlimited");
            if (n2 == -1) {
                try {
                    double d2 = Double.parseDouble(string3);
                    d = Double.parseDouble(string4);
                    threshold = new Threshold(d, d2);
                    concurrentHashMap.put(string, threshold);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("Invalid threshold for the pattern : {} & Value : {} , {} ", string, string3, string4);
                }
                continue;
            }
            if (n2 == 0) {
                try {
                    int n3 = string3.indexOf("#");
                    if (n3 <= 0) continue;
                    String string5 = string3.substring(n3 + 1);
                    d = Double.parseDouble(string5);
                    double d3 = Double.parseDouble(string4);
                    Threshold threshold2 = new Threshold(true, d3, d);
                    concurrentHashMap.put(string, threshold2);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("Invalid threshold for the pattern : {} & Value : {} , {} ", string, string3, string4);
                }
                continue;
            }
            if (n2 <= 0) continue;
            try {
                if (string4 == null || !string4.equals("Unlimited")) continue;
                BTMLog.logger.info("Threshold configured for the pattern \"{}\" is Unlimited.!!!", (Object)string);
                double d4 = Double.parseDouble(string3);
                d = -1.0;
                threshold = new Threshold(d, d4, true);
                concurrentHashMap.put(string, threshold);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Invalid threshold for the pattern : {} & Value : {} , {} ", string, string3, string4);
            }
        }
    }

    static void updateAutoPatternThreshold(Hashtable hashtable) {
        PropsManager.updateThreshold(hashtable, autoPatternThreshold);
        BTMLog.logger.info("Thresholds for Auto Patterns : {} ", (Object)autoPatternThreshold);
    }

    static void updateManualPatternThreshold(Hashtable hashtable) {
        PropsManager.updateThreshold(hashtable, manualPatternThreshold);
        BTMLog.logger.info("Thresholds for Auto Patterns : {} ", (Object)manualPatternThreshold);
    }

    static void handlePropChangesFromTest(ArrayList arrayList, String string) {
        String string2;
        BTMLog.logger.info("Received props from agent: {} from : {} ", (Object)arrayList, (Object)string);
        boolean bl = false;
        if (string.equals("BusinessTransTest")) {
            bl = true;
        }
        int n = arrayList.size();
        int n2 = 26;
        String string3 = (String)arrayList.get(0);
        if (PropsManager.isIntegerPropUpdated(MONITORING_MODE, string3)) {
            PropsManager.setMonitoringMode(string3);
        }
        if (bl) {
            String string4 = (String)arrayList.get(1);
            if (PropsManager.isIntegerPropUpdated(MAX_URL_SEGMENTS, string4)) {
                UPDManager.setNoOfURLSegments(string4);
            }
        } else {
            string2 = (String)arrayList.get(1);
            if (PropsManager.isStringPropUpdated(URL_PATTERNS, PropsManager.cleanupPatternStr(string2, true))) {
                UPDManager.updateKeyPatternData(string2);
            }
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.equalsIgnoreCase("none")) {
                    UPDManager.setValidPattern(false);
                } else {
                    UPDManager.setValidPattern(true);
                }
            }
        }
        if (bl) {
            string2 = (String)arrayList.get(2);
            if (PropsManager.isStringPropUpdated(EXCLUDED_PATTERNS, PropsManager.cleanupFilteredPatternStr(string2))) {
                UPDManager.updateAutoFilteredPatternsTbl(string2);
            }
        } else {
            string2 = (String)arrayList.get(2);
            if (PropsManager.isStringPropUpdated(MANUAL_EXCLUDED_PATTERNS, PropsManager.cleanupFilteredPatternStr(string2))) {
                UPDManager.updateManualFilteredPatternsTbl(string2);
            }
        }
        if (PropsManager.isDoublePropUpdated(SLOW_URL_THRESHOLD, string2 = (String)arrayList.get(3))) {
            PropsManager.setSlowURLThreshold(string2);
        }
        if (PropsManager.isDoublePropUpdated(STALLED_URL_THRESHOLD, string2 = (String)arrayList.get(4))) {
            PropsManager.setStalledURLThreshold(string2);
        }
        if (PropsManager.isDoublePropUpdated(METHOD_EXEC_CUTOFF, string2 = (String)arrayList.get(5))) {
            PropsManager.setMethExecCutOff(string2);
        }
        if (PropsManager.isDoublePropUpdated(SQL_EXEC_CUTOFF, string2 = (String)arrayList.get(6))) {
            PropsManager.setSqlExecCutOff(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_SLOW_URLS_PER_TEST_PERIOD, string2 = (String)arrayList.get(7))) {
            PropsManager.setMaxSlowURLs(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_ERROR_URLS_PER_TEST_PERIOD, string2 = (String)arrayList.get(8))) {
            PropsManager.setMaxErrorURLs(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_HEALTHY_URLS_PER_TEST_PERIOD, string2 = (String)arrayList.get(9))) {
            PropsManager.setHealthyURLs(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_STALLED_URLS_PER_TEST_PERIOD, string2 = (String)arrayList.get(10))) {
            PropsManager.setMaxStalledURLs(string2);
        }
        if (PropsManager.isStringPropUpdated(HEALTHY_URL_TRACE, string2 = (String)arrayList.get(11))) {
            PropsManager.setHealthyUrlTrace(string2);
        }
        if (PropsManager.isLongPropUpdated(EGMEASPERIOD, string2 = (String)arrayList.get(12))) {
            PropsManager.setEgMeasPeriod(string2);
        }
        if (PropsManager.isLongPropUpdated(MAX_POJO_CALL_TRACE_COUNT, string2 = (String)arrayList.get(13))) {
            PropsManager.setMaxTraceLines(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_POJO_CALL_TRACE_TIME, string2 = (String)arrayList.get(14))) {
            PropsManager.setPOJOTracePeriod(string2);
        }
        if (PropsManager.isLongPropUpdated(RECURSION_TRACE_LIMIT, string2 = (String)arrayList.get(15))) {
            PropsManager.setRecursionLimit(string2);
        }
        if (PropsManager.isLongPropUpdated(MAX_POINTCUT_LIMIT, string2 = (String)arrayList.get(16))) {
            PropsManager.setOtherPointcutMethodLimit(string2);
        }
        if (PropsManager.isIntegerPropUpdated(MAX_EXCEPTION_TRACE_LINE_COUNT, string2 = (String)arrayList.get(17))) {
            PropsManager.setMaxExceptionLineCount(string2);
        }
        if (PropsManager.isStringPropUpdated(INCLUDE_EXCEPTIONS, string2 = (String)arrayList.get(18))) {
            PropsManager.setIncludeException(string2);
        }
        if (PropsManager.isStringPropUpdated(IGNORE_EXCEPTIONS, string2 = (String)arrayList.get(19))) {
            PropsManager.setIgnoreException(string2);
        }
        if (PropsManager.isStringPropUpdated(Chars_TO_Exclude, string2 = (String)arrayList.get(20))) {
            PropsManager.setCharToExclude(string2);
        }
        if (bl) {
            string2 = (String)arrayList.get(21);
            if (PropsManager.isIntegerPropUpdated(MAX_AUTO_GROUPED_URLS, string2)) {
                PropsManager.setMaxLimit4AutoGroupedURL(string2);
            }
        } else {
            string2 = (String)arrayList.get(21);
            if (PropsManager.isIntegerPropUpdated(MAX_MANUAL_GROUPED_URLS, string2)) {
                PropsManager.setMaxLimit4ManualGroupedURL(string2);
            }
        }
        if (PropsManager.isIntegerPropUpdated(MAX_SQL_QUERY_COUNT, string2 = (String)arrayList.get(22))) {
            PropsManager.setMaxSQLTraceCount(string2);
        }
        try {
            string2 = (String)arrayList.get(23);
            if (PropsManager.isStringPropUpdated(HTTP_STATUS_CODE, string2)) {
                PropsManager.setCaptureHttpStatus(string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Problem while getting value for {} , Assigning default value of \"false\" ", (Object)HTTP_STATUS_CODE);
        }
        try {
            string2 = (String)arrayList.get(24);
            if (PropsManager.isStringPropUpdated(HTTP_COOKIES, string2)) {
                PropsManager.setCaptureHttpCookies(string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Problem while getting value for {} , Assigning default value of \"false\"", (Object)HTTP_COOKIES);
        }
        string2 = (String)arrayList.get(25);
        try {
            if (PropsManager.isStringPropUpdated(HTTP_HEADERS, string2)) {
                PropsManager.setCaptureHttpHeaders(string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Problem while getting value for  {} , Assigning default value of \"false\" ", (Object)HTTP_HEADERS);
        }
        if (n > n2) {
            int n3 = n2;
            try {
                string2 = (String)arrayList.get(n3);
                if (!string2.equalsIgnoreCase("-")) {
                    isNewAgent = true;
                    compNameLength = subCompNames.length;
                    URLPatternMeasure.updateDefaultPatternData();
                    BTMLog.logger.info("eG Agent Version is 6.3 or higher !!!.");
                }
                if (PropsManager.isStringPropUpdated(TRACK_CPU_TIME, string2)) {
                    ThreadDiagnosis.setTrackThreadCpuTime(string2);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Problem while getting value for {} Assigning default value of \"false\" ", (Object)TRACK_CPU_TIME);
            }
            ++n3;
            try {
                string2 = (String)arrayList.get(n3);
                if (PropsManager.isStringPropUpdated(TRACK_BLOCKED_WAITED_TIME, string2)) {
                    ThreadDiagnosis.setTrackThreadBlockedWaitedTime(string2);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Problem while getting value for {} Assigning default value of \"false\" ", (Object)TRACK_BLOCKED_WAITED_TIME);
            }
            ++n3;
            try {
                string2 = (String)arrayList.get(n3);
                if (PropsManager.isIntegerPropUpdated(MAX_MONGODB_QUERY_LENGTH, string2)) {
                    PropsManager.setMaxMongoDbQueryLength(string2);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Problem while getting value for {} Assigning default value of \"1024\"", (Object)MAX_MONGODB_QUERY_LENGTH);
            }
            string2 = (String)arrayList.get(++n3);
            if (PropsManager.isIntegerPropUpdated(MAX_SQL_ERROR_QUERY_COUNT, string2)) {
                PropsManager.setMaxErrorSQLTraceCount(string2);
            }
            if (PropsManager.isIntegerPropUpdated(MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT, string2 = (String)arrayList.get(++n3))) {
                PropsManager.setCaptureExceptionsWithStackTraceLimit(string2);
            }
            if (PropsManager.isIntegerPropUpdated(MAX_EXCE_FQEN_CAPTURE_LIMIT, string2 = (String)arrayList.get(++n3))) {
                PropsManager.setCaptureExceptionsWithFQENLimit(string2);
            }
            if (PropsManager.isIntegerPropUpdated(MAX_EXCE_TRACE_COUNT_LIMIT, string2 = (String)arrayList.get(++n3))) {
                PropsManager.setCaptureExceptionsMaxTraceLimit(string2);
            }
            ++n3;
            try {
                String string5 = (String)arrayList.remove(n3);
                if (PropsManager.isStringPropUpdated("NODE_ID", string5)) {
                    BTMOffLoadConfig.setOffloadNodeID(string5);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Problem while getting value for {}, Assigning default value of \"None\" ", (Object)"NODE_ID");
            }
        } else {
            BTMLog.logger.info("eG Agent Version is less than 6.3 !!!.");
            compNameLength = subCompNames.length - 3;
            URLPatternMeasure.modifyDefaultPatternData();
        }
        arrayList.clear();
    }

    static void applyBTMProps() {
        if (StartServer.isOffloadCheckDone() || !PropsManager.isOldModel()) {
            PropsManager.getThreshFromPropsFile();
        }
        PropsManager.setMonitoringMode(BTMProps.getProperty(MONITORING_MODE));
        UPDManager.setNoOfURLSegments(BTMProps.getProperty(MAX_URL_SEGMENTS));
        UPDManager.updateAutoFilteredPatternsTbl(BTMProps.getProperty(EXCLUDED_PATTERNS));
        PropsManager.setSlowURLThreshold(BTMProps.getProperty(SLOW_URL_THRESHOLD));
        PropsManager.setStalledURLThreshold(BTMProps.getProperty(STALLED_URL_THRESHOLD));
        PropsManager.setMethExecCutOff(BTMProps.getProperty(METHOD_EXEC_CUTOFF));
        PropsManager.setSqlExecCutOff(BTMProps.getProperty(SQL_EXEC_CUTOFF));
        PropsManager.setMaxSlowURLs(BTMProps.getProperty(MAX_SLOW_URLS_PER_TEST_PERIOD));
        PropsManager.setMaxErrorURLs(BTMProps.getProperty(MAX_ERROR_URLS_PER_TEST_PERIOD));
        PropsManager.setHealthyURLs(BTMProps.getProperty(MAX_HEALTHY_URLS_PER_TEST_PERIOD));
        PropsManager.setHealthyUrlTrace(BTMProps.getProperty(HEALTHY_URL_TRACE));
        PropsManager.setEgMeasPeriod(BTMProps.getProperty(EGMEASPERIOD));
        PropsManager.setMaxTraceLines(BTMProps.getProperty(MAX_POJO_CALL_TRACE_COUNT));
        PropsManager.setPOJOTracePeriod(BTMProps.getProperty(MAX_POJO_CALL_TRACE_TIME));
        PropsManager.setMaxSQLTraceCount(BTMProps.getProperty(MAX_SQL_QUERY_COUNT));
        PropsManager.setMaxErrorSQLTraceCount(BTMProps.getProperty(MAX_SQL_ERROR_QUERY_COUNT));
        PropsManager.setCharToExclude(BTMProps.getProperty(Chars_TO_Exclude));
        PropsManager.setRecursionLimit(BTMProps.getProperty(RECURSION_TRACE_LIMIT));
        PropsManager.setOtherPointcutMethodLimit(BTMProps.getProperty(MAX_POINTCUT_LIMIT));
        PropsManager.setMaxExceptionLineCount(BTMProps.getProperty(MAX_EXCEPTION_TRACE_LINE_COUNT));
        PropsManager.setIncludeException(BTMProps.getProperty(INCLUDE_EXCEPTIONS));
        PropsManager.setIgnoreException(BTMProps.getProperty(IGNORE_EXCEPTIONS));
        PropsManager.setMaxLimit4AutoGroupedURL(BTMProps.getProperty(MAX_AUTO_GROUPED_URLS));
        if (StartServer.isOffloadCheckDone() || !PropsManager.isOldModel()) {
            BTMOffLoadConfig.updateOffLoadConfiguration();
            String string = EG_BTM_HOME + File.separatorChar + "config.props";
            PropsManager.setValidJvmGUID(string);
        }
        if (BTMProps.containsKey("KBusinessTransTest") && BTMProps.getProperty("KBusinessTransTest").equalsIgnoreCase("true")) {
            PropsManager.setURLPatterns(BTMProps.getProperty(URL_PATTERNS));
        }
        PropsManager.setMaxLimit4ManualGroupedURL(BTMProps.getProperty(MAX_MANUAL_GROUPED_URLS));
        PropsManager.setCaptureHttpCookies(BTMProps.getProperty(HTTP_COOKIES));
        PropsManager.setCaptureHttpHeaders(BTMProps.getProperty(HTTP_HEADERS));
        PropsManager.setCaptureHttpStatus(BTMProps.getProperty(HTTP_STATUS_CODE));
        PropsManager.setMaxMongoDbQueryLength(BTMProps.getProperty(MAX_MONGODB_QUERY_LENGTH));
        ThreadDiagnosis.setTrackThreadCpuTime(BTMProps.getProperty(TRACK_CPU_TIME));
        ThreadDiagnosis.setTrackThreadBlockedWaitedTime(BTMProps.getProperty(TRACK_BLOCKED_WAITED_TIME));
        PropsManager.updateOtherBTMProps();
        LogCleanUp.checkLogHomeCode();
    }

    private static void setURLPatterns(String string) {
        UPDManager.updateKeyPatternData(string);
        if (string != null && string.trim().length() > 0) {
            if (string.equalsIgnoreCase("none")) {
                UPDManager.setValidPattern(false);
                manualPatternTable.clear();
            } else {
                UPDManager.setValidPattern(true);
            }
        }
    }

    public static void updateOtherBTMProps() {
        String string;
        String string2;
        String string3;
        String string4 = System.getProperty("LazyTimePeriod");
        BTMLog.logger.info("System property value of LazyTimePeriod :" + string4);
        if (string4 == null || string4.length() == 0) {
            string4 = BTMProps.getProperty("LazyTimePeriod");
        }
        if (string4 != null && string4.length() > 0) {
            try {
                lazyTimeInseconds = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                lazyTimeInseconds = 180;
            }
        } else {
            lazyTimeInseconds = 180;
        }
        String string5 = System.getProperty(INSTRUMENTATION_LEVEL);
        BTMLog.logger.info("System property value of Instrumentation Level :" + string5);
        if (string5 == null || string5.length() == 0) {
            string5 = BTMProps.getProperty(INSTRUMENTATION_LEVEL);
        }
        if (string5 != null && string5.length() > 0) {
            instrumentationLevel = string5.equalsIgnoreCase("1") ? TraceLevel.ONE : (string5.equalsIgnoreCase("2") ? TraceLevel.TWO : TraceLevel.THREE);
            BTMLog.logger.info("Assigned Level of Instrumentation :" + (Object)((Object)instrumentationLevel));
        } else {
            instrumentationLevel = TraceLevel.THREE;
            BTMLog.logger.info("Assigned Default Level of Instrumentation :" + (Object)((Object)instrumentationLevel));
        }
        String string6 = BTMProps.getProperty(SHOW_CALLGRAPH_IN_LOG);
        if (string6 != null && string6.length() > 0) {
            if (string6.equalsIgnoreCase("true")) {
                PropsManager.setShowTraceInLog(true);
            } else {
                PropsManager.setShowTraceInLog(false);
            }
        }
        if ((string3 = BTMProps.getProperty(MAX_SQL_CALL_COUNT_LIMIT)) != null && string3.trim().length() > 0) {
            try {
                PropsManager.setMaxSQLCountLimit(Long.parseLong(string3));
                BTMLog.logger.trace("Updated Max.SQL call limit as {} ", (Object)PropsManager.getMaxSQLCountLimit());
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occurred while converting the value : {} for the property {} ", (Object)string3, (Object)MAX_SQL_CALL_COUNT_LIMIT);
            }
        }
        if ((string2 = BTMProps.getProperty(ERROR_STATUS_CODE_RANGE)) != null && string2.trim().length() > 0) {
            StatusCodeErrorRange.initializeErrorRange(string2);
        }
        REMOTE_ADDRESS_HEADER_NAME = (string = BTMProps.getProperty(REMOTE_HEADER_ADDRESS)) != null && string.length() > 0 ? string : "X-Forwarded-For";
        String string7 = BTMProps.getProperty(REQUEST_INVOKE_COUNT);
        if (string7 != null && string7.length() > 0) {
            long l = Long.parseLong(string7);
            if (l > 0L && l == requestInvokeCount) {
                BTMLog.logger.debug(" value is not updated using previous value " + l + " for auto discovery....");
            } else {
                requestInvokeCount = l;
                BTMLog.logger.debug(" updating auto discovery request counter with : " + PropsManager.getRequestInvokeCount());
            }
        }
        EgCustomPointCutManager.getInstance().assembleCustomPointcutData(BTMProps);
        ExceptionTestConfigManager.updatePropertiesFromPropsFile(BTMProps);
        RumPropsManager.updateRumProperties();
    }

    public static void setPropFileNames() {
        logPropsFileName = EG_BTM_HOME + File.separatorChar + "btmLogging.props";
        logPropsFile = new File(logPropsFileName);
        otherPropsFileName = EG_BTM_HOME + File.separatorChar + "btmOther.props";
        otherPropsFile = new File(otherPropsFileName);
        configPropsFileName = EG_BTM_HOME + File.separatorChar + "config.props";
        configPropsFile = new File(configPropsFileName);
        cpcPropsFileName = EG_BTM_HOME + File.separatorChar + "custom.props";
        cpcPropsFile = new File(cpcPropsFileName);
        thresholdPropsFileName = EG_BTM_HOME + File.separatorChar + "threshold.props";
        thresholdPropsFile = new File(thresholdPropsFileName);
        discoveryPropsFileName = EG_BTM_HOME + File.separatorChar + "autodiscovery.props";
        discoveryPropsFile = new File(discoveryPropsFileName);
        excludePropsFileName = EG_BTM_HOME + File.separatorChar + "exclude.props";
        excludePropsFile = new File(excludePropsFileName);
    }

    public static boolean isPropsFileValid(File file) {
        if (file != null) {
            boolean bl = file.exists() && file.isFile() && file.length() != 0L;
            return bl;
        }
        return false;
    }

    private static boolean isStringPropUpdated(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.length() != 0) {
            String string3 = BTMProps.getProperty(string);
            if (!string2.equals(string3)) {
                BTMProps.setProperty(string, string2);
                BTMLog.logger.info("Updated param {} with : {} ", (Object)string, (Object)string2);
                return true;
            }
            return false;
        }
        BTMLog.logger.warn("Cannot update property {} with blank value. ", (Object)string);
        return false;
    }

    private static boolean isDoublePropUpdated(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        double d = BTMUtils.String2Double(string2);
        String string3 = BTMProps.getProperty(string);
        if (d > -1.0) {
            double d2 = BTMUtils.String2Double(string3);
            if (d != d2) {
                BTMProps.setProperty(string, string2);
                BTMLog.logger.info("Updated prop {} with : {}", (Object)string, (Object)string2);
                return true;
            }
            return false;
        }
        BTMLog.logger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", string, string2, string3);
        return false;
    }

    private static boolean isLongPropUpdated(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        long l = BTMUtils.String2Long(string2);
        String string3 = BTMProps.getProperty(string);
        if (l > -1L) {
            long l2 = BTMUtils.String2Long(string3);
            if (l != l2) {
                BTMProps.setProperty(string, string2);
                BTMLog.logger.info("Updated prop {} with : {}", (Object)string, (Object)string2);
                return true;
            }
            return false;
        }
        BTMLog.logger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", string, string2, string3);
        return false;
    }

    private static boolean isIntegerPropUpdated(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        int n = BTMUtils.String2Integer(string2);
        String string3 = BTMProps.getProperty(string);
        if (n > -1) {
            int n2 = BTMUtils.String2Integer(string3);
            if (n != n2) {
                BTMProps.setProperty(string, string2);
                BTMLog.logger.info("Updated prop {} with : {}", (Object)string, (Object)string2);
                return true;
            }
            return false;
        }
        BTMLog.logger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", string, string2, string3);
        return false;
    }

    private static String cleanupFilteredPatternStr(String string) {
        if (string == null) {
            return "None";
        }
        if (string.trim().equalsIgnoreCase("None")) {
            return string;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.trim().length() <= 0 || arrayList.contains(string2)) continue;
            arrayList.add(string2);
            if (stringBuffer.length() == 0) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(",").append(string2);
        }
        arrayList.clear();
        return stringBuffer.toString();
    }

    private static String cleanupPatternStr(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl && string.trim().equalsIgnoreCase("None")) {
            return string;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!PropsManager.ValidateSyntax(stringArray[i])) continue;
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(stringArray[i]);
                    continue;
                }
                stringBuffer.append(",").append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    private static boolean ValidateSyntax(String string) {
        int n = 58;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            return string.substring(n2 + 1).indexOf(n) == -1;
        }
        return false;
    }

    public static void setBTMEnabled() {
        System.out.println(new Date() + " *** BTM is ENABLED ***");
        TalkingToAgent = true;
    }

    public static void resetBTMEnabled() {
        System.out.println(new Date() + " *** BTM is DISABLED ***");
        TalkingToAgent = false;
    }

    public static double getSQLExecCutOff() {
        return Sql_Exec_CutOff;
    }

    public static void setSQLExecCutOff(double d) {
        Sql_Exec_CutOff = d;
    }

    public static long getMaxTraceLines() {
        return maxTraceLines;
    }

    private static void setRecursionLimit(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                int n2 = PropsManager.getRecursionTraceLimit();
                if (n != n2) {
                    recursionTraceLimit = n;
                }
            }
            catch (Exception exception) {
                recursionTraceLimit = 1000;
            }
        }
    }

    public static void setMaxTraceLines(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                l = Math.abs(l);
                long l2 = PropsManager.getMaxTraceLines();
                if (l2 != l) {
                    maxTraceLines = l;
                }
            }
            catch (Exception exception) {
                maxTraceLines = 1000L;
            }
        }
        BTMLog.logger.info("Max POJO Trace count is changed to {} ", (Object)PropsManager.getMaxTraceLines());
    }

    public static void setPOJOTracePeriod(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                n = Math.abs(n);
                long l = (long)n * 1000L;
                long l2 = PropsManager.getPOJOTracePeriod();
                if (l2 != l) {
                    pojoTracePeriod = l;
                }
            }
            catch (Exception exception) {
                pojoTracePeriod = 10000L;
            }
        }
        PropsManager.setMaxTracePeriod();
    }

    private static long getPOJOTracePeriod() {
        return pojoTracePeriod;
    }

    private static void setMaxTracePeriod() {
        maxTracePeriod = PropsManager.getPOJOTracePeriod() + (long)Slow_URL_Threshold;
        BTMLog.logger.info("Max.Trace Period is changed to {} milliseconds", (Object)PropsManager.getMaxTracePeriod());
    }

    static long getMaxTracePeriod() {
        return maxTracePeriod;
    }

    static long getMaxSQLTraceCount() {
        return maxSQLTraceCount;
    }

    static long getMaxSQLErrorTraceCount() {
        return maxSQLErrorTraceCount;
    }

    private static void setMaxSQLTraceCount(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                l = Math.abs(l);
                long l2 = PropsManager.getMaxSQLTraceCount();
                if (l2 != l) {
                    maxSQLTraceCount = l;
                }
            }
            catch (Exception exception) {
                maxSQLTraceCount = 500L;
            }
        }
        BTMLog.logger.info("Max.SQL Trace count is changed to {} ", (Object)PropsManager.getMaxSQLTraceCount());
    }

    private static void setMaxErrorSQLTraceCount(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                long l2 = PropsManager.getMaxSQLErrorTraceCount();
                if (l2 != l) {
                    maxSQLErrorTraceCount = l;
                }
            }
            catch (Exception exception) {
                maxSQLErrorTraceCount = 10L;
            }
        }
        BTMLog.logger.info("Max.SQL Error Trace count is changed to {} ", (Object)PropsManager.getMaxSQLErrorTraceCount());
    }

    private static void setCaptureExceptionsWithStackTraceLimit(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                long l2 = PropsManager.getCaptureExceptionsWithStackTraceLimit();
                if (l2 != l) {
                    captureExceptionsWithStackTraceLimit = l;
                }
            }
            catch (Exception exception) {
                captureExceptionsWithStackTraceLimit = 5L;
            }
        }
        BTMLog.logger.info("Max.Exception with stack trace capture limit is changed to {} ", (Object)PropsManager.getCaptureExceptionsWithStackTraceLimit());
    }

    private static void setCaptureExceptionsWithFQENLimit(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l;
                long l2 = Long.parseLong(string);
                if (l2 > PropsManager.getCaptureExceptionsWithStackTraceLimit()) {
                    l2 -= PropsManager.getCaptureExceptionsWithStackTraceLimit();
                }
                if ((l = PropsManager.getCaptureExceptionsWithFQENLimit()) != l2) {
                    captureExceptionsWithFQENLimit = l2;
                }
            }
            catch (Exception exception) {
                captureExceptionsWithFQENLimit = 100L;
            }
        }
        BTMLog.logger.info("Max.Exception FQEN capture limit is changed to {} ", (Object)PropsManager.getCaptureExceptionsWithFQENLimit());
    }

    private static void setCaptureExceptionsMaxTraceLimit(String string) {
        if (string != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                long l2 = PropsManager.getCaptureExceptionsMaxTraceLimit();
                if (l2 != (l -= PropsManager.getCaptureExceptionsWithFQENLimit() + PropsManager.getCaptureExceptionsWithStackTraceLimit())) {
                    captureExceptionsMaxTraceLimit = l;
                }
            }
            catch (Exception exception) {
                captureExceptionsMaxTraceLimit = 1000L;
            }
        }
        BTMLog.logger.info("Max.Exception trace capture limit is changed to {} ", (Object)PropsManager.getCaptureExceptionsMaxTraceLimit());
    }

    public static long getCaptureExceptionsWithStackTraceLimit() {
        return captureExceptionsWithStackTraceLimit;
    }

    public static long getCaptureExceptionsWithFQENLimit() {
        return captureExceptionsWithFQENLimit;
    }

    public static long getCaptureExceptionsMaxTraceLimit() {
        return captureExceptionsMaxTraceLimit;
    }

    public static int getMaxExceptionLineCount() {
        return maxExceptionLineCount;
    }

    private static void setIncludeException(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
                includeExceptionList.clear();
                includeExceptionList.addAll(arrayList);
                arrayList = null;
            }
        } else {
            includeExceptionList.clear();
        }
    }

    private static void setIgnoreException(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
                ignoreExceptionList.clear();
                ignoreExceptionList.addAll(arrayList);
                arrayList = null;
            }
        } else {
            ignoreExceptionList.clear();
        }
    }

    private static void setCharToExclude(String string) {
        String[] stringArray;
        if (string != null && string.length() > 0 && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : stringArray) {
                hashSet.add(string2);
            }
            BTMLog.logger.info("Exclude the URLs that contanis the chars from the list {} ", (Object)hashSet);
            excludeCharsList.clear();
            excludeCharsList.addAll(hashSet);
            hashSet = null;
        }
    }

    private static void setMaxExceptionLineCount(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                int n2 = PropsManager.getMaxExceptionLineCount();
                if (n2 != n) {
                    maxExceptionLineCount = n == -1 || n >= 10 ? n : 10;
                }
            }
            catch (Exception exception) {
                maxExceptionLineCount = 10;
                BTMLog.logger.warn("[PropsManager - updateOtherProps ] parsing Exception : {} ", exception);
            }
        }
        BTMLog.logger.info("Max Exception trace Line count is changed to : {}", (Object)maxExceptionLineCount);
    }

    public static boolean isExceptionMatchedIgnoreExceptionList(String string) {
        return ignoreExceptionList.contains(string);
    }

    public static boolean isExceptionMatchedIncludeExceptionList(String string) {
        return includeExceptionList.contains(string);
    }

    static int getOtherPointcutMethodLimit() {
        return otherPointcutMethodLimit;
    }

    private static void setOtherPointcutMethodLimit(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                int n2 = PropsManager.getOtherPointcutMethodLimit();
                if (n > 100) {
                    if (n2 != n) {
                        otherPointcutMethodLimit = n;
                    }
                } else {
                    BTMLog.logger.info("{}  is too low, setting the current value : {} ", (Object)MAX_POINTCUT_LIMIT, (Object)n2);
                }
            }
            catch (Exception exception) {
                otherPointcutMethodLimit = 1000;
                BTMLog.logger.warn("Invalid {} value : {} {} ", MAX_POINTCUT_LIMIT, string, exception);
            }
        }
    }

    static int getRecursionTraceLimit() {
        return recursionTraceLimit;
    }

    static boolean isShowTraceInLog() {
        return showTraceInLog;
    }

    private static void setShowTraceInLog(boolean bl) {
        showTraceInLog = bl;
    }

    private static void setHealthyUrlTrace(String string) {
        if (string != null && string.equalsIgnoreCase("true")) {
            TraceHealthyURL = true;
            BTMLog.logger.info("Healthy URL Tracing flag set to true");
        } else {
            TraceHealthyURL = false;
            BTMLog.logger.info("Healthy URL Tracing flag set to false");
        }
    }

    private static void setHealthyURLs(String string) {
        try {
            Max_Healthy_URLs = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Max_Healthy_URLs = 10;
        }
        BTMLog.logger.info("Maximum number of Healthy URLs  set to {} ", (Object)PropsManager.getHelathyURLs());
    }

    static int getHelathyURLs() {
        return Max_Healthy_URLs;
    }

    static int getMaxSlowURLs() {
        return Max_Slow_URLs;
    }

    static int getMaxStalledURLs() {
        return Max_Stalled_URLs;
    }

    private static void setMaxStalledURLs(String string) {
        try {
            Max_Stalled_URLs = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Max_Stalled_URLs = 10;
        }
        BTMLog.logger.info("Maximum number of stalled URLs  set to {} ", (Object)PropsManager.getMaxStalledURLs());
    }

    private static void setMaxSlowURLs(String string) {
        try {
            Max_Slow_URLs = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Max_Slow_URLs = 10;
        }
        BTMLog.logger.info("Maximum number of slow URLs  set to {} ", (Object)PropsManager.getMaxSlowURLs());
    }

    static int getMaxErrorURLs() {
        return Max_Error_URLs;
    }

    private static void setMaxErrorURLs(String string) {
        try {
            Max_Error_URLs = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Max_Error_URLs = 10;
        }
        BTMLog.logger.info("Maximum number of Error URLs  set to {} ", (Object)PropsManager.getMaxErrorURLs());
    }

    static double getMethExecCutOff() {
        return Meth_Exec_CutOff;
    }

    private static void setMethExecCutOff(String string) {
        try {
            double d;
            Meth_Exec_CutOff = d = Double.parseDouble(string);
            BTMLog.logger.info("Method execution cutoff parsed and set to {} milliseconds ", (Object)PropsManager.getMethExecCutOff());
        }
        catch (NumberFormatException numberFormatException) {
            Meth_Exec_CutOff = 250.0;
        }
    }

    static boolean isTraceHealthyURL() {
        return TraceHealthyURL;
    }

    private static void setSqlExecCutOff(String string) {
        try {
            double d = Double.parseDouble(string);
            PropsManager.setSQLExecCutOff(d);
            BTMLog.logger.info("SQL execution cutoff parsed and set to {} milliseconds", (Object)d);
        }
        catch (NumberFormatException numberFormatException) {
            PropsManager.setSQLExecCutOff(10.0);
        }
    }

    private static void setSlowURLThreshold(String string) {
        try {
            Slow_URL_Threshold = Double.parseDouble(string);
            PropsManager.setMaxTracePeriod();
            BTMLog.logger.info("Slow_URL_Threshold parsed and set to {} milliseconds", (Object)Slow_URL_Threshold);
        }
        catch (NumberFormatException numberFormatException) {
            Slow_URL_Threshold = 4000.0;
        }
    }

    private static void setMonitoringMode(String string) {
        int n = Monitoring_Mode;
        try {
            int n2 = Integer.parseInt(string);
            if (n != n2) {
                Monitoring_Mode = n2;
                BTMLog.logger.info("Monitoring_Mode parsed and set to {} ", (Object)PropsManager.getMonitoringMode());
            }
        }
        catch (Exception exception) {
            Monitoring_Mode = 1;
        }
    }

    static int getMonitoringMode() {
        return Monitoring_Mode;
    }

    private static void setEgMeasPeriod(String string) {
        long l = egMeasPeriod;
        try {
            long l2 = Long.parseLong(string) * 1000L;
            if (l2 == l) {
                BTMLog.logger.info(" Both Current Measure Period and Measure Period from eG Agent are same");
            } else {
                egMeasPeriod = l2;
                if (oldModel) {
                    SnapshotManager.scheduleSnapshotTaker();
                    RASwitchOverCutoff = 10L * egMeasPeriod;
                    BTMLog.logger.info("Registered Agent Switchover cut off is {} milliseconds", (Object)RASwitchOverCutoff);
                    UPDManager.setMeasPeriodChanged();
                } else {
                    BTMLog.logger.info(" PropsManager.egMeasPeriod : {} ", (Object)egMeasPeriod);
                    BTMOffLoadConfig.updateMeasurePeriod(egMeasPeriod);
                    if (SnapshotManager.SSTimer != null) {
                        SnapshotManager.stopSnapshotTaker();
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static long getEgMeasPeriod() {
        return egMeasPeriod;
    }

    private static void setStalledURLThreshold(String string) {
        try {
            long l;
            stalledThreshold = l = Long.parseLong(string);
            BTMLog.logger.info("Stalled threshold time is set to : {} milliseconds ", (Object)stalledThreshold);
            PropsManager.setMaxTracePeriod();
        }
        catch (Exception exception) {
            stalledThreshold = 60000L;
            BTMLog.logger.info("Stalled threshold time is set to : {} milliseconds ", (Object)stalledThreshold);
        }
    }

    public static int getURLLevel() {
        return URLLevel;
    }

    public static void setURLLevel(int n) {
        URLLevel = n;
    }

    static int getMaxLimit4AutoGroupedURL() {
        return maxLimit4AutoGroupedURL;
    }

    private static void setMaxLimit4AutoGroupedURL(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    int n2 = PropsManager.getMaxLimit4AutoGroupedURL();
                    if (n2 != n) {
                        maxLimit4AutoGroupedURL = n;
                    }
                } else {
                    BTMLog.logger.warn("Assigned {} Value is less than zero.", (Object)MAX_AUTO_GROUPED_URLS);
                    maxLimit4AutoGroupedURL = 50;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Value is invalid. Assigning default Value {} ", (Object)MAX_AUTO_GROUPED_URLS, (Object)50);
                maxLimit4AutoGroupedURL = 50;
            }
        }
        BTMLog.logger.info("Assigning MAX_AUTO_GROUPED_URLS : {}", (Object)maxLimit4AutoGroupedURL);
    }

    static int getMaxLimit4ManualGroupedURL() {
        return maxLimit4ManualGroupedURL;
    }

    private static void setMaxLimit4ManualGroupedURL(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    int n2 = PropsManager.getMaxLimit4ManualGroupedURL();
                    if (n2 != n) {
                        maxLimit4ManualGroupedURL = n;
                    }
                } else {
                    BTMLog.logger.warn("Assigned {} Value is less than zero.", (Object)MAX_MANUAL_GROUPED_URLS);
                    maxLimit4ManualGroupedURL = 50;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Value is invalid.Assigning default Value {}", (Object)MAX_MANUAL_GROUPED_URLS, (Object)50);
                maxLimit4ManualGroupedURL = 50;
            }
        }
        BTMLog.logger.info("Assinging MAX_MANUAL_GROUPED_URLS :{}", (Object)string);
    }

    static Threshold getThreshold(boolean bl, String string) {
        Threshold threshold = null;
        threshold = bl ? manualPatternThreshold.get(string) : autoPatternThreshold.get(string);
        if (threshold == null) {
            threshold = GLOBAL_THRESHOLD;
        }
        return threshold;
    }

    static boolean captureHttpStatusCode() {
        return CaptureHttpStatus;
    }

    private static void setCaptureHttpStatus(String string) {
        CaptureHttpStatus = Boolean.parseBoolean(string);
        if (CaptureHttpStatus) {
            BTMLog.logger.info("BTM Engine will now capture Http Status code for each transactions");
        } else {
            BTMLog.logger.info("Http Status code tracking is disable for BTM Engine !!!");
        }
    }

    public static boolean captureHttpHeadersDetails() {
        return CaptureHttpHeaders;
    }

    private static void setCaptureHttpHeaders(String string) {
        CaptureHttpHeaders = Boolean.parseBoolean(string);
        if (CaptureHttpHeaders) {
            BTMLog.logger.info("BTM Engine will now capture Http headers details for each transactions");
        } else {
            BTMLog.logger.info("Http headers details tracking is disable for BTM Engine !!!");
        }
    }

    public static boolean captureHttpCookiesDetails() {
        return CaptureHttpCookies;
    }

    private static void setCaptureHttpCookies(String string) {
        CaptureHttpCookies = Boolean.parseBoolean(string);
        if (CaptureHttpCookies) {
            BTMLog.logger.info("BTM Engine will now capture Http cookies details for each transactions");
        } else {
            BTMLog.logger.info("Http cookies details tracking is disable for BTM Engine !!!");
        }
    }

    static String getDebugString() {
        return BTMProps.getProperty("Debug");
    }

    static String getBTMPortString() {
        return BTMProps.getProperty("BTM_Port");
    }

    static String getDesignatedAgentString() {
        return BTMProps.getProperty("Designated_Agent");
    }

    static void setTalkingToAgent(boolean bl) {
        TalkingToAgent = bl;
    }

    public static boolean isTalkingToAgent() {
        return TalkingToAgent;
    }

    public static Vector getExcludeCharsList() {
        return excludeCharsList;
    }

    static boolean isNewAgent() {
        return isNewAgent;
    }

    static int getSubCompNameLength() {
        return compNameLength;
    }

    public static int getMaxMongoDbQueryLimit() {
        return maxMongoDbQueryLimit;
    }

    public static String getRemoteAddressHeaderName() {
        return REMOTE_ADDRESS_HEADER_NAME;
    }

    private static void setMaxMongoDbQueryLength(String string) {
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                int n2 = PropsManager.getMaxMongoDbQueryLimit();
                if (n2 != n) {
                    maxMongoDbQueryLimit = n;
                }
            }
            catch (Exception exception) {
                maxMongoDbQueryLimit = 1024;
            }
        }
        BTMLog.logger.info("Max.MongoDB Query Length count is changed to {} ", (Object)PropsManager.getMaxMongoDbQueryLimit());
    }

    static long getRASwitchOverCutoff() {
        return RASwitchOverCutoff;
    }

    static String getProperty(String string) {
        return BTMProps.getProperty(string);
    }

    public static final String getJvmGUID() {
        return JVM_GUID;
    }

    static void assignJvmGUID() {
        if (JVM_GUID != null && !JVM_GUID.equalsIgnoreCase("none")) {
            if (JVM_GUID.startsWith("DISCOVER_ME")) {
                BTMOffLoadConfig.setCurrentMode(Mode.OFFLOAD_DISCOVERY);
            } else {
                BTMOffLoadConfig.setCurrentMode(Mode.OFFLOAD_DATA_COLLECTION);
            }
        } else {
            JVM_GUID = "DISCOVER_ME_" + UUID.randomUUID().toString();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("COMPONENT_GUID", JVM_GUID);
            String string = JVM_GUID;
            hashMap.put("NODE_ID", string);
            onMemoryBTMProps.putAll((Map<?, ?>)hashMap);
            BTMOffLoadConfig.writeOffloadConfigProps(hashMap);
            BTMOffLoadConfig.setCurrentMode(Mode.OFFLOAD_DISCOVERY);
            PropsManager.getConfigFromPropsFile();
        }
    }

    static void writeDiscoveryProps(Hashtable hashtable) {
        if (hashtable.size() == 0) {
            return;
        }
        String string = "Please, Don't edit below discovery details for the component : ";
        PropsManager.updateProperties(discoveryPropsFile, hashtable, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void writeThresholdProps(HashMap hashMap) {
        if (hashMap.size() == 0) {
            return;
        }
        if (BTMOffLoadConfig.isMemoryCopyOnly()) {
            Object object;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)hashMap);
            String string = (String)BTMProps.get("BusinessTransTest");
            if (string != null && string.equalsIgnoreCase("true")) {
                object = PropsManager.class;
                // MONITORENTER : com.eg.jtm.PropsManager.class
                PropsManager.updateAutoPatternThreshold(PropsManager.spiltThresh(properties, "Thresh4B>"));
                // MONITOREXIT : object
            }
            if ((object = (String)BTMProps.get("KBusinessTransTest")) == null) return;
            if (!((String)object).equalsIgnoreCase("true")) return;
            Class<PropsManager> clazz = PropsManager.class;
            // MONITORENTER : com.eg.jtm.PropsManager.class
            PropsManager.updateManualPatternThreshold(PropsManager.spiltThresh(properties, "Thresh4KB>"));
            // MONITOREXIT : clazz
            return;
        }
        if (!PropsManager.isPropsFileExists(thresholdPropsFile)) {
            return;
        }
        Class<PropsManager> clazz = PropsManager.class;
        // MONITORENTER : com.eg.jtm.PropsManager.class
        String string = "Please, Don't edit below threshold.details for the component : ";
        PropsManager.updateProperties(thresholdPropsFile, hashMap, string, false);
        // MONITOREXIT : clazz
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateProperties(File file, Map map, String string, boolean bl) {
        String string2 = file.getName();
        try {
            EgProperties egProperties = new EgProperties();
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                egProperties.load(fileInputStream);
            }
            catch (Exception exception) {
                BTMLog.logger.warn(" Unable to load props  from {} - (}", (Object)string2, (Object)exception);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (bl) {
                egProperties.clear();
            }
            egProperties.putAll(map);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                egProperties.store(fileOutputStream, string + " " + BTMOffLoadConfig.getNodeID());
            }
            catch (Exception exception) {
                BTMLog.logger.warn(" Unable to store {} to {} - {} ", egProperties, string2, exception);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            egProperties.clear();
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Failure to update props on the file {} due to {} ", (Object)string2, (Object)exception);
        }
    }

    static boolean isPropsFileExists(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Unable to create props file file {} : {} ", (Object)file, (Object)exception);
            return false;
        }
        return true;
    }

    public static TraceLevel getInstrumentationLevel() {
        return instrumentationLevel;
    }

    static long getMaxSQLCountLimit() {
        return maxSQLCountLimitPerBT;
    }

    private static void setMaxSQLCountLimit(long l) {
        maxSQLCountLimitPerBT = l;
    }

    public static long getRequestInvokeCount() {
        return requestInvokeCount;
    }

    static final void updatePropertiesOnMemory(Map map, boolean bl) {
        BTMProps.putAll((Map<?, ?>)map);
        onMemoryBTMProps.putAll((Map<?, ?>)map);
        BTMLog.logger.info(BTMProps.toString());
        String string = BTMProps.getProperty("COMPONENT_GUID");
        boolean bl2 = PropsManager.setValidJvmGUID(string, bl);
        BTMLog.logger.debug("On-Memory update ; Is JVM GUID valid ? {} ", (Object)bl2);
        JVMConfig.updateJVMTestConfigs();
        BTMOffLoadConfig.updateOffLoadConfiguration();
        PropsManager.checkBTMTestStatus(bl);
    }

    private static boolean setValidJvmGUID(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = System.getProperty("eG_Component_GUID");
        if (string2 == null || string2.length() <= 0) {
            string2 = string;
        }
        if (string2 != null && string2.length() > 0) {
            JVM_GUID = string2;
            BTMLog.logger.info("JVM is assigned with the GUID : {}", (Object)JVM_GUID);
            bl2 = true;
        } else {
            BTMLog.logger.warn("JVM GUID is Null or Empty !!! ");
        }
        return bl2;
    }

    static HashMap<String, String> getBTMDefaultProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MONITORING_MODE, "1");
        hashMap.put(MAX_URL_SEGMENTS, "3");
        hashMap.put(EXCLUDED_PATTERNS, DEFAULT_EXCLUDED_URL);
        hashMap.put(SLOW_URL_THRESHOLD, "4000.0");
        hashMap.put(STALLED_URL_THRESHOLD, "60000.0");
        hashMap.put(METHOD_EXEC_CUTOFF, "250.0");
        hashMap.put(SQL_EXEC_CUTOFF, "10.0");
        hashMap.put(MAX_SLOW_URLS_PER_TEST_PERIOD, "10");
        hashMap.put(MAX_ERROR_URLS_PER_TEST_PERIOD, "10");
        hashMap.put(MAX_STALLED_URLS_PER_TEST_PERIOD, "10");
        hashMap.put(MAX_HEALTHY_URLS_PER_TEST_PERIOD, "10");
        hashMap.put(HEALTHY_URL_TRACE, "false");
        hashMap.put(EGMEASPERIOD, "300");
        hashMap.put(MANUAL_EXCLUDED_PATTERNS, DEFAULT_EXCLUDED_URL);
        hashMap.put(URL_PATTERNS, "None");
        hashMap.put(MAX_POJO_CALL_TRACE_COUNT, "1000");
        hashMap.put(MAX_POJO_CALL_TRACE_TIME, "10");
        hashMap.put(RECURSION_TRACE_LIMIT, "1000");
        hashMap.put(MAX_POINTCUT_LIMIT, "1000");
        hashMap.put(MAX_EXCEPTION_TRACE_LINE_COUNT, "10");
        hashMap.put(INCLUDE_EXCEPTIONS, "None");
        hashMap.put(IGNORE_EXCEPTIONS, "None");
        hashMap.put(Chars_TO_Exclude, "\\");
        hashMap.put(MAX_AUTO_GROUPED_URLS, "50");
        hashMap.put(MAX_MANUAL_GROUPED_URLS, "50");
        hashMap.put(MAX_SQL_QUERY_COUNT, "500");
        hashMap.put(HTTP_STATUS_CODE, "false");
        hashMap.put(HTTP_COOKIES, "false");
        hashMap.put(HTTP_HEADERS, "false");
        hashMap.put(TRACK_CPU_TIME, "false");
        hashMap.put(TRACK_BLOCKED_WAITED_TIME, "false");
        hashMap.put(MAX_MONGODB_QUERY_LENGTH, "1024");
        hashMap.put(MAX_SQL_ERROR_QUERY_COUNT, "10");
        hashMap.put(MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT, "5");
        hashMap.put(MAX_EXCE_FQEN_CAPTURE_LIMIT, "100");
        hashMap.put(MAX_EXCE_TRACE_COUNT_LIMIT, "1000");
        hashMap.put(REMOTE_HEADER_ADDRESS, "X-Forwarded-For");
        return hashMap;
    }

    public static int getLazyPeriod() {
        return lazyTimeInseconds;
    }

    static String getExcludeFileName() {
        return excludePropsFileName;
    }

    static File getExcludePropsFile() {
        return excludePropsFile;
    }

    static long getExcludeLastModified() {
        if (PropsManager.isPropsFileValid(excludePropsFile)) {
            try {
                return excludePropsFile.lastModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    static String getCommonFileName() {
        return commonPropsFileName;
    }

    static File getCommonPropsFile() {
        return commonPropsFile;
    }

    static long getCommonLastModified() {
        if (PropsManager.isPropsFileValid(commonPropsFile)) {
            try {
                return commonPropsFile.lastModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static void processIcMeasuresFromGuidPropsFile() {
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(PropsManager.getCommonFileName())));
            MeasureUtil.addMeasures(properties, "CommonProps");
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception during reading IC properties from {} {}", (Object)PropsManager.getCommonFileName(), (Object)exception);
        }
    }

    public static void processCpcConfigsFromGuidPropsFile() {
        try {
            Properties properties = CustomConfigurationManager.readCPCProps(PropsManager.getCommonFileName());
            CustomConfigurationManager.getCustomConfiguredPatternMap(properties, "custom.pattern.conf.bt.CPC_IDS", "custom.pattern.conf.bt.", false);
            CustomConfigurationManager.getCustomConfiguredPatternMap(properties, "custom.pattern.conf.kbt.CPC_IDS", "custom.pattern.conf.kbt.CPC", true);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception during reading CPC properties from {} {}", (Object)PropsManager.getCommonFileName(), (Object)exception);
        }
    }

    static boolean requestConfigFromAgent() {
        BTMLog.logger.info(" Request full test configs from eG Agent : {}", (Object)requestConfigFromAgent);
        return requestConfigFromAgent;
    }

    static void setRequestConfigFromAgent(boolean bl) {
        BTMLog.logger.info(" Request full test configs from eG Agent set to : {}", (Object)bl);
        requestConfigFromAgent = bl;
    }

    static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Getting Exception while fetching System.getProperties() {}", exception);
            return new Properties();
        }
    }

    static Map getSystemEnvVariable() {
        try {
            return System.getenv();
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Getting Exception while fetching System.getSystemEnvVariable() {}", exception);
            return new HashMap();
        }
    }

    static {
        useDesigAgtOnly = false;
        portChanged = false;
        measPeriodChanged = false;
        desigAgtChanged = false;
        requestConfigFromAgent = true;
        Slow_URL_Threshold = 4000.0;
        excludeCharsList = new Vector();
        subCompNames = new String[]{"ALL_URLS", "SLOW_URLS", "ERROR_URLS", "STALLED_URLS", "SQL", "FIRST_ALL", "FIRST_SLOW", "FIRST_ERROR", "FIRST_STALLED", "CPU_TIME", "BLOCK_TIME", "WAIT_TIME"};
        compNameLength = subCompNames.length - 3;
        BTMProps = new Properties();
        onMemoryBTMProps = new Properties();
        TalkingToAgent = true;
        URLLevel = 3;
        lazyTimeInseconds = 180;
        maxTraceLines = 1000L;
        maxTracePeriod = pojoTracePeriod = 1000L;
        maxSQLTraceCount = 500L;
        maxSQLCountLimitPerBT = 100000L;
        maxSQLErrorTraceCount = 10L;
        maxExceptionLineCount = 10;
        maxMongoDbQueryLimit = 1024;
        captureExceptionsWithStackTraceLimit = 5L;
        captureExceptionsWithFQENLimit = 100L;
        captureExceptionsMaxTraceLimit = 1000L;
        stalledThreshold = 60000L;
        Monitoring_Mode = 1;
        maxLimit4AutoGroupedURL = 50;
        maxLimit4ManualGroupedURL = 50;
        CaptureHttpStatus = false;
        CaptureHttpHeaders = false;
        CaptureHttpCookies = false;
        ignoreExceptionList = new ArrayList();
        includeExceptionList = new ArrayList();
        otherPointcutMethodLimit = 1000;
        recursionTraceLimit = 1000;
        showTraceInLog = false;
        isNewAgent = false;
        PropsManager.resetBTMEnabled();
        excludePropsFileName = null;
        excludePropsFile = null;
        commonPropsFileName = null;
        commonPropsFile = null;
        commonGuidPropsFileAvailable = false;
        manualPatternTable = new Hashtable();
        autoPatternTable = new Hashtable();
        autoFilteredPatternsList = new Vector();
        manualFilteredPatternsList = new Vector();
        autoPatternThreshold = new ConcurrentHashMap();
        manualPatternThreshold = new ConcurrentHashMap();
        GLOBAL_THRESHOLD = new Threshold(Slow_URL_Threshold, stalledThreshold);
        oldModel = true;
        instrumentationLevel = TraceLevel.THREE;
        autoDiscoveryHTable = new Hashtable();
        autoDiscoveryEnumMappings = new HashMap();
    }
}

