/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.PropsManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RumPropsManager {
    private static final String RUMFLAG = "RUMFLAG";
    private static boolean isRumEnabled = false;
    private static final String RUM_SCRIPT = "RUM_SCRIPT";
    private static final String EXCLUDE_URL_PATTERN = "Rum_Exclude_Url_Pattern";
    private static final String INCLUDE_URL_PATTERN = "Rum_Include_Url_Pattern";
    private static String rumScript = "  ";
    private static ArrayList<String> rumExcludeUrlList = new ArrayList();
    private static ArrayList<String> rumIncludeUrlList = new ArrayList();
    private static final String RUM_BTM_FLAG = "RUM_BTM_FLAG";
    private static boolean isRumBtmIntegrationEnabled = false;

    private RumPropsManager() {
    }

    static void updateRumProperties() {
        String string;
        String string2 = PropsManager.getProperty(RUMFLAG);
        try {
            if (string2 != null && string2.length() > 0 && string2.equalsIgnoreCase("true") && PropsManager.getInstrumentationLevel().getTraceLevel() <= 2) {
                isRumEnabled = true;
                BTMLog.logger.info("Assigned {} Value as {}", (Object)RUMFLAG, (Object)isRumEnabled);
            } else {
                isRumEnabled = false;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Problem while getting value for {}, Assigning default value of \"false\" ", (Object)RUMFLAG);
            isRumEnabled = false;
        }
        String string3 = PropsManager.getProperty(RUM_BTM_FLAG);
        try {
            if (string3 != null && string3.length() > 0) {
                isRumBtmIntegrationEnabled = Boolean.parseBoolean(string3);
                BTMLog.logger.info("Assigned {} Value as {}", (Object)RUM_BTM_FLAG, (Object)isRumBtmIntegrationEnabled);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Problem while getting value for {}, Assigning default value of \"false\" ", (Object)RUM_BTM_FLAG);
        }
        String string4 = PropsManager.getProperty(RUM_SCRIPT);
        if (string4 != null && !(string = string4.trim()).equalsIgnoreCase("none")) {
            rumScript = "  " + string4;
        }
        string = PropsManager.getProperty(EXCLUDE_URL_PATTERN);
        rumExcludeUrlList = RumPropsManager.getRumUrlList(string, EXCLUDE_URL_PATTERN);
        String string5 = PropsManager.getProperty(INCLUDE_URL_PATTERN);
        rumIncludeUrlList = RumPropsManager.getRumUrlList(string5, INCLUDE_URL_PATTERN);
    }

    private static ArrayList<String> getRumUrlList(String string, String string2) {
        BTMLog.logger.debug("[RumPropsManager] UrlString for {} from props file : {}", (Object)string2, (Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                HashSet<String> hashSet = new HashSet<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null || string3.length() <= 0) continue;
                    string3 = string3.trim();
                    hashSet.add(string3);
                }
                arrayList = new ArrayList(hashSet);
            }
            BTMLog.logger.debug("[RumPropsManager] {} of URL's   : {} ", (Object)string2, (Object)arrayList);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while parsing {} {} ", (Object)string2, (Object)exception);
        }
        return arrayList;
    }

    public static boolean isRumIncludedUrl(String string) {
        return RumPropsManager.rumUrlChecker(string, rumIncludeUrlList);
    }

    public static boolean isRumExcludedUrl(String string) {
        return RumPropsManager.rumUrlChecker(string, rumExcludeUrlList);
    }

    public static boolean rumUrlChecker(String string, ArrayList<String> arrayList) {
        boolean bl = false;
        try {
            int n = arrayList.size();
            if (n <= 0) {
                return bl;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = arrayList.get(i);
                bl = BTMUtils.patternMatch(string, string2);
                if (!bl) continue;
                return bl;
            }
            return bl;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while checking URL List : {} ", exception);
            return bl;
        }
    }

    public static boolean isRumEnabled() {
        return isRumEnabled;
    }

    public static String getRumScript() {
        return rumScript;
    }

    public static boolean isRumBtmIntegrationEnabled() {
        return isRumBtmIntegrationEnabled;
    }
}

