/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMQueue;
import com.eg.jtm.Mode;
import com.eg.jtm.Worker;
import java.util.ArrayList;

public class ThreadPoolManager {
    private BTMQueue myQueue = null;
    private int maxQueueCapacity;
    private int maxWorkers;
    private Mode threadPoolmode;
    private static ArrayList<Worker> workerList;
    private static String THREAD_NAME;
    private static ThreadPoolManager poolManager;

    private ThreadPoolManager(int n, int n2, Mode mode) {
        this.maxWorkers = n;
        this.threadPoolmode = mode;
        workerList = new ArrayList();
        this.maxQueueCapacity = n2;
        this.myQueue = new BTMQueue(n2);
        this.initAllConsumers();
    }

    private void initAllConsumers() {
        Integer n = 1;
        while (n <= this.maxWorkers) {
            Object object = new Worker(this.myQueue);
            Object object2 = new Thread((Runnable)object);
            ((Thread)object2).setContextClassLoader(null);
            ((Thread)object2).setDaemon(true);
            ((Thread)object2).setName(THREAD_NAME + n);
            ((Thread)object2).start();
            workerList.add((Worker)object);
            object = n;
            n = n + 1;
            object2 = n;
        }
        BTMLog.logger.info("ThreadPoolManager is created with the mode of {} & no.of worker {} & queue capacity is {}", new Object[]{this.threadPoolmode, this.maxWorkers, this.maxQueueCapacity});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolManager getThreadPoolManager() {
        if (poolManager != null) return poolManager;
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (poolManager != null) return poolManager;
            Mode mode = Mode.OFFLOAD_DATA_COLLECTION;
            int n = BTMOffLoadConfig.getOffLoadWorker();
            int n2 = BTMOffLoadConfig.getOffLoadQueueCapacity();
            THREAD_NAME = "eG_BTM_Worker_";
            if (BTMOffLoadConfig.isDiscoveryMode()) {
                n = 1;
                n2 = 100;
                mode = Mode.OFFLOAD_DISCOVERY;
                THREAD_NAME = "eG BTM Discovery Worker ";
            }
            poolManager = new ThreadPoolManager(n, n2, mode);
            // ** MonitorExit[var0] (shouldn't be in output)
            return poolManager;
        }
    }

    public static ThreadPoolManager getThreadPoolManager(boolean bl) {
        if (poolManager != null) {
            poolManager.clearThreadPoolManager();
        }
        return ThreadPoolManager.getThreadPoolManager();
    }

    public void submitTask(Object object) {
        this.myQueue.enqueue(object);
    }

    public int getQueueSize() {
        return this.myQueue.getSize();
    }

    public void clearData() {
        this.myQueue.clearQueue();
    }

    public Mode getThreadPoolManagerMode() {
        return this.threadPoolmode;
    }

    private void clearThreadPoolManager() {
        if (poolManager != null) {
            this.clearData();
            this.clearWorkers();
            poolManager = null;
            this.myQueue = null;
            BTMLog.logger.info(" {} Queue Cleared & ThreadPoolManager is destroyed ", (Object)this.threadPoolmode);
        }
    }

    private void clearWorkers() {
        try {
            if (workerList != null && workerList.size() > 0) {
                for (int i = 0; i < workerList.size(); ++i) {
                    Worker worker = workerList.get(i);
                    worker.setRunThis(false);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Unable to clear worker list in ThreadPoolManager ", exception);
        }
    }

    static {
        THREAD_NAME = "eG_BTM_Worker_";
        poolManager = ThreadPoolManager.getThreadPoolManager();
    }
}

