/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.learning;

import com.eg.jtm.BTMLog;
import com.eg.jtm.learning.LearningProperties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgThreadPoolExecutor
extends ThreadPoolExecutor {
    private static EgThreadPoolExecutor executor = null;

    private EgThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EgThreadPoolExecutor getExecutor() {
        if (executor != null) return executor;
        Class<EgThreadPoolExecutor> clazz = EgThreadPoolExecutor.class;
        synchronized (EgThreadPoolExecutor.class) {
            if (executor != null) return executor;
            int n = LearningProperties.getCorePoolSize();
            int n2 = LearningProperties.getMaxPoolSize();
            long l = LearningProperties.getKeepAliveTime();
            int n3 = LearningProperties.getQueueCapacity();
            ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(n3);
            executor = new EgThreadPoolExecutor(n, n2, l, TimeUnit.MILLISECONDS, arrayBlockingQueue);
            BTMLog.logger.info("EgThreadPoolExecutor is created with the following properties");
            BTMLog.logger.info("**********************************************************************************************************************************************");
            BTMLog.logger.info("CorePool Size : {} Max.Pool Size : {}  KeepAlive Time : {} ms & Queue Size : {} ", n, n2, l, arrayBlockingQueue.remainingCapacity());
            BTMLog.logger.info("***********************************************************************************************************************************************");
            executor.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return executor;
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable != null) {
            // empty if block
        }
    }
}

