/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jtm.JVMConfig;
import com.eg.jvmmonitor.JVMMetric;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JVMMemoryInfo
extends JVMMetric {
    String jmappath = null;
    String useSudo = null;
    String targetProcessUserName = null;
    String numOutputFields = null;
    String HASH = "#";
    String MINUS_FIVE = "-5.0";

    public JVMMemoryInfo(String string) {
        this.jmappath = string;
    }

    public JVMMemoryInfo() {
    }

    public ArrayList pollMeasures() {
        MBeanServerConnection mBeanServerConnection = JVMUtils.getMbeanServerConnection();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (mBeanServerConnection == null) {
            return arrayList;
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        ArrayList<Hashtable<String, String>> arrayList2 = new ArrayList<Hashtable<String, String>>();
        ArrayList arrayList3 = new ArrayList();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        boolean bl = false;
        if (JVMUtils.isZingJVM()) {
            if (JVMUtils.isZingMXBeanExists()) {
                Hashtable hashtable5 = null;
                Hashtable hashtable6 = null;
                ArrayList<Object> arrayList4 = new ArrayList<Object>();
                ArrayList<Object> arrayList5 = new ArrayList<Object>();
                ObjectName objectName = null;
                ObjectName objectName2 = null;
                try {
                    objectName = new ObjectName("com.azul.zing:type=Memory");
                    objectName2 = new ObjectName("com.azul.zing:type=MemoryPool,*");
                }
                catch (Exception exception) {
                    BTMLog.logger.error("[JVMMemoryInfo] - Exception occured while Fetching the ObjectName. " + exception.getMessage());
                }
                hashtable5 = this.queryZingMxBean(objectName, true, mBeanServerConnection);
                hashtable6 = this.queryZingMxBean(objectName2, false, mBeanServerConnection);
                arrayList4.add(hashtable5);
                arrayList4.add("true");
                arrayList5.add(hashtable6);
                arrayList5.add("false");
                arrayList.add(arrayList4);
                arrayList.add(arrayList5);
                return arrayList;
            }
            bl = true;
        }
        try {
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            StringBuffer stringBuffer = new StringBuffer();
            String string = "Heap Memory:Total";
            long l = memoryUsage.getInit();
            long l2 = memoryUsage.getUsed();
            long l3 = memoryUsage.getCommitted();
            long l4 = memoryUsage.getMax();
            stringBuffer.append(string).append(this.HASH);
            stringBuffer.append(l).append(this.HASH);
            stringBuffer.append(l2).append(this.HASH);
            stringBuffer.append(l3).append(this.HASH);
            stringBuffer.append(l4);
            hashtable4.put("HeapMemoryUsage", stringBuffer.toString());
            MemoryUsage memoryUsage2 = memoryMXBean.getNonHeapMemoryUsage();
            String string2 = "Non-Heap Memory:Total";
            StringBuffer stringBuffer2 = new StringBuffer();
            long l5 = memoryUsage2.getInit();
            long l6 = memoryUsage2.getUsed();
            long l7 = memoryUsage2.getCommitted();
            long l8 = memoryUsage2.getMax();
            stringBuffer2.append(string2).append(this.HASH);
            stringBuffer2.append(l5).append(this.HASH);
            stringBuffer2.append(l6).append(this.HASH);
            stringBuffer2.append(l7).append(this.HASH);
            stringBuffer2.append(l8);
            hashtable4.put("NonHeapMemoryUsage", stringBuffer2.toString());
            Set<ObjectName> set = mBeanServerConnection.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null);
            for (ObjectName objectName : set) {
                ObjectName objectName3 = objectName;
                MemoryPoolMXBean memoryPoolMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName3.toString(), MemoryPoolMXBean.class);
                if (memoryPoolMXBean == null) continue;
                String string3 = memoryPoolMXBean.getName();
                String string4 = memoryPoolMXBean.getType().toString();
                String[] stringArray = memoryPoolMXBean.getMemoryManagerNames();
                StringBuffer stringBuffer3 = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer3.append(stringArray[i] + ",");
                }
                String string5 = stringBuffer3.toString();
                if (string5.endsWith(",")) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
                hashtable.put(string3, string4 + this.HASH + string5);
                MemoryUsage memoryUsage3 = memoryPoolMXBean.getUsage();
                if (memoryUsage3 == null) continue;
                String string6 = null;
                String string7 = string4.toLowerCase();
                string6 = string7.startsWith("heap") ? "Heap Memory:Memory Pool " + string3 : "Non-Heap Memory:Memory Pool " + string3;
                StringBuffer stringBuffer4 = new StringBuffer();
                long l9 = memoryUsage3.getInit();
                long l10 = memoryUsage3.getUsed();
                long l11 = memoryUsage3.getCommitted();
                long l12 = memoryUsage3.getMax();
                stringBuffer4.append(string6).append(this.HASH);
                stringBuffer4.append(l9).append(this.HASH);
                stringBuffer4.append(l10).append(this.HASH);
                stringBuffer4.append(l11).append(this.HASH);
                stringBuffer4.append(l12);
                hashtable3.put(string6, stringBuffer4.toString());
            }
            arrayList2.add(hashtable);
            arrayList2.add(hashtable3);
            hashtable2.put("memoryPool_cf", arrayList2);
            boolean bl2 = JVMMemoryInfo.isIBMJVM();
            arrayList3 = !bl2 && JVMConfig.isIsheapOnOrOff() ? this.toGetJmap() : new ArrayList();
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMMemoryInfo] - Exception occured. " + exception.getMessage());
        }
        arrayList.add(hashtable4);
        arrayList.add(hashtable2);
        arrayList.add(arrayList3);
        arrayList.add(bl);
        return arrayList;
    }

    public ArrayList toGetJmap() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        String string = JVMUtils.getOSName();
        String string2 = "";
        String string3 = "";
        boolean bl = JVMUtils.isIBMJVM();
        if (bl) {
            return arrayList2;
        }
        String string4 = JVMUtils.getCurrentPID();
        if (this.jmappath.equalsIgnoreCase("none")) {
            string4 = string4.substring(0, string4.indexOf("@"));
            if (string.startsWith("win")) {
                string2 = "jmap -histo " + string4;
            } else {
                string3 = "jmap";
                string2 = "jmap -histo " + string4;
            }
        } else if (string.startsWith("win")) {
            string2 = "\"" + this.jmappath + "/bin/jmap\" -histo " + string4;
        } else {
            string3 = this.jmappath + "/bin/jmap";
            string2 = this.jmappath + "/bin/jmap -histo " + string4;
        }
        try {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            Process process = Runtime.getRuntime().exec(string2);
            InputStream inputStream = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string5 = null;
            String string6 = null;
            while ((string5 = bufferedReader2.readLine()) != null) {
                arrayList3.add(string5);
            }
            while ((string6 = bufferedReader.readLine()) != null) {
                arrayList4.add(string6);
            }
            arrayList.add(arrayList3);
            arrayList.add(arrayList4);
            return arrayList;
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMMemoryInfo] - Exception occured while fetching the data for Jmap. " + exception.getMessage());
            return new ArrayList();
        }
    }

    private Hashtable queryZingMxBean(ObjectName objectName, boolean bl, MBeanServerConnection mBeanServerConnection) {
        String[] stringArray = new String[]{"JavaHeapMemoryUsage", "NonJavaHeapMemoryUsage", "JavaHeapUsingMoreMemoryThanInitiallyReserved", "PercentJavaHeapOccupiedAfterCollection", "ApplicationObjectHeapUse", "ApplicationObjectHeapUsableMemory", "ApplicationObjectHeapMemoryPercentInUse"};
        String[] stringArray2 = new String[]{"Type", "Name", "MemoryPoolSizeType", "InitialReserved", "CurrentSize", "CurrentUse"};
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
            if (set != null && set.size() > 0) {
                Iterator<ObjectName> iterator = set.iterator();
                if (bl) {
                    while (iterator.hasNext()) {
                        ObjectName objectName2 = iterator.next();
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = stringArray[i];
                            Object object = mBeanServerConnection.getAttribute(objectName2, string);
                            hashtable.put(string, object);
                        }
                    }
                } else {
                    while (iterator.hasNext()) {
                        ObjectName objectName3 = iterator.next();
                        String string = (String)mBeanServerConnection.getAttribute(objectName3, stringArray2[0]);
                        if (string != null && string.equalsIgnoreCase("SYSTEM")) continue;
                        String string2 = (String)mBeanServerConnection.getAttribute(objectName3, stringArray2[1]);
                        String string3 = (String)mBeanServerConnection.getAttribute(objectName3, stringArray2[2]);
                        Object object = mBeanServerConnection.getAttribute(objectName3, stringArray2[3]);
                        Object object2 = mBeanServerConnection.getAttribute(objectName3, stringArray2[4]);
                        Object object3 = mBeanServerConnection.getAttribute(objectName3, stringArray2[5]);
                        String string4 = "Memory Pool_" + string2 + " (" + string + ")";
                        String string5 = string.toLowerCase();
                        string4 = string5.startsWith("heap") ? "Heap Memory:Memory Pool " + string2 : "Non-Heap Memory:Memory Pool " + string2;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        arrayList.add(string3);
                        arrayList.add(object2);
                        arrayList.add(object3);
                        hashtable.put(string4, arrayList);
                    }
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMMemoryInfo] - Exception occured while querying MBeans on the method \"queryZingMxBean\"" + exception.getMessage());
        }
        return hashtable;
    }
}

